      *************************************************************
       IDENTIFICATION DIVISION.
      * * * * * * * * * * * * * *
       Class-ID.   DBClass inherits SOMObject.
       AUTHOR.     IBM-Programmer.
      *************************************************************
      * Name:     DBClass                                       ***
      *                                                         ***
      * Language: IBM COBOL                                     ***
      *                                                         ***
      * Function: This class accesses the sample INDEXed file   ***
      *           and  returns information about the employee.  ***
      *                                                         ***
      *           This program is an example of existing        ***
      *           procedural code that has been modified by     ***
      *           making it into a COBOL CLASS with the main    ***
      *           procedure division made into a method.        ***
      *           One method was added to set the search name.  ***
      *           and another method was added to set the       ***
      *           search name default via SOMinit override.     ***
      *                                                         ***
      *           This CLASS is described to the Visual Builder ***
      *           in a .VCE file that is imported using its     ***
      *           import dialog.                                ***
      *                                                         ***
      * External subroutines: SERVC                             ***
      *                                                         ***
      * COPY members:                                           ***
      *           DATAAREA: Data area for communications        ***
      *           SERVSC: Service Calculation parameters        ***
      *                                                         ***
      *************************************************************

      *************************************************************
       ENVIRONMENT DIVISION.
      * * * * * * * * * * * * * *
       CONFIGURATION SECTION.
       Repository.
           CLASS SOMObject is "SOMObject"
           CLASS DBClass is "DBClass".

      *************************************************************
       DATA DIVISION.
       Working-Storage Section.
         01 In-LastName               PIC X(15).
         01 LName.
               49 LName-Len           PIC S9(4) COMP-5.
               49 LName-Data          PIC X(15).

         01 CS-Request                      PIC X.
            88  CS-Display-All                      VALUE "D".
            88  CS-Partial-Match                    VALUE "P".
      *************************************************************
       PROCEDURE DIVISION.
      *************************************************************

      *************************************************************
       Identification Division.
       Method-ID. "somInit" override.
      *************************************************************
      *  This method overrides the somInit method and           ***
      *  initializes the name for the search.                   ***
      *************************************************************

       Procedure Division.
            Move High-Values to In-LastName.
            Move 0 to LName-Len.
            Move High-Values to LName-Data.
       End Method "somInit".
      *************************************************************

      *************************************************************
       Identification Division.
       Method-ID. "setSrchName".
      *************************************************************
      *  This method sets the search name.                      ***
      *************************************************************
       Data Division.
       Linkage Section.
       01 SrchName.
           03 Name-Length                PIC 9(9) COMP-5.
           03 Name-String.
              05 Name-Chars              PIC X
                       OCCURS 1 TO 255 TIMES
                       DEPENDING ON Name-Length.

       Procedure Division Using SrchName.

            Move Name-String to In-LastName.
            Move Name-String to LName-Data.
            Move Name-Length to LName-Len.

      * Designate which type of name search was specified, i.e.,
      * ALL names or a partial name search

            If In-LastName = Spaces
               Move "D" to CS-Request
            Else
               Move "P" to CS-Request.

       End Method "setSrchName".
      *************************************************************

      *************************************************************
       Identification Division.
       Method-ID. "doSearch".

       Environment Division.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT EMP-DATA ASSIGN to EMPFILE
                  ORGANIZATION is INDEXED
                  ACCESS MODE IS DYNAMIC
                  RECORD KEY  is EMP-NAME
                  FILE STATUS is EMP-FILE-STAT, STATUS2.

       Data Division.
       FILE SECTION.
       FD  EMP-DATA is EXTERNAL
           RECORD CONTAINS 41 CHARACTERS.

           COPY "INDXFILE.CPY".

      *************************************************************
      *  This method performs the actual indexed file access;   ***
      *  it checks whether the search name is set to decide how ***
      *  to get the data from the file.                         ***
      *************************************************************
      *
       Working-Storage Section.
      *************************************************************
      *  Internal variables                                       *
      *************************************************************
       01  ARRAY-MAX-ENTRIES.
           05  EMP-ARRAY-MAX              PIC 9(2)  VALUE 50.
           05  RESULT-DATA-MAX            PIC 9(2)  VALUE 0.

       01  PROGRAM-WORK-FIELDS.
           05  EMP-PTR                    PIC 9(2).
           05  BLANK-COUNT                PIC 9(2).
           05  LASTNAME-LENGTH            PIC 9(2).
           05  DEPT-LENGTH                PIC 9(2).
           05  CHARPTR                    PIC 9(2).
           05  EDIT-HIRE-DATE             PIC XXXX/XX/XX.
           05  HIRE-DATE                  PIC X(8).

       77  UPPER-ALPHA                    PIC X(26)   VALUE
              "ABCDEFGHIJKLMNOPQRSTUVWXYZ".
       77  LOWER-ALPHA                    PIC X(26)   VALUE
              "abcdefghijklmnopqrstuvwxyz".

       01  LINE-COUNT                     PIC 9(2).
       01  TOTAL-COUNT                    PIC 9(2).
       01  THE-COUNT                      PIC 9(2) VALUE ZERO.
       01  FIX-FIELDS.
           05  LJUST-FIELD-1.
               10  LJUST-LASTNAME-1       PIC X(15).
           05  LJUST-FIELD-2.
               10  LJUST-LASTNAME-2       PIC X(15).

       01  SC-COMMAREA.
           COPY SERVSC.

       01  EMP-FILE-STAT              PIC x(02) value SPACES.
           88  STATUS-OK              VALUE "00".
           88  END-OF-FILE            VALUE "10".
           88  STAT96                 VALUE "96".
       01  STATUS2.
           05  RCODE1             COMP   PIC S9(4).
           05  RCODE2             COMP   PIC S9(4).
           05  RCODE3             COMP   PIC S9(4).

       Linkage Section.
      * - - - - - DataArea (for communications)
       01 DataArea.
           COPY DATAAREA.



      *************************************************************
       Procedure Division Returning DataArea.
      *************************************************************
      * 1000-MAIN: Main Processing
      *
      *   Return code is set if matches were found or not found.
      *************************************************************
        1000-MAIN.
      * Initialize
           INITIALIZE CS-RESULT-DATA.
           MOVE 0 TO RESULT-DATA-MAX.
           MOVE 0 to CS-Return-Code.

      * Open the INDEXed file
      *
           OPEN input EMP-DATA
           If emp-file-stat not equal to "00" Then
             Move 30 to cs-msg-length
             Move "File error: status code=" to CS-MSG-STRING
             Move emp-file-stat to CS-MSG-STRING(25:2)
             Close emp-data
             Set cs-db-error to true
             Goback
           End-if.



      * Execute the proper processing routines based on which
      * type of search was specified, Display ALL or name search

           EVALUATE TRUE
              WHEN CS-DISPLAY-ALL
                PERFORM 1100-DISPLAY-ALL THRU
                   1100-DISPLAY-ALL-EXIT
                subtract 1 from Results-Knt
              WHEN CS-PARTIAL-MATCH
                Perform 1600-FIX-NAME
                PERFORM 1200-DISPLAY-MATCH THRU
                   1200-DISPLAY-MATCH-EXIT
              WHEN OTHER
                MOVE 3 TO CS-RETURN-CODE
           END-EVALUATE.

           Close emp-data
           GOBACK.

      *************************************************************
      * 1100-DISPLAY-ALL:
      *   Return all of the entries in EMP-ARRAY.
      *************************************************************
        1100-DISPLAY-ALL.

      * Initialize retun code
           Set cs-ok to true.
      * Initialize subscripts
           MOVE 1 TO Results-Knt.
           MOVE 1 TO EMP-PTR.

      * Move all entries to CS-RESULT-DATA

           READ EMP-DATA NEXT RECORD END-READ.
           PERFORM
                   UNTIL EMP-FILE-STAT NOT EQUAL TO "00"

             Move 15 to cs-emp-last-len(Results-Knt)
             MOVE EMP-LAST-NAME  TO CS-EMP-LAST-DATA(Results-Knt)
             Move 10 to cs-emp-first-len(Results-Knt)
             MOVE EMP-FIRST-NAME TO CS-EMP-FIRST-DATA(Results-Knt)
             MOVE EMP-MIDINIT    TO CS-EMP-INITIAL(Results-Knt)
             MOVE EMP-DEPT       TO CS-EMP-DEPT(Results-Knt)
             MOVE EMP-PHONE      TO CS-EMP-PHONE(Results-Knt)
             MOVE EMP-HIRE-DATE  TO HIRE-DATE
             MOVE HIRE-DATE      TO EDIT-HIRE-DATE
             MOVE EDIT-HIRE-DATE TO CS-EMP-HIRE-DATE(Results-Knt)
      *******************************************
      *      Call Service Routine               *
      *******************************************
             MOVE EMP-HIRE-YEAR  TO SC-HIRE-YEAR
             MOVE EMP-HIRE-MONTH TO SC-HIRE-MONTH
             MOVE EMP-HIRE-DAY   TO SC-HIRE-DAY
             MOVE 4 TO SC-RETURN-CODE

             CALL "SERVC" USING SC-COMMAREA

             IF SC-RETURN-CODE NOT = 0
                MOVE 4 TO CS-RETURN-CODE
             END-IF
             MOVE SC-SERVICE-LENGTH TO CS-SERVICE-LENGTH(Results-Knt)

             ADD 1 TO Results-Knt

             Move spaces to EMP-DATA-REC
             READ EMP-DATA NEXT RECORD


           END-PERFORM

      * Indicate number of entries processed
           Subtract 1 from results-knt GIVING RESULT-DATA-MAX.

         1100-DISPLAY-ALL-EXIT. EXIT.


      *************************************************************
      * 1200-DISPLAY-MATCH
      *   Return all of the entries in EMP-ARRAY.
      *   Move all of the entries from EMP-DATA to CS-RESULT-DATA.
      *************************************************************
        1200-DISPLAY-MATCH.

      *   Determine the lengths of the client's inputs: IN-LASTNAME
      *   and build the search target, LNAME.
           PERFORM 1210-FIND-LENGTHS THRU 1210-FIND-LENGTHS-EXIT.
           STRING
              IN-LASTNAME
                DELIMITED BY SPACE
                INTO LNAME-DATA.

      * Initialize subscripts
           MOVE 0 TO Results-Knt.
           MOVE 0 TO EMP-PTR.

           PERFORM 1230-FETCH-MATCH THRU 1230-FETCH-MATCH-EXIT
                   WITH TEST BEFORE
                              UNTIL Results-Knt > EMP-ARRAY-MAX
                                    OR End-of-File.

      * Indicate number of entries processed and set return
      * code if nothing's found
           MOVE Results-Knt TO RESULT-DATA-MAX.
           IF Results-Knt = 0  AND CS-RETURN-CODE = 0
             Set cs-no-match to true
           END-IF.
      * Reset the search name
           Move High-Values to In-LastName.
           Move 0 to LName-Len.
           Move High-Values to LName-Data.

         1200-DISPLAY-MATCH-EXIT. EXIT.

      *************************************************************
      * 1210-FIND-LENGTHS: Determine length of what the user
      *   entered, and set that as the length of the host
      *   variable.
      *************************************************************
        1210-FIND-LENGTHS.
            IF IN-LASTNAME = SPACES
      * Lastname is blank
               MOVE 0 TO LNAME-LEN
            ELSE
      * Lastname is not blank; determine its length
               INITIALIZE BLANK-COUNT
      * Determine the number of trailing blanks in last name
      * input characters using intrinsic function REVERSE
               INSPECT FUNCTION REVERSE(IN-LASTNAME)
                   TALLYING BLANK-COUNT FOR LEADING SPACES
      * Calculate field length (field size minus trailing blanks)
               COMPUTE LNAME-LEN = 15 - BLANK-COUNT
            END-IF.

        1210-FIND-LENGTHS-EXIT. EXIT.

      *************************************************************
      * 1230-FETCH-MATCH
      *   This routine compares column 1 for as many characters
      *   as were entered for a match.  It then calls the calcyear
      *   routine (SERVC)
      *   to calculate the years of service.
      *************************************************************
         1230-FETCH-MATCH.

           READ EMP-DATA NEXT RECORD END-READ.
           If status-ok
            If in-lastname(1:lname-len) = emp-last-name(1:lname-len)
              ADD 1 TO Results-Knt
              Move 15 to cs-emp-last-len(Results-Knt)
              MOVE EMP-LAST-NAME  TO CS-EMP-LAST-DATA(Results-Knt)
              Move 10 to cs-emp-first-len(Results-Knt)
              MOVE EMP-FIRST-NAME TO CS-EMP-FIRST-DATA(Results-Knt)
              MOVE EMP-MIDINIT    TO CS-EMP-INITIAL(Results-Knt)
              MOVE EMP-DEPT       TO CS-EMP-DEPT(Results-Knt)
              MOVE EMP-PHONE      TO CS-EMP-PHONE(Results-Knt)
              MOVE EMP-HIRE-DATE  TO HIRE-DATE
              MOVE HIRE-DATE      TO EDIT-HIRE-DATE
              MOVE EDIT-HIRE-DATE TO CS-EMP-HIRE-DATE(Results-Knt)
      *-------***********************************
      *      Call Calcyear Routine              *
      *-------***********************************
              MOVE EMP-HIRE-YEAR  TO SC-HIRE-YEAR
              MOVE EMP-HIRE-MONTH TO SC-HIRE-MONTH
              MOVE EMP-HIRE-DAY   TO SC-HIRE-DAY
              MOVE 4  to SC-RETURN-CODE

              CALL "SERVC" USING SC-COMMAREA

              IF SC-RETURN-CODE NOT = 0
                 MOVE 4 TO CS-RETURN-CODE
              END-if
              MOVE SC-SERVICE-LENGTH TO CS-SERVICE-LENGTH(Results-Knt)
            ELSE
              Set cs-no-match to true
            END-IF
           Else
      * ---- If file status not ok, set the return code appropriately
              If end-of-file
                 Set cs-ok to true
              Else
                 Set cs-error to true
              END-IF
           End-if.

         1230-FETCH-MATCH-EXIT.   EXIT.

      ***************************************************************
      *  1600-FIX-NAME.                                             *
      *  This routine sets up the name for use in the search.       *
      *  It removes the leading blanks.                             *
      ***************************************************************

        1600-FIX-NAME.
      *    INSPECT IN-LASTNAME
      *        CONVERTING LOWER-ALPHA TO UPPER-ALPHA.
           INITIALIZE LJUST-FIELD-1, LJUST-FIELD-2

      * --- Left-justify the Last Name input
           IF IN-LASTNAME NOT = SPACES
              INSPECT IN-LASTNAME REPLACING LEADING SPACES BY
                      HIGH-VALUES
              UNSTRING IN-LASTNAME DELIMITED BY ALL HIGH-VALUES
                      INTO LJUST-FIELD-1, LJUST-FIELD-2
              IF LJUST-FIELD-1 = SPACES
                 MOVE LJUST-LASTNAME-2 TO IN-LASTNAME
              END-IF
           END-IF.
      ***************************************************************

       End Method "doSearch".

      ***************************************************************

       END CLASS DBClass.


