/**********************************************************************/
/* This command file creates a DB2 database and DB2 tables that       */
/* are used by the Y2KX2PG program.                                   */
/*                                                                    */
/**********************************************************************/

/* Set drive used for the database.                                   */
'set sstdrv=F:'

/**********************************************************************/
/* Start the DB manager.                                              */
/**********************************************************************/
'startdbm'

/**********************************************************************/
/* Drop the PURPT database (if it exists).                            */
/**********************************************************************/
'db2 -v DROP DATABASE PURPT'

/**********************************************************************/
/* Create the PURPT database.                                         */
/**********************************************************************/
'db2 -v CREATE DATABASE PURPT on %sstdrv% authentication client'

/**********************************************************************/
/* Connect to the PURPT database.                                     */
/**********************************************************************/
'db2 -v CONNECT TO PURPT'

/**********************************************************************/
/* Delete the tables (if they exist).                                 */
/**********************************************************************/
'db2 -v DROP TABLE SRCTBL'
'db2 -v DROP TABLE DITEMTBL'
'db2 -v DROP TABLE RSNTBL'

/**********************************************************************/
/* Create the source table.                                           */
/*  - PROGNAME : The program name.                                    */
/*  - SRCFILE  : Source file name. Could be the name of a COPY        */
/*               file used by the program.                            */
/**********************************************************************/
'db2 -v "CREATE TABLE SRCTBL(',
          'PROGNAME CHAR(30)  NOT NULL,',
          'SRCNAME  CHAR(56)  NOT NULL,',
          'PRIMARY KEY(PROGNAME,SRCNAME))" '


/**********************************************************************/
/* Create the item table.                                             */
/*  - ITEMNAME : The item name.                                       */
/*  - ITEMQID  : A unique date/time stamp with a suffix that uniquely */
/*               identifies the data item.                            */
/*  - PROGNAME : Program name where item was defined.                 */
/*  - SRCNAME  : Source file name where item was defined.             */
/*  - ITEMQTYP : Indicates if item is qualified.                      */
/*  - ITEMDLIN : Line number where the item was defined.              */
/*  - ITEMQNAM : Fully qualified name.                                */
/**********************************************************************/
'db2 -v "CREATE TABLE DITEMTBL(',
          'ITEMNAME CHAR(30)  NOT NULL,',
          'ITEMQID  CHAR(18)  NOT NULL,',
          'PROGNAME CHAR(30)  NOT NULL,',
          'SRCNAME  CHAR(56)  NOT NULL,',
          'ITEMQTYP CHAR(01)  NOT NULL,',
          'ITEMDLIN CHAR(06)  NOT NULL,',
          'ITEMQNAM VARCHAR(1500)     ,',
          'PRIMARY KEY(ITEMNAME,ITEMQID,PROGNAME,SRCNAME),',
          'FOREIGN KEY(PROGNAME,SRCNAME) REFERENCES SRCTBL)"'


/**********************************************************************/
/* Create the reason table.                                           */
/*  - ITEMNAME : The item name.                                       */
/*  - ITEMQID  : A unique date/time stamp with a suffix that uniquely */
/*               identifies the data item.                            */
/*  - PROGNAME : Program name where item was defined.                 */
/*  - SRCNAME  : Source file name where item was defined.             */
/*  - CAUSE    : The reason why the item was choosen.                 */
/**********************************************************************/
'db2 -v "CREATE TABLE RSNTBL(          ',
          'ITEMNAME CHAR(30)  NOT NULL,',
          'ITEMQID  CHAR(18)  NOT NULL,',
          'PROGNAME CHAR(30)  NOT NULL,',
          'SRCNAME  CHAR(56)  NOT NULL,',
          'CAUSE    CHAR(11)  NOT NULL,',
          'PRIMARY KEY(ITEMNAME,ITEMQID,PROGNAME,SRCNAME,',
                      'CAUSE),',
          'FOREIGN KEY(ITEMNAME,ITEMQID,PROGNAME,SRCNAME) ',
                  'REFERENCES DITEMTBL)"'


'db2 -v COMMIT WORK'


'set db2dbdft=PURPT'

'db2 -v TERMINATE'

