      * Tests modeling of various types of data definitions,            DAT00010
      * simple dataflow, and def/use edge construction.                 DAT00020
                                                                        DAT00030
        IDENTIFICATION DIVISION.                                        DAT00040
        PROGRAM-ID. DataEg1.                                            DAT00050
        DATE-WRITTEN 17 April 1996.                                     DAT00060
                                                                        DAT00070
        ENVIRONMENT DIVISION.                                           DAT00080
        INPUT-OUTPUT SECTION.                                           DAT00090
        FILE-CONTROL.                                                   DAT00100
            SELECT DatesInFile ASSIGN InFile.                           DAT00110
            SELECT DatesOutFile ASSIGN OutFile.                         DAT00120
                                                                        DAT00130
        DATA DIVISION.                                                  DAT00140
                                                                        DAT00150
        FILE SECTION.                                                   DAT00160
        FD DatesInFile RECORDING MODE F.                                DAT00170
        01 DatesIn.                                                     DAT00180
            05 TheDay           PIC 99.                                 DAT00190
            05 TheMonth         PIC 99.                                 DAT00200
            05 TheYear          PIC 99.                                 DAT00210
                                                                        DAT00220
        FD DatesOutFile RECORDING MODE F.                               DAT00230
        01 DatesOut.                                                    DAT00240
            05 TheDay           PIC 99.                                 DAT00250
            05 TheMonth         PIC 99.                                 DAT00260
            05 TheYear          PIC 99.                                 DAT00270
                                                                        DAT00280
        WORKING-STORAGE SECTION.                                        DAT00290
                                                                        DAT00300
        01 Date1.                                                       DAT00310
            05 Split.                                                   DAT00320
                10 TheDay          PIC 99 VALUE ZEROS.                  DAT00330
                10 TheMonth        PIC 99 VALUE 11.                     DAT00340
                10 TheYear         PIC 99 VALUE 22.                     DAT00350
            05 Composite REDEFINES Split.                               DAT00360
                10 WholeDate       PIC 9(6).                            DAT00370
            66 Dayless RENAMES TheMonth THRU TheYear.                   DAT00380
                                                                        DAT00390
      * Fields are uninitialized in the following                       DAT00400
                                                                        DAT00410
        01 Date2.                                                       DAT00420
            05 Split.                                                   DAT00430
                10 TheDay          PIC 99.                              DAT00440
                10 TheMonth        PIC 99.                              DAT00450
                10 TheYear         PIC 99.                              DAT00460
            05 Composite REDEFINES Split.                               DAT00470
                10 WholeDate       PIC 9(6).                            DAT00480
            66 Dayless RENAMES TheMonth THRU TheYear.                   DAT00490
                                                                        DAT00500
        01 Date3.                                                       DAT00510
            05 Yearless.                                                DAT00520
                10 TheDay          PIC 99 VALUE ZEROS.                  DAT00530
                10 TheMonth        PIC 99 VALUE ZEROS.                  DAT00540
                                                                        DAT00550
        01 Overlaps.                                                    DAT00560
            05 Layout1.                                                 DAT00570
                10 Field1          PIC X(2).                            DAT00580
                10 Field2          PIC X(3).                            DAT00590
            05 Layout2 REDEFINES Layout1.                               DAT00600
                10 Field3          PIC X(3).                            DAT00610
                10 Field4          PIC X(2).                            DAT00620
            05 Layout3 REDEFINES Layout2 PIC X(5).                      DAT00630
                                                                        DAT00640
        01 AString                 PIC X(20).                           DAT00650
                                                                        DAT00660
        01 FixedEmployeeTable.                                          DAT00670
            05 EmployeeTable OCCURS 100 TIMES                           DAT00680
               ASCENDING KEY IS WageRate EmployeeNo                     DAT00690
               INDEXED BY A, B.                                         DAT00700
                10 EmployeeName         PIC X(20).                      DAT00710
                10 EmployeeNo           PIC 9(6).                       DAT00720
                10 WageRate             PIC 9999V99.                    DAT00730
                10 WeekRecord OCCURS 52 TIMES                           DAT00740
                   ASCENDING KEY IS WeekNo INDEXED BY C.                DAT00750
                    15 WeekNo           PIC 99.                         DAT00760
                    15 AuthAbsences     PIC 9.                          DAT00770
                    15 UnauthAbsences   PIC 9.                          DAT00780
                    15 LateArrivals     PIC 9.                          DAT00790
                                                                        DAT00800
        01 EmployeeCount                PIC 9999.                       DAT00810
                                                                        DAT00820
        01 VariableEmployeeTable.                                       DAT00830
            05 EmployeeTable OCCURS 1 TO 1000 TIMES                     DAT00840
               DEPENDING ON EmployeeCount                               DAT00850
               ASCENDING KEY IS WageRate EmployeeNo                     DAT00860
               INDEXED BY A, B.                                         DAT00870
                10 EmployeeName         PIC X(20) VALUE "John Doe".     DAT00880
                10 EmployeeNo           PIC 9(6).                       DAT00890
                10 WageRate             PIC 9999V99.                    DAT00900
                10 WeekRecord OCCURS 52 TIMES                           DAT00910
                   ASCENDING KEY IS WeekNo INDEXED BY C.                DAT00920
                    15 WeekNo           PIC 99.                         DAT00930
                    15 AuthAbsences     PIC 9.                          DAT00940
                    15 UnauthAbsences   PIC 9.                          DAT00950
                    15 LateArrivals     PIC 9.                          DAT00960
                                                                        DAT00970
        01 I                    PIC 9(5).                               DAT00980
                                                                        DAT00990
                                                                        DAT01000
        PROCEDURE DIVISION.                                             DAT01010
                                                                        DAT01020
        MAIN-LINE-ROUTINE.                                              DAT01030
                                                                        DAT01040
      * A slice here should indicate that all fields                    DAT01050
      * of Date1 are defined by its initialization except TheDay.       DAT01060
                                                                        DAT01070
           MOVE 01 TO TheDay OF Date1.                                  DAT01080
                                                                        DAT01090
      * A slice here should indicate that all fields of                 DAT01100
      * Date2 except TheDay are uninitialized.                          DAT01110
                                                                        DAT01120
           MOVE TheDay OF Date1 TO TheDay OF Date2.                     DAT01130
                                                                        DAT01140
      * Slices w/r/t any component of Date1 should refer only to the    DAT01150
      * literal in the following statement (i.e., the assignment to     DAT01160
      * `Composite' should kill all components of `Split').             DAT01170
                                                                        DAT01180
           MOVE 311199 TO WholeDate of Date1.                           DAT01190
                                                                        DAT01200
      * TheDay of Date2 should be unaffected by the following.          DAT01210
                                                                        DAT01220
           MOVE Dayless OF Date1 TO Dayless OF Date2.                   DAT01230
                                                                        DAT01240
      * After assignments below, slices w/r/t TheMonth of Date1 should  DAT01250
      * refer to assignment; all other slices w/r/t                     DAT01260
      * Date1 should refer to new assignments.  TheMonth of Date2 shouldDAT01270
      * still be uninitialized.                                         DAT01280
                                                                        DAT01290
           MOVE 01 TO TheDay OF Date1.                                  DAT01300
           MOVE 01 TO TheDay OF Date2.                                  DAT01310
           MOVE 00 TO TheYear OF Date1.                                 DAT01320
           MOVE 00 TO TheYear OF Date2.                                 DAT01330
                                                                        DAT01340
      * Slices w/r/t TheMonth in Date1 should refer to both of the literDAT01350
      * in the following conditional; slices w/r/t to other components  DAT01360
      * should refer to previous assignments.                           DAT01370
                                                                        DAT01380
           IF TheDay OF Date1 = TheDay OF Date2 THEN                    DAT01390
             MOVE 12 TO TheMonth of Date1                               DAT01400
           ELSE                                                         DAT01410
             MOVE 00 TO TheMonth of Date1                               DAT01420
           END-IF.                                                      DAT01430
                                                                        DAT01440
      * TheYear of Date2 should be unaffected by the following.         DAT01450
                                                                        DAT01460
           MOVE CORRESPONDING Yearless of Date3 TO Split OF Date2.      DAT01470
                                                                        DAT01480
      * Test effect of moves of incompatibly-sized objects.             DAT01490
      * Slices w/r/t fields of Date2 should only refer to fields of     DAT01500
      * Date3 (TheDay and TheMonth); TheYear of Date2 should be         DAT01510
      * zero-filled, and thus not refer to a previous assignment.       DAT01520
                                                                        DAT01530
           MOVE Yearless OF Date3 TO Date2.                             DAT01540
                                                                        DAT01550
      * Test effects of moves to skewed overlapping fields: Assignment  DAT01560
      * to Field1 should affect Field3 but not Field4; assignment to FieDAT01570
      * should affect both Field3 and Field4.                           DAT01580
                                                                        DAT01590
           MOVE "AB" TO Field1 OF Overlaps.                             DAT01600
           MOVE "CDE" TO Field2 OF Overlaps.                            DAT01610
           MOVE Field3 OF Overlaps TO AString.                          DAT01620
           MOVE Field4 OF Overlaps TO AString.                          DAT01630
                                                                        DAT01640
      * Test effect of reference modification; in principal, Field1     DAT01650
      * isn't affected, but without information about reference modificaDAT01660
      * offsets, it (along with the other fields) will probably be affecDAT01670
                                                                        DAT01680
           MOVE AString(1:2) TO Layout3(3:2).                           DAT01690
           MOVE Field1 OF Overlaps TO AString.                          DAT01700
                                                                        DAT01710
      * Initialize only numeric fields in fixed length table; `EmployeeNDAT01720
      * should still refer to                                           DAT01730
           INITIALIZE FixedEmployeeTable REPLACING NUMERIC DATA BY 0.   DAT01740
                                                                        DAT01750
      * Update one field of each element in variable length table.      DAT01760
                                                                        DAT01770
           PERFORM VARYING I FROM 1 BY 1 UNTIL I > EmployeeCount        DAT01780
               MOVE I TO EmployeeNo OF VariableEmployeeTable (I)        DAT01790
           END-PERFORM.                                                 DAT01800
                                                                        DAT01810
      * A slice w/r/t EmployeeName should refer to the initialization   DAT01820
      * in the data definition section (_not_ to the previous loop).    DAT01830
                                                                        DAT01840
           PERFORM VARYING I FROM 1 BY 1 UNTIL I > EmployeeCount        DAT01850
               MOVE EmployeeName OF VariableEmployeeTable (I) TO AStringDAT01860
           END-PERFORM.                                                 DAT01870
                                                                        DAT01880
                                                                        DAT01890
      * A reference to an element of FixedEmployeeTable should refer    DAT01900
      * to corresponding element of VariableEmployeeTable.              DAT01910
                                                                        DAT01920
           MOVE VariableEmployeeTable TO FixedEmployeeTable.            DAT01930
                                                                        DAT01940
      * References to fields of DatesOutFiles should refer to           DAT01950
      * corresponding fields of DatesInFile (if any effort is made      DAT01960
      * to establish this correspondence at all).                       DAT01970
                                                                        DAT01980
           PERFORM VARYING I FROM 1 BY 1 UNTIL I > 10                   DAT01990
                READ DatesInFile                                        DAT02000
                MOVE DatesIn TO DatesOut                                DAT02010
                WRITE DatesOut                                          DAT02020
           END-PERFORM.                                                 DAT02030
                                                                        DAT02040
           GOBACK.                                                      DAT02050
