#********************************************************copyrite.xic******/
#                                                                          /
#   Licensed Materials - Property of IBM                                   /
#   IBM TCP/IP for OS/2                                                    /
#   (C) Copyright IBM Corporation. 1996.                                   /
#                                                                          /
#   All rights reserved.                                                   /
#                                                                          /
#   US Government Users Restricted Rights -                                /
#   Use, duplication or disclosure restricted by GSA ADP Schedule          /
#   Contract with IBM Corp.                                                /
#                                                                          /
#--------------------------------------------------------------------------/
#                                                                          /
#  DISCLAIMER OF WARRANTIES.  The following [enclosed] code is             /
#  sample code created by IBM Corporation. This sample code is not         /
#  part of any standard or IBM product and is provided to you solely       /
#  for  the purpose of assisting you in the development of your            /
#  applications.  The code is provided "AS IS", without                    /
#  warranty of any kind.  IBM shall not be liable for any damages          /
#  arising out of your use of the sample code, even if they have been      /
#  advised of the possibility of such damages.                             /
#                                                                          /
#**************************************************************************/

#---------------------------------------------------------------------------
#  Make Directives
#---------------------------------------------------------------------------
.AUTODEPEND
.SUFFIXES: .obj .c

#---------------------------------------------------------------------------
#  Make Macros
#---------------------------------------------------------------------------
BCOS2_DIR  = D:\BCOS2
TOOLKITLIB = C:\TOOLKIT\LIB
STARTUP    = $(BCOS2_DIR)\lib\c02.obj
LIB        = $(BCOS2_DIR)\lib
INCLUDE    = $(BCOS2_DIR)\include;C:\TOOLKIT\H

CC         = bcc -c -v -w

LFLAGS     = -c -x -v -ap /w-stk
LINK       = tlink $(LFLAGS) -L$(LIB) $(STARTUP)

LIBS       = c2 + os2

DLLLIBS    = $(TOOLKITLIB)\so32dll+ \
	     $(TOOLKITLIB)\tcp32dll+ \
	     c2mt + os2

#---------------------------------------------------------------------------
#  Make Rules
#---------------------------------------------------------------------------
.c.obj:
   $(CC) $(CFLAGS) -I$(INCLUDE) {$< }

#===========================================================================
#		Explicit Rules
#===========================================================================

ALL : echosmt.exe echosrv.exe echostcp.exe

clean:
   -del *.obj
   -del *.exe
   -del *.lib

#---------------------------------------------------------------------------
#  Dependancies of the make
#---------------------------------------------------------------------------

echosmt.obj : echosmt.c borland.mak
  $(CC) -I$(INCLUDE) $(CFLAGS) /DOS2 echosmt.c

echosmt.exe: echosmt.obj
   $(LINK) echosmt,echosmt.exe,,$(DLLLIBS),echo.def;

echosrv.obj : echosrv.c borland.mak
  $(CC) -I$(INCLUDE) $(CFLAGS) /DOS2 echosrv.c

echosrv.exe: echosrv.obj
   $(LINK) echosrv,echosrv.exe,,$(DLLLIBS),echo.def;

echostcp.obj : echostcp.c borland.mak
  $(CC) -I$(INCLUDE) $(CFLAGS) /DOS2 echostcp.c

echostcp.exe: echostcp.obj
   $(LINK) echostcp,echostcp.exe,,$(DLLLIBS),echo.def;


#==<eof>====================================================================

