      * --------------------------------------------- *
      *  BOTTLE.CBL
      *     Bottle class for the Wine store sample.
      *     Version 2
      * --------------------------------------------- *

       IDENTIFICATION DIVISION.
       CLASS-ID. "Bottle" inherits SOMObject.

       ENVIRONMENT DIVISION.
       Configuration Section.
       Repository.
            CLASS SOMObject is "SOMObject"
            CLASS Bottle is "Bottle".

       DATA DIVISION.
       Working-Storage Section.
       01   Wine-Type                  PIC X(20).
       01   Wine-Cost                  PIC 9(3)V99.

       PROCEDURE DIVISION.

      * ========================================
      * ========================================
       Identification Division.
       Method-Id. "GetType".
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       Linkage Section.
       01  LS-Type                     PIC X(20).

       PROCEDURE DIVISION
                   Returning LS-TYPE.
           Move Wine-Type to LS-Type.
           Exit Method.
       End Method "GetType".

      * ========================================
      * ========================================
       Identification Division.
       Method-Id. "SetType".
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       Linkage Section.
       01  LS-Type                     PIC X(20).

       PROCEDURE DIVISION
                   Using LS-TYPE.
           Move LS-Type to Wine-Type.
           Exit Method.
       End Method "SetType".

      * ========================================
      * ========================================
       Identification Division.
       Method-Id. "GetCost".
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       Linkage Section.
       01  LS-Cost                     PIC 9(3)V99.

       PROCEDURE DIVISION
                   Returning LS-Cost.
           Move Wine-Cost to LS-Cost.
           Exit Method.
       End Method "GetCost".

      * ========================================
      * ========================================
       Identification Division.
       Method-Id. "SetCost".
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       Linkage Section.
       01  LS-Cost                     PIC 9(3)V99.

       PROCEDURE DIVISION
                   Using LS-Cost.
           Move LS-Cost to Wine-Cost.
           Exit Method.
       End Method "SetCost".

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "IsEqual".
       DATA DIVISION.
       Linkage Section.
       01 ItemType                     PIC X(20).
       01 ItemCost                     PIC 9(3)V99.
       01 theEqualFlag                 PIC X.

       PROCEDURE DIVISION
                   Using ItemType ItemCost
                   Returning theEqualFlag.
           Move Low-Value to theEqualFlag.
            If (Wine-Type = ItemType) and (Wine-Cost = ItemCost)
               Then Move High-Value to theEqualFlag.
           Exit Method.
       End Method "IsEqual".

      *---------------------------------
       END CLASS "Bottle".


