      * --------------------------------------------- *
      *  WINEORDR.CBL
      *     Wine Order class for the wine store sample.
      *     Version 2
      * --------------------------------------------- *

       IDENTIFICATION DIVISION.
       CLASS-ID. "WineOrder" inherits SOMObject.

       ENVIRONMENT DIVISION.
       Configuration Section.
       Repository.
            CLASS SOMObject is "SOMObject"
            CLASS Bottle is "Bottle"
            CLASS WineOrder is "WineOrder".

       DATA DIVISION.
       Working-Storage Section.
       01  WS-Ev            Usage Pointer.
       01  Order-Object.
          05 Order-Number              PIC X(5).
          05 Order-Date                PIC X(10).
          05 Bottles.
              10 Bottle-Count          PIC 9(4).
              10 Bottle-Item  Occurs 1 to 64 times
                              Depending on Bottle-Count
                              Indexed by Item-Count.
                  15 bottleObj  Usage Object Reference Bottle.

       PROCEDURE DIVISION.

      * ========================================
      * ========================================
       Identification Division.
       Method-Id. "DescribeOrder".
       DATA DIVISION.
       Working-Storage Section.
       01  WS-Type                     PIC X(20).
       01  WS-Cost                     PIC 9(3)V99.
       Linkage Section.
       01  LS-Items.
           05  LS-Item-Count            PIC 9(4).
           05  LS-Item      Occurs 1 to 64 times
                            Depending on LS-Item-Count
                            Indexed by LS-Index.
               10 LS-Type              PIC X(20).
               10 LS-Cost              PIC 9(3)V99.
       PROCEDURE DIVISION
                   Returning LS-Items.
           Move Bottle-Count to LS-Item-Count.
           Set LS-Index to 1.
           if (Item-Count > 0)
              Perform Varying Item-Count from 1 by 1
                         Until (Item-Count > Bottle-Count)
                 Invoke bottleObj(Item-Count) "GetCost"
                             returning WS-Cost
                 Move WS-Cost to LS-Cost(LS-Index)
                 Invoke bottleObj(Item-Count) "GetType"
                             returning WS-Type
                 Move WS-Type to LS-Type(LS-Index)
                 Set LS-Index up by 1
              End-Perform
           End-If.
           Exit Method.
       End Method "DescribeOrder".

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "addBottle".
       DATA DIVISION.
       Working-Storage Section.
       01  Found-Flag                  PIC X(4).
           88  Found                      Value "0".
           88  Not-Found                  Value "1".
       01  Equal-Flag                  PIC X.
       Linkage Section.
       01 LS-Parms.
           05 LS-Item-Count            PIC S9(8) COMP.
           05 LS-Flag                  PIC X.
       01 LS-Type                      PIC X(20).
       01 LS-Cost                      PIC 9(3)V99.

       PROCEDURE DIVISION
                   Using LS-Type  LS-Cost
                   Returning LS-Parms.

           Move "1" to LS-Flag Found-Flag.
           Perform Varying Item-Count From 1 by 1
                     Until (Item-Count > 64) or (Found)
              If bottleObj(Item-Count) NOT = NULL
                 Perform Check-Equal
                 Move Bottle-Count to LS-Item-Count
              Else If Found-Flag = "1"
                 Invoke Bottle "somNew"
                                Returning bottleObj(Item-Count)
                 Invoke bottleObj(Item-Count) "SetType"
                                 Using LS-Type
                 Invoke bottleObj(Item-Count) "SetCost" Using LS-Cost
                 Add 1 to Bottle-Count
                 Move Bottle-Count to LS-Item-Count
                 Move "0" to LS-Flag Found-Flag
                 End-if
              End-if
           End-Perform.
           Exit Method.

       Check-Equal.
           Invoke bottleObj(Item-Count) "isEqual"
                     Using LS-Type LS-Cost
                     Returning Equal-Flag.
           If Equal-Flag  = High-Value
              Display
                    " Sorry .. that wine is already in the order."
              Move "0" to Found-Flag
           End-If.

       End Method "addBottle".

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "DeleteBottle".
       DATA DIVISION.
       Working-Storage Section.
       01  Found-Flag                  PIC X(4).
           88  Found                     Value "0".
           88  Not-Found                 Value "1".
       Local-Storage Section.
       77  Bott-Type                   PIC X(20).
       77  Bott-Cost                   PIC 9(3)V99.
       Linkage Section.
       01 LS-Parms.
           05 LS-Item-Count            PIC S9(8) COMP.
           05 LS-Flag                  PIC X.
       01  LS-Type                     PIC x(20).
       01  LS-Cost                     PIC 9(3)V99.
       PROCEDURE DIVISION
                   Using LS-Type LS-Cost LS-Parms.

           Move "1" to Found-Flag LS-Flag.
           Perform Varying Item-Count From 1 by 1
                     until (Item-Count > Bottle-Count) or (Found)
              Invoke bottleObj(Item-Count) "GetType"
                     Returning Bott-Type
              If LS-Type = Bott-Type
                 Invoke bottleObj(Item-Count) "GetCost"
                        Returning Bott-Cost
                 If LS-Cost = Bott-Cost
                    Set bottleObj(Item-Count) to bottleObj(Bottle-Count)
                    Set bottleObj(Bottle-Count) to NULL
                    Subtract 1 from Bottle-Count
                    Move Bottle-Count to LS-Item-Count
                    Move "0" to Found-Flag LS-Flag
                 End-If
              End-if
           End-Perform.
           Exit Method.
       End Method "DeleteBottle".


      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "CalculateCost".
       DATA DIVISION.
       Local-Storage Section.
       77  Cost                        PIC 9(3)V99.
       Linkage Section.
       01  LS-Total-Cost               PIC 9(7)V99.
       PROCEDURE DIVISION
                   Returning LS-Total-Cost.

           Move 0 to LS-Total-Cost.
           Perform Varying Item-Count From 1 by 1
                    until Item-Count > Bottle-Count
              Invoke bottleObj(Item-Count) "GetCost" returning Cost
              Add Cost to LS-Total-Cost
           End-Perform.
           Exit Method.
       End Method "CalculateCost".

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "GetOrderNumber".
       DATA DIVISION.
       Linkage Section.
       01  LS-Order-Number             PIC X(5).

       PROCEDURE DIVISION
                   Returning LS-Order-Number.
           Move Order-Number to LS-Order-Number.
           Exit Method.
       End Method "GetOrderNumber".

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "GetOrderDate".
       DATA DIVISION.
       Linkage Section.
       01  LS-Order-Date               PIC X(10).
       PROCEDURE DIVISION
                   Returning LS-Order-Date.
           Move Order-Date to LS-Order-Date.
           Exit Method.
       End Method "GetOrderDate".


      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "SetOrderNumber".
       DATA DIVISION.
       Linkage Section.
       01  LS-OrderNumber             PIC X(5).
       PROCEDURE DIVISION
                   Using LS-OrderNumber.
           Move LS-OrderNumber to Order-Number.
           Exit Method.
       End Method "SetOrderNumber".

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "SetOrderDate".
       DATA DIVISION.
       Linkage Section.
       01  LS-OrderDate               PIC X(10).
       PROCEDURE DIVISION
                   Using LS-OrderDate.
           Move LS-OrderDate to Order-Date.
           Exit Method.
       End Method "SetOrderDate".

      *---------------------------------
       END CLASS "WineOrder".


