/*******************************************************************************
* FILE NAME: ibctlob2.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of functions that have been replaced *
*   and are now obsolete.  They have been placed here to provide compatibility *
*   with prior releases.                                                       *
*   This is OS/2 and Windows unique code.                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
extern "C"
  {
  #define INCL_WINSTDSPIN
  #define INCL_WINSYS
  #define INCL_WINBUTTONS
  #define INCL_WINSTDBOOK
  #define INCL_WINDIALOGS           // Needed for PDLGTEMPLATE in BOOKPAGEINFO
  #include <os2.h>
  }

#ifndef _ISPINBT_
  #include <ispinbt.hpp>
#endif

#ifndef _ICCONST_
  #include <icconst.h>
#endif

#ifndef _IEXCEPT_
 #include <iexcept.hpp>
#endif

#ifndef _ICOLOR_
  #include <icolor.hpp>
#endif
#ifndef _ISPINBAS_
  #include <ispinbas.hpp>
#endif
#ifndef _ISPINSZH_
  #include <ispinszh.hpp>
#endif
#ifndef _IFONT_
  #include <ifont.hpp>
#endif
#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif
#ifndef _IRECT_
  #include <irect.hpp>
#endif
#ifndef _IRESLIB_
  #include <ireslib.hpp>
#endif
#ifndef _ISTRING_
  #include <istring.hpp>
#endif
#ifndef _ITRACE_
  #include <itrace.hpp>
#endif
#ifndef _IMPHDR_
  #include <imphdr.hpp>
#endif

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IBCTLOB2_CPP_
  #include <ipagetun.h>
#endif

#if (IC_OBSOLETE <= IC_OBSOLETE_1)

//
//
//  Block of obsolete function for obsolete level 1
//
//

/*------------------------------------------------------------------------------
| ISpinButtonSizeHandler::handleEventsFor                                      |
|                                                                              |
| Attach the handler to a spin button.                                         |
------------------------------------------------------------------------------*/
ISpinButtonSizeHandler& ISpinButtonSizeHandler :: handleEventsFor
                                        ( ISpinButton* spinButton )
{
  IASSERTPARM( spinButton != 0 );
  Inherited::handleEventsFor( spinButton );
  return *this;
}

/*------------------------------------------------------------------------------
| ISpinButtonSizeHandler::stopHandlingEventsFor                                |
|                                                                              |
| Detach the handler from a spin button.                                       |
------------------------------------------------------------------------------*/
ISpinButtonSizeHandler&
  ISpinButtonSizeHandler :: stopHandlingEventsFor
                              ( ISpinButton* spinButton )
{
  IASSERTPARM( spinButton != 0 );
  Inherited::stopHandlingEventsFor( spinButton );
  return *this;
}

/*------------------------------------------------------------------------------
| Public spin button styles.                                                   |
------------------------------------------------------------------------------*/
#pragma data_seg(ICLStaticConst)
const ISpinButton::Style
  ISpinButton::master            = SPBS_MASTER,
  ISpinButton::servant           = 0x00004000ul,
  ISpinButton::allCharacters     = 0x00008000ul,
  ISpinButton::numericOnly       = SPBS_NUMERICONLY,
  ISpinButton::readOnly          = SPBS_READONLY,
  ISpinButton::leftAlign         = SPBS_JUSTLEFT,
  ISpinButton::centerAlign       = 0x00002000ul,
  ISpinButton::rightAlign        = SPBS_JUSTRIGHT,
  ISpinButton::noBorder          = SPBS_NOBORDER,
  ISpinButton::fastSpin          = SPBS_FASTSPIN,
  ISpinButton::padWithZeros      = SPBS_PADWITHZEROS,
  ISpinButton::classDefaultStyle = ( WS_VISIBLE    |
                                     SPBS_MASTER   |
                                     SPBS_JUSTLEFT |
                                     SPBS_ALLCHARACTERS );
#pragma data_seg()

/*------------------------------------------------------------------------------
| Default style for new objects (initial value).                               |
------------------------------------------------------------------------------*/
#pragma data_seg(ICLNonConst)
ISpinButton::Style
  ISpinButton::currentDefaultStyle = ( WS_VISIBLE    |
                                       SPBS_MASTER   |
                                       SPBS_JUSTLEFT |
                                       SPBS_ALLCHARACTERS );

/*------------------------------------------------------------------------------
| The static object that ISpinButton uses to properly change its size.         |
------------------------------------------------------------------------------*/
static ISpinButtonStatics SpinButtonStatics;
#pragma data_seg()


/*------------------------------------------------------------------------------
| ISpinButton::ISpinButton                                                     |
|                                                                              |
| Constructor to create a spin button control on a standard window.            |
------------------------------------------------------------------------------*/
ISpinButton :: ISpinButton ( unsigned long id,
                             IWindow* parent,
                             IWindow* owner,
                             const IRectangle& initial,
                             const Style& style )
      :  bDelayedItems(false), spinText(), lCount(0), textLimit(255), pList(0)
{
  IASSERTPARM(parent!=0);
  unsigned long ulStyle = style.asUnsignedLong();

  /*********************************************************/
  /* Remove the library defined style values if specified. */
  /*********************************************************/
  if (style & allCharacters)
  {
     ulStyle &= ~allCharacters.asUnsignedLong();
     ulStyle &= ~numericOnly.asUnsignedLong();
  }
  if (style & servant)
  {
     ulStyle &= ~servant.asUnsignedLong();
     ulStyle &= ~master.asUnsignedLong();
  }
  if (style & centerAlign)
  {
     ulStyle &= ~centerAlign.asUnsignedLong();
     ulStyle |= SPBS_JUSTCENTER;
  }

  IWindowHandle spb =
      this -> create( id,
                      0,
                      ulStyle,
                      WC_SPINBUTTON,
                      parent->handle(),
                      (owner==0)?IWindowHandle(0):owner->handle(),
                      initial,
                      0,
                      0 );

  SpinButtonStatics.sizeHandler().handleEventsFor(this);
  IMousePointerHandler::defaultHandler()->handleEventsFor(this);

  startHandlingEventsFor(spb);
}

/*------------------------------------------------------------------------------
| ISpinButton::ISpinButton                                                     |
|                                                                              |
| Constructor to create a spin button control on a standard window.            |
------------------------------------------------------------------------------*/
ISpinButton :: ISpinButton ( unsigned long id, IWindow* parentDialog )
      :  bDelayedItems(false), spinText(), lCount(0), textLimit(255), pList(0)
{
   setAutoDestroyWindow(false);
   SpinButtonStatics.sizeHandler().handleEventsFor(this);
   IMousePointerHandler::defaultHandler()->handleEventsFor(this);
   startHandlingEventsFor(id, parentDialog);
}

/*------------------------------------------------------------------------------
| ISpinButton::ISpinButton                                                     |
|                                                                              |
| Constructor to instantiate spin button object from window handle.            |
------------------------------------------------------------------------------*/
ISpinButton :: ISpinButton ( const IWindowHandle& handle )
     :  bDelayedItems(false), spinText(), lCount(0), textLimit(255), pList(0)
{
   setAutoDestroyWindow(false);
   SpinButtonStatics.sizeHandler().handleEventsFor(this);
   IMousePointerHandler::defaultHandler()->handleEventsFor(this);
   startHandlingEventsFor(handle);
}

/*------------------------------------------------------------------------------
| ISpinButton::~ISpinButton                                                    |
------------------------------------------------------------------------------*/
ISpinButton::~ISpinButton ( )
{
   SpinButtonStatics.sizeHandler().stopHandlingEventsFor(this);
   IMousePointerHandler::defaultHandler()->stopHandlingEventsFor(this);
   if (this->pList)
      delete [] this->pList;
}

/*------------------------------------------------------------------------------
| ISpinButton::setAlignment                                                    |
|                                                                              |
| Change the spin field text alignment.                                        |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::setAlignment(Alignment aValue)
{
  unsigned long ulStyle = style();
  unsigned long ulOldStyle = ulStyle;

  switch (aValue)
  {
    case left:
      ulStyle |= leftAlign.asUnsignedLong();
      ulStyle &= ~rightAlign.asUnsignedLong();
    break;

    case right:
      ulStyle |= rightAlign.asUnsignedLong();
      ulStyle &= ~leftAlign.asUnsignedLong();
    break;

    case center:
      ulStyle |= SPBS_JUSTCENTER;
    break;
  }

  if (ulStyle != ulOldStyle)
  {
    setStyle(ulStyle);                  //Change style
    refresh();                          //Force refresh
  }
  return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::alignment                                                       |
|                                                                              |
| Returns the spin field alignment.                                            |
------------------------------------------------------------------------------*/
ISpinButton::Alignment ISpinButton :: alignment  ( ) const
{
   unsigned long ulStyle = style();
   if ( (ulStyle & leftAlign.asUnsignedLong()) &&
        !(ulStyle & rightAlign.asUnsignedLong()) )
      return left;
   else if ( (ulStyle & rightAlign.asUnsignedLong()) &&
             !(ulStyle & leftAlign.asUnsignedLong()) )
      return right;
   else
      return center;
}

/*------------------------------------------------------------------------------
| ISpinButton::setMaster                                                       |
|                                                                              |
| Assign the master for this servant spin button.                              |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: setMaster ( ISpinButton& master )
{
   IASSERTSTATE(isServant());
   IASSERTPARM(master.isMaster());

   unsigned long ulOk =
           handle().sendEvent(SPBM_SETMASTER,
                              IEventParameter1(master.handle()),
                              IEventParameter2(0));
   if (!ulOk)
      ITHROWGUIERROR2("SPBM_SETMASTER",
                      IErrorInfo::accessError,
                      IException::recoverable);

   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::foregroundColor                                                 |
|                                                                              |
| Returns the foreground color of the spinbutton.                              |
------------------------------------------------------------------------------*/
IColor ISpinButton::foregroundColor () const
{
  IGUIColor guiColor(IGUIColor::windowText);

  if (isReadOnly())
  {
    guiColor = IGUIColor(IGUIColor::outputText);
  }
  return (IWindow::color(PP_FOREGROUNDCOLOR, guiColor));
}

/*------------------------------------------------------------------------------
| ISpinButton::setLimit                                                        |
|                                                                              |
| Sets the number of characters permitted in a spin field.                     |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: setLimit ( unsigned long aNumber )
{
   this->textLimit = aNumber;
   unsigned long ulOk = handle().sendEvent(SPBM_SETTEXTLIMIT,
                                           IEventParameter1((USHORT)(aNumber)),
                                           IEventParameter2(0));
   if (!ulOk)
      ITHROWGUIERROR2("SPBM_SETTEXTLIMIT",
                      IErrorInfo::invalidParameter,
                      IException::recoverable);

   setLayoutDistorted(IWindow::minimumSizeChanged, 0);
   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::setInputType                                                    |
|                                                                              |
| Change the allowable input type in the spin field.                           |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: setInputType ( Type aValue )
{
   if (aValue == alphanumeric) {
      if (inputTypeAllowed() == numeric) {
         setStyle(style() & ~numericOnly.asUnsignedLong());
         removeAll();                  //Resets the entry field
      }
   }
   else {
      if (inputTypeAllowed() == alphanumeric) {
         removeAll();
         this->bDelayedItems = false;
         setStyle(style() | numericOnly.asUnsignedLong());
      }
   }
   refresh();                          //Force refresh
   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::spinDown                                                        |
|                                                                              |
| Spin the button down (backward) the specified amount of times.               |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: spinDown ( unsigned long spinBy )
{
   unsigned long ulOk = handle().sendEvent(SPBM_SPINDOWN,
                                           IEventParameter1(spinBy),
                                           IEventParameter2(0));
   if (!ulOk)
      ITHROWGUIERROR2("SPBM_SPINDOWN",
                      IErrorInfo::invalidRequest,
                      IException::recoverable);

   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::spinUp                                                          |
|                                                                              |
| Spin the button up (forward) the specified amount of times.                  |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: spinUp   ( unsigned long spinBy )
{
   unsigned long ulOk = handle().sendEvent(SPBM_SPINUP,
                                           IEventParameter1(spinBy),
                                           IEventParameter2(0));
   if (!ulOk)
      ITHROWGUIERROR2("SPBM_SPINUP",
                      IErrorInfo::invalidRequest,
                      IException::recoverable);

   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::isValid                                                         |
|                                                                              |
| Validate that the contents of the spin field are in the spin field number    |
| range or matches the spin text values.  If updateContent is set to true,     |
| the spin field will be conditionally updated.                                |
------------------------------------------------------------------------------*/
Boolean ISpinButton :: isValid ( Boolean  updateContent) const
{
   long lValue;
   unsigned long ulOk;
   if (updateContent)
      ulOk = handle().sendEvent(SPBM_QUERYVALUE,
                                IEventParameter1((void*)&lValue),
                                IEventParameter2(0,
                                                 SPBQ_ALWAYSUPDATE));
   else
      ulOk = handle().sendEvent(SPBM_QUERYVALUE,
                                IEventParameter1((void*)&lValue),
                                IEventParameter2(0,
                                                 SPBQ_DONOTUPDATE));

   return (ulOk) ? true : false;
}

/*------------------------------------------------------------------------------
| ISpinButton::setCurrent                                                      |
|                                                                              |
| Set the spin field to the specified numeric value.                           |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: setCurrent ( long aValue )
{
   if (inputTypeAllowed() == numeric) {
      unsigned long ulOk =
           handle().sendEvent(SPBM_SETCURRENTVALUE,
                              IEventParameter1((int)aValue),
                              IEventParameter2(0));
      if (!ulOk)
         ITHROWGUIERROR2("SPBM_SETCURRENTVALUE",
                         IErrorInfo::invalidParameter,
                         IException::recoverable);

   } else
     ITHROWLIBRARYERROR(IC_INVALID_RANGE_OPERATION,
                        IErrorInfo::invalidRequest,
                        IException::recoverable);
   return *this;
}


/*------------------------------------------------------------------------------
| ISpinButton::setRange                                                        |
|                                                                              |
| Sets the lower and upper range of the spin button numbers.  If the value in  |
| the spin field does not match the range, PM sets the spin field to the       |
| previous value.  If the range is empty, PM puts 0 in the spin field.  If     |
| override is set and the current value in the spin field is outside the       |
| new range, the current value in the spin field will not change.              |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: setRange ( const IRange& aNewRange,
                                       Boolean override )
{
   IASSERTSTATE(inputTypeAllowed() == numeric);
   IASSERTPARM(aNewRange.lowerBound() <= aNewRange.upperBound());
                         //If lower is greater than upper, operation will fail.

   if (override)
      handle().sendEvent(SPBM_OVERRIDESETLIMITS,
                         IEventParameter1((int)aNewRange.upperBound()),
                         IEventParameter2((int)aNewRange.lowerBound()));
   else
      handle().sendEvent(SPBM_SETLIMITS,
                         IEventParameter1((int)aNewRange.upperBound()),
                         IEventParameter2((int)aNewRange.lowerBound()));

   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::range                                                           |
|                                                                              |
| Query lower and upper bounds of the numeric range.                           |
------------------------------------------------------------------------------*/
IRange ISpinButton :: range ( ) const
{
   IMODTRACE_DEVELOP("ISpinButton::range");
   long lLow = 0;
   long lHigh = 0;
   if (inputTypeAllowed() == numeric) {
      unsigned long ulOk = handle().sendEvent(SPBM_QUERYLIMITS,
                                              IEventParameter1((void*)&lHigh),
                                              IEventParameter2((void*)&lLow));
      if (ulOk) {
         ITRACE_DEVELOP(IString("Lower Value = ") + IString(lLow));
         ITRACE_DEVELOP(IString("Upper Value = ") + IString(lHigh));
      } else
         ITHROWGUIERROR2("SPBM_QUERYLIMITS",
                         IErrorInfo::accessError,
                         IException::recoverable);
   } else
     ITHROWLIBRARYERROR(IC_INVALID_RANGE_OPERATION,
                        IErrorInfo::invalidRequest,
                        IException::recoverable);
   return IRange(lLow, lHigh);
}

/*------------------------------------------------------------------------------
| ISpinButton::value                                                           |
|                                                                              |
| Return the number in the spin field.                                         |
------------------------------------------------------------------------------*/
long ISpinButton :: value ( ) const
{
   IMODTRACE_DEVELOP("ISpinButton::value");
   long lValue = 0;
   if (inputTypeAllowed() == numeric) {
      handle().sendEvent(SPBM_QUERYVALUE,
                         IEventParameter1((void*)&lValue),
                         IEventParameter2(0, SPBQ_DONOTUPDATE));
   } else
      ITHROWLIBRARYERROR(IC_INVALID_RANGE_OPERATION,
                         IErrorInfo::invalidRequest,
                         IException::recoverable);
   return lValue;
}

/*------------------------------------------------------------------------------
| ISpinButton::setValue                                                        |
|                                                                              |
| Set the spin field with the specified value.                                 |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: setValue ( long aValue )
{
   IMODTRACE_DEVELOP("ISpinButton::setValue");

   if (inputTypeAllowed() == numeric) {

      // Work-around for window id breakage in Warp GA for the child
      // entry field of a spin button control (it should be the window
      // id of the parent spin button, but is 1).
      IWindowHandle hEntryFd =
          IWindow::handleWithId( id(), this->handle() );
      if (!hEntryFd)
      {            // Can't find a child entry field of a spin button.
         hEntryFd = IWindow::handleWithId( 1, this->handle() );
      }            // Try again with the one Warp GA uses.

      ITRACE_DEVELOP(IString("Value to be set is ") + IString(aValue));
      WinSetWindowText(hEntryFd, (const char*)IString(aValue));
   } else
      ITHROWLIBRARYERROR(IC_INVALID_RANGE_OPERATION,
                         IErrorInfo::invalidRequest,
                         IException::recoverable);
   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::text                                                            |
|                                                                              |
| Query the spin field text                                                    |
------------------------------------------------------------------------------*/
IString ISpinButton :: text  ( ) const
{
   if (inputTypeAllowed() != alphanumeric) {
      ITHROWLIBRARYERROR(IC_INVALID_TEXT_OPERATION,
                         IErrorInfo::invalidRequest,
                         IException::recoverable);
   }

   // Work-around for window id breakage in Warp GA for the child
   // entry field of a spin button control (it should be the window
   // id of the parent spin button, but is 1).
   IWindowHandle hEntryFd =
       IWindow::handleWithId( id(), this->handle() );
   if (!hEntryFd)
   {            // Can't find a child entry field of a spin button.
      hEntryFd = IWindow::handleWithId( 1, this->handle() );
   }            // Try again with the one Warp GA uses.

   unsigned long ulClBufLen =
         (unsigned long)WinQueryWindowTextLength(hEntryFd) + 1;

   char* pszClBuf = new char[ulClBufLen];
   WinQueryWindowText(hEntryFd, ulClBufLen, pszClBuf);
   IString str(pszClBuf);
   delete [] pszClBuf;
   return str;
}

/*------------------------------------------------------------------------------
| ISpinButton::setText                                                         |
|                                                                              |
| Set the spin field text.                                                     |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: setText ( const char* string )
{
   if (inputTypeAllowed() != alphanumeric) {
      ITHROWLIBRARYERROR(IC_INVALID_TEXT_OPERATION,
                         IErrorInfo::invalidRequest,
                         IException::recoverable);
   }

   IString strOrigText = this->text();
   if (strOrigText != string)
   {
      // Work-around for window id breakage in Warp GA for the child
      // entry field of a spin button control (it should be the window
      // id of the parent spin button, but is 1).
      IWindowHandle hEntryFd =
          IWindow::handleWithId( id(), this->handle() );
      if (!hEntryFd)
      {            // Can't find a child entry field of a spin button.
         hEntryFd = IWindow::handleWithId( 1, this->handle() );
      }            // Try again with the one Warp GA uses.

      WinSetWindowText(hEntryFd, string);
      this->notifyObservers(INotificationEvent(
                            IBaseSpinButton::textId, *this));
   }
   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::setText                                                         |
|                                                                              |
| Set the spin field text.                                                     |
------------------------------------------------------------------------------*/
ISpinButton&  ISpinButton :: setText(const IResourceId& residText)
{
  IString str = residText.resourceLibrary().loadString(residText);
  return setText((char*)str);
}

/*------------------------------------------------------------------------------
| ISpinButton::removeAll                                                       |
|                                                                              |
| Remove all spin text elements.                                               |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: removeAll ( )
{
   if (inputTypeAllowed() == alphanumeric) {
      this->spinText = "";
      this->lCount = 0;
      this->bDelayedItems = 0;

      if (this->pList) {
         delete [] this->pList;
         this->pList = 0;
      }
      char* nullList[1];
      nullList[0] = "";
      unsigned long ulOk =
           handle().sendEvent(SPBM_SETARRAY,
                              IEventParameter1(nullList),
                              IEventParameter2(1));
      if (!ulOk)
         ITHROWGUIERROR2("SPBM_SETARRAY",
                         IErrorInfo::accessError,
                         IException::recoverable);
   } else
      ITHROWLIBRARYERROR(IC_INVALID_TEXT_OPERATION,
                         IErrorInfo::invalidRequest,
                         IException::recoverable);
   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::Cursor::Cursor                                                  |
|                                                                              |
| Cursor constructor.                                                          |
------------------------------------------------------------------------------*/
ISpinButton::Cursor::Cursor(const ISpinButton& spBut )
  : rSpBut(spBut), lCurrent(0),
     ulCurCount(spBut.lCount)
{
  IMODTRACE_DEVELOP("ISpinButton::Cursor::ctor");

   if (spBut.inputTypeAllowed() == numeric) {
     ITHROWLIBRARYERROR(IC_INVALID_TEXT_OPERATION,
                        IErrorInfo::invalidRequest,
                        IException::recoverable);
  }
}

/*------------------------------------------------------------------------------
| ISpinButton::Cursor::~Cursor                                                 |
------------------------------------------------------------------------------*/
ISpinButton::Cursor::~Cursor ( )
{

}

/*------------------------------------------------------------------------------
| ISpinButton::Cursor::setToFirst                                              |
|                                                                              |
| Set the cursor to the first element.                                         |
------------------------------------------------------------------------------*/
Boolean ISpinButton::Cursor::setToFirst ()
{
  if ( (this->ulCurCount = rSpBut.lCount) > 0) {     //Validate the cursor
     this->lCurrent = 1;
     return true;
  } else {
     this->lCurrent = 0;
     return false;
  }
}

/*------------------------------------------------------------------------------
| ISpinButton::Cursor::setToNext                                               |
|                                                                              |
| Set the cursor to the next element.                                          |
------------------------------------------------------------------------------*/
Boolean ISpinButton::Cursor :: setToNext ()
{
   if (this->lCurrent == 0)
      return this->setToFirst();
   else {
      if (this->isValid() && this->lCurrent < this->ulCurCount) {
         ++this->lCurrent;
         return true;
      } else {
         this->lCurrent = 0;
         return false;
      }
   }
}

/*------------------------------------------------------------------------------
| ISpinButton::Cursor::setToPrevious                                           |
|                                                                              |
| Set the cursor to the previous element.                                      |
------------------------------------------------------------------------------*/
Boolean ISpinButton::Cursor :: setToPrevious ()
{
   if (this->lCurrent == 0)
      return this->setToLast();
   else {
      if (this->isValid() && this->lCurrent > 1) {
         --this->lCurrent;
         return true;
      } else {
         this->lCurrent = 0;
         return false;
      }
   }
}

/*------------------------------------------------------------------------------
| ISpinButton::Cursor::setToLast                                               |
|                                                                              |
| Set the cursor to the last element.                                          |
------------------------------------------------------------------------------*/
Boolean ISpinButton::Cursor :: setToLast ()
{
  if ( (this->ulCurCount = rSpBut.lCount) > 0) {      //Validate the cursor
     this->lCurrent = this->ulCurCount;
     return true;
  } else {
     this->lCurrent = 0;
     return false;
  }
}

/*------------------------------------------------------------------------------
| ISpinButton::refreshText                                                     |
|                                                                              |
| Adds or replaces elements in the spin button.                                |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::refreshText ( )
{
   IMODTRACE_DEVELOP("ISpinButton::refreshText");
   IASSERTSTATE(inputTypeAllowed() == alphanumeric);

   this->bDelayedItems = false;
   if (this->lCount > 0) {

      if (this->pList) {
         delete [] this->pList;
      }

      this->pList = new char*[this->lCount];
      unsigned int lIndex = 0;

      for (int ix = 0; ix < this->lCount ; ix++ ) {
                                       //Use the string buffer address to setup
                                       //pList char* address.
         this->pList[ix] = (char*)this->spinText + lIndex;
         lIndex = this->spinText.indexOf('\0', lIndex + 1);
      }

      unsigned long ulOk =
           handle().sendEvent(SPBM_SETARRAY,
                              IEventParameter1((char*)this->pList),
                              IEventParameter2((unsigned short)this->lCount));
      if (!ulOk)
          ITHROWLIBRARYERROR(IC_SET_SPIN_ARRAY_FAIL,
                             IErrorInfo::invalidRequest,
                             IException::recoverable);
   } else                              //If we have removed all of the
                                       //elements simply call removeAll
      removeAll();

   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::elementAt                                                       |
|                                                                              |
| Return the text element at cursor position.                                  |
------------------------------------------------------------------------------*/
IString ISpinButton::elementAt ( const Cursor& cursor ) const
{
   IMODTRACE_DEVELOP("ISpinButton::elementAt");
   IASSERTPARM(cursor.isValid());
   IASSERTSTATE(inputTypeAllowed() == alphanumeric);

   unsigned long lIndex = findStringIndex(cursor);
   return IString((char*)this->spinText.subString(lIndex));
}

/*------------------------------------------------------------------------------
| ISpinButton::removeAt                                                        |
|                                                                              |
| Remove the text element at cursor position.                                  |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::removeAt( Cursor& cursor,
                                    Boolean  immediateUpdate )
{
   IMODTRACE_DEVELOP("ISpinButton::removeAt");
   IASSERTPARM(cursor.isValid());
   IASSERTSTATE(inputTypeAllowed() == alphanumeric);

   unsigned long lIndex = findStringIndex(cursor);
   IString subStr = (char*)this->spinText.subString(lIndex);

   this->spinText.remove(lIndex, subStr.length()+1);
   --cursor.ulCurCount;                //Decrement count
   --this->lCount;

   if (cursor.lCurrent > cursor.ulCurCount)
      --cursor.lCurrent;              //Set cursor to previous

   ITRACE_DEVELOP(IString("Number of item = ") + IString(cursor.ulCurCount));
   ITRACE_DEVELOP(IString("Cursor at  = ") + IString(cursor.lCurrent));

   if (immediateUpdate)
      refreshText();
   else
      bDelayedItems = true;

   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::replaceAt                                                       |
|                                                                              |
| Replace the text element at the cursor position.                             |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::replaceAt  ( const IResourceId& resid,
                                       Cursor &cursor,
                                       Boolean  immediateUpdate )
{
   IString newText=resid.resourceLibrary().loadString(resid);
   return replaceAt(newText,cursor,immediateUpdate);
}

/*------------------------------------------------------------------------------
| ISpinButton::replaceAt                                                       |
|                                                                              |
| Replace the text element at the cursor position.                             |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::replaceAt  ( const char* newString,
                                       Cursor &cursor,
                                       Boolean  immediateUpdate )
{
   IMODTRACE_DEVELOP("ISpinButton::replaceAt");
   ITRACE_DEVELOP(IString("Number of item = ") + IString(cursor.ulCurCount));
   ITRACE_DEVELOP(IString("Cursor at b4 = ") + IString(cursor.lCurrent));

   IASSERTPARM(cursor.isValid());
   IASSERTSTATE(inputTypeAllowed() == alphanumeric);

   Boolean bLast = false;

   if (cursor.lCurrent == this->lCount)
      bLast = true;

   removeAt(cursor, false);

   if (bLast)
       addAsLast(newString, cursor, immediateUpdate);
   else
      if (this->lCount == 0 || cursor.lCurrent == 1)
         addAsFirst(newString, cursor, immediateUpdate);
      else {
         --cursor.lCurrent;
         addAsNext(newString, cursor, immediateUpdate);
      }

   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::findStringIndex                                                 |
|                                                                              |
| Locate the index of the string corresponding to the cursor position.         |
------------------------------------------------------------------------------*/
unsigned long ISpinButton::findStringIndex(const Cursor & cursor) const
{
   IMODTRACE_DEVELOP("ISpinButton::findStringIndex");
   /***************************************************/
   /* Loop to locate index of string to parse string. */
   /***************************************************/
   long lIndex = 1;
   for (int i=1; i < cursor.lCurrent; i++ ) {
     lIndex = this->spinText.indexOf('\0', lIndex);
     ++lIndex;
     ITRACE_DEVELOP(IString("Index = ") + IString(lIndex));
   }
   return lIndex;
}

/*------------------------------------------------------------------------------
| ISpinButton::addAsFirst                                                      |
|                                                                              |
| Adds the text as the first item and sets the cursor upon it.                 |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::addAsFirst ( const IResourceId& resid,
                                       Cursor&  object,
                                       Boolean  immediateUpdate )
{
   IString newText=resid.resourceLibrary().loadString(resid);
   return addAsFirst(newText, object, immediateUpdate);
}

/*------------------------------------------------------------------------------
| ISpinButton::addAsFirst                                                      |
|                                                                              |
| Adds the text as the first item and sets the cursor upon it.                 |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::addAsFirst ( const char* string,
                                       Cursor&  object,
                                       Boolean  immediateUpdate )
{
   IMODTRACE_DEVELOP("ISpinButton::addAsFirst");
   IASSERTSTATE(inputTypeAllowed() == alphanumeric);

   unsigned long ulLen1 = strlen(string) + 1;
   unsigned long ulLen2 = this->spinText.length();
   if (ulLen2)
      this->spinText = IString(string, ulLen1, (char*)this->spinText, ulLen2);
   else
      this->spinText = IString(string, ulLen1);

   object.lCurrent = 1;                //Set cursor to first
   ++this->lCount;
   object.ulCurCount = this->lCount;   // Validate

   ITRACE_DEVELOP(IString("Number of item = ") + IString(object.ulCurCount));
   ITRACE_DEVELOP(IString("Cursor at = ") + IString(object.lCurrent));

   if (immediateUpdate)
      refreshText();
   else
      bDelayedItems = true;
   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::addAsLast                                                       |
|                                                                              |
| Adds the text as the last  item and sets the cursor upon it.                 |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::addAsLast  ( const IResourceId& resid,
                                       Cursor& object,
                                       Boolean  immediateUpdate )
{
   IString newText=resid.resourceLibrary().loadString(resid);
   return addAsLast(newText, object, immediateUpdate);
}

/*------------------------------------------------------------------------------
| ISpinButton::addAsLast                                                       |
|                                                                              |
| Adds the text as the last  item and sets the cursor upon it.                 |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::addAsLast  ( const char* string, Cursor& object,
                                       Boolean  immediateUpdate )
{
   IMODTRACE_DEVELOP("ISpinButton::addAsLast");
   IASSERTSTATE(inputTypeAllowed() == alphanumeric);

   unsigned long ulLen1 = this->spinText.length();
   unsigned long ulLen2 = strlen(string) + 1;

   if (ulLen1)
      this->spinText = IString((char*)this->spinText, ulLen1, string, ulLen2);
   else
      this->spinText = IString(string, ulLen2);

   ++this->lCount;
   object.ulCurCount = this->lCount;      //Validate
   object.setToLast();                    //Set cursor to last

   ITRACE_DEVELOP(IString("Number of item = ") + IString(object.ulCurCount));
   ITRACE_DEVELOP(IString("Cursor at = ") + IString(object.lCurrent));

   if (immediateUpdate)
      refreshText();
   else
      bDelayedItems = true;

   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::add                                                             |
|                                                                              |
| Add a new item at the cursor location by pushing all the following items     |
| after the cursor.                                                            |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: add ( const IResourceId& resid, Cursor& cursor ,
                                 Boolean  immediateUpdate )
{
   IString newText=resid.resourceLibrary().loadString(resid);
   return add(newText, cursor, immediateUpdate);
}

/*------------------------------------------------------------------------------
| ISpinButton::add                                                             |
|                                                                              |
| Add a new item at the cursor location by pushing all the following items     |
| after the cursor.                                                            |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: add ( const char* string, Cursor& cursor ,
                                  Boolean  immediateUpdate )
{
   IMODTRACE_DEVELOP("ISpinButton::add");
   IASSERTPARM(cursor.isValid());
   IASSERTSTATE(inputTypeAllowed() == alphanumeric);
   ITRACE_DEVELOP(IString("Number of item b4 = ") + IString(cursor.ulCurCount));
   ITRACE_DEVELOP(IString("Cursor at b4 = ") + IString(cursor.lCurrent));

   if (cursor.lCurrent == this->lCount)
      addAsLast(string, cursor, immediateUpdate);
   else {
      ++cursor.lCurrent;
      unsigned long ulLen1 = findStringIndex(cursor) - 1;
      unsigned long ulLen2 = strlen(string) + 1;
      unsigned long ulLen3 = this->spinText.length() - ulLen1;
      this->spinText = IString((char*)this->spinText,
                               ulLen1,
                               string,
                               ulLen2,
                               (char*)this->spinText.subString(ulLen1 + 1),
                               ulLen3);

      ++cursor.ulCurCount;             //Increment counts
      ++this->lCount;

      if (immediateUpdate)
         refreshText();
      else
         this->bDelayedItems = true;
   }

   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::setCurrent                                                      |
|                                                                              |
| Set the spin field to the specified field.                                   |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: setCurrent ( const Cursor& cursor )
{
   IMODTRACE_DEVELOP("ISpinButton::setCurrent");
   ITRACE_DEVELOP(IString("Number of item b4 = ") + IString(cursor.ulCurCount));
   ITRACE_DEVELOP(IString("Cursor at b4 = ") + IString(cursor.lCurrent));

   IASSERTPARM(cursor.isValid());

   if (this->bDelayedItems)
      refreshText();
   handle().sendEvent(SPBM_SETCURRENTVALUE,
                      IEventParameter1((unsigned long)(cursor.lCurrent - 1)),
                      IEventParameter2(0));
   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::enable                                                          |
|                                                                              |
| Enables the window to accept keyboard and mouse input.                       |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: enable ( Boolean enableControl )
{
   IWindow::enable( enableControl);
   refresh();
   return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::calcMinimumSize                                                 |
|                                                                              |
| Return the minimum size of the spin button based on the font and the text    |
| limit.                                                                       |
------------------------------------------------------------------------------*/
ISize ISpinButton :: calcMinimumSize() const
{
  unsigned long ulClTextLimit = limit();

  IFont font( this );
  unsigned long ulWidth = font.avgCharWidth()   // Average char width
                            * ulClTextLimit;
  unsigned long ulHeight = font.maxCharHeight();

  /*****************************************************************/
  /* Use a step function to reflect the fact that you are more     */
  /* likely to exceed an average character width with an           */
  /* individual character, but a long string will likely be ok     */
  /* with this average value.                                      */
  /*****************************************************************/
  // DEFECT 8842 : earlier algorithm gave uneven length increases;
  // simplify to a smooth curve of lengths over text limit range.
  if (ulClTextLimit <= 2)
     ulWidth = (unsigned long)(ulWidth * 3);
  else if (ulClTextLimit <=16)
     ulWidth = (unsigned long)(ulWidth + 5);
  else if (ulClTextLimit <=24)
     ulWidth = (unsigned long)(ulWidth + 4);
  else if (ulClTextLimit <=32)
     ulWidth = (unsigned long)(ulWidth + 3);
  else if (ulClTextLimit <=40)
     ulWidth = (unsigned long)(ulWidth + 2);
  else if (ulClTextLimit <=48)
     ulWidth = (unsigned long)(ulWidth + 1);

  /*****************************************************************/
  /* Add room for the spin arrows, but still be sure that the size */
  /* does not exceed 35 avg chars                                  */
  /*                                                               */
  /* Note: Spin arrows are 17 pels wide.                           */
  /*****************************************************************/
  ulWidth += 17;
  unsigned long maxWidth = font.avgCharWidth() * 35;
  if ( ulWidth > maxWidth )
  {
     ulWidth = maxWidth;
  }

  if (!(style() & SPBS_NOBORDER))
  {                     // Entry field has border.
     ulWidth += (3 * WinQuerySysValue(HWND_DESKTOP,SV_CXBORDER));
     ulHeight += font.avgLowercase();
  }

  return ISize(ulWidth, ulHeight);
}

/*------------------------------------------------------------------------------
| ISpinButton::defaultStyle                                                    |
|                                                                              |
| Return the default style for new static text objects.                        |
------------------------------------------------------------------------------*/
ISpinButton::Style  ISpinButton :: defaultStyle()
{
  return currentDefaultStyle;
}

/*------------------------------------------------------------------------------
| ISpinButton::setReadOnly                                                     |
|                                                                              |
| Set or remove the readOnly style on the spinbutton.                          |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::setReadOnly (Boolean bReadOnly)
{
  unsigned long ulStyle = style();
  unsigned long ulOldStyle = ulStyle;

  if (bReadOnly)
  {
    ulStyle |= readOnly.asUnsignedLong();
  }
  else
  {
    ulStyle &= ~readOnly.asUnsignedLong();
  }

  if (ulStyle != ulOldStyle)
  {
    setStyle(ulStyle);              //Change style
    refresh();                      // force refresh
  }
  return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::setFastSpin                                                     |
|                                                                              |
| Set or remove the fastSpin style on the the spinbutton.                      |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::setFastSpin (Boolean fast)
{
  unsigned long ulStyle = style();
  unsigned long ulOldStyle = ulStyle;

  if (fast)
  {
    ulStyle |= fastSpin.asUnsignedLong();
  }
  else
  {
    ulStyle &= ~fastSpin.asUnsignedLong();
  }

  if (ulStyle != ulOldStyle)
  {
    setStyle(ulStyle);
  }
  return *this;
}

/*------------------------------------------------------------------------------
| ISpinButton::enableBorder                                                    |
|                                                                              |
| Enable or disable the border on the spinbutton.                              |
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton::enableBorder (Boolean enable)
{
  unsigned long ulStyle = style();
  unsigned long ulOldStyle = ulStyle;

  if (enable)
  {
    ulStyle &= ~noBorder.asUnsignedLong();
  }
  else
  {
    ulStyle |= noBorder.asUnsignedLong();
  }

  if (ulStyle != ulOldStyle)
  {
    setStyle(ulStyle);
    refresh();                      // force refresh
  }
  return *this;
}

ISpinButton& ISpinButton :: disableBorder ( )
/*------------------------------------------------------------------------------
   Suppress drawing the spin field border.
------------------------------------------------------------------------------*/
{
   return enableBorder(false);
}

IBase::Boolean ISpinButton :: isMaster ( ) const
/*------------------------------------------------------------------------------
   Is the spin button a master?
------------------------------------------------------------------------------*/
{
   return (style() & master.asUnsignedLong()) ? true : false;
}

IBase::Boolean ISpinButton :: isServant  ( ) const
/*------------------------------------------------------------------------------
   Is the spin button a servant?
------------------------------------------------------------------------------*/
{
   return (!isMaster());
}

IBase::Boolean ISpinButton :: isReadOnly ( ) const
/*------------------------------------------------------------------------------
   Is the spin field read only?
------------------------------------------------------------------------------*/
{
   return (style() & readOnly.asUnsignedLong()) ? true : false;
}

IBase::Boolean ISpinButton :: isFastSpin ( ) const
/*------------------------------------------------------------------------------
   Is fast spin activated?
------------------------------------------------------------------------------*/
{
   return (style() & fastSpin.asUnsignedLong()) ? true : false;
}

IBase::Boolean ISpinButton :: isBorder   ( ) const
/*------------------------------------------------------------------------------
   Does the spin field has a border?
------------------------------------------------------------------------------*/
{
   return (style() & noBorder.asUnsignedLong()) ? false : true;
}

ISpinButton::Type ISpinButton :: inputTypeAllowed ( ) const
/*------------------------------------------------------------------------------
   Returns the input type allowed.
------------------------------------------------------------------------------*/
{
   return (style() & numericOnly.asUnsignedLong()) ? numeric : alphanumeric;
}

ISpinButton& ISpinButton :: spinTo  ( long aValue )
/*------------------------------------------------------------------------------
   Set the current number with the range in the spin field.
------------------------------------------------------------------------------*/
{
   return setCurrent(aValue);
}

void ISpinButton::Cursor :: invalidate ()
/*------------------------------------------------------------------------------
  Invalidate the cursor
------------------------------------------------------------------------------*/
{
   this->lCurrent = 0;
}

IBase::Boolean ISpinButton::Cursor :: isValid () const
/*------------------------------------------------------------------------------
  Is the cursor valid?
------------------------------------------------------------------------------*/
{
   return (this->lCurrent > 0 && this->ulCurCount == rSpBut.lCount) ? true : false;
}

ISpinButton& ISpinButton :: spinTo ( const Cursor& cursor )
/*------------------------------------------------------------------------------
   Set the current text to the text at the cursor position.
------------------------------------------------------------------------------*/
{
   return setCurrent(cursor);
}

/*------------------------------------------------------------------------------
   Add a text next to the current cursor position.
------------------------------------------------------------------------------*/
ISpinButton& ISpinButton :: addAsNext  ( const char*   string,
                                         Cursor& cursor, Boolean immediateUpdate )
{
   add(string, cursor, immediateUpdate);
   return *this;
}

ISpinButton& ISpinButton :: addAsNext  ( const IResourceId& resid,
                                         Cursor& cursor, Boolean immediateUpdate )
{
   IString newText=resid.resourceLibrary().loadString(resid);
   return addAsNext(newText,cursor,immediateUpdate);
}

void  ISpinButton :: setDefaultStyle(const ISpinButton::Style& stsStyle)
/***************************************************************/
/* Replace the default style for new static text objects.      */
/***************************************************************/
{
  currentDefaultStyle = stsStyle;
}


unsigned long ISpinButton::limit ( ) const
/*------------------------------------------------------------------------------
   Returns the number of characters allowed.
------------------------------------------------------------------------------*/
{
   return this->textLimit;
}

//
//
//  End of obsolete function for obsolete level 1
//
//

#endif
