#ifndef _IENTRYFD_
  #define _IENTRYFD_
/*******************************************************************************
* FILE NAME: ientryfd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IEntryField                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <irect.hpp>

class IRange;
class ISize;
class IString;
class IResourceId;
class IColor;
class IEntryFieldData;

#pragma pack(4)

class IEntryField : public ITextControl {
typedef ITextControl
  Inherited;

public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IEntryField  ( unsigned long        id,
                 IWindow*             parent,
                 IWindow*             owner,
                 const IRectangle&    initial = IRectangle(),
                 const Style&         style = defaultStyle() );

  IEntryField  ( unsigned long        id,
                 IWindow*             parent );

  IEntryField  ( const IWindowHandle& handle );

virtual
 ~IEntryField  ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IEntryField, IWindow, IControl);

static const Style
  classDefaultStyle,
  autoScroll,
  margin,
  readOnly,
  unreadable,
  leftAlign,
  centerAlign,
  rightAlign;
static const Style
  autoTab,
  command,
  anyData,
  sbcsData,
  dbcsData,
  mixedData;
#ifndef IC_MOTIFPM_FLAGNOP
static const Style
  border3D;
#endif

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*---------------------------- Enumerations ----------------------------------*/
enum Alignment {
  left,
  center,
  right
};

enum CharType {
  sbcs
  , dbcs,
  any,
  mixed
};

/*-------------------------------- Attributes --------------------------------*/
Alignment
  alignment          ( ) const;

CharType
  charType           ( ) const;

#ifndef IC_WIN_FLAGNOP
virtual IEntryField
 &enableCommand      ( Boolean   enable=true ),
 &disableCommand     ( );
#endif

#ifdef IC_PMWIN
// defect: 9826 Moved the foloowing 2 virtual function back into the correct
//  order.  The previous defect 4624, moved the functions, thus messing
//  up the vft.  They MUST exist where they were originally defined.
virtual IEntryField
 &enableAutoTab      ( Boolean   enable=true ),
 &disableAutoTab     ( );
#endif

#ifndef IC_WIN_FLAGNOP
virtual IEntryField
 &setAlignment       ( Alignment alignment ),
 &setCharType        ( CharType  type ),
 &enableAutoScroll   ( Boolean   enable=true ),
 &disableAutoScroll  ( );

virtual IEntryField
 &enableMargin       ( Boolean   enable=true ),
 &disableMargin      ( );
#endif

Boolean
  isCommand          ( ) const,
  isAutoTab          ( ) const,
  isAutoScroll       ( ) const,
  isMargin           ( ) const;

/*-------------------------------- Clipboard Operations ----------------------*/
virtual IEntryField
 &cut        ( unsigned long timestamp=0 ),
 &copy       ( unsigned long timestamp=0 ),
 &paste      ( ),
 &clear      ( unsigned long timestamp=0 ),
 &discard    ( ),
 &removeAll  ( );

/*------------------------- Overloaded Disable/Enable Window -----------------*/
virtual IEntryField
 &disable  ( ),
 &enable   ( Boolean enable=true );

/*-------------------------------- Insert Mode -------------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual IEntryField
 &enableInsertMode   ( Boolean insert=true ),
 &disableInsertMode  ( );
#endif

Boolean
  isInsertMode       ( ) const;

/*---------------------------- Read-Only Operations --------------------------*/
virtual IEntryField
 &enableDataUpdate   ( Boolean update=true ),
 &disableDataUpdate  ( );

Boolean
  isWriteable        ( ) const;

/*-------------------------------- Text Limit --------------------------------*/
virtual IEntryField
 &setLimit  ( unsigned long      textLimit ),
 &setLimit  ( const IResourceId& textLimit );

unsigned long
  limit     ( ) const;

/*-------------------------------- Selected Text -----------------------------*/
static const long end;

virtual IEntryField
 &selectRange    ( const IRange& range = IRange(0,end),
                   unsigned long timestamp = 0 );

IRange
  selectedRange ( ) const;

IString
  selectedText  ( ) const;

unsigned long
  selectedTextLength ( ) const;

virtual IEntryField
 &setCursorPosition( unsigned long newCursorPos );

unsigned long
  cursorPosition ( ) const;

/*-------------------------------- Left Index --------------------------------*/
virtual IEntryField
  &setLeftIndex ( unsigned long index );

#ifndef IC_WIN_FLAGNOP
unsigned long
  leftIndex    ( ) const;
#endif

/*-------------------------------- Test Operations ---------------------------*/
Boolean
  hasChanged      ( ) const,
  isEmpty         ( ) const,
  hasSelectedText ( ) const;

virtual IEntryField
  &setChangedFlag ( Boolean changeFlag = true );

IEntryField
 &setTextChangedFlag    ( Boolean changed=true ),
 &resetTextChangedFlag  ( );

Boolean
  hasTextChanged  ( ) const;

/*---------------------------------- Colors ----------------------------------*/
virtual IColor
  foregroundColor ( ) const,
  backgroundColor ( ) const;


/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
#ifndef IC_WIN_FLAGNOP
  insertModeId,
#endif
  dataUpdateId,
  limitId,
  characterTypeId;

/*----------------------- Observer Notification ------------------------------*/
virtual IEntryField
 &enableNotification ( Boolean enable=true );

/*-------------------------------- Accessors ---------------------------------*/


protected:
/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;



/*---------------------------------- Styles ----------------------------------*/
virtual IEntryField
 &setStyle ( unsigned long style );

/*------------------------------- Constructors -------------------------------*/
  IEntryField ( );


private:
/*------------------------------ Hidden Members ------------------------------*/
  IEntryField  ( const IEntryField& entryField );
IEntryField
 &operator=    ( const IEntryField& entryField );

/*--------------------------------- Private ----------------------------------*/
friend class IEntryFieldNotifyHandler;

IRange
  getCursorInfo ( ) const;

void
  setCursorInfo ( const IRange &range );

static Style
  currentDefaultStyle;

enum ReadStatus {
  doesntMatter,
  wasInput,
  wasRead,
  wasInputButReset,
  wasReadButReset
};

ReadStatus
  eReadStatus;

Boolean
  queryInsMode;

IEntryFieldData
 *fEntryFieldData;

/*------------------------------ Obsolete Members ----------------------------*/
#if ( IC_OBSOLETE <= IC_OBSOLETE_1 )
public:
enum ColorArea {
  foreground,
  background,
  disabledForeground,
  highlightForeground,
  border
};

IEntryField
  &setColor ( ColorArea value, const IColor& color );

IColor
  color     ( ColorArea value ) const;

Boolean
  isReadOnly         ( ) const;
#endif
}; // IEntryField

INESTEDBITFLAGCLASSFUNCS(Style, IEntryField);

#pragma pack()

#endif  /* _IENTRYFD_ */
