/* NOSHIP */
#ifndef _IPLATFRM_
  #define _IPLATFRM_
/*******************************************************************************
* FILE NAME: iplatfrm.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains a class that sets static variables that determine       *
*   the runtime operating system (platform)                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

/*******************************************************************************
*  The platform variables are static.  They are initialized once,              *
*  automatically during initialization.                                        *
*                                                                              *
*  Therefore when querying the current platform, there is no need to create    *
*  an instance of this class.                                                  *
*  Call the static functions.  For example:  IPlatform::numProcessors()        *
*******************************************************************************/
#include <ibase.hpp>

#pragma pack(4)


class IPlatform : public IBase {
public:

/*------------------------------- Public Functions ---------------------------*/

static int
  numProcessors ();

private:
/*------------------------------- Constructors -------------------------------*/

  IPlatform();
  IPlatform(const IPlatform& x);       /* Copy Constructor */

/*------------------------------- Other Private functions---------------------*/

  IPlatform& operator=(const IPlatform&);
};

#pragma pack()

#endif  /*  _IPLATFRM_ */
