#ifndef _IBASE_
#define _IBASE_
/*******************************************************************************
* FILE NAME: ibase.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBase                                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iexcbase.hpp>

#pragma pack(4)

class ostream;
class IString;

class IBase {
public:

/*--------------------------- Boolean Definitions ----------------------------*/
typedef int
  Boolean;

enum BooleanConstants {
  false = 0,
  true  = 1
  };

/*--------------------------------- Messages ---------------------------------*/
static char
 *messageFile    ( );

static void
  setMessageFile ( const char *msgFileName );

static IMessageText
  messageText    ( unsigned long messageId,
                   const char*   textInsert1 = 0,
                   const char*   textInsert2 = 0,
                   const char*   textInsert3 = 0,
                   const char*   textInsert4 = 0,
                   const char*   textInsert5 = 0,
                   const char*   textInsert6 = 0,
                   const char*   textInsert7 = 0,
                   const char*   textInsert8 = 0,
                   const char*   textInsert9 = 0 );

/*------------------------------- Diagnostics --------------------------------*/
friend ostream
 &operator <<    ( ostream     &aStream,
                   const IBase &anObject );

IString
  asString       ( ) const,
  asDebugInfo    ( ) const;

struct Version   {
unsigned short
  major,
  minor;
  };

static Version
  version        ( );

protected:
/*---------------------------- Exception Severity ----------------------------*/
static IException::Severity
  unrecoverable,
  recoverable;

private:
/*--------------------------------- Private ----------------------------------*/
static char
 *msgFile;
}; // IBase

/*-------------------------- Static Object Priority --------------------------*/
#define IBASE_PRIORITY -2147483647 - 1 + 1024

#ifdef __BORLANDC__
  #define _System __stdcall __import //this is the definition of WINAPI from windef.h
  #define _Optlink
#endif

#ifdef __ZTC__
  #define _System  pascal far
  #define _Optlink
#endif

#ifdef __xlC__
  #define _System
  #define _Optlink
#endif

/*----------------------------- Platform Macros ------------------------------*/
#if ( !defined(IC_PM) && !defined(IC_MOTIF) && !defined(IC_WIN) )
  #ifdef __OS2__
     #define IC_PM
  #endif
  #ifdef _AIX
     #define IC_MOTIF
  #endif
  #ifdef __WINDOWS__
     #define IC_WIN
  #endif
#endif

#if defined(IC_PM)
  #define IC_PMWIN
  #define IC_MOTIFPM
#endif
#if defined(IC_MOTIF)
  #define IC_MOTIFPM
  #define IC_MOTIFWIN
#endif
#if defined(IC_WIN)
  #define IC_PMWIN
  #define IC_MOTIFWIN
#endif

/*------------------------------ Version Levels ------------------------------*/
#ifdef IC_WIN
  #define IC_MAJOR_VERSION 320
#endif
#ifdef IC_PM
  #define IC_MAJOR_VERSION 310
#endif

#define IC_MINOR_VERSION 801

#define IC_OBSOLETE_1    310

#ifndef IC_OBSOLETE
 #ifdef IC_WIN
   #define IC_OBSOLETE  320
 #endif
 #ifdef IC_PM
   #define IC_OBSOLETE  310
 #endif
#endif

extern "C" {

#ifdef IC_WIN

typedef void * (__stdcall
  IWinProc)( void *, unsigned long, void *, void * );

#endif
#ifndef IC_WIN

typedef void * _System
  IWinProc ( unsigned long, unsigned long, void *, void * );

#endif
}

#ifndef IC_RUNTIME
  #define IC_RUNTIME
#endif

#define IC_TRACE_RUNTIME

#ifdef IC_DEVELOP
  #define IC_TRACE_DEVELOP
#endif

#ifdef IC_TRACE_ALL
  #define IC_TRACE_DEVELOP
#endif

/*-------------------------- Implementation Messages -------------------------*/
#define IC_UM_BASE            ( 0xFF00 )
#ifdef IC_WIN
#define WM_CONTROL                ( IC_UM_BASE + 0xD0 )
#define WM_CONTEXTMENU            ( IC_UM_BASE + 0xD1 )
#define IC_UM_QUERYFRAMECTLCOUNT  ( IC_UM_BASE + 0xD2 )
#define IC_UM_FORMATFRAME         ( IC_UM_BASE + 0xD3 )
#define IC_UM_UPDATEFRAME         ( IC_UM_BASE + 0xD4 )
#define IC_UM_CALCFRAMERECT       ( IC_UM_BASE + 0xD5 )
#endif
#define IC_UM_DRAGDROP_RENDER     ( IC_UM_BASE + 0xE1 )
#define IC_UM_CANVAS_SETFOCUS     ( IC_UM_BASE + 0xE2 )
#define IC_UM_CANVAS_PAINT        ( IC_UM_BASE + 0xE3 )
#define IC_UM_CREATED             ( IC_UM_BASE + 0xE4 )
#define IC_UM_DESTROY_MENU        ( IC_UM_BASE + 0xE5 )
#define IC_UM_UNLATCH             ( IC_UM_BASE + 0xE6 )
#define IC_UM_BMP_VIEW            ( IC_UM_BASE + 0xE7 )
#define IC_UM_TXT_VIEW            ( IC_UM_BASE + 0xE8 )
#define IC_UM_BMP_TXT_VIEW        ( IC_UM_BASE + 0xE9 )
#define IC_UM_QRY_BMP_VISIBLE     ( IC_UM_BASE + 0xEA )
#define IC_UM_QRY_TXT_VISIBLE     ( IC_UM_BASE + 0xEB )
#define IC_UM_FLY_PAINT           ( IC_UM_BASE + 0xEC )
#define IC_UM_TOOLBAR             ( IC_UM_BASE + 0xED )
#define IC_UM_DRAW_DOWN           ( IC_UM_BASE + 0xEE )
#define IC_UM_QRY_PREVENTUPDATE   ( IC_UM_BASE + 0xEF )
#define IC_UM_WINDOWPOSCHANGED    ( IC_UM_BASE + 0xF0 )
#define IC_UM_DELAYNOTIFY         ( IC_UM_BASE + 0xF1 )
#define IC_UM_CLOSE               ( IC_UM_BASE + 0xF2 )
#define IC_UM_BIDI_CHANGE         ( IC_UM_BASE + 0xF3 )
#define IC_UM_MEDIA_LOADED        ( IC_UM_BASE + 0xF4 )
#define IC_UM_MEDIA_UNLOADED      ( IC_UM_BASE + 0xF5 )
#define IC_UM_DESTROY_FRAME       ( IC_UM_BASE + 0xF6 )

#ifndef IC_ID_BASE
  #define IC_ID_BASE            ( 0x7000 )
#endif

#define IC_RESERVED_TIMERS         1000

/*-------------------------- Notification Delay Ids --------------------------*/
#define IC_NOTDEL_SETBT_SELECT    ( IC_ID_BASE + 0xF00 )
#define IC_NOTDEL_PUSHBT_SELECT   ( IC_ID_BASE + 0xF01 )
#define IC_NOTDEL_EF_DATAUPD      ( IC_ID_BASE + 0xF02 )
#define IC_NOTDEL_EF_LIMIT        ( IC_ID_BASE + 0xF03 )
#define IC_NOTDEL_MLE_DATAUPD     ( IC_ID_BASE + 0xF04 )
#define IC_NOTDEL_MLE_LIMIT       ( IC_ID_BASE + 0xF05 )
#define IC_NOTDEL_SCRL_POS        ( IC_ID_BASE + 0xF06 )
#define IC_NOTDEL_BOOK_COLOR      ( IC_ID_BASE + 0xF07 )
#define IC_NOTDEL_TITLE_COLOR     ( IC_ID_BASE + 0xF08 )
#define IC_NOTDEL_MENU_COLOR      ( IC_ID_BASE + 0xF09 )
#define IC_NOTDEL_CNR_TITLE       ( IC_ID_BASE + 0xF0A )
#define IC_NOTDEL_FRAME_ACTIVE    ( IC_ID_BASE + 0xF0B )

/*------------------------------- Alias Names --------------------------------*/
#define IContainerObject           ICnrObj
#define IContainerControl          ICnrCtl
#define IDDEClientAcknowledgeEvent IDDECAckEvt
#define IDDEServerAcknowledgeEvent IDDESAckEvt
#define IDDEServerConversation     IDDESConv
#define IDDEServerHotLink          IDDESHotLnk
#define IDDEServerHotLinkItem      IDDESHLItem
#define IDDEActiveServer           IDDEActServ
#define IDDEClientHotLinkEvent     IDDECHLEvt
#define IDDEClosedConversation     IDDEClsConv
#define IRowColumnCanvas           IRCCv
#define AlignmentTag               Tag
#define RowColumn                  RCol

#pragma pack()

#ifndef _ISYNONYM_
  #include <isynonym.hpp>
#endif

#ifdef IC_PMWIN
#ifndef __MULTI__
 #error Error: Use of IBM Open Class Library requires the /Gm+ compiler option.
 #error Check the makefile (or its profile) for a missing /Gm+ option.
#endif
#endif

#endif /* _IBASE_ */
