//===============================================================
// vbtncmd.h - Button Command class -- Windows
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VBTNCMD_H
#define VBTNCMD_H

#include <v/v_defs.h>
#include <v/vapp.h>
#include <v/vcmd.h>	// We are derived from vcmd
#include <v/vcmdprnt.h>	// need PPElement
#include <v/vcolor.h>

  class vCmdParent;
  class vIcon;

  class vButtonCmd : public vCmd
  {
    public:   //---------------------------------------- public
      vButtonCmd(vCmdParent* dp, CommandObject* co);
      virtual ~vButtonCmd(void);
      virtual void initialize(void);
      virtual int GetCmdValue(ItemVal id);
      virtual void ResetItemValue(void);
      int ToggleCmdValue(void);
      int userClick(int clicked);
      virtual void SetCmdVal(ItemVal val, ItemSetType st);

      virtual void SetCmdStr(char* str);

//      virtual int MEASUREITEM(int id, USERBUTTON* ub);
      virtual int DRAWITEM(int id, OWNERITEM* ub);
      int GetOwnCmdValue(void);

      // Internal Methods
      MRESULT vBtnToggleProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

    protected:  //--------------------------------------- protected
      virtual void CmdCallback(UINT uMsg, MPARAM mp1, MPARAM mp2);

    private:		//--------------------------------------- private
      void initIconButton(long style);
      void initColorButton(void);
      vIcon* _ip;
      BTNCDATA _btncData;
      PPElement _PPColor[3];
      vColor _color;	// color of this button
      vColor* _origColor;	// ptr to orig color of this button
      int _click;
      PVOID _orgBtnProc;
  };
#endif
