//===============================================================
// vwinprtr.h: Windows Printer class .h file - Windows
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VWINPRTR_H
#define VWINPRTR_H

#include <v/v_defs.h>
#include <v/vmodald.h>

#define vPaperLetter 0
#define vPaperLegal 1
#define vPaperTabloid 2
#define vPaperLedger 3
#define vPaperStatement 4
#define vPaperExecutive 5
#define vPaperA3 6
#define vPaperA4 7
#define vPaperA5 8
#define vPaperB4 9
#define vPaperB5 10
#define vPaperFolio 11
#define vPaperQuarto 12
#define vPaper10x14 13

#define vPaperDefault vPaperLetter              // Index to default paper

// this stuff specific to OS/2 printers
#define MAX_DEVICENAME        32
#define MAX_QUEUENAME         10
#define MAX_QUEUEDESC         64
#define MAX_DRIVERNAME        128
#define MAX_BUFF              256

#define QUEUENAME_LENGTH      10
#define QUEUEDESC_LENGTH      64
#define DEVICENAME_LENGTH     32
#define DRIVERNAME_LENGTH     128

  class V_EXPORT vWinPrinter
  {
    public:           //---------------------------------------- public
      vWinPrinter();
      virtual ~vWinPrinter();
      vWinPrinter(const vWinPrinter& pr);

      vWinPrinter& operator =(const vWinPrinter& pr);

      int GetHeight(const int Mode) VCONST;
      int GetWidth(const int Mode) VCONST;
      FIXED GetScale(const int Mode) VCONST;

      VCONST char* GetDocName() VCONST {return _name;}

      int GetPortrait() VCONST {return _portrait;}
      void SetPortrait(int p) {_portrait = p;}

      int GetUseColors() VCONST {return _useColor;}
      void SetUseColors(int c) {_useColor = c;}

      int GetPaper() VCONST {return _paperType;}
      char* GetPaperName();

      int GetCopies() VCONST {return _copies;}
      void SetCopies(int s) {_copies = s;}

      int GetToFile() VCONST {return _toFile;}
      int Setup(VCONST char* fn = 0);

      HPS GetHDC() VCONST { return _printhDC; }

      // intended for internal use only, minimal error checking
      VOID NewFrame(VOID);
      USHORT EndDoc(VOID);
      HPS GetHDevC() { return _hPrintDevC; }
      HPS CreateHDC(const int Mode);
      VOID DestroyHDC(void);

      // os/2 callback
      int DynamicDlgProc(HWND hwnd, UINT msg, MPARAM mp1, MPARAM mp2);

    protected:        //--------------------------------------- protected

    private:          //--------------------------------------- private

      // these functions are for internal use only
      VOID EnumPrintQueues(HWND hWnd);
      VOID GetJobProps(ULONG Option);
      BOOL CreateInfoDC(void);
      void SplitDotName(PSZ DotName, PSZ DriverName, PSZ DeviceName);

      static int _instances;
      HPS _printhDC;

      // Printer attributes
      char* _name;            // name of stream
      LONG _copies;
      int _width;             // width of printer (logical units)
      int _height;            // height of printer (logical units)
      int _portrait;          // true if portrait, else landscape
      int _useColor;          // true if printer supports colors

      int _paperType;
      int _toFile;
      PVOID _pMem;            // base pointer for printer info
      int _isCopy;            // are we copied from another instance?
      int _bitmapOn;          // are we using a bitmap PS?
      USHORT _jobID;

      // OS/2 variables
      HDC       _hPrintDevC;

      HDC       _hMemDevC;           // used for bitmap blit mode
      HBITMAP   _hbm;                // used for bitmap blit mode
      HPS       _shadowPrinthDC;     // used for bitmap blit mode

      SIZEL     _PhyResDpi;          // raw printer resolutionin (dpi)
      SIZEL     _PrintSize;          // size in logical units of printer PS
      SIZEL     _PhyPagePels;        // size in pixels of printable page
      SIZEL     _PrintOffsetSizel;   // left/bottom margin size in pixels
      LONG      _PrintRange;
      BOOL      _Collate;
      LONG      _Priority;

      // PRQINFO3 Print-queue information structure.
      // This structure is used at information levels 3 and 4.
      // PSZ          pszName;        /* Queue name  */
      // USHORT       uPriority;      /* Queue priority  */
      // USHORT       uStartTime;     /* Minutes after midnight when queue becomes active  */
      // USHORT       uUntilTime;     /* Minutes after midnight when queue ceases to be active  */
      // USHORT       fsType;         /* Queue type  */
      // PSZ          pszSepFile;     /* Separator-page file  */
      // PSZ          pszPrProc;      /* Default queue-processor  */
      // PSZ          pszParms;       /* Queue parameters  */
      // PSZ          pszComment;     /* Queue description  */
      // USHORT       fsStatus;       /* Queue status  */
      // USHORT       cJobs;          /* Number of jobs in queue  */
      // PSZ          pszPrinters;    /* Print devices connected to queue  */
      // PSZ          pszDriverName;  /* Default device driver  */
      // PDRIVDATA    pDriverData;    /* Default queue job properties  */
      PPRQINFO3 _pPRQCurrent;
      ULONG     _SizePRQCurrent;

      // DRIVDATA Driver-data structure.
      // LONG    cb;                /* Length  */
      // LONG    lVersion;          /* Version  */
      // CHAR    szDeviceName[32];  /* Device name  */
      // CHAR    abGeneralData[1];  /* General data  */
      PDRIVDATA _pDDCurrent;
      ULONG     _SizeDDCurrent;
      PPRQINFO3 _pPRQArray;
      ULONG     _SizePRQArray;
      ULONG     _ixCurrent;

      CHAR      _QueueDesc[MAX_QUEUEDESC];
      CHAR      _QueueName[MAX_QUEUENAME];
  };

#endif
