/*
	This program is provided on an "as is" basis, without warranty of any
	kind. The entire risk as to the quality and performance of the program
	is borne by you.

    Report bugs to: july@cblink.net
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "v2i.h"

char *colors[] =
{
 	"black", "maroon", "green", "olive", "navy", "purple", "teal",
    "silver", "gray", "red", "lime", "yellow", "blue", "fuchsia",
    "aqua", "white"
};

rgbquad stdtable[] =
{
    { 0, 0, 0, 0 },            /*  0: black */
    { 0, 0, 0x80, 0 },         /*  1: maroon */
    { 0, 0x80, 0, 0 },         /*  2: green */
    { 0, 0x80, 0x80, 0 },      /*  3: olive */
    { 0x80, 0, 0, 0 },         /*  4: navy */
    { 0x80, 0, 0x80, 0 },      /*  5: purple */
    { 0x80, 0x80, 0, 0 },      /*  6: teal */
    { 0xc0, 0xc0, 0xc0, 0 },   /*  7: silver */
    { 0x80, 0x80, 0x80, 0 },   /*  8: gray */
    { 0, 0, 0xff, 0 },         /*  9: red */
    { 0, 0xff, 0, 0 },         /* 10: lime */
    { 0, 0xff, 0xff, 0 },      /* 11: yellow */
    { 0xff, 0, 0, 0 },         /* 12: blue */
    { 0xff, 0, 0xff, 0 },      /* 13: fuchsia */
    { 0xff, 0xff, 0, 0 },      /* 14: aqua */
    { 0xff, 0xff, 0xff, 0 }    /* 15: white */
};

icondir idir =
{
	0,	/* reserved */
    1,	/* type */
    1,	/* count */
};

icondirentry ientry =
{
 	32,			/* width */
    32,			/* height */
    16,			/* color count */
    0, 0, 0,	/* reserved, planes, bitcount */
    744,		/* bytes in resource */
    22,			/* image offset */
};

bitmapinfoheader ibmhdr =
{
 	40,			/* size of the structure */
    32,			/* width */
    64,			/* height */
    1,			/* planes */
    4,			/* bitcount */
    0, 			/* not used */
    640,		/* size of the image */
    0, 0, 0, 0	/* not used */
};

#define SQR(x)      ((x)*(x))
#define SQDIST(x,y) \
        (SQR((long)x.b - (long)y.b) + \
         SQR((long)x.g - (long)y.g) + \
         SQR((long)x.r - (long)y.r))

FILE *inf, *outf;

iconrec *icn;
iconrec *iarray[MAXICONS];
int iptr = 0;
int vbmfiles = 0;

char *outfile = 0;
static char scratch[128];	/* scratch buffer */
static char *cptr2[2];		/* work buffer for `processArgs' */

int f_help( int *, int, char *[] );
int f_outname( int *, int, char *[] );
int f_transpc( int *, int, char *[] );
int f_rgb( int *, int, char *[] );
int f_ul( int *, int, char *[] );
int f_ur( int *, int, char *[] );
int f_ll( int *, int, char *[] );
int f_lr( int *, int, char *[] );

void usage();
int allocrec();
int readvbm( char *name );
int writeico( char *name );
int bitmapsize( int width, int height, int colord );
int process_args( int argc, char *argv[], char *appn );

int main( int argc, char *argv[] )
{
    if( argc < 2 )
    {
        usage();
        return 0;
    }
 	allocrec();	/* ha! no check :-) */
    if( !process_args( argc, argv, "v2i" ) )
    	return 1;
    else
        return !writeico( outfile );
}

int allocrec()
{
    if( iptr > MAXICONS )
      	return 0;
	icn = iarray[iptr++] = (iconrec *)malloc( sizeof( iconrec ) );
    if( icn != 0 )
    {
	    memset( icn, 0, sizeof( iconrec ) );
	    icn->colortable = (int *)malloc( sizeof( int ) * 256 );
	    icn->pict = (int *)malloc( sizeof( int ) * 64 * 64 );
        if( icn->colortable != 0 && icn->pict != 0 )
        {
	    	memset( icn->colortable, 0, sizeof( int ) * 256 );
    		memset( icn->pict, 0, sizeof( int ) * 64 * 64 );
            icn->ttype = ttll;
            return 1;
        }
    	free( icn );
    }
	return 0;
}

int readvbm( char *name )
{
 	int res;

 	if( ( inf = fopen( name, "rt" ) ) == 0 )
	{
     	printf( "Can't open .vbm file (%s)!\n", name );
        return 0;
    }

    printf( "Processing file %s.\n", name );
	res = yyparse() == 0;

    vbmfiles++;
	fclose( inf );
    if( !allocrec() )
	{
    	if( iptr > MAXICONS )
     		printf( "Maximum number of %d .vbm files allowed!\n", MAXICONS );
		else
            printf( "Memory allocation error!\n" );
        return 0;
    }
    return res;
}

int writeico( char *name )
{
    int i, j, k, l, c, pad;
    long offset;

	if( vbmfiles == 0 )
      	return 1;
	if( name == 0 )
    {
    	printf( "No output name specified!\n" );
        return 0;
    }
	if( ( outf = fopen( name, "wb" ) ) == 0 )
    {
    	printf( "Error creating file (%s)!\n", name );
        return 0;
    }
    printf( "Writing file %s\n", name );
	idir.count = vbmfiles;
    fwrite( &idir, sizeof( icondir ), 1, outf );
    offset = sizeof( icondir ) + sizeof( icondirentry ) * vbmfiles;
    for( i = 0; i < vbmfiles; i++ )
	{
    	ientry.width = iarray[i]->width;
    	ientry.height = iarray[i]->height;
    	ientry.bytes = bitmapsize( ientry.width, ientry.height << 1, 4 ) +
        				sizeof( bitmapinfoheader ) +
        				sizeof( stdtable );
		ientry.imageoff = offset;
        offset += ientry.bytes;
    	fwrite( &ientry, sizeof( icondirentry ), 1, outf );
    }
    for( l = 0; l < vbmfiles; l++ )
	{
        icn = iarray[l];
    	ibmhdr.width = icn->width;
    	ibmhdr.height = icn->height << 1;
        ibmhdr.sizeimage = bitmapsize( ibmhdr.width, ibmhdr.height, 4 );
    	fwrite( &ibmhdr, sizeof( bitmapinfoheader ), 1, outf );
    	fwrite( stdtable, sizeof( stdtable ), 1, outf );
        switch( icn->ttype )
        {
        	case ttul:
                 icn->transpc = PICT( 0, 0 );
                 break;
        	case ttur:
                 icn->transpc = PICT( 0, icn->width - 1 );
                 break;
        	case ttll:
                 icn->transpc = PICT( icn->height - 1 , 0 );
                 break;
            case ttlr:
                 icn->transpc = PICT( icn->height, icn->width - 1  );
                 break;
            case ttcolor:
                 break;
        }
        /* image */
        pad = ( icn->width >> 1 ) % 4 ? 4 - ( icn->width >> 1 ) % 4 : 0;
		for( i = icn->height - 1; i >= 0; i-- )
		{
			for( j = 0; j < icn->width; j += 2 )
			{
             	c = PICT( i, j ) == icn->transpc ? 0 : PICT( i, j );
                c <<= 4;
             	c |= PICT( i, j + 1 ) == icn->transpc ? 0 : PICT( i, j + 1 );
             	fputc( c, outf );
            }
			for( j = 0; j < pad; j++ )
             	fputc( 0, outf );
        }
        /* mask */
        pad = ( icn->width >> 3 ) % 4 ? 4 - ( icn->width >> 3 ) % 4 : 0;
		for( i = icn->height - 1; i >= 0; i-- )
		{
			for( j = 0; j < icn->width; j += 8 )
            {
               	for( c = k = 0; k < 8; k++ )
				{
                 	c <<= 1;
					if( PICT( i, j + k ) == icn->transpc )
						c |= 1;
                }
             	fputc( c, outf );
            }
			for( j = 0; j < pad; j++ )
             	fputc( 0, outf );
        }
        free( iarray[l]->colortable );
        free( iarray[l]->pict );
        free( iarray[l] );
    }
    fclose( outf );
    return 1;
}

int nearest( rgbquad q )
{
    int i, res = 0;
    long e, d = SQDIST( q, stdtable[0] );

    for( i = 1; i < sizeof( stdtable ) / sizeof( stdtable[0] ); i++ )
         if( ( e = SQDIST( q, stdtable[i] ) ) < d )
            d = e, res = i;
    return res;
}

int read_char()
{
 	if( feof( inf ) ) return EOF;
    else return fgetc( inf );
}

int process_args( int argc, char *argv[], char *appn )
{
    int i, j, k, incr;
    char *envs, *workp, **argp;

    static struct
    {
        char *prefix;
        char *alt;
        int (*handler)( int *incr, int argc, char *argv[] );
    } optable[] =
    {
        { "-h", "--help", f_help },
        { "-o", "--output", f_outname },
        { "-c", "--color", f_transpc },
        { "-r", "--rgb", f_rgb },
        { "-ul", "--upper-left", f_ul },
        { "-ur", "--upper-right", f_ur },
        { "-ll", "--lower-left", f_ll },
        { "-lr", "--lower-right", f_lr },
        { 0 }
    };

	envs = getenv( appn );
    if( envs != 0 )
    {
    	strcpy( scratch, envs );
        envs = strtok( scratch, " \t" );
    }
    else
    	scratch[0] = 0;

    for( i = 1; i < argc || envs != 0; i += incr )
    {
		if( i < argc )
        {
        	workp = argv[i];
            argp = argv + i;
            k = argc - i /* - 1*/;
        }
        else
        {
 			workp = cptr2[0] = envs;
            argp = &cptr2[0];
            envs = strtok( 0, " \t" );
            k = ( ( cptr2[1] = envs ) != 0 ) ? 2 : 1;
        }
        incr = 0;
        for( j = 0; optable[j].prefix != 0; j++ )
            if( strncmp( workp, optable[j].prefix, strlen( optable[j].prefix ) ) == 0 )
            {
                if( !optable[j].handler( &incr, k, argp ) )
                    return 0;
                break;
            }
            else if( optable[j].alt &&
                strncmp( workp, optable[j].alt, strlen( optable[j].alt ) ) == 0 )
            {
                if( !optable[j].handler( &incr, k, argp ) )
                    return 0;
                break;
            }
        if( optable[j].prefix == 0 )
        {
            if( !readvbm( argp[0] ) )
              	return 0;
            incr++;
		}
    }
    return 1;
}

int f_help( int *incr, int argc, char *argv[] )
{
	usage();
    return 0;
}

int f_outname( int *incr, int argc, char *argv[] )
{
	(*incr)++;
	if( argc > 1 )
    {
     	outfile = argv[1];
        (*incr)++;
    }
	return 1;
}

int f_transpc( int *incr, int argc, char *argv[] )
{
	int i;

	(*incr)++;
    if( argc > 1 )
	{
    	for( i = 0; i < sizeof( colors ) / sizeof( colors[0] ); i++ )
        	if( strcmp( argv[1], colors[i] ) == 0 )
            {
             	icn->ttype = ttcolor;
            	icn->transpc = i;
                (*incr)++;
                return 1;
            }
    	printf( "Bad color name (%s)!\n", argv[1] );
    }
    return 0;
}

int f_rgb( int *incr, int argc, char *argv[] )
{
	long color;
    char *endp;
    rgbquad r;

	(*incr)++;
    if( argc > 1 )
	{
     	color = strtol( argv[1], &endp, 0 );
        if( *endp == '\0' )
        {
         	r.r = ( color >> 16 ) & 0xff;
         	r.g = ( color >> 8 ) & 0xff;
         	r.b = ( color ) & 0xff;
            r.res = 0;
          	icn->ttype = ttcolor;
          	icn->transpc = nearest( r );
            (*incr)++;
            return 1;
        }
    	printf( "Bad color value (%s)!\n", argv[1] );
    }
	return 0;
}

int f_ul( int *incr, int argc, char *argv[] )
{
	(*incr)++;
    icn->ttype = ttul;
    return 1;
}

int f_ur( int *incr, int argc, char *argv[] )
{
	(*incr)++;
    icn->ttype = ttur;
    return 1;
}

int f_ll( int *incr, int argc, char *argv[] )
{
	(*incr)++;
    icn->ttype = ttll;
    return 1;
}
int f_lr( int *incr, int argc, char *argv[] )
{
	(*incr)++;
    icn->ttype = ttlr;
    return 1;
}

int bitmapsize( int width, int height, int colord )
{
 	int rowlen = ( ( colord * width ) / 8 + 3 ) / 4;
    rowlen = rowlen * (height>>1) +
			 ( width / 8 + 3 ) / 4 * (height>>1);
	return rowlen * 4;
}

void usage()
{
    printf(

"Usage:   v2i.exe vbmfile [options] vbmfile [options] ...\n"
"Options:\n"
"\n"
"-h\n"
"--help                  Show this message and exit\n"
"\n"
"-o\n"
"--output ICOFILE        Name the icon-resource file output ICOFILE\n"
"\n"
"-c\n"
"--color CNAME           Use color CNAME for transparent areas\n"
"\n"
"-r\n"
"--rgb VALUE             Use RGB value VALUE for the transparent areas\n"
"\n"
"-ul\n"
"--upper-left            Use the color of the upper-left hand pixel for\n"
"                        the transparent areas\n"
"\n"
"-ur\n"
"--upper-right           Use the color of the upper-right hand pixel for\n"
"                        the transparent areas\n"
"\n"
"-ll\n"
"--lower-left            Use the color of the lower-left hand pixel for\n"
"                        the transparent areas\n"
"\n"
"-lr\n"
"--lower-right           Use the color of the lower-right hand pixel for\n"
"                        transparent areas (default)\n"
"\n"
"Up to five .VBM files may be placed in single .ICO file. All options,\n"
"except the -o option, stands for the next .VBM file. You may use\n"
"the same option more than once. For example, if you want to specify the\n"
"black areas to be transparent in the file SMALL.VBM and the red areas to be\n"
"transparent in the second file, BIG.VBM, use the following statement:\n"
"\n"
"        v2i -c black small.vbm -c red big.vbm -o app.ico\n"
"\n"
"Report bugs to: Youlian Ivanov <july@cblink.net>\n"
    );

}

