\
\ library.4 ---	several system extensions, that are more easily done in Forth.
\		Feel free to add your good ideas to this file!
\
\ This file does not contain dpANS-Forth compatible source!
\ One of it's uses is "au contraire" to demonstrate pfe's internals.
\
\ (duz 17Aug93)
\

\ =============================================================================
\ more on blocks and loading
\ =============================================================================

: +LOAD		\ n --- \ load screen relative
		BLK @ + LOAD ;

: +THRU		\ first last --- \ like THRU, relative block numbers
		SWAP BLK @ + SWAP BLK @ + THRU ;

: INDEX		\ first last --- \ show first lines of block range
		START?CR
		1+ SWAP DO  ?CR I 3 .R SPACE  I BLOCK 64 TYPE
		LOOP SPACE ;

: #BLOCKS	\ --- u \ number of blocks in current block file
		BLOCK-FILE FILE-SIZE ?FILE  1024 UM/MOD NIP ;

: QX		\ --- \ show first lines partially of every block in file
		CR START?CR
		#BLOCKS 0 DO
			OUT @ 20 + XMAX >= IF ?CR THEN
			I 3 .R SPACE  I BLOCK 16 TYPE
		LOOP SPACE ;

\ =============================================================================
\ more on search order
\ =============================================================================

: SET-CONTEXT	\ wid --- \ adds the given word list to the search order
		ALSO CONTEXT ! ;
		\ Kevin's idea is dpANS compatible:
		\ >R GET-ORDER R> SWAP 1+ SET-ORDER ;

\ =============================================================================
\ F83-like DEFER and IS for vectorized execution
\ =============================================================================

: CRASH		TRUE ABORT" uninitialized DEFER called" ;

: DEFER		\ "word" --- \ yes you can do CONSTANT ... DOES> in pfe:
		['] CRASH CONSTANT DOES> PERFORM ;		

: IS		\ xt --- \ store in PFA of following word
			 \ which should be defined by DEFER
		POSTPONE TO ; IMMEDIATE

\ =============================================================================
\ multi-dimensional array type
\ =============================================================================

\ Multi-dimensional arrays are supported by two primitives in the kernel
\ doing the multiplication work:
\	BUILD-ARRAY \ n1 n2 ... nX X --- n
\		takes a list of upper bounds plus the dimension of the array,
\		writes those upper bounds to the dictionary, returns their
\		product.
\	ACCESS-ARRAY \ i1 i2 ... iX addr1 --- addr2 offset
\		addr1 points to a list generated by BUILD-ARRAY.
\		Multiplies the actual indices i with the registered bounds
\		pointed to by addr1.
\		Returns the offset in items of the accessed element,
\		addr2 points to just after the list of upper bounds.
\		Indices start with 0, highest index iY is nY - 1.
\		On index out of range ACCESS-ARRAY throws -2051.
\ Usage is simple and demonstrated below with an array of Cells:

: CELL-ARRAY	CREATE	\ n1 n2 ... nX X --- ; X is dimension of ARRAY
			BUILD-ARRAY		\ --- size in items
			CELLS			\ --- size in address units
			HERE OVER ALLOT		\ allocate space
			SWAP ERASE		\ and wipe it
		DOES>	\ i1 i2 ... iX --- addr
			ACCESS-ARRAY		\ addr item-offset
			CELLS + ;


\ =============================================================================
\ String stuff
\ =============================================================================

: " postpone s" over + 0 swap c! ;

\ =============================================================================
\ Shared libraries
\ =============================================================================

S" HOST-SYSTEM" ENVIRONMENT? DROP S" Linux" COMPARE 0= [IF]

\ creates shared library variable
: got ( n _)   create ,   does> ( a)  @ @ ;

\ creates shared library call
: plt ( n _)   create ,   does> ( ... cw a - res)  @ call-c ;

[THEN]
