/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1993  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.5 of 15-May-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de
 *	/pub/unix/languages/pfe-VERSION.tar.gz
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * toolkit.c ---	The Optional Programming-Tools Word Set
 * (duz 09Jul93)
 */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "config.h"
#include "term.h"
#include "support.h"
#include "compiler.h"


#define DECWIDTH (sizeof (Cell) * 5 / 2 + 1)
#define HEXWIDTH (sizeof (Cell) * 2)


static void
printCell (Cell n)
{
  outf ("%*ld [%0*lX] ",
	DECWIDTH, (long)n,
	HEXWIDTH, (unsigned long)n);
}

Code (dot_s)
{
  int i, dd, fd;

  dd = memtop.stack - sp;
  fd = memtop.fstack - fp;
  if (dd == 0)
    if (fd == 0)
      {
	/* both stacks empty */
	outf ("<stacks empty> ");
      }
    else
      {
	/* only floating point stack not empty */
	outf ("\n<stack empty>%*.7G ",
	      (DECWIDTH + HEXWIDTH + 4 - 13) + 15, fp [0]);
	for (i = 1; i < fd; i++)
	  outf ("\n%*.7G ",
		(DECWIDTH + HEXWIDTH + 4) + 15, fp [i]);
      }
  else
    if (fd == 0)
      {
	/* only data stack not empty */
	for (i = 0; i < dd; i++)
	  {
	    cr_();
	    printCell (sp [i]);
	  }
      }
    else
      {
	int bd = dd < fd ? dd : fd;
	for (i = 0; i < bd; i++)
	  {
	    cr_();
	    printCell (sp [i]);
	    outf ("%15.7G ", fp [i]);
	  }
	for (; i < dd; i++)
	  {
	    cr_();
	    printCell (sp [i]);
	  }
	for (; i < fd; i++)
	  outf ("\n%*.7G ",
		(DECWIDTH + HEXWIDTH + 4) + 15, fp [i]);
      }
}

Code (question)
{
  fetch_();
  dot_();
}

Code (dump)
{
  uCell i, j, n = (uCell)*sp++;
  Byte *p;

  POP (Byte *, sp, p);
  cr_();
  start_question_cr_();
  outf ("%*s ", HEXWIDTH, "");
  for (j = 0; j < 16; j++)
    outf ("%02X ", (uCell)(p + j) & 0x0F);
  for (j = 0; j < 16; j++)
    outf ("%X", (uCell)(p + j) & 0x0F);
  for (i = 0; i < n; i += 16, p += 16)
    {
      if (question_cr ())
	break;
      outf ("%0*lX ", HEXWIDTH, (unsigned long)(uCell)p);
      for (j = 0; j < 16; j++)
	outf ("%02X ", p [j]);
      for (j = 0; j < 16; j++)
	outf ("%c", printable (p [j]) ? p [j] : '.');
    }
  space_();
}

Code (see)
{
  char *nfa, buf [80];
  Xt xt;

  cr_();
  nfa = tick (&xt);
  if (*xt == create_runtime || *xt == sysvar_runtime)
    {
      outs ("VARIABLE ");
      dot_name (nfa);
    }
  else if (*xt == constant_runtime)
    {
      DOT (*TO_BODY (xt), buf);
      outs ("CONSTANT ");
      dot_name (nfa);
    }
  else if (*xt == value_runtime)
    {
      DOT (*TO_BODY (xt), buf);
      outs ("VALUE ");
      dot_name (nfa);
    }
  else if (*xt == sysconst_runtime)
    {
      DOT (**(Cell **)TO_BODY (xt), buf);
      outs ("CONSTANT ");
      dot_name (nfa);
    }
  else if (*xt == two_constant_runtime)
    {
      DDOTR (*(dCell *)TO_BODY (xt), 0, buf);
      outs (". 2CONSTANT ");
      dot_name (nfa);
    }
  else if (*xt == f_constant_runtime)
    {
      outf ("%g FCONSTANT ", *(double *)TO_BODY (xt));
      dot_name (nfa);
    }
  else if (*xt == marker_runtime)
    {
      outs ("MARKER ");
      dot_name (nfa);
    }
  else if (*xt == vocabulary_runtime)
    {
      outs ("VOCABULARY ");
      dot_name (nfa);
    }
  else if (*xt == colon_runtime ||
	   *xt == debug_colon_runtime)
    {
      outs (": ");
      dot_name (nfa);
      decompile ((Xt *)TO_BODY (xt));
    }
  else if (*xt == does_defined_runtime ||
	   *xt == debug_does_defined_runtime)
    {
      outs ("DOES> ");
      decompile (((Xt **)xt) [-1]);
    }
  else
    {
      dot_name (nfa);
      outf ("is primitive ");
    }
  if (*nfa & IMMEDIATE)
    outs ("IMMEDIATE ");
}

Code (words)
{
  Wordl w;
  char **t, **s, l;

  cr_();
  start_question_cr_();
  w = CONTEXT [0] ? *CONTEXT [0] : *ONLY;
  for (t = thread_with_latest (&w); *t;
       t = thread_with_latest (&w))
    {
      l = **t & 0x1F;
      if (OUT + 20 - OUT % 20 + 2 + l > cols)
	{
	  if (question_cr ())
	    break;
	}
      else
	if (OUT)
	  tab (20);
      s = name_to_link (*t);
      outf ("%c ", category (*link_from (s)));
      dot_name (*t);
      *t = *s;
    }
  space_();
}

/* Programming-Tools Extension words */

code (ahead)
{
  forward_mark_();
  *--sp = ORIG_MAGIC;
}

Code (bye)
{
  save_buffers_();
  close_all_files_();
  if (option.quiet)
    outc ('\n');
  else
    outs ("\nGoodbye!\n");
  exit (0);
}

Code (cs_pick)
{
  Cell n = (*sp-- + 1) << 1;
  sp [0] = sp [n];
  sp [1] = sp [n + 1];
}

Code (cs_roll)
{
  Cell n = *sp++;
  dCell h = ((dCell *)sp) [n];
  for (; n > 0; n--)
    ((dCell *)sp) [n] = ((dCell *)sp) [n - 1];
  ((dCell *)sp) [0] = h;
}

Code (forget)
{
  Xt xt;
  unsmudge_();
  forget (tick (&xt));
}

Code (bracket_else)
{
  char *p;
  int len, level = 1;

  do
    {
      for (;;)
	{
	  p = word (' ');
	  if ((len = *(Byte *)p++) == 0)
	    break;
	  if (sys.lower_case)
	    to_upper (p, len);
	  if (len == 4 && strncmp (p, "[IF]", 4) == 0)
	    ++level;
	  else	if (len == 6 && strncmp (p, "[ELSE]", 6) == 0)
	    if (--level == 0) return; else ++level;
	  else	if (len == 6 && strncmp (p, "[THEN]", 6) == 0)
	    if (--level == 0) return;
	}
    }
  while (refill ());
  tHrow (THROW_UNEXPECTED_EOF);
}

Code (bracket_if)
{
  if (*sp++ == 0)
    bracket_else_();
}

LISTWORDS (toolkit) =
{
  CO (".S",		dot_s),
  CO ("?",		question),
  CO ("DUMP",		dump),
  CO ("SEE",		see),
  CO ("WORDS",		words),
  CO ("AHEAD",		ahead),
  CO ("BYE",		bye),
  CO ("CS-PICK",	cs_pick),
  CO ("CS-ROLL",	cs_roll),
  CO ("FORGET",		forget),
  CI ("[ELSE]",		bracket_else),
  CI ("[IF]",		bracket_if),
  CI ("[THEN]",		noop),
};
COUNTWORDS (toolkit, "Programming-Tools + parts of extensions");
