/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1993  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.5 of 15-May-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de
 *	/pub/unix/languages/pfe-VERSION.tar.gz
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * vocs.c ---	Vocabularies and lists of words to preload.
 * (duz 18Apr94)
 */

#include "forth.h"
#include "support.h"

extern const Words
  core_words,		block_words,
  double_words,		exception_words,
  facility_words,	file_words,
  floating_words,	locals_words,
  memory_words,		toolkit_words,
  search_words,		string_words,
  forth_83_words,	lpf83_words,
  misc_words,		debug_words,
  shell_words,		system_words,
  your_words;

static const Words *const only_sets [] =
{
  &search_words
};

static const Words *const forth_sets [] =
{
  &core_words,		&block_words,
  &double_words,	&exception_words,
  &facility_words,	&file_words,
  &floating_words,	&locals_words,
  &memory_words,	&toolkit_words,
  &string_words
};

static const Words *const extensions_sets [] =
{
  &forth_83_words,	&lpf83_words,
  &misc_words,		&debug_words,
  &system_words,	&shell_words,
  &your_words
};

preloadList only_list =
	{ DIM (only_sets), only_sets };
preloadList forth_list =
	{ DIM (forth_sets), forth_sets };
preloadList extensions_list =
	{ DIM (extensions_sets), extensions_sets };

const preloadList *preload_list [] =
{
  &only_list, &forth_list, &extensions_list
};

const int preload_lists = DIM (preload_list);
