package bench;
public class QSortAlgorithm
    extends SortAlgorithm
{
    public QSortAlgorithm()
    {
        super("Quick Sort");
    }

    private final void QuickSort(int lo0, int hi0)
    {
        int lo = lo0;
        int hi = hi0;
        int mid; 

        if( hi0 > lo0)
        {
            mid = a[(lo0 + hi0 ) / 2];

            while(lo <= hi)
            {
                while((lo < hi0) && (a[lo] < mid))
                {
                    ++lo;
                }

                while((hi > lo0) && (a[hi] > mid))
                {
                    --hi;
                }

                if(lo <= hi)
                {
                    swap(lo, hi);
                    ++lo;
                    --hi;
                }
            }

            if(lo0 < hi)
            {
                QuickSort(lo0, hi);
            }

            if(lo < hi0)
            {
                QuickSort(lo, hi0);
            }
        }
    }

    private final void swap(int i, int j)
    {
        int T;

        T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    public final void performTest()
    {
        QuickSort(0, a.length - 1);
    }
}