 /********************************************************************/
 /*                                                                  */
 /*      Module:        PL/I I/O Request Block (IORB)                */
 /*      Version:       1.4                                          */
 /*      Date:          Sep, 2004                                    */
 /*      Author:        Peter Flass                                  */
 /*                                                                  */
 /*      Function:      Describes the request data passed to PL/I    */
 /*                     I/O routines.                                */
 /*                                                                  */
 /*      Length:        64 bytes ('40'x).                            */
 /*                                                                  */
 /*      Where held:    Temporary (stack) storage for the duration   */
 /*                     of an I/O operation.                         */
 /*                                                                  */
 /*      Created by:    I/O Statement                                */
 /*      Deleted by:    same                                         */
 /*                                                                  */
 /*      Dependencies:  Mapped in compiled code.                     */
 /*                     For version compatibility, add new data      */
 /*                     to end.                                      */
 /*                     'IOR_SRB' is the  same as the SRB            */
 /*                     structure and 'GPSB_SRB' in the GPSB.        */
 /*                                                                  */
 /*      Modifications:                                              */
 /*        2017-09-01: Change bit value for FROM.                    */
 /*        Version 1.4: Remap fields into IOR_SRB'.                  */
 /*        Version 1.3: Add 16 bytes.                                */
 /*        Version 1.2a Add IOR_condmask.                            */
 /*        Version 1.2: Add 8 bytes.                                 */
 /*        Version 1.x: Move back to stack.                          */
 /*        Version 1.1: add pDSA pOpt, pDesc, pName.                 */
 /*                                                                  */
 /********************************************************************/

 dcl   1 IORB                aligned based,
         5 IOR_Ver           fixed bin(15),      /* IORB version   00*/
         /*  Change version when the format of the IORB changes.     */
         /*  Current version is 1.                                   */
         5 IOR_Func          fixed bin(15),      /* I/O Function   02*/
         /*  1: Open         +--              ----                 --*/
         /*  2: Close        |  These are arbitrary codes,           */
         /* 10: Read         |  but the runtime library              */
         /* 11: Write        |  must agree with the code             */
         /* 12: Rewrite      |  generated by GIO.                    */
         /* 13: Locate       |                                       */
         /* 14: Delete       |                                       */
         /* 15: Unlock       |                                       */
         /* 20: Get          |                                       */
         /* 21: Put          |                                       */
         /* 30: Lineno BIF   |                                       */
         /* 31: Count BIF    |                                       */
         /* 35: Status       +--              ----                 --*/
         5 IOR_pFile         ptr,                /* -> FILE var    04*/
         5 IOR_pDCLCB        ptr,                /* -> Declared att08*/
         5 IOR_SRB,                              /* IORB Stream dat0C*/
           10 IOR_pDSA       ptr,                /* -> Curr DSA    0C*/
           10 IOR_pOPT       ptr,                /* -> Variable Opt10*/
           10 IOR_bOpt       bit(32),            /* Option bits    14*/
           /* Bit Values for IOR_bOpt by stmt (defined by KEYWORD)   */
           /* (Values for GET and PUT are the same as SRB_bOpt)      */
           /*                         |         C D G L O P R R U W  */
           /* Statement ------------->|         L E E O P U E E N R  */
           /*                         |         O L T C E T A W L I  */
           /*                                   S E   A N   D R O T  */
           /* -------------- Data Transmission Statement Options --- */
           /* '00000001'bx - FILE                 R R R   R R R R R  */
           /* '00000002'bx - KEY                  E         E E E    */
           /* '00000004'bx - KEYTO                          R     R  */
           /* '00000008'bx - KEYFROM                  E           E  */
           /* '00000010'bx - EVENT                          R R      */
           /* '00000020'bx - INTO                           X        */
           /* '00000040'bx - FROM                             R   R  */
           /* '00000080'bx - SET                      R     R        */
           /* '00000100'bx - NOLOCK                         X        */
           /* '00000200'bx - IGNORE                         X        */
           /* '00001000'bx - LIST                   X     X          */
           /* '00002000'bx - DATA                   X     X          */
           /* '00004000'bx - EDIT                   X     X          */
           /* '00010000'bx - COPY                   R                */
           /* '00020000'bx - SKIP                   E     E          */
           /* '00040000'bx - PAGE                         X          */
           /* '00080000'bx - LINE                         E          */
           /* '80000000'bx - STRING                 E     R          */
           /* --- The following values are NOT from KEYWORD (GET|PUT)*/
           /* '10000000'bx - Put a ';'                          0.9.8*/
           /* '20000000'bx - Last data-list item for PUT             */
           /* '40000000'bx - SKIP(1) specified                       */
           /* '80000000'bx - First use of this IORB. (Reuses STRING) */
           /* -------------- OPEN/CLOSE OPTIONS -------------------- */
           /* '00000001'bx - FILE               R       R            */
           /* '00000002'bx - ENVIRONMENT        X                    */
           /* '00000004'bx - RECORD                     X            */
           /* '00000008'bx - STREAM                     X            */
           /* '00000010'bx - INPUT                      X            */
           /* '00000020'bx - OUTPUT                     X            */
           /* '00000040'bx - UPDATE                     X            */
           /* '00000080'bx - BACKWARDS                  X            */
           /* '00000100'bx - DIRECT                     X            */
           /* '00000200'bx - SEQUENTIAL                 X            */
           /* '00000400'bx - TRANSIENT                  X            */
           /* '00000800'bx - EXCLUSIVE                  X            */
           /* '00001000'bx - BUFFERED                   X            */
           /* '00002000'bx - LINESIZE                   E            */
           /* '00004000'bx - KEYED                      X            */
           /* '00010000'bx - TITLE                      E            */
           /* '00020000'bx - UNBUFFERED                 X            */
           /* '00040000'bx - PAGESIZE                   E            */
           /* '00080000'bx - PRINT                      X            */
           10 IOR_pFmt       ptr,                /* ->Format item  18*/
           10 IOR_pData      ptr,                /* ->Data         1C*/
           10 IOR_pDesc      ptr,                /* ->Data Desc    20*/
           10 IOR_pName      ptr,                /* ->Data Name    24*/
           10 IOR_aFmt       ptr,                /* R format chain 28*/
           10 IOR_condmask   bit(16),            /* Enabled cond   2C*/
           10 fil1           char(2),            /* (alignment)    2E*/
         5 fil2              char(16),           /* unused         30*/
         5 IOR_end           char(0);            /* End of IORB    40*/

 /* Definitions of variable options.  Options are stored             */
 /* contiguously beginning at address IOR_pOpt.  Options are in      */
 /* order by sequence of bits in IOR_bOpt.                           */
 /* Each option is one of the following:                             */
 dcl     IOR_optF            fixed bin(31) based;/* FIXED_option     */
 dcl     IOR_optP            ptr           based;/* -> other_option  */

