module: Dylan-User
author: chiles@cs.cmu.edu
synopsis: This file defines the Streams library and its modules.
copyright: See below.
rcs-header: $Header: /afs/cs.cmu.edu/project/gwydion/hackers/nkramer/mindy/mindy-1.3/libraries/streams/RCS/library.dylan,v 1.20 95/04/08 19:19:21 nkramer Exp $

//======================================================================
//
// Copyright (c) 1994  Carnegie Mellon University
// All rights reserved.
// 
// Use and copying of this software and preparation of derivative
// works based on this software are permitted, including commercial
// use, provided that the following conditions are observed:
// 
// 1. This copyright notice must be retained in full on any copies
//    and on appropriate parts of any derivative works.
// 2. Documentation (paper or online) accompanying any system that
//    incorporates this software, or any part of it, must acknowledge
//    the contribution of the Gwydion Project at Carnegie Mellon
//    University.
// 
// This software is made available "as is".  Neither the authors nor
// Carnegie Mellon University make any warranty about the software,
// its performance, or its conformity to any specification.
// 
// Bug reports, questions, comments, and suggestions should be sent by
// E-mail to the Internet address "gwydion-bugs@cs.cmu.edu".
//
//======================================================================
//


///
/// These definitions go into the Dylan-User module because this is how we
/// jumpstart a library.
///

define library streams
  use dylan;
  export streams, standard-io;
end library;


/// The Internals Module exports everything that is necessary to make the
/// code in the Streams Module run, but only stuff that is of an internals
/// nature to a Dylan implementation.
///
define module internals
  use dylan;
  use extensions,
    import: {<boolean>, <byte-character>, <byte-vector>, <fixed-integer>,
	     $maximum-fixed-integer, one-of, type-or, false-or, ignore,
	     on-exit},
    export: all;
  use cheap-io, export: all;
  use system,
    import: {<buffer>, copy-bytes, $newlines-are-CRLF},
    export: all;
  use threads,
    import: {<multilock>, <semaphore>, grab-lock, release-lock, locked?},
    export: all;
  use file-descriptors,
    // This is one of two use file-descriptors clauses.  This one prefixes
    // everything with "fd-"
    import: {// Lseek values for whence argument.
	     seek_set => fd-seek-start,
	     seek_cur => fd-seek-current,
	     seek_end => fd-seek-end,

	     // Open values for flags argument
	     o_rdonly, o_wronly, o_rdwr, o_creat, o_trunc, o_excl,

	     // Open errors.
	     enoent, eexist},
    prefix: "fd-",
    export: all;
  use file-descriptors,
    // This is two of two use file-descriptors clauses.  This one does no
    // prefixing.
    import: {fd-read, fd-write, fd-open, fd-close, fd-seek,
	     fd-input-available?, fd-sync-output, fd-error-string},
    export: all;
  export
    <byte>, call-fd-function;
end module;

define module streams
  use dylan;
  use internals,
    export: {<byte-vector>, <buffer>, <byte-character>, <byte>};
  export
    //
    // Classes and types.
    <stream>,
    <file-stream>,
    <string-input-stream>,
    <byte-string-input-stream>,
    <string-output-stream>,
    <byte-string-output-stream>,
    <buffer-index>,
    //
    // Constants.
    $maximum-buffer-size,
    //
    // Conditions.
    <end-of-file>,
    <file-not-found>,
    <file-exists>,
    //
    // Stream Extension Protocol.
    close,
    stream-extension-get-input-buffer,
    stream-extension-release-input-buffer,
    stream-extension-fill-input-buffer,
    stream-extension-input-available-at-source?,
    stream-extension-get-output-buffer,
    stream-extension-release-output-buffer,
    stream-extension-empty-output-buffer,
    stream-extension-force-secondary-buffers,
    stream-extension-synchronize,
    //
    // Basic I/O Protocol.
    read-byte,
    peek-byte,
    read-line,
    input-available?,
    flush-input,
    force-output,
    synchronize-output,
    //
    // Buffer Access Protocol.
    get-input-buffer,
    release-input-buffer,
    fill-input-buffer,
    input-available-at-source?,
    get-output-buffer,
    release-output-buffer,
    empty-output-buffer,
    force-secondary-buffers,
    synchronize,
    //
    // Data Extension Protocol.
    read-as,
    read-into!,
    write,
    write-line,
    //
    // <random-access-stream> protocol.
    stream-position,
    stream-position-setter,
    adjust-stream-position,
    stream-size,
    //
    // <string-output-stream> protocol.
    string-output-stream-string,
    //
    // <buffer> protocol.
    buffer-subsequence,
    copy-from-buffer!,
    copy-into-buffer!,
    //
    // Conditions operations.
    end-of-file-stream,
    file-not-found-filename,
    file-exists-filename,
    //
    // Locking.
    stream-locked?,
    lock-stream,
    unlock-stream,
    //
    // The following are extensions to the standard Streams Library.
    <fd-stream>;
end module;

define module standard-io
  use dylan;
  use streams,
    import: {<fd-stream>};
  export
    *standard-input*, *standard-output*, *standard-error*;
end module
