IMPLEMENTATION MODULE YaflFName;

FROM Conversions IMPORT PatternMapper;
IMPORT SYSTEM;
IMPORT String;
FROM YaflError IMPORT CompilerError;
FROM YaflCfg IMPORT CurrentSpot, YaflCfg;

  CLASS FileNameMapper;

    REDEFINE METHOD CREATE;
      BEGIN
      END CREATE;

    DEFERRED METHOD BuildFileName (Pattern,
                                   Prefix, 
                                   Radix, 
                                   Extension, 
                                   Work: ARRAY OF CHAR): ARRAY OF CHAR;
                                   
    METHOD MakeAbsolute (SourcePathName: ARRAY OF CHAR): ARRAY OF CHAR;
      BEGIN            
      RESULT := SourcePathName;
      END MakeAbsolute;


  END FileNameMapper;
-----------------------------------------------------------------
  CLASS PatternFileNameMapper;
    INHERITS FileNameMapper;

    VAR
      SourcePattern, 
      TempPattern, 
      TargetPattern,
      ProjectPattern: ARRAY OF CHAR;

    METHOD SetPatterns (SourcePattern,
                        TempPattern,
                        TargetPattern,
                        ProjectPattern: ARRAY OF CHAR);
      BEGIN
      ASSERT SourcePattern <> VOID;
      ASSERT TempPattern <> VOID;
      ASSERT TargetPattern <> VOID;
      ASSERT ProjectPattern <> VOID;
      THIS.SourcePattern := SourcePattern;
      THIS.TempPattern := TempPattern;
      THIS.TargetPattern := TargetPattern;
      THIS.ProjectPattern := ProjectPattern;
      END SetPatterns;

    REDEFINE METHOD CREATE (SourcePattern,
                            TempPattern,
                            TargetPattern,
                            ProjectPattern: ARRAY OF CHAR);
      BEGIN
      BASE;
      SetPatterns (SourcePattern, TempPattern, TargetPattern, ProjectPattern);
      END CREATE;

    REDEFINE METHOD BuildFileName (Pattern,
                                   Prefix, 
                                   Radix, 
                                   Extension, 
                                   Work: ARRAY OF CHAR): ARRAY OF CHAR;
      VAR
        TheMapper: ONCE PatternMapper;
      BEGIN
      IF TheMapper = VOID THEN
        TheMapper.CREATE;
        END;
      TheMapper.Associate('P', Prefix);
      TheMapper.Associate('R', Radix);
      TheMapper.Associate('E', Extension);
      TheMapper.Associate('W', Work);
      RESULT := TheMapper.Map(Pattern);
      END BuildFileName;

    REDEFINE METHOD BuildSourceFileName (Prefix, 
                                         Radix, 
                                         Extension: ARRAY OF CHAR):
                                                ARRAY OF CHAR;
      BEGIN
      RESULT := BuildFileName (SourcePattern, Prefix, Radix, Extension,
                               Work := VOID);
      END BuildSourceFileName;

    REDEFINE METHOD BuildTargetFileName (Prefix, 
                                         Radix,
                                         Extension, 
                                         Work: ARRAY OF CHAR):
                                                ARRAY OF CHAR;
      BEGIN
      RESULT := BuildFileName (TargetPattern, Prefix, Radix, Extension, Work);
      END BuildTargetFileName;

    REDEFINE METHOD BuildTempFileName (Prefix, 
                                       Radix,
                                       Extension, 
                                       Work: ARRAY OF CHAR):
                                                ARRAY OF CHAR;
      BEGIN
      RESULT := BuildFileName (TempPattern, Prefix, Radix, Extension, Work);
      END BuildTempFileName;

    REDEFINE METHOD BuildProjectFileName (Prefix, 
                                          Radix,
                                          Extension: ARRAY OF CHAR):
                                                ARRAY OF CHAR;
      BEGIN
      RESULT := BuildFileName (ProjectPattern, Prefix, Radix, Extension, 
                               Work := VOID);
      END BuildProjectFileName;
      
    REDEFINE METHOD BuildIndexFileName (Prefix,
                                          Radix,
                                          Extension: ARRAY OF CHAR):
                                                ARRAY OF CHAR;
      BEGIN
      RESULT := BuildFileName (ProjectPattern, Prefix, Radix, Extension,
                               Work := VOID);
      END BuildIndexFileName;

    METHOD SetSourcePattern  (Value: ARRAY OF CHAR);
      BEGIN
      IF Value <> VOID THEN
        SourcePattern := Value;
        END;
      END SetSourcePattern;
        
    METHOD SetTargetPattern  (Value: ARRAY OF CHAR);
      BEGIN
      IF Value <> VOID THEN
        TargetPattern := Value;
        END;
      END SetTargetPattern;
        
    METHOD SetTempPattern    (Value: ARRAY OF CHAR);
      BEGIN
      IF Value <> VOID THEN
        TempPattern := Value;
        END;
      END SetTempPattern;
        
    METHOD SetProjectPattern (Value: ARRAY OF CHAR);
      BEGIN
      IF Value <> VOID THEN
        ProjectPattern := Value;
        END;
      END SetProjectPattern;
                       
  END PatternFileNameMapper;
-----------------------------------------------------------------
  ONCE CLASS UnixFileNameMapper;
    INHERITS PatternFileNameMapper;
    REDEFINE METHOD CREATE;
      BEGIN
      BASE(SourcePattern := "%/p%-8r.%-3e",
           TempPattern := "%/p%/w%-8r.%-2e$",
           TargetPattern := "%/p%/w%-8r.%-3e",
           ProjectPattern := "%/p%-8r.%-3e");
      END CREATE;
  END UnixFileNameMapper;
-----------------------------------------------------------------
  ONCE CLASS DosFileNameMapper;
    INHERITS PatternFileNameMapper;
    REDEFINE METHOD CREATE;
      BEGIN
      BASE(SourcePattern := "%\p%-8r.%-3e",
           TempPattern := "%\p%\w%-8r.%-2e$",
           TargetPattern := "%\p%\w%-8r.%-3e",
           ProjectPattern := "%\p%-8r.%-3e");
      END CREATE;
  END DosFileNameMapper;
-----------------------------------------------------------------
  ONCE CLASS MvsFileNameMapper;
    INHERITS PatternFileNameMapper;
    REDEFINE METHOD CREATE;
      BEGIN
      BASE(SourcePattern := "%+p.%+3e(%+8r)",
           TempPattern := "%+p.%+w.%+3e(%+7r@)",
           TargetPattern := "%+p.%+w.%+3e(%+8r)",
           ProjectPattern := "%+.pCNTL(%+5r%+3e)");
      END CREATE;
      
    REDEFINE METHOD MakeAbsolute (SourcePathName: ARRAY OF CHAR): 
                                                         ARRAY OF CHAR;
      VAR
        Mapper: ONCE PatternMapper;                                                         
        ThePattern: ONCE ARRAY OF CHAR;
        Err: CompilerError;
      BEGIN                        
      IF Mapper = VOID THEN
        Mapper.CREATE;
        ThePattern := YaflCfg.FindValue ("ABSOLUTE_FILE_PATTERN");
        IF ThePattern = VOID THEN
          Err.CREATE (0, 0, "The configuration variable " + 
                             "ABSOLUTE_FILE_PATTERN is undefined", VOID);
          CurrentSpot.CurrentCompilationRun.AppendWarning (Err);
          END;                   
        END;  
      IF ThePattern = VOID THEN
        RESULT := SourcePathName;
       ELSE                      
        Mapper.Associate ("p", SourcePathName);
        RESULT := Mapper.Map (ThePattern);
        END;
      END MakeAbsolute;

  END MvsFileNameMapper;

END YaflFName;
