IMPLEMENTATION MODULE YaflGModules;

FROM Streams               IMPORT StdErr;
FROM YaflModules           IMPORT CompilationUnit, 
                                  ImplementationModule,
                                  DefinitionModule,
                                  ModuleSet;
FROM YaflCfg               IMPORT CurrentSpot, YaflCfg;
FROM YaflCreator           IMPORT Creators;
FROM Streams               IMPORT StdOut,
                                  Stream;
FROM YaflClImplementation  IMPORT ClassImplementation;
FROM YaflClDefinition      IMPORT ClassDefinition;
FROM YaflClasses           IMPORT ClassDeclaration;
FROM YaflNTList            IMPORT DeclList, 
                                  MultiDeclList,
                                  ClassList,
                                  NTSet;
FROM YaflPredefined        IMPORT PredefItems;
FROM YaflMethods           IMPORT MethodDeclaration;
FROM YaflParser            IMPORT NonTerminal, Walker;
FROM YaflStatements        IMPORT Statement;
FROM String                IMPORT String;
FROM Conversions           IMPORT IntConversions;

FROM YaflCfg IMPORT YaflCfg;
FROM YaflController IMPORT Controller;

IMPORT SYSTEM;
  CLASS CompilationUnitCodeGenerator(ObjType IN CompilationUnit, CtxType IN GcContext);
    INHERITS GC(ObjType, CtxType);
     
  END CompilationUnitCodeGenerator;

-----------------------------------------------------------

  CLASS ImplModuleCodeGenerator(CtxType IN GcContext);
    INHERITS CompilationUnitCodeGenerator(ImplementationModule, CtxType);
   
    METHOD CreateContext: CtxType;
      BEGIN 
      StdErr.WriteLine("ImplmoduleCodeGenerator 'CreateContext' MUST be redefined");
      RESULT := VOID;
      END CreateContext;

    REDEFINE METHOD GetFatherCtx: CtxType;
      BEGIN
      IF Ctx <> VOID THEN
        RESULT := Ctx;
       ELSE
        RESULT := CreateContext;
        END;
      END GetFatherCtx;

  END ImplModuleCodeGenerator;
   
-----------------------------------------------------------

  CLASS DefModuleCodeGenerator(CtxType IN GcContext);
    INHERITS CompilationUnitCodeGenerator(DefinitionModule, CtxType);
   
  END DefModuleCodeGenerator;
    
   
END YaflGModules;
