#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <yafl_rnt.h>
#include "dbx_rnt.h"
#include "dbx_type.h"
#include "dbx_fiel.h"
#include "dbx_list.h"
#include "dbx_fram.h"

dbx_frame *new_frame YPARAMS8(obj_ptr,      objarr,
                             dbx_class *,  class,
			     dbx_field *,  field,
			     unsigned,     subscript)
{
  dbx_frame *p;
  p = (dbx_frame *)malloc(sizeof(dbx_frame));
  assertp(p);
  memset(p,0,sizeof(dbx_frame));
  p->objarr = objarr;
  p->class = class;
  p->field = field;
  p->subscript = subscript;
  return p;
}

void dispose_frame YPARAMS2(dbx_frame *,  pf)
{
  assertp(pf);
  free(pf);
}

obj_ptr frame_objarr YPARAMS2(dbx_frame *,  pf)
{
  assertp(pf);
  return (pf->objarr);
}

dbx_class *frame_class YPARAMS2(dbx_frame *,  pf)
{
  assertp(pf);
  return (pf->class);
}

dbx_field *frame_field YPARAMS2(dbx_frame *,  pf)
{
  assertp(pf);
  return (pf->field);
}

unsigned frame_subscript YPARAMS2(dbx_frame *,  pf)
{
  assertp(pf);
  return (pf->subscript);
}


dbx_stack *new_stack YPARAMS0
{
   return (new_list());
}

/* the stack must be empty before being destructed */
void dispose_stack YPARAMS2(dbx_stack *,  ps)
{
  assertp(ps);
  dispose_list(ps);
}

int empty_stack YPARAMS2(dbx_stack *,  ps)
{
  assertp(ps);
  return (ps->nbr == 0);
}

void push_frame YPARAMS4(dbx_stack *,  ps,
                        dbx_frame *,  pf)
{
  assertp(ps);
  assertp(pf); 
  insert(ps,last_elem(ps),NULL,pf);
}

void pop_frame YPARAMS2(dbx_stack *,  ps)
{
  dbx_frame *pf;
  assertp(ps);
  pf = suppress(ps,last_elem(ps));
  free(pf); /* ok to use free if no indirect memory */
}

dbx_frame *top_frame YPARAMS2(dbx_stack *,  ps)
{
  assertp(ps);
  assertp(last_elem(ps)); /**/
  return (elem_info(last_elem(ps)));
}		

			 
