#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <ctype.h>
#include <yafl_rnt.h>
#include "dbx_rnt.h"
#include "dbx_worl.h"
#include "dbx_modu.h"
#include "dbx_type.h"
#include "dbx_vari.h"
#include "dbx_clas.h"
#include "dbx_fiel.h"
#include "dbx_meth.h"
#include "dbx_call.h"
#include "dbx_loca.h"
#include "dbx_ctrl.h"
#include "dbx_list.h"
#include "dbx_fram.h"
#include "dbx_ctxt.h"
#include "dbx_curr.h"
#include "dbx_file.h"
#include "dbx_brea.h"
#include "dbx_watc.h"
#include "dbx_sign.h"
#include "dbx_out.h"
#include "dbx_io.h"

static dbx_module *cur_module = NULL;
static dbx_class *cur_class = NULL;
static dbx_field *cur_field = NULL;
static dbx_method *cur_method = NULL;
static dbx_local *cur_local = NULL;


static dbx_method *master_method = NULL;

void dbx_down_level YPARAMS0
{
  master_method = cur_method;
}

void dbx_up_level YPARAMS0
{
  master_method = enclosing_method(master_method);
}

/* these functions are called during the initialisation process */
/* they serve to enter all the static informations about the */
/* debugged program in the structures of the debugger */
/* as it is the only place where various fields of these structures */
/* are being written it is ok to bypass information hiding */
/* it would be useless to define modifying functions for these */
/* fields as they will be used in read-only mode later */

void dbx_add_module YPARAMS2(dbx_module *, module)
{
  dbx_module *p;
  p = module;
/*
  p->name = name;				  
  p->source_file_name = file_name;
  p->beginline = beginline;
  p->endline = endline;
  p->line_numbers = line_numbers;
*/
  cur_module = p;
  cur_class = NULL;
  cur_field = NULL;
  cur_method = NULL;
  cur_local = NULL;
/*
  return p;
*/
}


void dbx_add_class YPARAMS2(dbx_class *, class)
{
  dbx_class *p, **pp;
  assertp(cur_module);
  p = class;
  if (cur_class == NULL)
  {
    cur_module->first_class = p;
  }
  else
  {
    cur_class->next = p;
    p->prev = cur_class;
  }
  cur_module->last_class = p;
  p->module = cur_module;
/*
  p->name = name;
  p->once_ptr = once_ptr;
  p->dual = dual;
  p->beginline = beginline;
  p->endline = endline;
*/
  cur_class = p;
  cur_field = NULL;
  cur_method = NULL;
  cur_local = NULL;
/*
  return p;
*/
}



dbx_method *dbx_add_method YPARAMS0
{
  dbx_method *p;
  assertp(cur_class);
  p = new_method();
  if (cur_method == NULL)
  {
    cur_class->first_method = p;
  }
  else
  {
    cur_method->next = p;
    p->prev = cur_method;
  }
  cur_class->last_method = p;
  p->class = cur_class;
/*
  p->name = name;
  p->beginline = beginline;
  p->endline = endline;
*/
  p->bp_count = 0;
  p->method = master_method;
  if (master_method)
  {
    if (master_method->last_inner)
    {
      p->prev_inner = master_method->last_inner;
      master_method->last_inner->next_inner = p;          
    }
    else
    {
      master_method->first_inner = p;
    }
    master_method->last_inner = p;
  }
  cur_method = p;
  cur_local = NULL;
  return p;
}


dbx_local *dbx_add_local YPARAMS10(char *,         name,
                            minimal_dual*,  type,
                            unsigned,       level,
                            VOID*,          once,
                            unsigned,       offset)
{
  dbx_local *p;
  assertp(name);
/*  assertp(type); */
  assertp(cur_method);
  p = new_local();
  if (cur_local == NULL)
  {
    cur_method->first_local = p;
  }
  else
  {
    cur_local->next = p;
    p->prev = cur_local;
  }
  cur_method->last_local = p;
  p->method = cur_method;
  p->name = name;
  p->type = type;
  p->level = level;
  p->once = once;
  p->offset = offset;
  cur_local = p;
  return p;
}





void init_dbx_rnt YPARAMS0
{
  init_dbx_modu();
  init_dbx_call();
  init_dbx_type();
  init_dbx_ctrl();
  init_dbx_worl();
  init_dbx_file();
  init_dbx_curr();
  init_dbx_brea();
  init_dbx_watc();
  init_dbx_sign();  
  init_dbx_out();
  init_dbx_io();
}

void term_dbx_rnt YPARAMS0
{
  term_dbx_modu();
  term_dbx_call();
  term_dbx_type();
  term_dbx_ctrl();
  term_dbx_file();
  term_dbx_worl();
  term_dbx_curr();
  term_dbx_brea();
  term_dbx_watc();
  term_dbx_sign();
  term_dbx_out();
  term_dbx_io();
}



