#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <yafl_rnt.h>
#include "dbx_rnt.h"
#include "dbx_type.h"
#include "dbx_vari.h"

dbx_variable *new_variable YPARAMS6(dbx_type *,  pt,
                                   unsigned,  level,
                                   VOID *,  address)
{
  dbx_variable *p;
  assertp(pt);
  assertp(address);  
  p = (dbx_variable *)malloc(sizeof(dbx_variable));
  assertp(p);
  p->type = pt;
  p->level = level;
  p->address = address;
  return p;
}

void dispose_variable YPARAMS2(dbx_variable *,  pv)
{
  assertp(pv);
  free(pv);
}

dbx_type *variable_type YPARAMS2(dbx_variable *,  pv)
{
  assertp(pv);
  return(pv->type);
}

unsigned variable_level YPARAMS2(dbx_variable *,  pv)
{
  assertp(pv);
  return(pv->level);
}

VOID *variable_address YPARAMS2(dbx_variable *,  pv)
{
  assertp(pv);
  return(pv->address);
}

