#include <assert.h>
#include <string.h>
#include <yafl_usr.h>
#include <yafl_rnt.h>
/*********************************************************/
obj_ptr array_element YPARAMS4(obj_ptr, p, YINT, elem_nr)
{
  header *h;
  int step;
  unsigned a_level, a_size;

  if (p == NULL)
    fail_void_array();
  h = HEADER(p);   
  a_level = HEADER_ARRAY_LEVEL(h);
  if (a_level <= 0)
    {
      yafl_err(YERR_BAD_ARRAY);
      dump_trace();
      exit(1);
    }                     
  a_size = HEADER_ARRAY_SIZE(h);
  if ((elem_nr >= a_size) || (elem_nr < (YINT)0))
    fail_idx_array(a_size, elem_nr);
  if ((h->dual->first_sig < 0) && (a_level == 1))
    step = h->dual->elem_size;
   else
    step = sizeof(obj_ptr);
  return (obj_ptr) ((char *)p + ((int) elem_nr * step));
}
/*********************************************************/
yint univ_high YPARAMS2(obj_ptr, p)
{
  char a[200];
  unsigned a_level;
  
  if (! p)
    fail_void_array();
  a_level = HEADER_ARRAY_LEVEL(HEADER(p));
  if (a_level < 1)
    {
      yafl_err(YERR_BAD_ARRAY);
      sprintf (a, "HIGH failed, array level is: %d\n", 
                   a_level);
      emit_stdout(a);                   
      dump_trace();
      exit(1);
    }
  return HIGH(p);
}
