#ifndef DBX_CTRL_H
#define DBX_CTRL_H 1

/* codes for normal stop conditions */
#define XSTOPPED_BREAK 0
#define XSTOPPED_STEP 1
#define XSTOPPED_MOVE 2
#define XSTOPPED_LEAVE 3
#define XSTOPPED_TRACE 4

#define FIRST_STOPPED XSTOPPED_BREAK
#define LAST_STOPPED XSTOPPED_TRACE
#define NUMBER_STOPPED (LAST_STOPPED - FIRST_STOPPED + 1)

/* codes for error catched by YAFL checking */
#define XFAILED_ASSERT 5
#define XFAILED_VOID_MTH 6
#define XFAILED_VOID_OBJ 7
#define XFAILED_BAD_CLAS 8
#define XFAILED_VOID_ARR 9
#define XFAILED_FOR_STEP 10
#define XFAILED_IDX_ARR 11
#define XFAILED_VOID_WHAT 12
#define XFAILED_BAD_WHAT 13
#define XFAILED_BAD_CASE 14
#define XFAILED_DUAL_OVFL 15
#define XFAILED_NO_MEM 16
#define XFAILED_BAD_CLONE 17
#define XFAILED_BAD_ARRAY 18
#define XFAILED_VERSION 19
#define XFAILED_BAD_ARRAY_SIZE 20
#define XFAILED_PREC 21
#define XFAILED_POST 22

#define FIRST_FAILED XFAILED_ASSERT
#define LAST_FAILED XFAILED_POST
#define NUMBER_FAILED (LAST_FAILED - FIRST_FAILED + 1)

/* codes for errors catched by capturing synchonous signals */
#define XCRASHED_FPE 23
#define XCRASHED_ILL 24
#define XCRASHED_BUS 25
#define XCRASHED_SEGV 26
#define XCRASHED_ABRT 27

#define FIRST_CRASHED XCRASHED_FPE
#define LAST_CRASHED XCRASHED_ABRT
#define NUMBER_CRASHED (LAST_CRASHED - FIRST_CRASHED + 1)

/* codes for keyboard-generated,asynchronous signals */
#define XPRESSED_INT 28
#define XPRESSED_TSTP 29

#define FIRST_PRESSED XPRESSED_INT
#define LAST_PRESSED XPRESSED_TSTP
#define NUMBER_PRESSED (LAST_PRESSED - FIRST_PRESSED + 1)

char *ctrl_message YARGS((unsigned code));
void monitor YARGS((void));
void crash YARGS((int code));
void mode_run YARGS((void));
void mode_step YARGS((void));
void mode_trace YARGS((void));
void mode_enter YARGS((void));
void mode_leave YARGS((void));
void init_dbx_ctrl YARGS((void));
void term_dbx_ctrl YARGS((void));

#endif

