(********************************************************************************************
** PROGRAM     : FileCRC
** VERSION     : 1.0.0
** DESCRIPTION : Calculates a CRC for a file.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 2002. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and was written to provide
** an example of how to use the built-in function crc32. To make best use of this
** sample you should have a basic understanding of Pascal.
**********************************************************************************************)
program filecrc(input, output);
var
   fn : filename;
   f : file of char;
   c : char;
   crc : integer;
begin
   write('Enter filename: ');
   readln(fn);
   writeln('Calculating CRC...');
   crc := 0;
   reset(f, fn);
   while not eof(f) do
      begin
         read(f, c);
         crc32(crc, c);
      end;

   crc32(crc, 0);
   crc32(crc, 0);
   crc32(crc, 0);
   crc32(crc, 0);

   writeln('CRC for ', fn, ' is ', crc, ' or (', hex(crc), ') in hexadecimal');
end.
