(********************************************************************************************
** PROGRAM     : type
** VERSION     : 1.0.0
** DESCRIPTION : Copies characters from an input file to an output file.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 1998-2002. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and was written as an example
** of how to read and write files using Irie Pascal. To make best use of this sample you
** should have a basic understanding of Pascal.
**
** Syntax: ivm type [in [out]]
**    where 'in' is the name of the input file. If 'in' is omitted then
**          the standard input stream is used.
**    and  'out' is the name of the output file. If 'out' is omitted then
**         the standard output stream is used.
**********************************************************************************************)
program _type(f, out); //type is a keyword so use _type instead
var
   f, out : text;
   c : char;
begin
   reset(f);            (* Open "in" or the standard input *)
   rewrite(out);        (* Open "out" or the standard output *)
   while not eof(f) do
      if eoln(f) then
         begin
            readln(f);
            writeln(out)
         end
      else
         begin
            read(f, c);
            write(out, c)
         end
end.
