(********************************************************************************************
** PROGRAM     : Start
** VERSION     : 1.0.0
** DESCRIPTION : Simple Windows Sockets Demo
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 2003. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and was written to provide
** an example of how to write Windows Sockets API programs with Irie Pascal. To make best
** use of this sample you should have a basic understanding of Pascal as well as a basic
** understanding of the Sockets API. An effort was made, while writing this program, to
** stick to the general Sockets API as much as possible, and to avoid the extensions added
** in the Windows Sockets API. However in two cases this was not possible. The Windows Sockets
** API, requires you to call function "WSAStartUp" before calling any other function, and to
** call the function "WSACleanUp" when you are finished.
**
**    The file "winsock2.inc" is a system include file, that is distributed with
** Irie Pascal and contains declarations for the functions, procedures, types, and
** constants defined in the Windows Sockets API. In almost all cases, the names of
** entities declared in "winsock2.inc" are identical to the names of the
** corresponding entity in the Sockets API. However there are a few unavoidable
** cases where different names are used. The Sockets API was created for the C
** programming language, and defines the type "SOCKET" and the function "socket".
** Although "SOCKET" and "socket" differ only in case, this is not a problem in C
** which is case sensitive. However since Pascal is not case sensitive, "SOCKET"
** and "socket" are the same identifier and can not refer to different entities. So
** "winsock2.inc" uses "SOCKET" for the type and "createsocket" for the function.
**
**   Notice that "winsock2.inc" is included before the keyword "program" which normally
** marks the start of a program. Starting in version 2.5, Irie Pascal allows declarations
** to occur before the keyword "program". When this is done, the declarations are placed
** in the same invisible outermost scope, as the declarations for the built-in identifiers
** like "writeln" or "integer". As you probably know, if you declare an identifier your
** declaration will override any other declarations of that identifier in outer scopes.
** This means that the program below can use any declarations in "winsock2.inc" it wants
** to, and pretend that the other declarations don't exist (since they will be overridden if
** they are occur in the program). For this reason, it is recommended that you also include
** system include files before the keyword "program".
*********************************************************************************************)

(*$I winsock2.inc *)
program start(output);
var
	data : WSADATA;
	iRet : integer;
begin
	iRet := WSAStartUp($0202, data);
	if iRet <> 0 then
		begin
			writeln('WSAStartUp call failed. Return Code=', iRet);
			halt;
		end;
	writeln('WSAStartUp call succeeded.');
	writeln('Version: $', hex(data.wVersion));
	writeln('High Version: $', hex(data.wHighVersion));
	writeln('Description: ', data.szDescription);
	writeln('System Status: ', data.szSystemStatus);
	iRet := WSACleanUp
end.
