//FILE: WINBASE.INC
//VERSION: 1.0
(*$W44- *)
(*$W53- *)
(*$W42- *)

(*$I windef.inc *)

const
    INVALID_HANDLE_VALUE = -1;
    INVALID_FILE_SIZE = $FFFFFFFF;

    FILE_BEGIN = 0;
    FILE_CURRENT = 1;
    FILE_END = 2;
    TIME_ZONE_ID_INVALID = $FFFFFFFF;
    WAIT_FAILED = $FFFFFFFF;
    WAIT_OBJECT_0 = STATUS_WAIT_0;

    WAIT_ABANDONED = STATUS_ABANDONED_WAIT_0;
    WAIT_ABANDONED_0 = STATUS_ABANDONED_WAIT_0;
    WAIT_TIMEOUT = STATUS_TIMEOUT;
    WAIT_IO_COMPLETION = STATUS_USER_APC;
    STILL_ACTIVE = STATUS_PENDING;
    EXCEPTION_ACCESS_VIOLATION = STATUS_ACCESS_VIOLATION;
    EXCEPTION_DATATYPE_MISALIGNMENT = STATUS_DATATYPE_MISALIGNMENT;
    EXCEPTION_BREAKPOINT = STATUS_BREAKPOINT;
    EXCEPTION_SINGLE_STEP = STATUS_SINGLE_STEP;
    EXCEPTION_ARRAY_BOUNDS_EXCEEDED = STATUS_ARRAY_BOUNDS_EXCEEDED;
    EXCEPTION_FLT_DENORMAL_OPERAND = STATUS_FLOAT_DENORMAL_OPERAND;
    EXCEPTION_FLT_DIVIDE_BY_ZERO = STATUS_FLOAT_DIVIDE_BY_ZERO;
    EXCEPTION_FLT_INEXACT_RESULT = STATUS_FLOAT_INEXACT_RESULT;
    EXCEPTION_FLT_INVALID_OPERATION = STATUS_FLOAT_INVALID_OPERATION;
    EXCEPTION_FLT_OVERFLOW = STATUS_FLOAT_OVERFLOW;
    EXCEPTION_FLT_STACK_CHECK = STATUS_FLOAT_STACK_CHECK;
    EXCEPTION_FLT_UNDERFLOW = STATUS_FLOAT_UNDERFLOW;
    EXCEPTION_INT_DIVIDE_BY_ZERO = STATUS_INTEGER_DIVIDE_BY_ZERO;
    EXCEPTION_INT_OVERFLOW = STATUS_INTEGER_OVERFLOW;
    EXCEPTION_PRIV_INSTRUCTION = STATUS_PRIVILEGED_INSTRUCTION;
    EXCEPTION_IN_PAGE_ERROR = STATUS_IN_PAGE_ERROR;
    EXCEPTION_ILLEGAL_INSTRUCTION = STATUS_ILLEGAL_INSTRUCTION;
    EXCEPTION_NONCONTINUABLE_EXCEPTION = STATUS_NONCONTINUABLE_EXCEPTION;
    EXCEPTION_STACK_OVERFLOW = STATUS_STACK_OVERFLOW;
    EXCEPTION_INVALID_DISPOSITION = STATUS_INVALID_DISPOSITION;
    EXCEPTION_GUARD_PAGE = STATUS_GUARD_PAGE_VIOLATION;
    EXCEPTION_INVALID_HANDLE = STATUS_INVALID_HANDLE;
    CONTROL_C_EXIT = STATUS_CONTROL_C_EXIT;

    FILE_FLAG_WRITE_THROUGH = $80000000;
    FILE_FLAG_OVERLAPPED = $40000000;
    FILE_FLAG_NO_BUFFERING = $20000000;
    FILE_FLAG_RANDOM_ACCESS = $10000000;
    FILE_FLAG_SEQUENTIAL_SCAN = $08000000;
    FILE_FLAG_DELETE_ON_CLOSE = $04000000;
    FILE_FLAG_BACKUP_SEMANTICS = $02000000;
    FILE_FLAG_POSIX_SEMANTICS = $01000000;
    CREATE_NEW = 1;
    CREATE_ALWAYS = 2;
    OPEN_EXISTING = 3;
    OPEN_ALWAYS = 4;
    TRUNCATE_EXISTING = 5;

    PROGRESS_CONTINUE = 0;
    PROGRESS_CANCEL = 1;
    PROGRESS_STOP = 2;
    PROGRESS_QUIET = 3;

    CALLBACK_CHUNK_FINISHED = $00000000;
    CALLBACK_STREAM_SWITCH = $00000001;
    COPY_FILE_FAIL_IF_EXISTS = $00000001;
    COPY_FILE_RESTARTABLE = $00000002;

    PIPE_ACCESS_INBOUND = $00000001;
    PIPE_ACCESS_OUTBOUND = $00000002;
    PIPE_ACCESS_DUPLEX = $00000003;
    PIPE_CLIENT_END = $00000000;
    PIPE_SERVER_END = $00000001;
    PIPE_WAIT = $00000000;
    PIPE_NOWAIT = $00000001;
    PIPE_READMODE_BYTE = $00000000;
    PIPE_READMODE_MESSAGE = $00000002;
    PIPE_TYPE_BYTE = $00000000;
    PIPE_TYPE_MESSAGE = $00000004;

    PIPE_UNLIMITED_INSTANCES = 255;

type
	SECURITY_IMPERSONATION_LEVEL = (SecurityAnonymous, SecurityIdentification,
									SecurityImpersonation, SecurityDelegation);

const
	SECURITY_MAX_IMPERSONATION_LEVEL = SecurityDelegation;

    DEFAULT_IMPERSONATION_LEVEL = SecurityImpersonation;
    SECURITY_ANONYMOUS = 0;
    SECURITY_IDENTIFICATION = $100;
    SECURITY_IMPERSONATION = $200;
    SECURITY_DELEGATION = $300;
    SECURITY_CONTEXT_TRACKING = $00040000;
    SECURITY_EFFECTIVE_ONLY = $00080000;
    SECURITY_SQOS_PRESENT = $00100000;
    SECURITY_VALID_SQOS_FLAGS = $001F0000;

    TOKEN_ASSIGN_PRIMARY = $0001;
    TOKEN_DUPLICATE = $0002;
    TOKEN_IMPERSONATE = $0004;
    TOKEN_QUERY = $0008;
    TOKEN_QUERY_SOURCE = $0010;
    TOKEN_ADJUST_PRIVILEGES = $0020;
    TOKEN_ADJUST_GROUPS = $0040;
    TOKEN_ADJUST_DEFAULT = $0080;

	TOKEN_ALL_ACCESS = $000F00FF;
	TOKEN_READ = $000F0008;
	TOKEN_WRITE = $000200E0;
	TOKEN_EXECUTE = STANDARD_RIGHTS_EXECUTE;

type
	TOKEN_TYPE = (TokenPlaceHolder, TokenPrimary, TokenImpersonation);
	TOKEN_INFORMATION_CLASS = (TokenInfoPlaceHolder, TokenUser, TokenGroups,
    		TokenPrivileges, TokenOwner, TokenPrimaryGroup, TokenDefaultDacl,
    		TokenSource, TokenType, TokenImpersonationLevel, TokenStatistics);

	ACL_INFORMATION_CLASS = (AclPlaceHolder, AclRevisionInformation, AclSizeInformation);

	TOKEN_USER = packed record
    	User : SID_AND_ATTRIBUTES;
	end;

	TOKEN_GROUPS = packed record
	    GroupCount : DWORD;
	end;

	TOKEN_PRIVILEGES = packed record
	    PrivilegeCount : DWORD;
	end;

	TOKEN_OWNER = packed record
    	Owner : address;
	end;

	TOKEN_PRIMARY_GROUP = packed record
    	PrimaryGroup : address;
	end;

	TOKEN_DEFAULT_DACL = packed record
    	DefaultDacl : address;
	end;

const
	TOKEN_SOURCE_LENGTH = 7;

type
	TOKEN_SOURCE = packed record
	    SourceName : cstring[TOKEN_SOURCE_LENGTH];
    	SourceIdentifier : LUID;
	end;

	TOKEN_STATISTICS = packed record
	    TokenId : LUID;
    	AuthenticationId : LUID;
	    ExpirationTime : LARGE_INTEGER;
    	TokenType : TOKEN_TYPE;
	    ImpersonationLevel : SECURITY_IMPERSONATION_LEVEL;
    	DynamicCharged : DWORD;
	    DynamicAvailable : DWORD;
    	GroupCount : DWORD;
	    PrivilegeCount : DWORD;
    	ModifiedId : LUID;
	end;

	TOKEN_CONTROL = packed record
	    TokenId : LUID;
    	AuthenticationId : LUID;
	    ModifiedId : LUID;
    	TokenSource : TOKEN_SOURCE;
	end;

const
	SECURITY_DYNAMIC_TRACKING = TRUE;
	SECURITY_STATIC_TRACKING = FALSE;

type
	SECURITY_INFORMATION = DWORD;

	SECURITY_CONTEXT_TRACKING_MODE = boolean;

	OVERLAPPED = packed record
	    Internal : DWORD;
    	InternalHigh : DWORD;
	    Offset : DWORD;
    	OffsetHigh : DWORD;
	    hEvent : HANDLE;
	end;

	SECURITY_ATTRIBUTES = packed record
    	nLength : DWORD;
    	lpSecurityDescriptor : LPVOID;
    	bInheritHandle : BOOL;
	end;

	PROCESS_INFORMATION = packed record
	    hProcess : HANDLE;
    	hThread : HANDLE;
	    dwProcessId : DWORD;
    	dwThreadId : DWORD;
	end;

	FILETIME = packed record
    	dwLowDateTime : DWORD;
    	dwHighDateTime : DWORD;
	end;

	SYSTEMTIME = packed record
    	wYear : shortword;
    	wMonth : shortword;
    	wDayOfWeek : shortword;
    	wDay : shortword;
    	wHour : shortword;
    	wMinute : shortword;
    	wSecond : shortword;
    	wMilliseconds : shortword;
	end;

	CRITICAL_SECTION = RTL_CRITICAL_SECTION;

const
    EVENT_MODIFY_STATE = $0002;
    EVENT_ALL_ACCESS = $001F0003;
    MUTANT_QUERY_STATE = $0001;
    MUTANT_ALL_ACCESS = $001F0001;
    SEMAPHORE_MODIFY_STATE = $0002;
    SEMAPHORE_ALL_ACCESS = $001F0003;
    TIME_ZONE_ID_UNKNOWN = 0;
    TIME_ZONE_ID_STANDARD = 1;
    TIME_ZONE_ID_DAYLIGHT = 2;
    MUTEX_MODIFY_STATE = MUTANT_QUERY_STATE;
    MUTEX_ALL_ACCESS = MUTANT_ALL_ACCESS;

    SP_SERIALCOMM = $00000001;
    PST_UNSPECIFIED = $00000000;
    PST_RS232 = $00000001;
    PST_PARALLELPORT = $00000002;
    PST_RS422 = $00000003;
    PST_RS423 = $00000004;
    PST_RS449 = $00000005;
    PST_MODEM = $00000006;
    PST_FAX = $00000021;
    PST_SCANNER = $00000022;
    PST_NETWORK_BRIDGE = $00000100;
    PST_LAT = $00000101;
    PST_TCPIP_TELNET = $00000102;
    PST_X25 = $00000103;

    PCF_DTRDSR = $0001;
    PCF_RTSCTS = $0002;
    PCF_RLSD = $0004;
    PCF_PARITY_CHECK = $0008;
    PCF_XONXOFF = $0010;
    PCF_SETXCHAR = $0020;
    PCF_TOTALTIMEOUTS = $0040;
    PCF_INTTIMEOUTS = $0080;
    PCF_SPECIALCHARS = $0100;
    PCF_16BITMODE = $0200;

    SP_PARITY = $0001;
    SP_BAUD = $0002;
    SP_DATABITS = $0004;
    SP_STOPBITS = $0008;
    SP_HANDSHAKING = $0010;
    SP_PARITY_CHECK = $0020;
    SP_RLSD = $0040;

    BAUD_075 = $00000001;
    BAUD_110 = $00000002;
    BAUD_134_5 = $00000004;
    BAUD_150 = $00000008;
    BAUD_300 = $00000010;
    BAUD_600 = $00000020;
    BAUD_1200 = $00000040;
    BAUD_1800 = $00000080;
    BAUD_2400 = $00000100;
    BAUD_4800 = $00000200;
    BAUD_7200 = $00000400;
    BAUD_9600 = $00000800;
    BAUD_14400 = $00001000;
    BAUD_19200 = $00002000;
    BAUD_38400 = $00004000;
    BAUD_56K = $00008000;
    BAUD_128K = $00010000;
    BAUD_115200 = $00020000;
    BAUD_57600 = $00040000;
    BAUD_USER = $10000000;

    DATABITS_5 = $0001;
    DATABITS_6 = $0002;
    DATABITS_7 = $0004;
    DATABITS_8 = $0008;
    DATABITS_16 = $0010;
    DATABITS_16X = $0020;
    STOPBITS_10 = $0001;
    STOPBITS_15 = $0002;
    STOPBITS_20 = $0004;
    PARITY_NONE = $0100;
    PARITY_ODD = $0200;
    PARITY_EVEN = $0400;
    PARITY_MARK = $0800;
    PARITY_SPACE = $1000;

type
	COMMPROP = packed record
	    wPacketLength : shortword;
    	wPacketVersion : shortword;
	    dwServiceMask : DWORD;
    	dwReserved1 : DWORD;
	    dwMaxTxQueue : DWORD;
    	dwMaxRxQueue : DWORD;
	    dwMaxBaud : DWORD;
    	dwProvSubType : DWORD;
	    dwProvCapabilities : DWORD;
    	dwSettableParams : DWORD;
	    dwSettableBaud : DWORD;
    	wSettableData : shortword;
	    wSettableStopParity : shortword;
    	dwCurrentTxQueue : DWORD;
	    dwCurrentRxQueue : DWORD;
    	dwProvSpec1 : DWORD;
	    dwProvSpec2 : DWORD;
	end;

const
	COMMPROP_INITIALIZED = $E73CF52E;

    COMSTAT_flags_fCtsHold  = %00000001;
    COMSTAT_flags_fDsrHold  = %00000010;
    COMSTAT_flags_fRlsdHold = %00000100;
    COMSTAT_flags_fXoffHold = %00001000;
    COMSTAT_flags_fXoffSent = %00010000;
    COMSTAT_flags_fEof      = %00100000;
    COMSTAT_flags_fTxim     = %01000000;

type
	COMSTAT = packed record
		flags : DWORD;
	    cbInQue : DWORD;
    	cbOutQue : DWORD;
	end;

const
    DTR_CONTROL_DISABLE = $00;
    DTR_CONTROL_ENABLE = $01;
    DTR_CONTROL_HANDSHAKE = $02;
    RTS_CONTROL_DISABLE = $00;
    RTS_CONTROL_ENABLE = $01;
    RTS_CONTROL_HANDSHAKE = $02;
    RTS_CONTROL_TOGGLE = $03;

const
    DCB_flags_fBinary = $01;
    DCB_flags_fParity = $02;
    DCB_flags_fOutxCtsFlow = $04;
    DCB_flags_fOutxDsrFlow = $08;
    DCB_flags_fDtrControl = $30;
    DCB_flags_fDsrSensitivity = $40;
    DCB_flags_fTXContinueOnXoff = $80;
    DCB_flags_fOutX = $100;
    DCB_flags_fInX = $200;
    DCB_flags_fErrorChar = $400;
    DCB_flags_fNull = $800;
    DCB_flags_fRtsControl = $3000;
    DCB_flags_fAbortOnError = $4000;

type
	DCB = packed record
	    DCBlength : DWORD;
    	BaudRate : DWORD;
		flags : DWORD;
	    wReserved : shortword;
    	XonLim : shortword;
	    XoffLim : shortword;
	    ByteSize : byte;
    	Parity : byte;
	    StopBits : byte;
    	XonChar : char;
	    XoffChar : char;
	    ErrorChar : char;
    	EofChar : char;
	    EvtChar : char;
    	wReserved1 : shortword;
	end;
	_DCB = DCB;

	COMMTIMEOUTS = packed record
	    ReadIntervalTimeout : DWORD;
    	ReadTotalTimeoutMultiplier : DWORD;
	    ReadTotalTimeoutConstant : DWORD;
    	WriteTotalTimeoutMultiplier : DWORD;
	    WriteTotalTimeoutConstant : DWORD;
	end;

	COMMCONFIG = packed record
	    dwSize : DWORD;
    	wVersion : shortword;
	    wReserved : shortword;
    	dcb : _DCB;
	    dwProviderSubType : DWORD;
    	dwProviderOffset : DWORD;
	    dwProviderSize : DWORD;
	end;

	MODEMDEVCAPS = packed record
	    dwActualSize : DWORD;
    	dwRequiredSize : DWORD;
	    dwDevSpecificOffset : DWORD;
    	dwDevSpecificSize : DWORD;
	    dwModemProviderVersion : DWORD;
    	dwModemManufacturerOffset : DWORD;
	    dwModemManufacturerSize : DWORD;
    	dwModemModelOffset : DWORD;
		dwModemModelSize : DWORD;
	    dwModemVersionOffset : DWORD;
    	dwModemVersionSize : DWORD;
	    dwDialOptions : DWORD;
    	dwCallSetupFailTimer : DWORD;
	    dwInactivityTimeout : DWORD;
    	dwSpeakerVolume : DWORD;
	    dwSpeakerMode : DWORD;
    	dwModemOptions : DWORD;
	    dwMaxDTERate : DWORD;
    	dwMaxDCERate : DWORD;
	end;

	MODEMSETTINGS = packed record
	    dwActualSize : DWORD;
    	dwRequiredSize : DWORD;
	    dwDevSpecificOffset : DWORD;
    	dwDevSpecificSize : DWORD;
	    dwCallSetupFailTimer : DWORD;
    	dwInactivityTimeout : DWORD;
	    dwSpeakerVolume : DWORD;
    	dwSpeakerMode : DWORD;
	    dwPreferredModemOptions : DWORD;
	    dwNegotiatedModemOptions : DWORD;
    	dwNegotiatedDCERate : DWORD;
	end;

const
    DIALOPTION_BILLING = $00000040;
    DIALOPTION_QUIET = $00000080;
    DIALOPTION_DIALTONE = $00000100;
    MDMVOLFLAG_LOW = $00000001;
    MDMVOLFLAG_MEDIUM = $00000002;
    MDMVOLFLAG_HIGH = $00000004;
    MDMVOL_LOW = $00000000;
    MDMVOL_MEDIUM = $00000001;
    MDMVOL_HIGH = $00000002;
    MDMSPKRFLAG_OFF = $00000001;
    MDMSPKRFLAG_DIAL = $00000002;
    MDMSPKRFLAG_ON = $00000004;
    MDMSPKRFLAG_CALLSETUP = $00000008;
    MDMSPKR_OFF = $00000000;
    MDMSPKR_DIAL = $00000001;
    MDMSPKR_ON = $00000002;
    MDMSPKR_CALLSETUP = $00000003;
	MDM_COMPRESSION = $00000001;
    MDM_ERROR_CONTROL = $00000002;
    MDM_FORCED_EC = $00000004;
    MDM_CELLULAR = $00000008;
    MDM_FLOWCONTROL_HARD = $00000010;
    MDM_FLOWCONTROL_SOFT = $00000020;
    MDM_CCITT_OVERRIDE = $00000040;
    MDM_SPEED_ADJUST = $00000080;
    MDM_TONE_DIAL = $00000100;
    MDM_BLIND_DIAL = $00000200;
    MDM_V23_OVERRIDE = $00000400;

type
	SYSTEM_INFO = packed record
		wProcessorArchitecture : shortword;
		wReserved : shortword;
	    dwPageSize : DWORD;
    	lpMinimumApplicationAddress : LPVOID;
	    lpMaximumApplicationAddress : LPVOID;
    	dwActiveProcessorMask : DWORD;
	    dwNumberOfProcessors : DWORD;
    	dwProcessorType : DWORD;
	    dwAllocationGranularity : DWORD;
    	wProcessorLevel : shortword;
	    wProcessorRevision : shortword;
	end;

const
    GMEM_FIXED = $0000;
    GMEM_MOVEABLE = $0002;
    GMEM_NOCOMPACT = $0010;
    GMEM_NODISCARD = $0020;
    GMEM_ZEROINIT = $0040;
    GMEM_MODIFY = $0080;
    GMEM_DISCARDABLE = $0100;
    GMEM_NOT_BANKED = $1000;
    GMEM_SHARE = $2000;
    GMEM_DDESHARE = $2000;
    GMEM_NOTIFY = $4000;
    GMEM_LOWER = GMEM_NOT_BANKED;
    GMEM_VALID_FLAGS = $7F72;
    GMEM_INVALID_HANDLE = $8000;
    GHND = $0042;
    GPTR = $0040;

    GMEM_DISCARDED = $4000;
    GMEM_LOCKCOUNT = $00FF;

type
	MEMORYSTATUS = packed record
	    dwLength : DWORD;
    	dwMemoryLoad : DWORD;
	    dwTotalPhys : DWORD;
    	dwAvailPhys : DWORD;
	    dwTotalPageFile : DWORD;
    	dwAvailPageFile : DWORD;
	    dwTotalVirtual : DWORD;
    	dwAvailVirtual : DWORD;
	end;

const
    LMEM_FIXED = $0000;
    LMEM_MOVEABLE = $0002;
    LMEM_NOCOMPACT = $0010;
    LMEM_NODISCARD = $0020;
    LMEM_ZEROINIT = $0040;
    LMEM_MODIFY = $0080;
    LMEM_DISCARDABLE = $0F00;
    LMEM_VALID_FLAGS = $0F72;
    LMEM_INVALID_HANDLE = $8000;
    LHND = $0042;
    LPTR = $0040;
    NONZEROLHND = LMEM_MOVEABLE;
    NONZEROLPTR = LMEM_FIXED;

    LMEM_DISCARDED = $4000;
    LMEM_LOCKCOUNT = $00FF;

    DEBUG_PROCESS = $00000001;
    DEBUG_ONLY_THIS_PROCESS = $00000002;
    CREATE_SUSPENDED = $00000004;
    DETACHED_PROCESS = $00000008;
    CREATE_NEW_CONSOLE = $00000010;
    NORMAL_PRIORITY_CLASS = $00000020;
    IDLE_PRIORITY_CLASS = $00000040;
    HIGH_PRIORITY_CLASS = $00000080;
    REALTIME_PRIORITY_CLASS = $00000100;
    CREATE_NEW_PROCESS_GROUP = $00000200;
    CREATE_UNICODE_ENVIRONMENT = $00000400;
    CREATE_SEPARATE_WOW_VDM = $00000800;
    CREATE_SHARED_WOW_VDM = $00001000;
    CREATE_FORCEDOS = $00002000;
    CREATE_DEFAULT_ERROR_MODE = $04000000;
    CREATE_NO_WINDOW = $08000000;
    PROFILE_USER = $10000000;
    PROFILE_KERNEL = $20000000;
    PROFILE_SERVER = $40000000;

    THREAD_BASE_PRIORITY_LOWRT = 15;
    THREAD_BASE_PRIORITY_MAX = 2;
    THREAD_BASE_PRIORITY_MIN = -2;
    THREAD_BASE_PRIORITY_IDLE = -15;

    THREAD_PRIORITY_LOWEST = THREAD_BASE_PRIORITY_MIN;
    THREAD_PRIORITY_BELOW_NORMAL = -1;
    THREAD_PRIORITY_NORMAL = 0;
    THREAD_PRIORITY_HIGHEST = THREAD_BASE_PRIORITY_MAX;
    THREAD_PRIORITY_ABOVE_NORMAL = 1;
    THREAD_PRIORITY_ERROR_RETURN = MAXLONG;
    THREAD_PRIORITY_TIME_CRITICAL = THREAD_BASE_PRIORITY_LOWRT;
    THREAD_PRIORITY_IDLE = THREAD_BASE_PRIORITY_IDLE;

    EXCEPTION_DEBUG_EVENT = 1;
    CREATE_THREAD_DEBUG_EVENT = 2;
    CREATE_PROCESS_DEBUG_EVENT = 3;
    EXIT_THREAD_DEBUG_EVENT = 4;
    EXIT_PROCESS_DEBUG_EVENT = 5;
    LOAD_DLL_DEBUG_EVENT = 6;
    UNLOAD_DLL_DEBUG_EVENT = 7;
    OUTPUT_DEBUG_STRING_EVENT = 8;
    RIP_EVENT = 9;

type
	EXCEPTION_DEBUG_INFO = packed record
	    ExceptionRecord : EXCEPTION_RECORD;
    	dwFirstChance : DWORD;
	end;

	CREATE_THREAD_DEBUG_INFO = packed record
	    hThread : HANDLE;
    	lpThreadLocalBase : LPVOID;
	    lpStartAddress : PROC;
	end;

	CREATE_PROCESS_DEBUG_INFO = packed record
	    hFile : HANDLE;
    	hProcess : HANDLE;
	    hThread : HANDLE;
    	lpBaseOfImage : LPVOID;
	    dwDebugInfoFileOffset : DWORD;
    	nDebugInfoSize : DWORD;
	    lpThreadLocalBase : LPVOID;
    	lpStartAddress : PROC;
	    lpImageName : LPVOID;
    	fUnicode : shortword;
	end;

	EXIT_THREAD_DEBUG_INFO = packed record
    	dwExitCode : DWORD;
	end;

	EXIT_PROCESS_DEBUG_INFO = packed record
    	dwExitCode : DWORD;
	end;

	LOAD_DLL_DEBUG_INFO = packed record
	    hFile : HANDLE;
    	lpBaseOfDll : LPVOID;
	    dwDebugInfoFileOffset : DWORD;
    	nDebugInfoSize : DWORD;
	    lpImageName : LPVOID;
    	fUnicode : shortword;
	end;

	UNLOAD_DLL_DEBUG_INFO = packed record
    	lpBaseOfDll : LPVOID;
	end;

	OUTPUT_DEBUG_STRING_INFO = packed record
	    lpDebugStringData : LPSTR;
    	fUnicode : shortword;
	    nDebugStringLength : shortword;
	end;

	RIP_INFO = packed record
	    dwError : DWORD;
    	dwType : DWORD;
	end;

	DEBUG_EVENT = packed record
		case dwDebugEventCode : DWORD of
	    EXCEPTION_DEBUG_EVENT: (
		    Exception_dwProcessId : DWORD;
	    	Exception_dwThreadId : DWORD;
        	Exception : EXCEPTION_DEBUG_INFO;
	    	);
    	CREATE_THREAD_DEBUG_EVENT: (
		    CreateThread_dwProcessId : DWORD;
	    	CreateThread_dwThreadId : DWORD;
         	CreateThread : CREATE_THREAD_DEBUG_INFO;
   		);
	    CREATE_PROCESS_DEBUG_EVENT: (
		    CreateProcessInfo_dwProcessId : DWORD;
	    	CreateProcessInfo_dwThreadId : DWORD;
	        CreateProcessInfo : CREATE_PROCESS_DEBUG_INFO;
	    	);
    	EXIT_THREAD_DEBUG_EVENT: (
		    ExitThread_dwProcessId : DWORD;
	    	ExitThread_dwThreadId : DWORD;
	        ExitThread : EXIT_THREAD_DEBUG_INFO;
    		);
	    EXIT_PROCESS_DEBUG_EVENT: (
		    ExitProcess_dwProcessId : DWORD;
	    	ExitProcess_dwThreadId : DWORD;
	        ExitProcess : EXIT_PROCESS_DEBUG_INFO;
	    	);
    	LOAD_DLL_DEBUG_EVENT: (
		    LoadDll_dwProcessId : DWORD;
	    	LoadDll_dwThreadId : DWORD;
	        LoadDll : LOAD_DLL_DEBUG_INFO;
    		);
	    UNLOAD_DLL_DEBUG_EVENT: (
		    UnloadDll_dwProcessId : DWORD;
	    	UnloadDll_dwThreadId : DWORD;
	        UnloadDll : UNLOAD_DLL_DEBUG_INFO;
	    	);
    	OUTPUT_DEBUG_STRING_EVENT: (
		    DebugString_dwProcessId : DWORD;
	    	DebugString_dwThreadId : DWORD;
	        DebugString : OUTPUT_DEBUG_STRING_INFO;
    		);
	    RIP_EVENT: (
		    RipInfo_dwProcessId : DWORD;
	    	RipInfo_dwThreadId : DWORD;
        	RipInfo : RIP_INFO;
	    	)
	end;

const
    DRIVE_UNKNOWN = 0;
    DRIVE_NO_ROOT_DIR = 1;
    DRIVE_REMOVABLE = 2;
    DRIVE_FIXED = 3;
    DRIVE_REMOTE = 4;
    DRIVE_CDROM = 5;
    DRIVE_RAMDISK = 6;

    FILE_TYPE_UNKNOWN = $0000;
    FILE_TYPE_DISK = $0001;
    FILE_TYPE_CHAR = $0002;
    FILE_TYPE_PIPE = $0003;
    FILE_TYPE_REMOTE = $8000;

    STD_INPUT_HANDLE = -10;
    STD_OUTPUT_HANDLE = -11;
    STD_ERROR_HANDLE = -12;

    NOPARITY = 0;
    ODDPARITY = 1;
    EVENPARITY = 2;
    MARKPARITY = 3;
    SPACEPARITY = 4;
    ONESTOPBIT = 0;
    ONE5STOPBITS = 1;
    TWOSTOPBITS = 2;

    IGNORE = 0;
    INFINITE = $FFFFFFFF;

    CBR_110 = 110;
    CBR_300 = 300;
    CBR_600 = 600;
    CBR_1200 = 1200;
    CBR_2400 = 2400;
    CBR_4800 = 4800;
    CBR_9600 = 9600;
    CBR_14400 = 14400;
    CBR_19200 = 19200;
    CBR_38400 = 38400;
    CBR_56000 = 56000;
    CBR_57600 = 57600;
    CBR_115200 = 115200;
    CBR_128000 = 128000;
    CBR_256000 = 256000;

    CE_RXOVER = $0001;
    CE_OVERRUN = $0002;
    CE_RXPARITY = $0004;
    CE_FRAME = $0008;
    CE_BREAK = $0010;
    CE_TXFULL = $0100;
    CE_PTO = $0200;
    CE_IOE = $0400;
    CE_DNS = $0800;
    CE_OOP = $1000;
    CE_MODE = $8000;

    IE_BADID = -1;
    IE_OPEN = -2;
    IE_NOPEN = -3;
    IE_MEMORY = -4;
    IE_DEFAULT = -5;
    IE_HARDWARE = -10;
    IE_BYTESIZE = -11;
    IE_BAUDRATE = -12;

    EV_RXCHAR = $0001;
    EV_RXFLAG = $0002;
    EV_TXEMPTY = $0004;
    EV_CTS = $0008;
    EV_DSR = $0010;
    EV_RLSD = $0020;
    EV_BREAK = $0040;
    EV_ERR = $0080;
    EV_RING = $0100;
    EV_PERR = $0200;
    EV_RX80FULL = $0400;
    EV_EVENT1 = $0800;
    EV_EVENT2 = $1000;

    SETXOFF = 1;
    SETXON = 2;
    SETRTS = 3;
    CLRRTS = 4;
    SETDTR = 5;
    CLRDTR = 6;
    RESETDEV = 7;
    SETBREAK = 8;
    CLRBREAK = 9;

    PURGE_TXABORT = $0001;
    PURGE_RXABORT = $0002;
    PURGE_TXCLEAR = $0004;
    PURGE_RXCLEAR = $0008;
    LPTx = $80;

    MS_CTS_ON = $0010;
    MS_DSR_ON = $0020;
    MS_RING_ON = $0040;
    MS_RLSD_ON = $0080;

    S_QUEUEEMPTY = 0;
    S_THRESHOLD = 1;
    S_ALLTHRESHOLD = 2;

    S_NORMAL = 0;
    S_LEGATO = 1;
    S_STACCATO = 2;

    S_PERIOD512 = 0;
    S_PERIOD1024 = 1;
    S_PERIOD2048 = 2;
    S_PERIODVOICE = 3;
    S_WHITE512 = 4;
    S_WHITE1024 = 5;
    S_WHITE2048 = 6;
    S_WHITEVOICE = 7;
    S_SERDVNA = -1;
    S_SEROFM = -2;
    S_SERMACT = -3;
    S_SERQFUL = -4;
    S_SERBDNT = -5;
    S_SERDLN = -6;
    S_SERDCC = -7;
    S_SERDTP = -8;
    S_SERDVL = -9;
    S_SERDMD = -10;
    S_SERDSH = -11;
    S_SERDPT = -12;
    S_SERDFQ = -13;
    S_SERDDR = -14;
    S_SERDSR = -15;
    S_SERDST = -16;

    NMPWAIT_WAIT_FOREVER = $ffffffff;
    NMPWAIT_NOWAIT = $00000001;
    NMPWAIT_USE_DEFAULT_WAIT = $00000000;
    FS_CASE_IS_PRESERVED = FILE_CASE_PRESERVED_NAMES;
    FS_CASE_SENSITIVE = FILE_CASE_SENSITIVE_SEARCH;
    FS_UNICODE_STORED_ON_DISK = FILE_UNICODE_ON_DISK;
    FS_PERSISTENT_ACLS = FILE_PERSISTENT_ACLS;
    FS_VOL_IS_COMPRESSED = FILE_VOLUME_IS_COMPRESSED;
    FS_FILE_COMPRESSION = FILE_FILE_COMPRESSION;

    FILE_MAP_COPY = SECTION_QUERY;
    FILE_MAP_WRITE = SECTION_MAP_WRITE;
    FILE_MAP_READ = SECTION_MAP_READ;
    FILE_MAP_ALL_ACCESS = SECTION_ALL_ACCESS;

    OF_READ = $00000000;
    OF_WRITE = $00000001;
    OF_READWRITE = $00000002;
    OF_SHARE_COMPAT = $00000000;
    OF_SHARE_EXCLUSIVE = $00000010;
    OF_SHARE_DENY_WRITE = $00000020;
    OF_SHARE_DENY_READ = $00000030;
    OF_SHARE_DENY_NONE = $00000040;
    OF_PARSE = $00000100;
    OF_DELETE = $00000200;
    OF_VERIFY = $00000400;
    OF_CANCEL = $00000800;
    OF_CREATE = $00001000;
    OF_PROMPT = $00002000;
    OF_EXIST = $00004000;
    OF_REOPEN = $00008000;

	OFS_MAXPATHNAME = 127;

type
	OFSTRUCT = packed record
	    cBytes : byte;
    	fFixedDisk : byte;
	    nErrCode : shortword;
    	Reserved1 : shortword;
	    Reserved2 : shortword;
    	szPathName : cstring[OFS_MAXPATHNAME];
	end;

	function InterlockedIncrement(var lpAddend : LONG) : LONG;
		external dll='kernel32.dll';
	function InterlockedDecrement(var lpAddend : LONG) : LONG;
		external dll='kernel32.dll';
	function InterlockedExchange(var Target : LONG; Value : LONG) : LONG;
		external dll='kernel32.dll';
	function InterlockedCompareExchange(Destination : address; Exchange, Comperand : address) : address;
		external dll='kernel32.dll';
	function InterlockedExchangeAdd(var Addend : LONG; Value : LONG) : LONG;
		external dll='kernel32.dll';

	function LockResource(hResData : HGLOBAL) : LPVOID;
		external dll='kernel32.dll';

const
	MAXINTATOM  = $C000;
	INVALID_ATOM = 0;

	function WinMain(hInstance, hPrevInstance : _HINSTANCE;
					  lpCmdLine : address; nShowCmd : integer) : integer;
		external dll='kernel32.dll';
	function FreeLibrary(hLibModule : HMODULE) : BOOL;
		external dll='kernel32.dll';
	procedure FreeLibraryAndExitThread(hLibModule : HMODULE; dwExitCode : DWORD);
		external dll='kernel32.dll';
	function DisableThreadLibraryCalls(hLibModule : HMODULE) : BOOL;
		external dll='kernel32.dll';
	function GetProcAddress(hMod : HMODULE; lpProcName : address) : PROC;
		external dll='kernel32.dll';
	function GetVersion : DWORD;
		external dll='kernel32.dll';

	function GlobalAlloc(uFlags : UINT; dwBytes : DWORD) : HGLOBAL;
    	external dll='kernel32.dll';
	function GlobalReAlloc(hMem : HGLOBAL; dwBytes : DWORD; uFlags : UINT) : HGLOBAL;
    	external dll='kernel32.dll';
	function GlobalSize(hMem : HGLOBAL) : DWORD;
    	external dll='kernel32.dll';
	function GlobalFlags(hMem : HGLOBAL) : UINT;
    	external dll='kernel32.dll';
	function GlobalLock(hMem : HGLOBAL) : LPVOID;
    	external dll='kernel32.dll';
	function GlobalUnlock(hMem : HGLOBAL) : BOOL;
    	external dll='kernel32.dll';
	function GlobalFree(hMem : HGLOBAL) : HGLOBAL;
    	external dll='kernel32.dll';
	function GlobalCompact(dwMinFree : DWORD) : UINT;
    	external dll='kernel32.dll';
	procedure GlobalMemoryStatus(var lpBuffer : MEMORYSTATUS);
    	external dll='kernel32.dll';
	function LocalAlloc(uFlags, uBytes : UINT) : HLOCAL;
    	external dll='kernel32.dll';
	function LocalReAlloc(hMem : HLOCAL; uBytes, uFlags : UINT) : HLOCAL;
    	external dll='kernel32.dll';
	function LocalLock(hMem : HLOCAL) : LPVOID;
    	external dll='kernel32.dll';
	function WinLocalHandle(pMem : LPVOID) : HLOCAL;
    	external dll='kernel32.dll' name='LocalHandle';
	function LocalUnlock(hMem : HLOCAL) : BOOL;
    	external dll='kernel32.dll';
	function LocalSize(hMem : HLOCAL) : UINT;
    	external dll='kernel32.dll';
	function LocalFlags(hMem : HLOCAL) : UINT;
    	external dll='kernel32.dll';
	function LocalFree(hMem : HLOCAL) : HLOCAL;
    	external dll='kernel32.dll';
	function LocalShrink(hMem : HLOCAL; cbNewSize : UINT) : UINT;
    	external dll='kernel32.dll';
	function LocalCompact(uMinFree : UINT) : UINT;
    	external dll='kernel32.dll';

	function FlushInstructionCache(hProcess : HANDLE; lpBaseAddress : LPVOID; dwSize : DWORD) : BOOL;
    	external dll='kernel32.dll';
	function VirtualAlloc(lpAddress : LPVOID; dwSize, flAllocationType, flProtect : DWORD) : LPVOID;
    	external dll='kernel32.dll';
	function VirtualFree(lpAddress : LPVOID; dwSize, dwFreeType : DWORD) : BOOL;
    	external dll='kernel32.dll';
	function VirtualProtect(lpAddress : LPVOID; dwSize, flAllocationType, flNewProtect : DWORD;
							var lpflOldProtect : DWORD) : BOOL;
    	external dll='kernel32.dll';
	function VirtualQuery(lpAddress : LPVOID; var lpBuffer : MEMORY_BASIC_INFORMATION;
							dwLength : DWORD) : DWORD;
    	external dll='kernel32.dll';
	function VirtualAllocEx(hProcess : HANDLE; lpAddress : LPVOID;
							dwSize, flAllocationType, flProtect : DWORD) : LPVOID;
    	external dll='kernel32.dll';
	function VirtualFreeEx(hProcess : HANDLE; lpAddress : LPVOID; dwSize, dwFreeType : DWORD) : BOOL;
    	external dll='kernel32.dll';
	function VirtualProtectEx(hProcess : HANDLE; lpAddress : LPVOID; dwSize, flNewProtext : DWORD;
								var lpflOldProtext : DWORD) : BOOL;
    	external dll='kernel32.dll';
	function VirtualQueryEx(hProcess : HANDLE; lpAddress : LPVOID;
							var lpBuffer : MEMORY_BASIC_INFORMATION; dwLength : DWORD) : DWORD;
    	external dll='kernel32.dll';
	function HeapCreate(flOptions, dwInitialSize, dwMaximumSize : DWORD) : HANDLE;
    	external dll='kernel32.dll';
	function HeapDestroy(hHeap : HANDLE) : BOOL;
    	external dll='kernel32.dll';
	function HeapAlloc(hHeap : HANDLE; dwFlags, dwBytes : DWORD) : LPVOID;
    	external dll='kernel32.dll';
	function HeapReAlloc(hHeap : HANDLE; dwFlags : DWORD; lpMem : LPVOID; dwBytes : DWORD) : LPVOID;
    	external dll='kernel32.dll';
	function HeapFree(hHeap : HANDLE; dwFlags : DWORD; lpMem : LPVOID) : BOOL;
    	external dll='kernel32.dll';
	function HeapSize(hHeap : HANDLE; dwFlags : DWORD; lpMem : LPVOID) : DWORD;
    	external dll='kernel32.dll';
	function HeapValidate(hHeap : HANDLE; dwFlags : DWORD; lpMem : LPVOID) : BOOL;
    	external dll='kernel32.dll';
	function HeapCompact(hHeap : HANDLE; dwFlags : DWORD) : UINT;
    	external dll='kernel32.dll';
	function GetProcessHeap : HANDLE;
    	external dll='kernel32.dll';
	function GetProcessHeaps(NumberOfHeaps : DWORD; ProcessHeaps : address) : DWORD;
    	external dll='kernel32.dll';

const
    PROCESS_HEAP_REGION = $0001;
    PROCESS_HEAP_UNCOMMITTED_RANGE = $0002;
    PROCESS_HEAP_ENTRY_BUSY = $0004;
    PROCESS_HEAP_ENTRY_MOVEABLE = $0010;
    PROCESS_HEAP_ENTRY_DDESHARE = $0020;

type
	PROCESS_HEAP_ENTRY = packed record
	    lpData : PVOID;
    	cbData : DWORD;
	    cbOverhead : byte;
    	iRegionIndex : byte;
	    case wFlags : shortword of
    	PROCESS_HEAP_REGION: (
    		dwCommittedSize : DWORD;
    		dwUncommittedSize : DWORD;
    		lpFirstBlock : LPVOID;
    		lpLastBlock : LPVOID;
    		);
    	PROCESS_HEAP_UNCOMMITTED_RANGE,
    	PROCESS_HEAP_ENTRY_BUSY,
    	PROCESS_HEAP_ENTRY_MOVEABLE,
	    PROCESS_HEAP_ENTRY_DDESHARE: (
	    	hMem : HANDLE;
	    	dwReserved : array[0..2] of DWORD;
	    	)
	end;

	function HeapLock(hHeap : HANDLE) : BOOL;
    	external dll='kernel32.dll';
	function HeapUnlock(hHeap : HANDLE) : BOOL;
    	external dll='kernel32.dll';
	function HeapWalk(hHeap : HANDLE; var lpEntry : PROCESS_HEAP_ENTRY) : BOOL;
    	external dll='kernel32.dll';

const
    SCS_32BIT_BINARY = 0;
    SCS_DOS_BINARY = 1;
    SCS_WOW_BINARY = 2;
    SCS_PIF_BINARY = 3;
    SCS_POSIX_BINARY = 4;
    SCS_OS216_BINARY = 5;

	function GetBinaryType(lpApplicationName : address; var lpBinaryType : DWORD) : BOOL;
		external dll='kernel32.dll' name='GetBinaryTypeA';
	function GetShortPathName(lpszLongPath, lpszShortPath : address; cchBuffer : DWORD) : DWORD;
		external dll='kernel32.dll' name='GetShortPathNameA';
	function GetProcessAffinityMask(hProcess : HANDLE; var lpProcessAffinityMask, lpSystemAffinityMask : DWORD) : BOOL;
		external dll='kernel32.dll';
	function SetProcessAffinityMask(hProcess : HANDLE; dwProcessAffinityMask : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetProcessTimes(hProcess : HANDLE; var lpCreationTime, lpExitTime, lpKernelTime, lpUserTime : FILETIME) : BOOL;
		external dll='kernel32.dll';
	function GetProcessWorkingSetSize
				(hProcess : HANDLE;	var lpMinimumWorkingSetSize, lpMaximumWorkingSetSize : DWORD) : BOOL;
		external dll='kernel32.dll';
	function SetProcessWorkingSetSize
				(hProcess : HANDLE; dwMinimumWorkingSetSize, dwMaximumWorkingSetSize : DWORD) : BOOL;
		external dll='kernel32.dll';
	function OpenProcess(dwDesiredAccess : DWORD; bInheritHandle : BOOL; dwProcessId : DWORd) : HANDLE;
		external dll='kernel32.dll';
	function GetCurrentProcess : HANDLE;
		external dll='kernel32.dll';
	function GetCurrentProcessId : DWORD;
		external dll='kernel32.dll';
	procedure ExitProcess(uExitCode : UINT);
		external dll='kernel32.dll';
	function TerminateProcess(hProcess : HANDLE; uExitCode : UINT) : BOOL;
		external dll='kernel32.dll';
	function GetExitCodeProcess(hProcess : HANDLE; var lpExitCode : DWORd) : BOOL;
		external dll='kernel32.dll';
	procedure FatalExit(ExitCode : integer);
		external dll='kernel32.dll';
	function GetEnvironmentStrings : LPSTR;
		external dll='kernel32.dll';
	function FreeEnvironmentStrings(lpszEnvironmentBlock : address) : BOOL;
		external dll='kernel32.dll' name='FreeEnvironmentStringsA';
	procedure RaiseException(dwExceptionCode, dwExceptionFlags, nNumberOfArguments : DWORD;
							lpArguments : address);
		external dll='kernel32.dll';
	function UnhandledExceptionFilter(var ExceptionInfo : EXCEPTION_POINTERS) : LONG;
		external dll='kernel32.dll';
	function SetUnhandledExceptionFilter(lpTopLevelExceptionFilter : PROC) : PROC;
		external dll='kernel32.dll';

	function CreateFiber(dwStackSize : DWORD; lpStartAddress : address; lpParameter : LPVOID) : LPVOID;
		external dll='kernel32.dll';
	procedure DeleteFiber(lpFiber : LPVOID);
		external dll='kernel32.dll';
	function ConvertThreadToFiber(lpParameter : LPVOID) : LPVOID;
		external dll='kernel32.dll';
	procedure SwitchToFiber(lpFiber : LPVOID);
		external dll='kernel32.dll';
	function SwitchToThread : BOOL;
		external dll='kernel32.dll';

	function CreateThread(var lpThreadAttributes : SECURITY_ATTRIBUTES; dwStackSize : DWORD;
							lpStartAddress : address; lpParameter : LPVOID;
							dwCreationFlags : DWORD; var lpThreadId : DWORD) : HANDLE;
		external dll='kernel32.dll';
	function CreateRemoteThread(hProcess : HANDLE; var lpThreadAttributes : SECURITY_ATTRIBUTES;
								dwStackSize : DWORD; lpStartAddress : address;
								lpParameter : LPVOID; dwCreationFlags : DWORD;
								var lpThreadId : DWORD) : HANDLE;
		external dll='kernel32.dll';
	function GetCurrentThread : HANDLE;
		external dll='kernel32.dll';
	function GetCurrentThreadId : DWORD;
		external dll='kernel32.dll';
	function SetThreadAffinityMask(hThread : HANDLE; dwThreadAffinityMask : DWORD) : DWORD;
		external dll='kernel32.dll';
	function SetThreadIdealProcessor(hThread : HANDLE; dwIdealProcessor : DWORD) : DWORD;
		external dll='kernel32.dll';
	function SetProcessPriorityBoost(hProcess : HANDLE; bDisablePriorityBoost : BOOL) : BOOL;
		external dll='kernel32.dll';
	function GetProcessPriorityBoost(hProcess : HANDLE; var pDisablePriorityBoost : BOOL) : BOOL;
		external dll='kernel32.dll';
	function SetThreadPriority(hThread : HANDLE; nPriority : integer) : BOOL;
		external dll='kernel32.dll';
	function SetThreadPriorityBoost(hThread : HANDLE; bDisablePriorityBoost : BOOL) : BOOL;
		external dll='kernel32.dll';
	function GetThreadPriorityBoost(hThread : HANDLE; var pDisablePriorityBoost : BOOL) : BOOL;
		external dll='kernel32.dll';
	function GetThreadPriority(hThread : HANDLE) : integer;
		external dll='kernel32.dll';
	function GetThreadTimes(
				hThread : HANDLE;
				var lpCreationTime, lpExitTime, lpKernelTime, lpUserTime : FILETIME
			) : BOOL;
		external dll='kernel32.dll';
	procedure ExitThread(dwExitCode : DWORD);
		external dll='kernel32.dll';
	function TerminateThread(hThread : HANDLE; dwExitCode : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetExitCodeThread(hThread : HANDLE; var lpExitCode : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetThreadSelectorEntry(hThread : HANDLE; dwSelector : DWORD;
									var lpSelectorEntry : LDT_ENTRY) : BOOL;
		external dll='kernel32.dll';
	function WinGetLastError : DWORD;
		external dll='kernel32.dll' name='GetLastError';
	procedure WinSetLastError(dwErrCode : DWORD);
		external dll='kernel32.dll' name='SetLastError';
	function GetOverlappedResult(hFile : HANDLE; var lpOverlapped : OVERLAPPED;
								var lpNumberOfBytesTransferred : DWORD;
								bWait : BOOL) : BOOL;
		external dll='kernel32.dll';
	function CreateIoCompletionPort(FileHandle, ExistingCompletionPort : HANDLE;
									CompletionKey, NumberOfConcurrentThreads : DWORD) : HANDLE;
		external dll='kernel32.dll';
	function GetQueuedCompletionStatus
		(CompletionPort : HANDLE; var lpNumberOfBytesTransferred, lpCompletionKey : DWORD;
		var lpOverlapped : OVERLAPPED; dwMilliseconds : DWORD) : BOOL;
		external dll='kernel32.dll';
	function PostQueuedCompletionStatus
		(CompletionPort : HANDLE; dwNumberOfBytesTransferred, dwCompletionKey : DWORD;
		var lpOverlapped : OVERLAPPED) : BOOL;
		external dll='kernel32.dll';

const
    SEM_FAILCRITICALERRORS = $0001;
    SEM_NOGPFAULTERRORBOX = $0002;
    SEM_NOALIGNMENTFAULTEXCEPT = $0004;
    SEM_NOOPENFILEERRORBOX = $8000;

	function SetErrorMode(uMode : UINT) : UINT;
		external dll='kernel32.dll';
	function ReadProcessMemory(hProcess : HANDLE; lpBaseAddress : LPVOID; lpBuffer : LPVOID;
								nSize : DWORD; var lpNumberOfBytesRead : DWORD) : BOOL;
		external dll='kernel32.dll';
	function WriteProcessMemory(hProcess : HANDLE; lpBaseAddress : LPVOID; lpBuffer : LPVOID;
								nSize : DWORD; var lpNumberOfBytesWritten : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetThreadContext(hThread : HANDLE; var lpContext : CONTEXT) : BOOL;
		external dll='kernel32.dll';
	function SetThreadContext(hThread : HANDLE; var lpContext : CONTEXT) : BOOL;
		external dll='kernel32.dll';
	function SuspendThread(hThread : HANDLE) : DWORD;
		external dll='kernel32.dll';
	function ResumeThread(hThread : HANDLE) : DWORD;
		external dll='kernel32.dll';

	function QueueUserAPC(pfnAPC : PROC; hThread : HANDLE; dwData : DWORD) : DWORD;
		external dll='kernel32.dll';

	procedure DebugBreak;
		external dll='kernel32.dll';
	function WaitForDebugEvent(var lpDebugEvent : DEBUG_EVENT; dwMilliseconds : DWORD) : BOOL;
		external dll='kernel32.dll';
	function ContinueDebugEvent(dwProcessId, dwThreadId, dwContinueStatus : DWORD) : BOOL;
		external dll='kernel32.dll';
	function DebugActiveProcess(dwProcessId : DWORD) : BOOL;
		external dll='kernel32.dll';
	procedure InitializeCriticalSection(var lpCriticalSection : CRITICAL_SECTION);
		external dll='kernel32.dll';
	procedure EnterCriticalSection(var lpCriticalSection : CRITICAL_SECTION);
		external dll='kernel32.dll';
	procedure LeaveCriticalSection(var lpCriticalSection : CRITICAL_SECTION);
		external dll='kernel32.dll';
	function TryEnterCriticalSection(var lpCriticalSection : CRITICAL_SECTION) : BOOL;
		external dll='kernel32.dll';
	procedure DeleteCriticalSection(var lpCriticalSection : CRITICAL_SECTION);
		external dll='kernel32.dll';

	function SetEvent(hEvent : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function ResetEvent(hEvent : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function PulseEvent(hEvent : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function ReleaseSemaphore(hSemaphore : HANDLE; lReleaseCount : LONG; var lpPreviousCount : LONG) : BOOL;
		external dll='kernel32.dll';
	function ReleaseMutex(hMutex : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function WaitForSingleObject(hHandle : HANDLE; dwMilliseconds : DWORD) : DWORD;
		external dll='kernel32.dll';
	function WaitForMultipleObjects(nCount : DWORD; lpHandles : address; bWaitAll : BOOL;
									dwMilliseconds : DWORD) : DWORD;
		external dll='kernel32.dll';
	procedure WinSleep(dwMilliseconds : DWORD);
		external dll='kernel32.dll' name='sleep';

	function LoadResource(hMod : HMODULE; hResInfo : HRSRC) : HGLOBAL;
		external dll='kernel32.dll';
	function SizeofResource(hMod : HMODULE; hResInfo : HRSRC) : DWORD;
		external dll='kernel32.dll';
	function GlobalDeleteAtom(nAtom : ATOM) : ATOM;
		external dll='kernel32.dll';
	function InitAtomTable(nSize : DWORD) : BOOL;
		external dll='kernel32.dll';
	function DeleteAtom(nAtom : ATOM) : ATOM;
		external dll='kernel32.dll';
	function SetHandleCount(uNumber : UINT) : UINT;
		external dll='kernel32.dll';

	function GetLogicalDrives : DWORD;
		external dll='kernel32.dll';
	function LockFile(hFile : HANDLE;
						dwFileOffsetLow, dwFileOffsetHigh, nNumberOfBytesToLockLow, nNumberOfBytesToLockHigh : DWORD) : BOOL;
		external dll='kernel32.dll';
	function UnlockFile(hFile : HANDLE;
						dwFileOffsetLow, dwFileOffsetHigh, nNumberOfBytesToUnlockLow, nNumberOfBytesToUnlockHigh : DWORD) : BOOL;
		external dll='kernel32.dll';
	function LockFileEx(hFile : HANDLE;
						dwFlags, dwReserved, nNumberOfBytesToLockLow, nNumberOfBytesToLockHigh : DWORD;
						var lpOverlapped : OVERLAPPED) : BOOL;
		external dll='kernel32.dll';

const
    LOCKFILE_FAIL_IMMEDIATELY = $00000001;
    LOCKFILE_EXCLUSIVE_LOCK = $00000002;

	function UnlockFileEx(hFile : HANDLE;
						dwReserved, nNumberOfBytesToUnlockLow, nNumberOfBytesToUnlockHigh : DWORD;
						var lpOverlapped : OVERLAPPED) : BOOL;
		external dll='kernel32.dll';

type
	BY_HANDLE_FILE_INFORMATION = packed record
	    dwFileAttributes : DWORD;
    	ftCreationTime : FILETIME;
	    ftLastAccessTime : FILETIME;
    	ftLastWriteTime : FILETIME;
	    dwVolumeSerialNumber : DWORD;
    	nFileSizeHigh : DWORD;
	    nFileSizeLow : DWORD;
    	nNumberOfLinks : DWORD;
	    nFileIndexHigh : DWORD;
    	nFileIndexLow : DWORD;
	end;

	function GetFileInformationByHandle(hFile : HANDLE; var lpFileInformation : BY_HANDLE_FILE_INFORMATION) : BOOL;
		external dll='kernel32.dll';
	function GetFileType(hFile : HANDLE) : DWORD;
		external dll='kernel32.dll';
	function GetFileSize(hFile : HANDLE; var lpFileSizeHigh : DWORD) : DWORD;
		external dll='kernel32.dll';
	function GetStdHandle(nStdHandle : DWORD) : HANDLE;
		external dll='kernel32.dll';
	function SetStdHandle(nStdHandle : DWORD; hHandle : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function WriteFile(hFile : HANDLE; lpBuffer : LPVOID; nNumberOfBytesToWrite : DWORD;
						var lpNumberOfBytesWritten : DWORD;
						var lpOverlapped : OVERLAPPED) : BOOL;
		external dll='kernel32.dll';
	function ReadFile(hFile : HANDLE; lpBuffer : LPVOID; nNumberOfBytesToRead : DWORD;
						var lpNumberOfBytesRead : DWORD;
						var lpOverlapped : OVERLAPPED) : BOOL;
		external dll='kernel32.dll';
	function FlushFileBuffers(hFile : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function DeviceIoControl(hDevice : HANDLE; dwIoControlCode : DWORD; lpInBuffer : LPVOID;
							nInBufferSize : DWORD; lpOutBuffer : LPVOID; nOutBufferSize : DWORD;
							var lpBytesReturned : DWORD;
							var lpOverlapped : OVERLAPPED) : BOOL;
		external dll='kernel32.dll';
	function SetEndOfFile(hFile : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function SetFilePointer(hFile : HANDLE; lDistanceToMove : LONG;
							var lpDistanceToMoveHigh : LONG; dwMoveMethod : DWORD) : DWORD;
		external dll='kernel32.dll';
	function nFindClose(hFindFile : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function WinGetFileTime(hFile : HANDLE; var lpCreationTime, lpLastAccessTime, lpLastWriteTime : FILETIME) : BOOL;
		external dll='kernel32.dll' name='GetFileTime';
	function WinSetFileTime(hFile : HANDLE; var lpCreationTime, lpLastAccessTime, lpLastWriteTime : FILETIME) : BOOL;
		external dll='kernel32.dll' name='SetFileTime';
	function CloseHandle(hObject : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function DuplicateHandle(
				hSourceProcessHandle, hSourceHandle, hTargetProcessHandle : HANDLE;
				var lpTargetHandle : HANDLE; dwDesiredAccess : DWORD;
				bInheritHandle : BOOL; dwOptions : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetHandleInformation(hObject : HANDLE; var lpdwFlags : DWORD) : BOOL;
		external dll='kernel32.dll';
	function SetHandleInformation(hObject : HANDLE; dwMask, dwFlags : DWORD) : BOOL;
		external dll='kernel32.dll';

const
    HANDLE_FLAG_INHERIT = $00000001;
    HANDLE_FLAG_PROTECT_FROM_CLOSE = $00000002;
    HINSTANCE_ERROR = 32;

	function LoadModule(lpModuleName : address; lpParameterBlock : LPVOID) : DWORD;
		external dll='kernel32.dll';
	function WinExec(lpCmdLine : address; uCmdShow : UINT) : UINT;
		external dll='kernel32.dll';
	function ClearCommBreak(hFile : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function ClearCommError(hFile : HANDLE; var lpErrors : DWORD; var lpStat : COMSTAT) : BOOL;
		external dll='kernel32.dll';
	function SetupComm(hFile : HANDLE; dwInQueue, dwOutQueue : DWORD) : BOOL;
		external dll='kernel32.dll';
	function EscapeCommFunction(hFile : HANDLE; dwFunc : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetCommConfig(hCommDev : HANDLE; lpCC : address; var lpdwSize : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetCommMask(hFile : HANDLE; var lpEvtMask : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetCommProperties(hFile : HANDLE; var lpCommProp : COMMPROP) : BOOL;
		external dll='kernel32.dll';
	function GetCommModemStatus(hFile : HANDLE; var lpModeStat : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetCommState(hFile : HANDLE; var lpDCB : DCB) : BOOL;
		external dll='kernel32.dll';
	function GetCommTimeouts(hFile : HANDLE; var lpCommTimeouts : COMMTIMEOUTS) : BOOL;
		external dll='kernel32.dll';
	function PurgeComm(hFile : HANDLE; dwFlags : DWORD) : BOOL;
		external dll='kernel32.dll';
	function SetCommBreak(hFile : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function SetCommConfig(hCommDev : HANDLE; lpCC : address; dwSize : DWORD) : BOOL;
		external dll='kernel32.dll';
	function SetCommMask(hFile : HANDLE; dwEvtMask : DWORD) : BOOL;
		external dll='kernel32.dll';
	function SetCommState(hFile : HANDLE; var lpDCB : DCB) : BOOL;
		external dll='kernel32.dll';
	function SetCommTimeouts(hFile : HANDLE; var lpCommTimeouts : COMMTIMEOUTS) : BOOL;
		external dll='kernel32.dll';
	function TransmitCommChar(hFile : HANDLE; cChar : char) : BOOL;
		external dll='kernel32.dll';
	function WaitCommEvent(hFile : HANDLE; var lpEvtMask : DWORD; var lpOverlapped : OVERLAPPED) : BOOL;
		external dll='kernel32.dll';
	function SetTapePosition(hDevice : HANDLE;
							dwPositionMethod, dwPartition, dwOffsetLow, dwOffsetHigh : DWORD;
							bImmediate : BOOL) : DWORD;
		external dll='kernel32.dll';
	function GetTapePosition(hDevice : HANDLE; dwPositionType : DWORD;
							var lpdwPartition, lpdwOffsetLow, lpdwOffsetHigh : DWORD) : DWORD;
		external dll='kernel32.dll';
	function PrepareTape(hDevice : HANDLE; dwOperation : DWORD; bImmediate : BOOL) : DWORD;
		external dll='kernel32.dll';
	function EraseTape(hDevice : HANDLE; dwEraseType : DWORD; bImmediate : BOOL) : DWORD;
		external dll='kernel32.dll';
	function CreateTapePartition(hDevice : HANDLE; dwPositionMethod, dwCount, dwSize : DWORD) : DWORD;
		external dll='kernel32.dll';
	function WriteTapemark(hDevice : HANDLE; dwTapemarkType, dwTapemarkCount : DWORD;
							bImmediate : BOOL) : DWORD;
		external dll='kernel32.dll';
	function GetTapeStatus(hDevice : HANDLE) : DWORD;
		external dll='kernel32.dll';
	function GetTapeParameters(hDevice : DWORD; dwOperation : DWORD;
								var lpdwSize :DWORD; lpTapeInformation : LPVOID) : DWORD;
		external dll='kernel32.dll';

const
    GET_TAPE_MEDIA_INFORMATION = 0;
    GET_TAPE_DRIVE_INFORMATION = 1;
    SET_TAPE_MEDIA_INFORMATION = 0;
    SET_TAPE_DRIVE_INFORMATION = 1;

	function SetTapeParameters(hDevice : DWORD; dwOperation : DWORD;
								var lpdwSize :DWORD; lpTapeInformation : LPVOID) : DWORD;
		external dll='kernel32.dll';
	function Beep(dwFreq, dwDuration : DWORD) : BOOL;
		external dll='kernel32.dll';
	function MulDiv(nNumber, nNumerator, nDenominator : integer) : integer;
		external dll='kernel32.dll';
	procedure GetSystemTime(var lpSystemTime : SYSTEMTIME);
		external dll='kernel32.dll';
	procedure GetSystemTimeAsFileTime(var lpSystemTimeAsFileTime : FILETIME);
		external dll='kernel32.dll';
	function SetSystemTime(var lpSystemTime : SYSTEMTIME) : BOOL;
		external dll='kernel32.dll';
	procedure GetLocalTime(var lpSystemTime : SYSTEMTIME);
		external dll='kernel32.dll';
	function SetLocalTime(var lpSystemTime : SYSTEMTIME) : BOOL;
		external dll='kernel32.dll';
	procedure GetSystemInfo(var lpSystemInfo : SYSTEM_INFO);
		external dll='kernel32.dll';
	function IsProcessorFeaturePresent(ProcessorFeature : DWORD) : BOOL;
		external dll='kernel32.dll';

type
	TIME_ZONE_INFORMATION = packed record
	    Bias : LONG;
    	StandardName : array[0..31] of WCHAR;
	    StandardDate : SYSTEMTIME;
    	StandardBias : LONG;
	    DaylightName : array[0..31] of WCHAR;
    	DaylightDate : SYSTEMTIME;
	    DaylightBias : LONG;
	end;

	function SystemTimeToTzSpecificLocalTime(
				var lpTimeZoneInformation : TIME_ZONE_INFORMATION;
				var lpUniversalTime, lpLocalTime : SYSTEMTIME) : BOOL;
		external dll='kernel32.dll';
	function GetTimeZoneInformation(var lpTimeZoneInformation : TIME_ZONE_INFORMATION) : DWORD;
		external dll='kernel32.dll';
	function SetTimeZoneInformation(var lpTimeZoneInformation : TIME_ZONE_INFORMATION) : BOOL;
		external dll='kernel32.dll';
	function SystemTimeToFileTime(var lpSystemTime : SYSTEMTIME; var lpFileTime : FILETIME) : BOOL;
		external dll='kernel32.dll';
	function FileTimeToLocalFileTime(var lpFileTime, lpLocalFileTime : FILETIME) : BOOL;
		external dll='kernel32.dll';
	function LocalFileTimeToFileTime(var lpLocalFileTime, lpFileTime : FILETIME) : BOOL;
		external dll='kernel32.dll';
	function FileTimeToSystemTime(var lpFileTime : FILETIME; var lpSystemTime : SYSTEMTIME) : BOOL;
		external dll='kernel32.dll';
	function CompareFileTime(var lpFileTime1, lpFileTime2 : FILETIME) : LONG;
		external dll='kernel32.dll';
	function FileTimeToDosDateTime(var lpFileTime : FILETIME; var lpFatDate, lpFatTime : shortword) : BOOL;
		external dll='kernel32.dll';
	function DosDateTimeToFileTime(wFatDate, wFatTime : shortword; var lpFileTime : FILETIME) : BOOL;
		external dll='kernel32.dll';

	function GetTickCount : DWORD;
		external dll='kernel32.dll';
	function SetSystemTimeAdjustment(dwTimeAdjustment : DWORD; bTimeAdjustmentDisabled : BOOL) : BOOL;
		external dll='kernel32.dll';
	function GetSystemTimeAdjustment(var lpTimeAdjustment, lpTimeIncrement : DWORD;
										var lpTimeAdjustmentDisabled : BOOL) : BOOL;
		external dll='kernel32.dll';

	function FormatMessage(dwFlags : DWORD; lpSource : LPVOID; dwMessageId, dwLanguageId : DWORD;
							lpBuffer : LPSTR; nSize : DWORD; Arguments : address) : DWORD;
		external dll='kernel32.dll' name='FormatMessageA';

const
    FORMAT_MESSAGE_ALLOCATE_BUFFER = $00000100;
    FORMAT_MESSAGE_IGNORE_INSERTS = $00000200;
    FORMAT_MESSAGE_FROM_STRING = $00000400;
    FORMAT_MESSAGE_FROM_HMODULE = $00000800;
    FORMAT_MESSAGE_FROM_SYSTEM = $00001000;
    FORMAT_MESSAGE_ARGUMENT_ARRAY = $00002000;
    FORMAT_MESSAGE_MAX_WIDTH_MASK = $000000FF;

	function CreatePipe(var hReadPipe, hWritePipe : HANDLE; var lpPipeAttributes : SECURITY_ATTRIBUTES;
						nSize : DWORD) : BOOL;
		external dll='kernel32.dll';
	function ConnectNamedPipe(hNamedPipe : HANDLE; var lpOverlapped : OVERLAPPED) : BOOL;
		external dll='kernel32.dll';
	function DisconnectNamedPipe(hNamedPipe : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function SetNamedPipeHandleState(hNamedPipe : HANDLE;
									var lpMode, lpMaxCollectionCount, lpCollectDataTimeout : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetNamedPipeInfo(hNamedPipe : HANDLE;
							var lpFlags, lpOutBufferSize, lpInBufferSize, lpMaxInstances : DWORD) : BOOL;
		external dll='kernel32.dll';
	function PeekNamedPipe(hNamedPipe : HANDLE;
					         lpBuffer : address; nBufferSize : DWORD;
					         var lpBytesRead, lpTotalBytesAvail, lpBytesLeftThisMessage : DWORD) : BOOL;
		external dll='kernel32.dll';
	function TransactNamedPipe(hNamedPipe : HANDLE;
					lpInBuffer : address; nInBufferSize : DWORD;
					lpOutBuffer : address; nOutBufferSize : DWORD;
					var lpBytesRead : DWORD; var lpOverlapped : OVERLAPPED) : BOOL;
		external dll='kernel32.dll';
	function CreateMailslot(lpName : address; nMaxMessageSize, lReadTimeOut : DWORD;
							var lpSecurityAttributes : SECURITY_ATTRIBUTES) : HANDLE;
		external dll='kernel32.dll' name='CreateMailslotA';
	function GetMailslotInfo(hMailslot : HANDLE;
							var lpMaxMessageSize, lpNextSize, lpMessageCount, lpReadTimeout : DWORD) : BOOL;
		external dll='kernel32.dll';
	function SetMailslotInfo(hMailslot : HANDLE; lReadTimeout : DWORD) : BOOL;
		external dll='kernel32.dll';
	function MapViewOfFile(hFileMappingObject : HANDLE;
							dwDesiredAccess, dwFileOffsetHigh, dwFileOffsetLow, dwNumberOfBytesToMap : DWORD) : LPVOID;
		external dll='kernel32.dll';
	function FlushViewOfFile(lpBaseAddress : LPVOID; dwNumberOfBytesToFlush : DWORD) : BOOL;
		external dll='kernel32.dll';
	function UnmapViewOfFile(lpBaseAddress : LPVOID) : BOOL;
		external dll='kernel32.dll';

	function lstrcmp(lpString1, lpString2 : address) : integer;
		external dll='kernel32.dll' name='lstrcmpA';
	function lstrcmpW(lpString1, lpString2 : LPCWSTR) : integer;
		external dll='kernel32.dll';
	function lstrcmpi(lpString1, lpString2 : address) : integer;
		external dll='kernel32.dll' name='lstrcmpiA';
	function lstrcmpiW(lpString1, lpString2 : LPCWSTR) : integer;
		external dll='kernel32.dll';
	function lstrcpyn(lpString1, lpString2 : address; iMaxLength : integer) : LPSTR;
		external dll='kernel32.dll' name='lstrcpynA';
	function lstrcpynW(lpString1, lpString2 : LPWSTR; iMaxLength : integer) : LPWSTR;
		external dll='kernel32.dll';
	function lstrcpy(lpString1, lpString2 : address) : LPSTR;
		external dll='kernel32.dll' name='lstrcpyA';
	function lstrcpyW(lpString1, lpString2 : LPWSTR) : LPWSTR;
		external dll='kernel32.dll';
	function lstrcat(lpString1, lpString2 : address) : LPSTR;
		external dll='kernel32.dll' name='lstrcatA';
	function lstrcatW(lpString1, lpString2 : LPWSTR) : LPWSTR;
		external dll='kernel32.dll';
	function lstrlen(lpString : address) : integer;
		external dll='kernel32.dll' name='lstrlenA';
	function lstrlenW(lpString1 : LPWSTR) : integer;
		external dll='kernel32.dll';

	function OpenFile(lpFileName : address; var lpReOpenBuff : OFSTRUCT; uStyle : UINT) : HFILE;
		external dll='kernel32.dll';
	function _lopen(lpPathName : address; iReadWrite : integer) : HFILE;
		external dll='kernel32.dll';
	function _lcreate(lpPathName : address; iAttribute : integer) : HFILE;
		external dll='kernel32.dll';
	function _lread(hFile : _HFILE; lpBuffer : LPVOID; uBytes : UINT) : UINT;
		external dll='kernel32.dll';
	function _lwrite(hFile : _HFILE; lpBuffer : LPVOID; uBytes : UINT) : UINT;
		external dll='kernel32.dll';
	function _hread(hFile : _HFILE; lpBuffer : LPVOID; lBytes : integer) : integer;
		external dll='kernel32.dll';
	function _hwrite(hFile : _HFILE; lpBuffer : LPVOID; lBytes : integer) : integer;
		external dll='kernel32.dll';
	function _lclose(hFile : _HFILE) : _HFILE;
		external dll='kernel32.dll';
	function _llseek(hFile : _HFILE; lOffset : LONG; iOrigin : integer) : LONG;
		external dll='kernel32.dll';

	function IsTextUnicode(lpBuffer : LPVOID; cb : integer; var lpi : integer) : BOOL;
		external dll='kernel32.dll';
	function TlsAlloc : DWORD;
		external dll='kernel32.dll';

const
	TLS_OUT_OF_INDEXES = $FFFFFFFF;

	function TlsGetValue(dwTlsIndex : DWORD) : LPVOID;
		external dll='kernel32.dll';
	function TlsSetValue(dwTlsIndex : DWORD; lpTlsValue : LPVOID) : BOOL;
		external dll='kernel32.dll';
	function TlsFree(dwTlsIndex : DWORD) : BOOL;
		external dll='kernel32.dll';

	function SleepEx(dwMilliseconds : DWORD; bAlertable : BOOL) : DWORD;
		external dll='kernel32.dll';
	function WaitForSingleObjectEx(hHandle : HANDLE; dwMilliseconds : DWORD; bAlertable : BOOL) : DWORD;
		external dll='kernel32.dll';
	function WaitForMultipleObjectsEx(nCount : DWORD; lpHandles : address; bWaitAll : BOOL;
										dwMilliseconds : DWORD; bAlertable : BOOL) : DWORD;
		external dll='kernel32.dll';
	function SignalObjectAndWait(hObjectToSignal, hObjectToWaitOn : HANDLE;
										dwMilliseconds : DWORD; bAlertable : BOOL) : DWORD;
		external dll='kernel32.dll';
	function ReadFileEx(hFile : HANDLE; lpBuffer : LPVOID; nNumberOfBytesToRead : DWORD;
						var lpOverlapped : OVERLAPPED; lpCompletionRoutine : PROC) : BOOL;
		external dll='kernel32.dll';
	function WriteFileEx(hFile : HANDLE; lpBuffer : LPVOID; nNumberOfBytesToWrite : DWORD;
						var lpOverlapped : OVERLAPPED; lpCompletionRoutine : PROC) : BOOL;
		external dll='kernel32.dll';
	function BackupRead(hFile : HANDLE; lpBuffer : LPVOID; nNumberOfBytesToRead : DWORD;
						var lpNumberOfBytesRead : DWORD; bAbort, bProcessSecurity : BOOL;
						var lpContext : LPVOID) : BOOL;
		external dll='kernel32.dll';
	function BackupSeek(hFile : HANDLE; dwLowBytesToSeek, dwHighBytesToSeek : DWORD;
						var lpdwLowByteSeeked, lpdwHighByteSeeked : DWORD;
						var lpContext : LPVOID) : BOOL;
		external dll='kernel32.dll';
	function BackupWrite(hFile : HANDLE; lpBuffer : LPVOID; nNumberOfBytesToWrite : DWORD;
						var lpNumberOfBytesWritten : DWORD; bAbort, bProcessSecurity : BOOL;
						var lpContext : LPVOID) : BOOL;
		external dll='kernel32.dll';

type
	WIN32_STREAM_ID = packed record
        dwStreamId : DWORD;
        dwStreamAttributes : DWORD;
        Size : LARGE_INTEGER;
        dwStreamNameSize : DWORD;
	end;

const
    BACKUP_INVALID = $00000000;
    BACKUP_DATA = $00000001;
    BACKUP_EA_DATA = $00000002;
    BACKUP_SECURITY_DATA = $00000003;
    BACKUP_ALTERNATE_DATA = $00000004;
    BACKUP_LINK = $00000005;
    BACKUP_PROPERTY_DATA = $00000006;

    STREAM_NORMAL_ATTRIBUTE = $00000000;
    STREAM_MODIFIED_WHEN_READ = $00000001;
    STREAM_CONTAINS_SECURITY = $00000002;
    STREAM_CONTAINS_PROPERTIES = $00000004;

    STARTF_USESHOWWINDOW = $00000001;
    STARTF_USESIZE = $00000002;
    STARTF_USEPOSITION = $00000004;
    STARTF_USECOUNTCHARS = $00000008;
    STARTF_USEFILLATTRIBUTE = $00000010;
    STARTF_RUNFULLSCREEN = $00000020;
    STARTF_FORCEONFEEDBACK = $00000040;
    STARTF_FORCEOFFFEEDBACK = $00000080;
    STARTF_USESTDHANDLES = $00000100;
    STARTF_USEHOTKEY = $00000200;

type
	STARTUPINFO = packed record
	    cb : DWORD;
    	lpReserved : LPSTR;
	    lpDesktop : LPSTR;
    	lpTitle : LPSTR;
	    dwX : DWORD;
    	dwY : DWORD;
		dwXSize : DWORD;
	    dwYSize : DWORD;
    	dwXCountChars : DWORD;
	    dwYCountChars : DWORD;
    	dwFillAttribute : DWORD;
	    dwFlags : DWORD;
    	wShowWindow : shortword;
	    cbReserved2 : shortword;
    	lpReserved2 : address;
	    hStdInput : HANDLE;
    	hStdOutput : HANDLE;
	    hStdError : HANDLE;
	end;

	STARTUPINFOW = packed record
	    cb : DWORD;
    	lpReserved : LPWSTR;
	    lpDesktop : LPWSTR;
    	lpTitle : LPWSTR;
	    dwX : DWORD;
    	dwY : DWORD;
		dwXSize : DWORD;
	    dwYSize : DWORD;
    	dwXCountChars : DWORD;
	    dwYCountChars : DWORD;
    	dwFillAttribute : DWORD;
	    dwFlags : DWORD;
    	wShowWindow : shortword;
	    cbReserved2 : shortword;
    	lpReserved2 : address;
	    hStdInput : HANDLE;
    	hStdOutput : HANDLE;
	    hStdError : HANDLE;
	end;

const
	SHUTDOWN_NORETRY = $00000001;

type
	WIN32_FIND_DATA = packed record
	    dwFileAttributes : DWORD;
    	ftCreationTime : FILETIME;
	    ftLastAccessTime : FILETIME;
    	ftLastWriteTime : FILETIME;
	    nFileSizeHigh : DWORD;
    	nFileSizeLow : DWORD;
	    dwReserved0 : DWORD;
    	dwReserved1 : DWORD;
	    cFileName : cstring[MAX_CSTRING_PATH];
    	cAlternateFileName : cstring[13];
	end;

	WIN32_FILE_ATTRIBUTE_DATA = packed record
	    dwFileAttributes : DWORD;
    	ftCreationTime : FILETIME;
	    ftLastAccessTime : FILETIME;
    	ftLastWriteTime : FILETIME;
	    nFileSizeHigh : DWORD;
    	nFileSizeLow : DWORD;
	end;

	function CreateMutex(var lpMutexAttributes : SECURITY_ATTRIBUTES;
						bInitialOwner : BOOL; lpName : address) : HANDLE;
		external dll='kernel32.dll' name='CreateMutexA';
	function OpenMutex(dwDesiredAccess : DWORD; bInheritHandle : BOOL;
						lpName : address) : HANDLE;
		external dll='kernel32.dll' name='OpenMutexA';

	function CreateEvent(var lpEventAttributes : SECURITY_ATTRIBUTES;
						bManualReset, bInitialState : BOOL; lpName : address) : HANDLE;
		external dll='kernel32.dll' name='CreateEventA';
	function OpenEvent(dwDesiredAccess : DWORD; bInheritHandle : BOOL;
						lpName : address) : HANDLE;
		external dll='kernel32.dll' name='OpenEventA';
	function CreateSemaphore(var lpSemaphoreAttributes : SECURITY_ATTRIBUTES;
						lInitialCount, lMaximumCount : LONG; lpName : address) : HANDLE;
		external dll='kernel32.dll' name='CreateSemaphoreA';
	function OpenSemaphore(dwDesiredAccess : DWORD; bInheritHandle : BOOL;
						lpName : address) : HANDLE;
		external dll='kernel32.dll' name='OpenSemaphoreA';
	function CreateWaitableTimer(var lpTimerAttributes : SECURITY_ATTRIBUTES;
						bManualReset : BOOL; lpTimerName : address) : HANDLE;
		external dll='kernel32.dll' name='CreateWaitableTimerA';
	function OpenWaitableTimer(dwDesiredAccess : DWORD; bInheritHandle : BOOL;
						lpTimerName : address) : HANDLE;
		external dll='kernel32.dll' name='OpenWaitableTimerA';
	function SetWaitableTimer(hTimer : HANDLE; var lpDueTime : LARGE_INTEGER;
								lPeriod : LONG; pfnCompletionRoutine : PROC;
								lpArgToCompletionRoutine : LPVOID; fResume : BOOL) : BOOL;
		external dll='kernel32.dll';
	function CancelWaitableTimer(hTimer : HANDLE) : BOOL;
		external dll='kernel32.dll';

	function CreateFileMapping(hFile : HANDLE; var lpFileMappingAttributes : SECURITY_ATTRIBUTES;
								flProtect, dwMaximumSizeHigh, dwMaximumSizeLow : DWORD;
								lpName : address) : HANDLE;
		external dll='kernel32.dll' name='CreateFileMappingA';
	function OpenFileMapping(dwDesiredAccess : DWORD; bInheritHandle : BOOL;
						lpName : address) : HANDLE;
		external dll='kernel32.dll' name='OpenFileMappingA';
	function GetLogicalDriveStrings(nBufferLength : DWORD; lpBuffer : LPSTR) : DWORD;
		external dll='kernel32.dll' name='GetLogicalDriveStringsA';
	function LoadLibrary(lpLibName : address) : HMODULE;
		external dll='kernel32.dll' name='LoadLibraryA';
	function LoadLibraryEx(lpLibFileName : address; hFile : HANDLE; dwFlags : DWORD) : HMODULE;
		external dll='kernel32.dll' name='LoadLibraryExA';

const
    DONT_RESOLVE_DLL_REFERENCES = $00000001;
    LOAD_LIBRARY_AS_DATAFILE = $00000002;
    LOAD_WITH_ALTERED_SEARCH_PATH = $00000008;

	function GetModuleFileName(hMod : HMODULE; lpFilename : address; nSize : DWORD) : DWORD;
		external dll='kernel32.dll' name='GetModuleFileNameA';
	function GetModuleHandle(lpModuleName : address) : HMODULE;
		external dll='kernel32.dll' name='GetModuleHandleA';
	function CreateProcess(lpApplicationName, lpCommandLine : address;
							var lpProcessAttributes, lpThreadAttributes : SECURITY_ATTRIBUTES;
							bInheritHandles : BOOL; dwCreationFlags : DWORD;
							lpEnvironment : LPVOID; lpCurrentDirectory : address;
							var lpStartupInfo : STARTUPINFO;
							var lpProcessInformation : PROCESS_INFORMATION) : BOOL;
		external dll='kernel32.dll';
	function SetProcessShutdownParameters(dwLevel, dwFlags : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetProcessShutdownParameters(var lpdwLevel, lpdwFlags : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetProcessVersion(ProcessId : DWORD) : DWORD;
		external dll='kernel32.dll';
	procedure FatalAppExit(uAction : UINT; lpMessageText : address);
		external dll='kernel32.dll' name='FatalAppExitA';
	procedure GetStartupInfo(var lpStartupInfo : STARTUPINFO);
		external dll='kernel32.dll' name='GetStartupInfoA';
	function GetCommandLine : LPSTR;
		external dll='kernel32.dll' name='GetCommandLineA';
	function GetEnvironmentVariable(lpName : address; lpBuffer : LPSTR; nSize : DWORD) : DWORD;
		external dll='kernel32.dll' name='GetEnvironmentVariableA';
	function SetEnvironmentVariable(lpName : address; lpValue : LPSTR) : BOOL;
		external dll='kernel32.dll' name='SetEnvironmentVariableA';
	function ExpandEnvironmentStrings(lpSrc, lpDst : LPSTR; nSize : DWORD) : DWORD;
		external dll='kernel32.dll' name='ExpandEnvironmentStringsA';
	procedure OutputDebugString(lpOutputString : address);
		external dll='kernel32.dll' name='OutputDebugStringA';
	function FindResource(hMod : HMODULE; lpName, lpType : address) : HRSRC;
		external dll='kernel32.dll' name='FindResourceA';
	function FindResourceEx(hMod : HMODULE; lpType, lpName : address; wLanguage : shortword) : HRSRC;
		external dll='kernel32.dll' name='FindResourceExA';
	function EnumResourceTypes(hMod : HMODULE; lpEnumFunc : PROC; lParam : LONG) : BOOL;
		external dll='kernel32.dll' name='EnumResourceTypesA';
	function EnumResourceNames(hMod : HMODULE; lpType : address; lpEnumFunc : PROC; lParam : LONG) : BOOL;
		external dll='kernel32.dll' name='EnumResourceNamesA';
	function EnumResourceLanguages(hMod : HMODULE; lpType, lpName : address; lpEnumFunc : PROC; lParam : LONG) : BOOL;
		external dll='kernel32.dll' name='EnumResourceLanguagesA';
	function BeginUpdateResource(pFileName : address; bDeleteExistingResources : BOOL) : HANDLE;
		external dll='kernel32.dll' name='BeginUpdateResourceA';
	function UpdateResource(hUpdate : HANDLE; lpType, lpName : address;
							wLanguage : shortword; lpData : LPVOID; cbData : DWORD) : BOOL;
		external dll='kernel32.dll' name='UpdateResourceA';
	function EndUpdateResource(hUpdate : HANDLE; fDiscard : BOOL) : BOOL;
		external dll='kernel32.dll' name='EndUpdateResourceA';

	function GlobalAddAtom(lpString : address) : ATOM;
		external dll='kernel32.dll' name='GlobalAddAtomA';
	function GlobalFindAtom(lpString : address) : ATOM;
		external dll='kernel32.dll' name='GlobalFindAtomA';
	function GlobalGetAtomName(nAtom : ATOM; lpBuffer : address; nSize : integer) : UINT;
		external dll='kernel32.dll' name='GlobalGetAtomNameA';
	function AddAtom(lpString : address) : ATOM;
		external dll='kernel32.dll' name='AddAtomA';
	function FindAtom(lpString : address) : ATOM;
		external dll='kernel32.dll' name='FindAtomA';
	function GetAtomName(nAtom : ATOM; lpBuffer : address; nSize : integer) : UINT;
		external dll='kernel32.dll' name='GetAtomNameA';

	function GetProfileInt(lpAppName, lpKeyName : address; nDefault : integer) : UINT;
		external dll='kernel32.dll' name='GetProfileIntA';
	function GetProfileString(lpAppName, lpKeyName, lpDefault, lpReturnedString : address;
								nSize : DWORD) : DWORD;
		external dll='kernel32.dll' name='GetProfileStringA';
	function WriteProfileString(lpAppName, lpKeyName, lpString : address) : BOOL;
		external dll='kernel32.dll' name='WriteProfileStringA';
	function GetProfileSection(lpAppName, lpReturnedString : address; nSize : DWORD) : DWORD;
		external dll='kernel32.dll' name='GetProfileSectionA';
	function WriteProfileSection(lpAppName, lpString : address) : BOOL;
		external dll='kernel32.dll' name='WriteProfileSectionA';
	function GetPrivateProfileInt(lpAppName, lpKeyName : address; nDefault : integer;
								lpFileName : address) : UINT;
		external dll='kernel32.dll' name='GetPrivateProfileIntA';
	function GetPrivateProfileString(lpAppName, lpKeyName, lpDefault, lpReturnedString : address;
								nSize : DWORD; lpFileName : address) : DWORD;
		external dll='kernel32.dll' name='GetPrivateProfileStringA';
	function WritePrivateProfileString(lpAppName, lpKeyName, lpString : address;
										lpFileName : address) : BOOL;
		external dll='kernel32.dll' name='WritePrivateProfileStringA';
	function GetPrivateProfileSection(lpAppName, lpReturnedString : address; nSize : DWORD;
										lpFileName : address) : DWORD;
		external dll='kernel32.dll' name='GetPrivateProfileSectionA';
	function WritePrivateProfileSection(lpAppName, lpString, lpFileName : address) : BOOL;
		external dll='kernel32.dll' name='WritePrivateProfileSectionA';
	function GetPrivateProfileSectionNames(lpszReturnBuffer : LPSTR; nSize : DWORD;
										lpFileName : address) : DWORD;
		external dll='kernel32.dll' name='GetPrivateProfileSectionNamesA';
	function GetPrivateProfileStruct(lpszSection, lpszKey : address;
									lpStruct : LPVOID; uSizeStruct : UINT;
									szFile : address) : BOOL;
		external dll='kernel32.dll' name='GetPrivateProfileStructA';
	function WritePrivateProfileStruct(lpszSection, lpszKey : address;
									lpStruct : LPVOID; uSizeStruct : UINT;
									szFile : address) : BOOL;
		external dll='kernel32.dll' name='WritePrivateProfileStructA';

	function GetDriveType(lpRootPathName : address) : UINT;
		external dll='kernel32.dll' name='GetDriveTypeA';
	function GetSystemDirectory(lpBuffer : address; uSize : UINT) : UINT;
		external dll='kernel32.dll' name='GetSystemDirectoryA';
	function GetTempPath(nBufferLength : DWORD; lpBuffer : address) : DWORD;
		external dll='kernel32.dll' name='GetTempPathA';
	function GetTempFileName(lpPathName, lpPrefixString : address; uUnique : UINT;
							lpTempFileName : address) : UINT;
		external dll='kernel32.dll' name='GetTempFileNameA';
	function GetWindowsDirectory(lpBuffer : address; uSize : UINT) : UINT;
		external dll='kernel32.dll' name='GetWindowsDirectoryA';
	function SetCurrentDirectory(lpPathName : address) : BOOL;
		external dll='kernel32.dll' name='SetCurrentDirectoryA';
	function GetCurrentDirectory(nBufferLength : DWORD; lpBuffer : address) : DWORD;
		external dll='kernel32.dll' name='GetCurrentDirectoryA';
	function GetDiskFreeSpace(
		lpRootPathName : address;
		var lpSectorsPerCluster, lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters : DWORD
	) : BOOL;
		external dll='kernel32.dll' name='GetDiskFreeSpaceA';
	function GetDiskFreeSpaceEx(
		lpDirectoryName : address;
		var lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes, lpTotalNumberOfFreeBytes : ULARGE_INTEGER
	) : BOOL;
		external dll='kernel32.dll' name='GetDiskFreeSpaceExA';
	function CreateDirectory(lpPathName : address; var lpSecurityAttributes : SECURITY_ATTRIBUTES) : BOOL;
		external dll='kernel32.dll' name='CreateDirectoryA';
	function CreateDirectoryEx(lpTemplateDirectory, lpNewDirectory : address;
								var lpSecurityAttributes : SECURITY_ATTRIBUTES) : BOOL;
		external dll='kernel32.dll' name='CreateDirectoryExA';
	function RemoveDirectory(lpPathName : address) : BOOL;
		external dll='kernel32.dll' name='RemoveDirectoryA';
	function GetFullPathName(lpFileName : address; nBufferLength : DWORD;
							lpBuffer : address; lpFilePart : address) : DWORD;
		external dll='kernel32.dll' name='GetFullPathNameA';

const
    DDD_RAW_TARGET_PATH = $00000001;
    DDD_REMOVE_DEFINITION = $00000002;
    DDD_EXACT_MATCH_ON_REMOVE = $00000004;
    DDD_NO_BROADCAST_SYSTEM = $00000008;

	function DefineDosDevice(dwFlags : DWORD; lpDeviceName, lpTargetPath : address) : BOOL;
		external dll='kernel32.dll' name='DefineDosDeviceA';
	function QueryDosDevice(lpDeviceName, lpTargetPath : address; ucchMax : DWORD) : DWORD;
		external dll='kernel32.dll' name='QueryDosDeviceA';
	function CreateFile(lpFileName : address; dwDesiredAccess, dwShareMode : DWORD;
						var lpSecurityAttributes : SECURITY_ATTRIBUTES;
						dwCreationDisposition, dwFlagsAndAttributes : DWORD;
						hTemplateFile : HANDLE) : HANDLE;
		external dll='kernel32.dll' name='CreateFileA';
	function SetFileAttributes(lpFileName : address; dwFileAttributes : DWORD) : BOOL;
		external dll='kernel32.dll' name='SetFileAttributesA';
	function GetFileAttributes(lpFileName : address) : DWORD;
		external dll='kernel32.dll' name='GetFileAttributesA';

type
	GET_FILEEX_INFO_LEVELS = (GetFileExInfoStandard, GetFileExMaxInfoLevel);

	function GetFileAttributesEx(lpFileName : address; fInfoLevelId : GET_FILEEX_INFO_LEVELS;
								lpFileInformation : LPVOID) : BOOL;
		external dll='kernel32.dll' name='GetFileAttributesExA';
	function GetCompressedFileSize(lpFileName : address; var lpFileSizeHigh : DWORD) : DWORD;
		external dll='kernel32.dll' name='GetCompressedFileSizeA';
	function DeleteFile(lpFileName : address) : BOOL;
		external dll='kernel32.dll' name='DeleteFileA';

type
	FINDEX_INFO_LEVELS = (FindExInfoStandard, FindExInfoMaxInfoLevel);
	FINDEX_SEARCH_OPS = (FindExSearchNameMatch, FindExSearchLimitToDirectories, FindExSearchLimitToDevices, FindExSearchMaxSearchOp);

const
	FIND_FIRST_EX_CASE_SENSITIVE = $00000001;

	function FindFirstFileEx(lpFileName : address; fInfoLevelId : FINDEX_INFO_LEVELS;
							lpFileFindData : LPVOID; fSearchOp : FINDEX_SEARCH_OPS;
							lpSearchFilter : LPVOID; dwAdditionalFlags : DWORD) : HANDLE;
		external dll='kernel32.dll' name='FindFirstFileExA';
	function FindFirstFile(lpFileName : address; var lpFindFileData : WIN32_FIND_DATA) : HANDLE;
		external dll='kernel32.dll' name='FindFirstFileA';
	function FindNextFile(hFindFile : HANDLE; var lpFindFileData : WIN32_FIND_DATA) : BOOL;
		external dll='kernel32.dll' name='FindNextFileA';
	function SearchPath(lpPath, lpFileName, lpExtension : address;
						nBufferLength : DWORD; lpBuffer : address; var lpFilePart : LPSTR) : DWORD;
		external dll='kernel32.dll' name='SearchPathA';
	function CopyFile(lpExistingFileName, lpNewFileName : address; bFailIfExists : BOOL) : BOOL;
		external dll='kernel32.dll' name='CopyFileA';
	function CopyFileEx(lpExistingFileName, lpNewFileName : address; lpProgressRoutine : PROC;
						lpData : LPVOID; var pbCancel : BOOL; dwCopyFlags : DWORD) : BOOL;
		external dll='kernel32.dll' name='CopyFileExA';
	function MoveFile(lpExistingFileName, lpNewFileName : address) : BOOL;
		external dll='kernel32.dll' name='MoveFileA';
	function MoveFileEx(lpExistingFileName, lpNewFileName : address; dwFlags : DWORD) : BOOL;
		external dll='kernel32.dll' name='MoveFileExA';

const
    MOVEFILE_REPLACE_EXISTING = $00000001;
    MOVEFILE_COPY_ALLOWED = $00000002;
    MOVEFILE_DELAY_UNTIL_REBOOT = $00000004;
    MOVEFILE_WRITE_THROUGH = $00000008;

	function CreateNamedPipe(lpName : address; dwOpenMode, dwPipeMode, nMaxInstances : DWORD;
							nOutBufferSize, nInBufferSize, nDefaultTimeOut : DWORD;
							var lpSecurityAttributes : SECURITY_ATTRIBUTES) : HANDLE;
		external dll='kernel32.dll' name='CreateNamedPipeA';
	function GetNamedPipeHandleState(hNamedPipe : HANDLE; var lpState, lpCurInstances : DWORD;
									var lpMaxCollectionCount, lpCollectDataTimeout : DWORD;
									lpUserName : address; nMaxUserNameSize : DWORD) : BOOL;
		external dll='kernel32.dll' name='GetNamedPipeHandleStateA';
	function CallNamedPipe(lpNamedPipeName : address; lpInBuffer : LPVOID;
							nInBufferSize : DWORD; lpOutBuffer : LPVOID;
							nOutBufferSize : DWORD; var lpBytesRead : DWORD;
							nTimeOut : DWORD) : BOOL;
		external dll='kernel32.dll' name='CallNamedPipeA';
	function WaitNamedPipe(lpNamedPipeName : address; nTimeOut : DWORD) : BOOL;
		external dll='kernel32.dll' name='WaitNamedPipeA';
	function SetVolumeLabel(lpRootPathName, lpVolumeName : address) : BOOL;
		external dll='kernel32.dll' name='SetVolumeLabelA';
	procedure SetFileApisToOEM;
		external dll='kernel32.dll';
	procedure SetFileApisToANSI;
		external dll='kernel32.dll';
	function AreFileApisANSI : BOOL;
		external dll='kernel32.dll';
	function GetVolumeInformation(lpRootPathName, lpVolumeName : address;
									nVolumeSize : DWORD;
									var lpVolumeSerialNumber, lpMaximumComponentLength : DWORD;
									var lpFileSystemFlags : DWORD;
									lpFileSystemNameBuffer : address;
									nFileSystemNameSize : DWORD) : BOOL;
		external dll='kernel32.dll' name='GetVolumeInformationA';
	function CancelIo(hFile : HANDLE) : BOOL;
		external dll='kernel32.dll';

	function ClearEventLog(hEventLog : HANDLE; lpBackupFileName : address) : BOOL;
		external dll='kernel32.dll' name='ClearEventLogA';
	function BackupEventLog(hEventLog : HANDLE; lpBackupFileName : address) : BOOL;
		external dll='kernel32.dll' name='BackupEventLogA';
	function CloseEventLog(hEventLog : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function DeregisterEventSource(hEventLog : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function NotifyChangeEventLog(hEventLog, hEvent : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function GetNumberOfEventLogRecords(hEventLog : HANDLE; var NumberOfRecords : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetOldestEventLogRecord(hEventLog : HANDLE; var OldestRecord : DWORD) : BOOL;
		external dll='kernel32.dll';
	function OpenEventLog(lpUNCServerName, lpSourceName : address) : HANDLE;
		external dll='kernel32.dll' name='OpenEventLogA';
	function RegisterEventSource(lpUNCServerName, lpSourceName : address) : HANDLE;
		external dll='kernel32.dll' name='RegisterEventSourceA';
	function OpenBackupEventLog(lpUNCServerName, lpSourceName : address) : HANDLE;
		external dll='kernel32.dll' name='OpenBackupEventLogA';
	function ReadEventLog(hEventLog : HANDLE; dwReadFlags, dwRecordOffset : DWORD;
							lpBuffer : LPVOID; nNumberOfBytesToRead : DWORD;
							var pnBytesRead, pnMinNumberOfBytesNeeded : DWORD) : BOOL;
		external dll='kernel32.dll' name='ReadEventLogA';
	function ReportEvent(hEventLog : HANDLE; wType, wCategory : shortword; dwEventID : DWORD;
						var lpUserSid : SID; wNumStrings : shortword; dwDataSize : DWORD;
						lpStrings : address; lpRawData : LPVOID) : BOOL;
		external dll='kernel32.dll' name='ReportEventA';

	function DuplicateToken(ExistingTokenHandle : HANDLE; ImpersonationLevel : SECURITY_IMPERSONATION_LEVEL;
							var DuplicateTokenHandle : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function GetKernelObjectSecurity(h : HANDLE; RequestedInformation : SECURITY_INFORMATION;
									var pSecurityDescriptor : SECURITY_DESCRIPTOR; nLength : DWORD;
									var lpnLengthNeeded : DWORD) : BOOL;
		external dll='kernel32.dll';
	function ImpersonateNamedPipeClient(hNamedClient : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function ImpersonateSelf(ImpersonationLevel : SECURITY_IMPERSONATION_LEVEL) : BOOL;
		external dll='kernel32.dll';
	function RevertToSelf : BOOL;
		external dll='kernel32.dll';
	function SetThreadToken(var Thread : HANDLE; Token : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function OpenProcessToken(ProcessHandle : HANDLE; DesiredAccess : DWORD; var TokenHandle : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function OpenThreadToken(ThreadHandle : HANDLE; DesiredAccess : DWORD; OpenAsSelf : BOOL;
								var TokenHandle : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function GetTokenInformation(TokenHandle : HANDLE; TokenInformationClass : TOKEN_INFORMATION_CLASS;
								TokenInformation : LPVOID; TokenInformationLength : DWORD;
								var ReturnLength : DWORD) : BOOL;
		external dll='kernel32.dll';
	function SetTokenInformation(TokenHandle : HANDLE; TokenInformationClass : TOKEN_INFORMATION_CLASS;
								TokenInformation : LPVOID; TokenInformationLength : DWORD) : BOOL;
		external dll='kernel32.dll';
	function IsValidSid(var pSid : SID) : BOOL;
		external dll='kernel32.dll';
	function EqualSid(var pSid1, pSid2 : SID) : BOOL;
		external dll='kernel32.dll';
	function EqualPrefixSid(var pSid1, pSid2 : SID) : BOOL;
		external dll='kernel32.dll';
	function GetSidLengthRequired(nSubAuthorityCount : UCHAR) : DWORD;
		external dll='kernel32.dll';
	function AllocateAndInitializeSid(var pIdentifierAuthority : SID_IDENTIFIER_AUTHORITY;
									nSubAuthority0, nSubAuthority1, nSubAuthority2, nSubAuthority3 : DWORD;
									nSubAuthority4, nSubAuthority5, nSubAuthority6, nSubAuthority7 : DWORD;
									var pSid : SID) : BOOL;
		external dll='kernel32.dll';
	function FreeSid(var pSid : SID) : PVOID;
		external dll='kernel32.dll';
	function InitializeSid(var pSid : SID; var pIdentifierAuthority : SID_IDENTIFIER_AUTHORITY;
							nSubAuthorityCount : byte) : BOOL;
		external dll='kernel32.dll';
	function GetSidIdentifierAuthority(var pSid : SID) : address;
		external dll='kernel32.dll';
	function GetSidSubAuthority(var pSid : SID; nSubAuthority : DWORD) : address;
		external dll='kernel32.dll';
	function GetSidSubAuthorityCount(var pSid : SID) : address;
		external dll='kernel32.dll';
	function GetLengthSid(var pSid : SID) : DWORD;
		external dll='kernel32.dll';
	function CopySid(nDestinationSidLength : DWORD; var pDestinationSid, pSourceSid : SID) : BOOL;
		external dll='kernel32.dll';
	function AreAllAccessesGranted(GrantAccess, DesiredAccess : DWORD) : BOOL;
		external dll='kernel32.dll';
	function AreAnyAccessesGranted(GrantAccess, DesiredAccess : DWORD) : BOOL;
		external dll='kernel32.dll';
	procedure MapGenericMask(var AccessMask : DWORD; var GenericMapping : GENERIC_MAPPING);
		external dll='kernel32.dll';

	function IsValidAcl(var pACL : ACL) : BOOL;
		external dll='kernel32.dll';
	function InitializeAcl(var pAcl : ACL; nAclLength, dwAclRevision : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetAclInformation(var pACL : ACL; pAclInformation : LPVOID;
								nAclInformationLength : DWORD;
								dwAclInformationClass : ACL_INFORMATION_CLASS) : BOOL;
		external dll='kernel32.dll';
	function SetAclInformation(var pACL : ACL; pAclInformation : LPVOID;
								nAclInformationLength : DWORD;
								dwAclInformationClass : ACL_INFORMATION_CLASS) : BOOL;
		external dll='kernel32.dll';
	function AddAce(var pACL : ACL; dwAceRevision, dwStartingAceIndex : DWORD;
					pAceList : LPVOID; nAceLIstLength : DWORD) : BOOL;
		external dll='kernel32.dll';
	function DeleteAce(var pACL : ACL; dwAceIndex : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetAce(var pACL : ACL; dwAceIndex : DWORD; var pAce : LPVOID) : BOOL;
		external dll='kernel32.dll';
	function AddAccessAllowedAce(var pACL : ACL; dwAceRevision, AccessMask : DWORD;
								var pSid : SID) : BOOL;
		external dll='kernel32.dll';
	function AddAccessDeniedAce(var pACL : ACL; dwAceRevision, AccessMask : DWORD;
								var pSid : SID) : BOOL;
		external dll='kernel32.dll';
	function AddAuditAccessAce(var pACL : ACL; dwAceRevision, AccessMask : DWORD;
								var pSid : SID; bAuditSuccess, bAuditFailure : BOOL) : BOOL;
		external dll='kernel32.dll';
	function FindFirstFreeAce(var pACL : ACL; var pAce : LPVOID) : BOOL;
		external dll='kernel32.dll';
	function InitializeSecurityDescriptor(var pSecurityDescriptor : SECURITY_DESCRIPTOR; dwRevision : DWORD) : BOOL;
		external dll='kernel32.dll';
	function IsValidSecurityDescriptor(var pSecurityDescriptor : SECURITY_DESCRIPTOR) : BOOL;
		external dll='kernel32.dll';
	function GetSecurityDescriptorLength(var pSecurityDescriptor : SECURITY_DESCRIPTOR) : DWORD;
		external dll='kernel32.dll';
	function GetSecurityDescriptorControl(var pSecurityDescriptor : SECURITY_DESCRIPTOR;
											var pControl : SECURITY_DESCRIPTOR_CONTROL;
											var lpdwRevision : DWORD) : BOOL;
		external dll='kernel32.dll';
	function SetSecurityDescriptorDacl(var pSecurityDescriptor : SECURITY_DESCRIPTOR;
										bDaclPresent : BOOL; var pDacl : ACL;
										bDaclDefaulted : BOOL) : BOOL;
		external dll='kernel32.dll';
	function GetSecurityDescriptorDacl(var pSecurityDescriptor : SECURITY_DESCRIPTOR;
										var lpbDaclPresent : BOOL;
										pDacl : address; var lpbDaclDefaulted : BOOL) : BOOL;
		external dll='kernel32.dll';
	function SetSecurityDescriptorSacl(var pSecurityDescriptor : SECURITY_DESCRIPTOR;
										bSaclPresent : BOOL; var pSacl : ACL;
										bSaclDefaulted : BOOL) : BOOL;
		external dll='kernel32.dll';
	function GetSecurityDescriptorSacl(var pSecurityDescriptor : SECURITY_DESCRIPTOR;
										var lpbSaclPresent : BOOL;
										pSacl : address; var lpbSaclDefaulted : BOOL) : BOOL;
		external dll='kernel32.dll';
	function SetSecurityDescriptorOwner(var pSecurityDescriptor : SECURITY_DESCRIPTOR;
										var pOwner : SID; bOwnerDefaulted : BOOL) : BOOL;
		external dll='kernel32.dll';
	function GetSecurityDescriptorOwner(var pSecurityDescriptor : SECURITY_DESCRIPTOR;
										pOwner : address; var lpbOwnerDefaulted : BOOL) : BOOL;
		external dll='kernel32.dll';
	function SetSecurityDescriptorGroup(var pSecurityDescriptor : SECURITY_DESCRIPTOR;
										var pGroup : SID; bGroupDefaulted : BOOL) : BOOL;
		external dll='kernel32.dll';
	function GetSecurityDescriptorGroup(var pSecurityDescriptor : SECURITY_DESCRIPTOR;
										pGroup : address; var lpbGroupDefaulted : BOOL) : BOOL;
		external dll='kernel32.dll';
	function CreatePrivateObjectSecurity(var ParentDescriptor, CreatorDescriptor : SECURITY_DESCRIPTOR;
											NewDescriptor : address; IsDirectoryObject : BOOL;
											Token : HANDLE; var GenericMapping : GENERIC_MAPPING) : BOOL;
		external dll='kernel32.dll';
	function SetPrivateObjectSecurity(SecurityInformation : SECURITY_INFORMATION;
										var ModificationDescriptor : SECURITY_DESCRIPTOR;
										ObjectsSecurityDescriptor : address;
										var GenericMapping : GENERIC_MAPPING;
										Token : HANDLE) : BOOL;	
		external dll='kernel32.dll';
	function GetPrivateObjectSecurity(var ObjectDescriptor : SECURITY_DESCRIPTOR;
										SecurityInformation : SECURITY_INFORMATION;
										var ResultantDescriptor : SECURITY_DESCRIPTOR;
										DescriptorLength : DWORD;
										var ReturnLength : DWORD) : BOOL;
		external dll='kernel32.dll';
	function DestroyPrivateObjectSecurity(ObjectDescriptor : address) : BOOL;
		external dll='kernel32.dll';
	function MakeSelfRelativeSD(var pAbsoluteSecurityDescriptor, pSelfRelativeSecurityDescriptor : SECURITY_DESCRIPTOR;
								var lpdwBufferLength : DWORD) : BOOL;
		external dll='kernel32.dll';
	function MakeAbsoluteSD(var pAbsoluteSecurityDescriptor, pSelfRelativeSecurityDescriptor : SECURITY_DESCRIPTOR;
							var lpdwAbsoluteSecurityDescriptorSize : DWORD;
							var pDacl : ACL; var lpdwDaclSize : DWORD;
							var pSacl : ACL; var lpdwSaclSize : DWORD;
							var pOwner : SID; var lpdwOwnerSize : DWORD;
							var pPrimaryGroup : SID; var lpdwPrimaryGroupSize : DWORD) : BOOL;
		external dll='kernel32.dll';

	function SetFileSecurity(lpFileName : address; SecurityInformation : SECURITY_INFORMATION;
							var pSecurityDescriptor : SECURITY_DESCRIPTOR) : BOOL;
		external dll='kernel32.dll' name='SetFileSecurityA';
	function GetFileSecurity(lpFileName : address; RequestedInformation : SECURITY_INFORMATION;
							var pSecurityDescriptor : SECURITY_DESCRIPTOR; nLength : DWORD;
							var lpnLengthNeeded : DWORD) : BOOL;
		external dll='kernel32.dll' name='GetFileSecurityA';
	function SetKernelObjectSecurity(h : HANDLE; SecurityInformation : SECURITY_INFORMATION;
									var pSecurityDescriptor : SECURITY_DESCRIPTOR) : BOOL;
		external dll='kernel32.dll';
	function FindFirstChangeNotification(lpPathName : address; bWatchSubtree : BOOL;
											dwNotifyFilter : DWORD) : HANDLE;
		external dll='kernel32.dll' name='FindFirstChangeNotificationA';
	function FindNextChangeNotification(hChangeHandle : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function FindCloseChangeNotification(hChangeHandle : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function ReadDirectoryChangesW(hDirectory : HANDLE; lpBuffer : LPVOID;
									nBufferLength : DWORD; bWatchSubtree : BOOL;
									dwNotifyFilter : DWORD; var lpBytesReturned : DWORD;
									var lpOverlapped : OVERLAPPED; lpCompletionRoutine : PROC) : BOOL;
		external dll='kernel32.dll';

	function VirtualLock(lpAddress : LPVOID; dwSize : DWORD) : BOOL;
		external dll='kernel32.dll';
	function VirtualUnlock(lpAddress : LPVOID; dwSize : DWORD) : BOOL;
		external dll='kernel32.dll';
	function MapViewOfFileEx(hFileMappingObject : HANDLE;
							dwDesiredAccess, dwFileOffsetHigh, dwFileOffsetLow : DWORD;
							dwNumberOfBytesToMap : DWORD; lpBaseAddress : LPVOID) : LPVOID;
		external dll='kernel32.dll';
	function SetPriorityClass(hProcess : HANDLE; dwPriorityClass : DWORD) : BOOL;
		external dll='kernel32.dll';
	function GetPriorityClass(hProcess : HANDLE) : DWORD;
		external dll='kernel32.dll';
	function IsBadReadPtr(lp : address; ucp : UINT) : BOOL;
		external dll='kernel32.dll';
	function IsBadWritePtr(lp : LPVOID; ucb : UINT) : BOOL;
		external dll='kernel32.dll';
	function IsBadHugeReadPtr(lp : address; ucp : UINT) : BOOL;
		external dll='kernel32.dll';
	function IsBadHugeWritePtr(lp : LPVOID; ucb : UINT) : BOOL;
		external dll='kernel32.dll';
	function IsBadCodePtr(lpfn : PROC) : BOOL;
		external dll='kernel32.dll';
	function IsBadStringPtr(lpsz : LPCSTR; ucchMax : UINT) : BOOL;
		external dll='kernel32.dll' name='IsBadStringPtrA';
	function LookupAccountSid(lpSystemName : address; var pSid : SID;
								Name : address; var cbName : DWORD;
								ReferencedDomainName : address;
								var cbReferencedDomainName : DWORD;
								var peUse : SID_NAME_USE) : BOOL;
		external dll='kernel32.dll' name='IsBadStringPtrA';
	function LookupAccountName(lpSystemName, lpAccountName : address;
								var pSid : SID; var cbSid : DWORD;
								ReferencedDomainName : address;
								var cbReferencedDomainName : DWORD;
								var peUse : SID_NAME_USE) : BOOL;
		external dll='kernel32.dll' name='LookupAccountNameA';
	function LookupPrivilegeValue(lpSystemName, lpName : address;
								var lpLuid : LUID) : BOOL;
		external dll='kernel32.dll' name='LookupPrivilegeValueA';
	function LookupPrivilegeName(lpSystemName : address; var lpLuid : LUID;
								lpName : address; var cbName : DWORD) : BOOL;
		external dll='kernel32.dll' name='LookupPrivilegeNameA';
	function LookupPrivilegeDisplayName(lpSystemName, lpName, lpDisplayName : address;
										var cbDisplayName, lpLanguageId : DWORD) : BOOL;
		external dll='kernel32.dll' name='LookupPrivilegeDisplayNameA';
	function AllocateLocallyUniqueId(var id : LUID) : BOOL;
		external dll='kernel32.dll';
	function BuildCommDCB(lpDef : address; var lpDCB : DCB) : BOOL;
		external dll='kernel32.dll' name='BuildCommDCBA';
	function BuildCommDCBAndTimeouts(lpDef : address; var lpDCB : DCB;
									var lpCommTimeouts : COMMTIMEOUTS) : BOOL;
		external dll='kernel32.dll' name='BuildCommDCBAndTimeoutsA';
	function CommConfigDialog(lpszName : address; hWnd : _HWND; lpCC : address) : BOOL;
		external dll='kernel32.dll' name='CommConfigDialogA';
	function GetDefaultCommConfig(lpszName : address; lpCC : address;
									var lpdwSize : DWORD) : BOOL;
		external dll='kernel32.dll' name='GetDefaultCommConfigA';
	function SetDefaultCommConfig(lpszName : address; lpCC : address;
									dwSize : DWORD) : BOOL;
		external dll='kernel32.dll' name='SetDefaultCommConfigA';

const
	MAX_COMPUTERNAME_LENGTH = 15;

	function GetComputerName(lpBuffer : address; var nSize : DWORD) : BOOL;
		external dll='kernel32.dll' name='GetComputerNameA';
	function SetComputerName(lpComputerName : address) : BOOL;
		external dll='kernel32.dll' name='SetComputerNameA';
	function GetUserName(lpBuffer : address; var nSize : DWORD) : BOOL;
		external dll='kernel32.dll' name='GetUserNameA';

const
    LOGON32_LOGON_INTERACTIVE = 2;
    LOGON32_LOGON_NETWORK = 3;
    LOGON32_LOGON_BATCH = 4;
    LOGON32_LOGON_SERVICE = 5;
    LOGON32_PROVIDER_DEFAULT = 0;
    LOGON32_PROVIDER_WINNT35 = 1;
    LOGON32_PROVIDER_WINNT40 = 2;

	function LogonUser(lpszUsername, lpszDomain, lpszPassword : address;
						dwLogonType, dwLogonProvider : DWORD;
						var phToken : HANDLE) : BOOL;
		external dll='kernel32.dll' name='LogonUserA';
	function ImpersonateLoggedOnUser(hToken : HANDLE) : BOOL;
		external dll='kernel32.dll';
	function CreateProcessAsUser(hToken : HANDLE; lpApplicationName, lpCommandLine : address;
								var lpProcessAttributes, lpThreadAttributes : SECURITY_ATTRIBUTES;
								bInheritHandles : BOOL; dwCreationFlags : DWORD;
								lpEnvironment : LPVOID; lpCurrentDirectory : address;
								var lpStartupInfo : STARTUPINFO;
								var lpProcessInformation : PROCESS_INFORMATION) : BOOL;
		external dll='kernel32.dll' name='CreateProcessAsUserA';
	function DuplicateTokenEx(hExistingToken : HANDLE; dwDesiredAccess : DWORD;
								var lpTokenAttributes : SECURITY_ATTRIBUTES;
								ImpersonationLevel : SECURITY_IMPERSONATION_LEVEL;
								TokenType : TOKEN_TYPE; var phNewToken : HANDLE) : BOOL;
		external dll='kernel32.dll';

const
    HW_PROFILE_GUIDLEN = 38;
    MAX_PROFILE_LEN = 79;
    DOCKINFO_UNDOCKED = $1;
    DOCKINFO_DOCKED = $2;
    DOCKINFO_USER_SUPPLIED = $4;
    DOCKINFO_USER_UNDOCKED = $5;
    DOCKINFO_USER_DOCKED = $6;

type
	HW_PROFILE_INFO = packed record
	    dwDockInfo : DWORD;
    	szHwProfileGuid : cstring[HW_PROFILE_GUIDLEN];
	    szHwProfileName : cstring[MAX_PROFILE_LEN];
	end;

	function GetCurrentHwProfile(var lpHwProfileInfo : HW_PROFILE_INFO) : BOOL;
		external dll='kernel32.dll' name='GetCurrentHwProfileA';
	function QueryPerformanceCounter(var lpPerformanceCount : LARGE_INTEGER) : BOOL;
		external dll='kernel32.dll';
	function QueryPerformanceFrequency(var lpFrequency : LARGE_INTEGER) : BOOL;
		external dll='kernel32.dll';

type
	OSVERSIONINFO = packed record
	    dwOSVersionInfoSize : DWORD;
    	dwMajorVersion : DWORD;
	    dwMinorVersion : DWORD;
    	dwBuildNumber : DWORD;
	    dwPlatformId : DWORD;
    	szCSDVersion : cstring[127];
	end;

const
    VER_PLATFORM_WIN32s = 0;
    VER_PLATFORM_WIN32_WINDOWS = 1;
    VER_PLATFORM_WIN32_NT = 2;

	function GetVersionEx(var lpVersionInformation : OSVERSIONINFO) : BOOL;
		external dll='kernel32.dll' name='GetVersionExA';

const
    TC_NORMAL = 0;
    TC_HARDERR = 1;
    TC_GP_TRAP = 2;
    TC_SIGNAL = 3;

    AC_LINE_OFFLINE = $00;
    AC_LINE_ONLINE = $01;
    AC_LINE_BACKUP_POWER = $02;
    AC_LINE_UNKNOWN = $FF;
    BATTERY_FLAG_HIGH = $01;
    BATTERY_FLAG_LOW = $02;
    BATTERY_FLAG_CRITICAL = $04;
    BATTERY_FLAG_CHARGING = $08;
    BATTERY_FLAG_NO_BATTERY = $80;
    BATTERY_FLAG_UNKNOWN = $FF;
    BATTERY_PERCENTAGE_UNKNOWN = $FF;
    BATTERY_LIFE_UNKNOWN = $FFFFFFFF;

type
	SYSTEM_POWER_STATUS = packed record
	    ACLineStatus : byte;
    	BatteryFlag : byte;
	    BatteryLifePercent : byte;
    	Reserved1 : byte;
	    BatteryLifeTime : DWORD;
    	BatteryFullLifeTime : DWORD;
	end;

	function GetSystemPowerStatus(var lpSystemPowerStatus : SYSTEM_POWER_STATUS) : BOOL;
		external dll='kernel32.dll';
	function SetSystemPowerState(fSuspend, fForce : BOOL) : BOOL;
		external dll='kernel32.dll';

type
	WIN_CERTIFICATE = packed record
	    dwLength : DWORD;
    	wRevision : shortword;
	    wCertificateType : shortword;
	end;

const
    WIN_CERT_REVISION_1_0 = $0100;
    WIN_CERT_TYPE_X509 = $0001;
    WIN_CERT_TYPE_PKCS_SIGNED_DATA = $0002;
    WIN_CERT_TYPE_RESERVED_1 = $0003;

	function WinSubmitCertificate(var lpCertificate : WIN_CERTIFICATE) : BOOL;
		external dll='kernel32.dll';
	function WinVerifyTrust(hWnd : _HWND; var ActionID : GUID; ActionData : LPVOID) : LONG;
		external dll='kernel32.dll';
	function WinLoadTrustProvider(var ActionID : GUID) : BOOL;
		external dll='kernel32.dll';

type
	WIN_TRUST_SUBJECT = LPVOID;

	WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT = packed record
	    hClientToken : HANDLE;
    	SubjectType : address;
	    Subject : WIN_TRUST_SUBJECT;
	end;

	WIN_TRUST_ACTDATA_SUBJECT_ONLY = packed record
    	SubjectType : address;
	    Subject : WIN_TRUST_SUBJECT;
	end;

	WIN_TRUST_SUBJECT_FILE = packed record
	    hFile : HANDLE;
    	lpPath : LPCWSTR;
	end;

	WIN_TRUST_SUBJECT_FILE_AND_DISPLAY = packed record
	    hFile : HANDLE;
    	lpPath : LPCWSTR;
    	lpDisplayName : LPCWSTR;
	end;

	WIN_SPUB_TRUSTED_PUBLISHER_DATA = packed record
	    hClientToken : HANDLE;
    	lpCertificate : address;
	end;

(*$W42. *)
(*$W53. *)
(*$W44. *)
