#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/examples/unions/RCS/client.py,v $
# Version:      @(#)$RCSfile: client.py,v $ $Revision: 1.7 $
#
#############################################################################
""" Example client using IDL unions. """


# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import CORBA

# Stubs generated by 'fnidl'.
import Unions


def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    # Read the server's IOR from a file.
    stringified_ior = open('server.ref', 'r').read()

    print 'Creating active object reference...'

    # Convert the stringified IOR into an active object reference.
    server = orb.string_to_object(stringified_ior)

    # Make sure that the server is not a 'nil object reference' (represented
    # in Python by the value 'None').
    if server is None:
	raise 'Nil object reference!'

    # Make sure that the object implements the expected interface!
    if not server._is_a('IDL:dstc.edu.au/Unions/test:1.0'):
	raise 'This is not a "test" server!'

    # 'in' parameters.
    server.in_a(Unions.A(1, 123))
    server.in_a(Unions.A(0, 'Hello'))

    server.in_b(Unions.B(1, 123))
    server.in_b(Unions.B(0, 'Hello'))

    server.in_c(Unions.C(1, 123))
    server.in_c(Unions.C(0, 'Hello'))

    server.in_d(Unions.D(Unions.red, 123))
    server.in_d(Unions.D(Unions.green, 123.456))
    server.in_d(Unions.D(Unions.blue, 'Hello Bluey'))

    server.in_e(Unions.E(Unions.red, 123))
    server.in_e(Unions.E(Unions.green, 123.456))
    server.in_e(Unions.E(Unions.blue, 'Hello Bluey'))

    server.in_f(Unions.F(Unions.red, 123))
    server.in_f(Unions.F(Unions.green, 'Hello Greeny'))
    server.in_f(Unions.F(Unions.blue, 'Hello Bluey'))

    # 'inout' parameters.
    print server.inout_a(Unions.A(1, 123))
    print server.inout_a(Unions.A(0, 'Hello'))

    print server.inout_b(Unions.B(1, 123))
    print server.inout_b(Unions.B(0, 'Hello'))

    print server.inout_c(Unions.C(1, 123))
    print server.inout_c(Unions.C(0, 'Hello'))

    server.inout_d(Unions.D(Unions.red, 123))
    server.inout_d(Unions.D(Unions.green, 123.456))
    server.inout_d(Unions.D(Unions.blue, 'Hello Bluey'))

    server.inout_e(Unions.E(Unions.red, 123))
    server.inout_e(Unions.E(Unions.green, 123.456))
    server.inout_e(Unions.E(Unions.blue, 'Hello Bluey'))

    server.inout_f(Unions.F(Unions.red, 123))
    server.inout_f(Unions.F(Unions.green, 'Hello Greeny'))
    server.inout_f(Unions.F(Unions.blue, 'Hello Bluey'))

    # 'out' parameters.
    print server.out_a()
    print server.out_b()
    print server.out_c()
    print server.out_d()
    print server.out_e()
    print server.out_f()

    # Return values.
    print server.return_a()
    print server.return_b()
    print server.return_c()
    print server.return_d()
    print server.return_e()
    print server.return_f()

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
