#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/parser/RCS/Stack.py,v $
# Version:      @(#)$RCSfile: Stack.py,v $ $Revision: 1.7 $
#
#############################################################################
""" A simple stack implementation. """


class Stack:
    """ A simple stack implementation. """
    
    def __init__(self):
	""" Constructor. """

	self.__items = []
	return

    def __len__(self):
	""" Number of items on the stack. """

	return len(self.__items)

    def __str__(self):
	return str(self.__items)

    def push(self, item):
	""" Push an item onto the stack. """

	self.__items.append(item)
	return

    def pop(self):
	""" Pop the top item off the stack. """

	del self.__items[-1]
	return

    def get(self):
	""" Return the item on the top of the stack. """
	
	return self.__items[-1]

    def items(self):
	""" Return a copy of the stack as a list. """

	return self.__items[:]
	
#############################################################################
