/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BatchProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.dispatch.HookedJavaFileObject;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class BatchFilerImpl
implements Filer {
    protected final BaseAnnotationProcessorManager _dispatchManager;
    protected final BatchProcessingEnvImpl _env;
    protected final JavaFileManager _fileManager;
    protected final HashSet<URI> _createdFiles;

    public BatchFilerImpl(BaseAnnotationProcessorManager baseAnnotationProcessorManager, BatchProcessingEnvImpl batchProcessingEnvImpl) {
        this._dispatchManager = baseAnnotationProcessorManager;
        this._fileManager = batchProcessingEnvImpl._fileManager;
        this._env = batchProcessingEnvImpl;
        this._createdFiles = new HashSet();
    }

    public void addNewUnit(ICompilationUnit iCompilationUnit) {
        this._env.addNewUnit(iCompilationUnit);
    }

    public void addNewClassFile(ReferenceBinding referenceBinding) {
        this._env.addNewClassFile(referenceBinding);
    }

    @Override
    public JavaFileObject createClassFile(CharSequence charSequence, Element ... elementArray) throws IOException {
        JavaFileObject javaFileObject = this._fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, charSequence.toString(), JavaFileObject.Kind.CLASS, null);
        URI uRI = javaFileObject.toUri();
        if (this._createdFiles.contains(uRI)) {
            throw new FilerException("Class file already created : " + charSequence);
        }
        this._createdFiles.add(uRI);
        return new HookedJavaFileObject(javaFileObject, javaFileObject.getName(), charSequence.toString(), this);
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence charSequence, CharSequence charSequence2, Element ... elementArray) throws IOException {
        BatchFilerImpl.validateName(charSequence2);
        FileObject fileObject = this._fileManager.getFileForOutput(location, charSequence.toString(), charSequence2.toString(), null);
        URI uRI = fileObject.toUri();
        if (this._createdFiles.contains(uRI)) {
            throw new FilerException("Resource already created : " + location + '/' + charSequence + '/' + charSequence2);
        }
        this._createdFiles.add(uRI);
        return fileObject;
    }

    private static void validateName(CharSequence charSequence) {
        int n = charSequence.length();
        if (n == 0) {
            throw new IllegalArgumentException("relative path cannot be empty");
        }
        String string = charSequence.toString();
        if (string.indexOf(92) != -1) {
            string = string.replace('\\', '/');
        }
        if (string.charAt(0) == '/') {
            throw new IllegalArgumentException("relative path is absolute");
        }
        boolean bl = false;
        block4: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '/': {
                    if (!bl) continue block4;
                    throw new IllegalArgumentException("relative name " + charSequence + " is not relative");
                }
                case '.': {
                    bl = true;
                    continue block4;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (bl) {
            throw new IllegalArgumentException("relative name " + charSequence + " is not relative");
        }
    }

    @Override
    public JavaFileObject createSourceFile(CharSequence charSequence, Element ... elementArray) throws IOException {
        TypeElement typeElement;
        String string = charSequence.toString();
        int n = string.indexOf(47);
        String string2 = null;
        if (n != -1) {
            charSequence = string.substring(n + 1, charSequence.length());
            string2 = string.substring(0, n);
        }
        if ((typeElement = this._env._elementUtils.getTypeElement(charSequence)) != null) {
            throw new FilerException("Source file already exists : " + string);
        }
        JavaFileManager.Location location = string2 == null ? StandardLocation.SOURCE_OUTPUT : this._fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, string2);
        JavaFileObject javaFileObject = this._fileManager.getJavaFileForOutput(location, charSequence.toString(), JavaFileObject.Kind.SOURCE, null);
        URI uRI = javaFileObject.toUri();
        if (this._createdFiles.contains(uRI)) {
            throw new FilerException("Source file already created : " + charSequence);
        }
        this._createdFiles.add(uRI);
        return new HookedJavaFileObject(javaFileObject, javaFileObject.getName(), charSequence.toString(), this);
    }

    @Override
    public FileObject getResource(JavaFileManager.Location location, CharSequence charSequence, CharSequence charSequence2) throws IOException {
        BatchFilerImpl.validateName(charSequence2);
        FileObject fileObject = this._fileManager.getFileForInput(location, charSequence.toString(), charSequence2.toString());
        if (fileObject == null) {
            throw new FileNotFoundException("Resource does not exist : " + location + '/' + charSequence + '/' + charSequence2);
        }
        URI uRI = fileObject.toUri();
        if (this._createdFiles.contains(uRI)) {
            throw new FilerException("Resource already created : " + location + '/' + charSequence + '/' + charSequence2);
        }
        return fileObject;
    }
}

