/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.AnnotationMirrorImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ArrayTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.DeclaredTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ErrorTypeElement;
import org.eclipse.jdt.internal.compiler.apt.model.ErrorTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ModuleElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.NoTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.PackageElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.PrimitiveTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeParameterElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeVariableImpl;
import org.eclipse.jdt.internal.compiler.apt.model.VariableElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.WildcardTypeImpl;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class Factory {
    public static final Byte DUMMY_BYTE = 0;
    public static final Character DUMMY_CHAR = Character.valueOf('0');
    public static final Double DUMMY_DOUBLE = 0.0;
    public static final Float DUMMY_FLOAT = Float.valueOf(0.0f);
    public static final Integer DUMMY_INTEGER = 0;
    public static final Long DUMMY_LONG = 0L;
    public static final Short DUMMY_SHORT = 0;
    private final BaseProcessingEnvImpl _env;
    public static List<? extends AnnotationMirror> EMPTY_ANNOTATION_MIRRORS = Collections.emptyList();

    public Factory(BaseProcessingEnvImpl baseProcessingEnvImpl) {
        this._env = baseProcessingEnvImpl;
    }

    public List<? extends AnnotationMirror> getAnnotationMirrors(AnnotationBinding[] annotationBindingArray) {
        if (null == annotationBindingArray || 0 == annotationBindingArray.length) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationMirror> arrayList = new ArrayList<AnnotationMirror>(annotationBindingArray.length);
        for (AnnotationBinding annotationBinding : annotationBindingArray) {
            if (annotationBinding == null) continue;
            arrayList.add(this.newAnnotationMirror(annotationBinding));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public <A extends Annotation> A[] getAnnotationsByType(AnnotationBinding[] annotationBindingArray, Class<A> clazz) {
        Annotation[] annotationArray = this.getAnnotations(annotationBindingArray, clazz, false);
        return annotationArray == null ? (Annotation[])Array.newInstance(clazz, 0) : annotationArray;
    }

    public <A extends Annotation> A getAnnotation(AnnotationBinding[] annotationBindingArray, Class<A> clazz) {
        Annotation[] annotationArray = this.getAnnotations(annotationBindingArray, clazz, true);
        return (A)(annotationArray == null ? null : annotationArray[0]);
    }

    private <A extends Annotation> A[] getAnnotations(AnnotationBinding[] annotationBindingArray, Class<A> clazz, boolean bl) {
        if (annotationBindingArray == null || annotationBindingArray.length == 0 || clazz == null) {
            return null;
        }
        String string = clazz.getName();
        if (string == null) {
            return null;
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationBindingArray.length);
        for (AnnotationBinding annotationBinding : annotationBindingArray) {
            AnnotationMirrorImpl annotationMirrorImpl;
            if (annotationBinding == null || (annotationMirrorImpl = this.createAnnotationMirror(string, annotationBinding)) == null) continue;
            arrayList.add((Annotation)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)annotationMirrorImpl));
            if (bl) break;
        }
        Object[] objectArray = (Annotation[])Array.newInstance(clazz, arrayList.size());
        return arrayList.size() > 0 ? (Annotation[])arrayList.toArray(objectArray) : null;
    }

    private AnnotationMirrorImpl createAnnotationMirror(String string, AnnotationBinding annotationBinding) {
        ReferenceBinding referenceBinding = annotationBinding.getAnnotationType();
        if (referenceBinding != null && referenceBinding.isAnnotationType()) {
            char[] cArray;
            if (referenceBinding.isMemberType()) {
                string = string.replace('$', '.');
                cArray = CharOperation.concatWith(referenceBinding.enclosingType().compoundName, referenceBinding.sourceName, '.');
                CharOperation.replace(cArray, '$', '.');
            } else {
                cArray = CharOperation.concatWith(referenceBinding.compoundName, '.');
            }
            if (string.equals(new String(cArray))) {
                return (AnnotationMirrorImpl)this._env.getFactory().newAnnotationMirror(annotationBinding);
            }
        }
        return null;
    }

    private static void appendModifier(Set<Modifier> set, int n, int n2, Modifier modifier) {
        if ((n & n2) != 0) {
            set.add(modifier);
        }
    }

    private static void decodeModifiers(Set<Modifier> set, int n, int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n2 = nArray.length;
        block22: for (int i = 0; i < n2; ++i) {
            switch (nArray[i]) {
                case 1: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.PUBLIC);
                    continue block22;
                }
                case 4: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.PROTECTED);
                    continue block22;
                }
                case 2: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.PRIVATE);
                    continue block22;
                }
                case 1024: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.ABSTRACT);
                    continue block22;
                }
                case 65536: {
                    try {
                        Factory.appendModifier(set, n, nArray[i], Modifier.valueOf("DEFAULT"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue block22;
                }
                case 8: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.STATIC);
                    continue block22;
                }
                case 16: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.FINAL);
                    continue block22;
                }
                case 32: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.SYNCHRONIZED);
                    continue block22;
                }
                case 256: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.NATIVE);
                    continue block22;
                }
                case 2048: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.STRICTFP);
                    continue block22;
                }
                case 128: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.TRANSIENT);
                    continue block22;
                }
                case 64: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.VOLATILE);
                    continue block22;
                }
                case 0x4000000: {
                    try {
                        Factory.appendModifier(set, n, nArray[i], Modifier.valueOf("NON_SEALED"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue block22;
                }
                case 0x10000000: {
                    try {
                        Factory.appendModifier(set, n, nArray[i], Modifier.valueOf("SEALED"));
                        continue block22;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static Object getMatchingDummyValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (clazz == Byte.TYPE) {
                return DUMMY_BYTE;
            }
            if (clazz == Character.TYPE) {
                return DUMMY_CHAR;
            }
            if (clazz == Double.TYPE) {
                return DUMMY_DOUBLE;
            }
            if (clazz == Float.TYPE) {
                return DUMMY_FLOAT;
            }
            if (clazz == Integer.TYPE) {
                return DUMMY_INTEGER;
            }
            if (clazz == Long.TYPE) {
                return DUMMY_LONG;
            }
            if (clazz == Short.TYPE) {
                return DUMMY_SHORT;
            }
            return DUMMY_INTEGER;
        }
        return null;
    }

    public TypeMirror getReceiverType(MethodBinding methodBinding) {
        if (methodBinding != null) {
            if (methodBinding.receiver != null) {
                return this._env.getFactory().newTypeMirror(methodBinding.receiver);
            }
            if (!(methodBinding.declaringClass == null || methodBinding.isStatic() || methodBinding.isConstructor() && !methodBinding.declaringClass.isMemberType())) {
                return this._env.getFactory().newTypeMirror(methodBinding.declaringClass);
            }
        }
        return NoTypeImpl.NO_TYPE_NONE;
    }

    public static Set<Modifier> getModifiers(int n, ElementKind elementKind) {
        return Factory.getModifiers(n, elementKind, false);
    }

    public static Set<Modifier> getModifiers(int n, ElementKind elementKind, boolean bl) {
        EnumSet<Modifier> enumSet = EnumSet.noneOf(Modifier.class);
        switch (elementKind) {
            case CONSTRUCTOR: 
            case METHOD: {
                Factory.decodeModifiers(enumSet, n, new int[]{1, 4, 2, 1024, 8, 16, 32, 256, 2048, 65536});
                break;
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                Factory.decodeModifiers(enumSet, n, new int[]{1, 4, 2, 8, 16, 128, 64});
                break;
            }
            case ENUM: {
                if (bl) {
                    Factory.decodeModifiers(enumSet, n, new int[]{1, 4, 16, 2, 1024, 8, 2048, 0x10000000});
                    break;
                }
                Factory.decodeModifiers(enumSet, n, new int[]{1, 4, 16, 2, 8, 2048, 0x10000000});
                break;
            }
            case ANNOTATION_TYPE: 
            case INTERFACE: 
            case CLASS: 
            case RECORD: {
                Factory.decodeModifiers(enumSet, n, new int[]{1, 4, 1024, 16, 2, 8, 2048, 0x10000000, 0x4000000});
                break;
            }
            case MODULE: {
                Factory.decodeModifiers(enumSet, n, new int[]{32, 32});
            }
        }
        return Collections.unmodifiableSet(enumSet);
    }

    public AnnotationMirror newAnnotationMirror(AnnotationBinding annotationBinding) {
        return new AnnotationMirrorImpl(this._env, annotationBinding);
    }

    public Element newElement(Binding binding, ElementKind elementKind) {
        if (binding == null) {
            return null;
        }
        switch (binding.kind()) {
            case 1: 
            case 2: 
            case 3: 
            case 131072: {
                return new VariableElementImpl(this._env, (VariableBinding)binding);
            }
            case 4: 
            case 2052: {
                ReferenceBinding referenceBinding = (ReferenceBinding)binding;
                if ((referenceBinding.tagBits & 0x80L) != 0L) {
                    return new ErrorTypeElement(this._env, referenceBinding);
                }
                if (CharOperation.equals(referenceBinding.sourceName, TypeConstants.PACKAGE_INFO_NAME)) {
                    return this.newPackageElement(referenceBinding.fPackage);
                }
                return new TypeElementImpl(this._env, referenceBinding, elementKind);
            }
            case 8: {
                return new ExecutableElementImpl(this._env, (MethodBinding)binding);
            }
            case 260: 
            case 1028: {
                return new TypeElementImpl(this._env, ((ParameterizedTypeBinding)binding).genericType(), elementKind);
            }
            case 16: {
                return this.newPackageElement((PackageBinding)binding);
            }
            case 4100: {
                return new TypeParameterElementImpl(this._env, (TypeVariableBinding)binding);
            }
            case 64: {
                return new ModuleElementImpl(this._env, (ModuleBinding)binding);
            }
            case 32: 
            case 68: 
            case 132: 
            case 516: 
            case 8196: {
                throw new UnsupportedOperationException("NYI: binding type " + binding.kind());
            }
        }
        return null;
    }

    public Element newElement(Binding binding) {
        return this.newElement(binding, null);
    }

    public PackageElement newPackageElement(PackageBinding packageBinding) {
        if (packageBinding != null && packageBinding.enclosingModule != null) {
            packageBinding = packageBinding.getIncarnation(packageBinding.enclosingModule);
        }
        if (packageBinding == null) {
            return null;
        }
        return new PackageElementImpl(this._env, packageBinding);
    }

    public NullType getNullType() {
        return NoTypeImpl.NULL_TYPE;
    }

    public NoType getNoType(TypeKind typeKind) {
        switch (typeKind) {
            case NONE: {
                return NoTypeImpl.NO_TYPE_NONE;
            }
            case VOID: {
                return NoTypeImpl.NO_TYPE_VOID;
            }
            case PACKAGE: {
                return NoTypeImpl.NO_TYPE_PACKAGE;
            }
            case MODULE: {
                return new NoTypeImpl(typeKind);
            }
        }
        throw new IllegalArgumentException();
    }

    public PrimitiveTypeImpl getPrimitiveType(TypeKind typeKind) {
        switch (typeKind) {
            case BOOLEAN: {
                return PrimitiveTypeImpl.BOOLEAN;
            }
            case BYTE: {
                return PrimitiveTypeImpl.BYTE;
            }
            case CHAR: {
                return PrimitiveTypeImpl.CHAR;
            }
            case DOUBLE: {
                return PrimitiveTypeImpl.DOUBLE;
            }
            case FLOAT: {
                return PrimitiveTypeImpl.FLOAT;
            }
            case INT: {
                return PrimitiveTypeImpl.INT;
            }
            case LONG: {
                return PrimitiveTypeImpl.LONG;
            }
            case SHORT: {
                return PrimitiveTypeImpl.SHORT;
            }
        }
        throw new IllegalArgumentException();
    }

    public PrimitiveTypeImpl getPrimitiveType(BaseTypeBinding baseTypeBinding) {
        AnnotationBinding[] annotationBindingArray = baseTypeBinding.getTypeAnnotations();
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            return this.getPrimitiveType(PrimitiveTypeImpl.getKind(baseTypeBinding));
        }
        return new PrimitiveTypeImpl(this._env, baseTypeBinding);
    }

    public TypeMirror newTypeMirror(Binding binding) {
        switch (binding.kind()) {
            case 1: 
            case 2: 
            case 3: 
            case 131072: {
                return this.newTypeMirror(((VariableBinding)binding).type);
            }
            case 16: {
                return this.getNoType(TypeKind.PACKAGE);
            }
            case 32: {
                throw new UnsupportedOperationException("NYI: import type " + binding.kind());
            }
            case 8: {
                return new ExecutableTypeImpl(this._env, (MethodBinding)binding);
            }
            case 4: 
            case 260: 
            case 1028: 
            case 2052: {
                ReferenceBinding referenceBinding = (ReferenceBinding)binding;
                if ((referenceBinding.tagBits & 0x80L) != 0L) {
                    return this.getErrorType(referenceBinding);
                }
                return new DeclaredTypeImpl(this._env, (ReferenceBinding)binding);
            }
            case 68: {
                return new ArrayTypeImpl(this._env, (ArrayBinding)binding);
            }
            case 132: {
                BaseTypeBinding baseTypeBinding = (BaseTypeBinding)binding;
                switch (baseTypeBinding.id) {
                    case 6: {
                        return this.getNoType(TypeKind.VOID);
                    }
                    case 12: {
                        return this.getNullType();
                    }
                }
                return this.getPrimitiveType(baseTypeBinding);
            }
            case 516: 
            case 8196: {
                return new WildcardTypeImpl(this._env, (WildcardBinding)binding);
            }
            case 4100: {
                return new TypeVariableImpl(this._env, (TypeVariableBinding)binding);
            }
            case 64: {
                return this.getNoType(TypeKind.MODULE);
            }
        }
        return null;
    }

    public TypeParameterElement newTypeParameterElement(TypeVariableBinding typeVariableBinding, Element element) {
        return new TypeParameterElementImpl(this._env, typeVariableBinding, element);
    }

    public ErrorType getErrorType(ReferenceBinding referenceBinding) {
        return new ErrorTypeImpl(this._env, referenceBinding);
    }

    public static Object performNecessaryPrimitiveTypeConversion(Class<?> clazz, Object object, boolean bl) {
        assert (clazz.isPrimitive()) : "expectedType is not a primitive type: " + clazz.getName();
        if (object == null) {
            return bl ? Factory.getMatchingDummyValue(clazz) : null;
        }
        String string = clazz.getName();
        char c = string.charAt(0);
        int n = string.length();
        if (object instanceof Byte) {
            byte by = (Byte)object;
            switch (c) {
                case 'b': {
                    if (n == 4) {
                        return object;
                    }
                    return bl ? Boolean.FALSE : object;
                }
                case 'c': {
                    return Character.valueOf((char)by);
                }
                case 'd': {
                    return (double)by;
                }
                case 'f': {
                    return Float.valueOf(by);
                }
                case 'i': {
                    return (int)by;
                }
                case 'l': {
                    return (long)by;
                }
                case 's': {
                    return (short)by;
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Short) {
            short s = (Short)object;
            switch (c) {
                case 'b': {
                    if (n == 4) {
                        return (byte)s;
                    }
                    return bl ? Boolean.FALSE : object;
                }
                case 'c': {
                    return Character.valueOf((char)s);
                }
                case 'd': {
                    return (double)s;
                }
                case 'f': {
                    return Float.valueOf(s);
                }
                case 'i': {
                    return (int)s;
                }
                case 'l': {
                    return (long)s;
                }
                case 's': {
                    return object;
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Character) {
            char c2 = ((Character)object).charValue();
            switch (c) {
                case 'b': {
                    if (n == 4) {
                        return (byte)c2;
                    }
                    return bl ? Boolean.FALSE : object;
                }
                case 'c': {
                    return object;
                }
                case 'd': {
                    return (double)c2;
                }
                case 'f': {
                    return Float.valueOf(c2);
                }
                case 'i': {
                    return (int)c2;
                }
                case 'l': {
                    return (long)c2;
                }
                case 's': {
                    return (short)c2;
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            switch (c) {
                case 'b': {
                    if (n == 4) {
                        return (byte)n2;
                    }
                    return bl ? Boolean.FALSE : object;
                }
                case 'c': {
                    return Character.valueOf((char)n2);
                }
                case 'd': {
                    return (double)n2;
                }
                case 'f': {
                    return Float.valueOf(n2);
                }
                case 'i': {
                    return object;
                }
                case 'l': {
                    return (long)n2;
                }
                case 's': {
                    return (short)n2;
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Long) {
            long l2 = (Long)object;
            switch (c) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': {
                    return bl ? Factory.getMatchingDummyValue(clazz) : object;
                }
                case 'd': {
                    return (double)l2;
                }
                case 'f': {
                    return Float.valueOf(l2);
                }
                case 'l': {
                    return object;
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            switch (c) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 'l': 
                case 's': {
                    return bl ? Factory.getMatchingDummyValue(clazz) : object;
                }
                case 'd': {
                    return (double)f;
                }
                case 'f': {
                    return object;
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Double) {
            if (c == 'd') {
                return object;
            }
            return bl ? Factory.getMatchingDummyValue(clazz) : object;
        }
        if (object instanceof Boolean) {
            if (c == 'b' && n == 7) {
                return object;
            }
            return bl ? Factory.getMatchingDummyValue(clazz) : object;
        }
        return bl ? Factory.getMatchingDummyValue(clazz) : object;
    }

    public static void setArrayMatchingDummyValue(Object object, int n, Class<?> clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            Array.setBoolean(object, n, false);
        } else if (Byte.TYPE.equals(clazz)) {
            Array.setByte(object, n, DUMMY_BYTE);
        } else if (Character.TYPE.equals(clazz)) {
            Array.setChar(object, n, DUMMY_CHAR.charValue());
        } else if (Double.TYPE.equals(clazz)) {
            Array.setDouble(object, n, DUMMY_DOUBLE);
        } else if (Float.TYPE.equals(clazz)) {
            Array.setFloat(object, n, DUMMY_FLOAT.floatValue());
        } else if (Integer.TYPE.equals(clazz)) {
            Array.setInt(object, n, DUMMY_INTEGER);
        } else if (Long.TYPE.equals(clazz)) {
            Array.setLong(object, n, DUMMY_LONG);
        } else if (Short.TYPE.equals(clazz)) {
            Array.setShort(object, n, DUMMY_SHORT);
        } else {
            Array.set(object, n, null);
        }
    }

    public static AnnotationBinding[] getPackedAnnotationBindings(AnnotationBinding[] annotationBindingArray) {
        int n;
        int n2;
        int n3;
        int n4 = n3 = annotationBindingArray == null ? 0 : annotationBindingArray.length;
        if (n3 == 0) {
            return annotationBindingArray;
        }
        AnnotationBinding[] annotationBindingArray2 = annotationBindingArray;
        for (n2 = 0; n2 < n3; ++n2) {
            MethodBinding[] methodBindingArray;
            ReferenceBinding referenceBinding;
            ReferenceBinding referenceBinding2;
            AnnotationBinding annotationBinding = annotationBindingArray2[n2];
            if (annotationBinding == null || !(referenceBinding2 = annotationBinding.getAnnotationType()).isRepeatableAnnotationType() || (referenceBinding = referenceBinding2.containerAnnotationType()) == null || (methodBindingArray = referenceBinding.getMethods(TypeConstants.VALUE)) == null || methodBindingArray.length != 1) continue;
            MethodBinding methodBinding = methodBindingArray[0];
            if (methodBinding.returnType == null || methodBinding.returnType.dimensions() != 1 || TypeBinding.notEquals(methodBinding.returnType.leafComponentType(), referenceBinding2)) continue;
            ArrayList<AnnotationBinding> arrayList = null;
            for (int i = n2 + 1; i < n3; ++i) {
                AnnotationBinding annotationBinding2 = annotationBindingArray2[i];
                if (annotationBinding2 == null || annotationBinding2.getAnnotationType() != referenceBinding2) continue;
                if (annotationBindingArray2 == annotationBindingArray) {
                    AnnotationBinding[] annotationBindingArray3 = annotationBindingArray2;
                    annotationBindingArray2 = new AnnotationBinding[n3];
                    System.arraycopy(annotationBindingArray3, 0, annotationBindingArray2, 0, n3);
                }
                annotationBindingArray2[i] = null;
                if (arrayList == null) {
                    arrayList = new ArrayList<AnnotationBinding>();
                    arrayList.add(annotationBinding);
                }
                arrayList.add(annotationBinding2);
            }
            if (arrayList == null) continue;
            ElementValuePair[] elementValuePairArray = new ElementValuePair[]{new ElementValuePair(TypeConstants.VALUE, arrayList.toArray(), methodBinding)};
            annotationBindingArray2[n2] = new AnnotationBinding(referenceBinding, elementValuePairArray);
        }
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            if (annotationBindingArray2[n] == null) continue;
            ++n2;
        }
        if (annotationBindingArray2 == annotationBindingArray && n2 == n3) {
            return annotationBindingArray;
        }
        annotationBindingArray = new AnnotationBinding[n2];
        int n5 = 0;
        for (n = 0; n < n3; ++n) {
            if (annotationBindingArray2[n] == null) continue;
            annotationBindingArray[n5++] = annotationBindingArray2[n];
        }
        return annotationBindingArray;
    }

    public static AnnotationBinding[] getUnpackedAnnotationBindings(AnnotationBinding[] annotationBindingArray) {
        int n;
        int n2 = n = annotationBindingArray == null ? 0 : annotationBindingArray.length;
        if (n == 0) {
            return annotationBindingArray;
        }
        ArrayList<AnnotationBinding> arrayList = new ArrayList<AnnotationBinding>();
        block0: for (int i = 0; i < n; ++i) {
            ElementValuePair[] elementValuePairArray;
            TypeBinding typeBinding;
            AnnotationBinding annotationBinding = annotationBindingArray[i];
            if (annotationBinding == null) continue;
            arrayList.add(annotationBinding);
            ReferenceBinding referenceBinding = annotationBinding.getAnnotationType();
            MethodBinding[] methodBindingArray = referenceBinding.getMethods(TypeConstants.VALUE);
            if (methodBindingArray == null || methodBindingArray.length != 1) continue;
            MethodBinding methodBinding = methodBindingArray[0];
            if (methodBinding.returnType.dimensions() != 1 || (typeBinding = methodBinding.returnType.leafComponentType()) == null || !typeBinding.isAnnotationType() || !typeBinding.isRepeatableAnnotationType() || typeBinding.containerAnnotationType() != referenceBinding) continue;
            for (ElementValuePair elementValuePair : elementValuePairArray = annotationBinding.getElementValuePairs()) {
                Object[] objectArray;
                if (!CharOperation.equals(elementValuePair.getName(), TypeConstants.VALUE)) continue;
                for (Object object : objectArray = (Object[])elementValuePair.getValue()) {
                    arrayList.add((AnnotationBinding)object);
                }
                continue block0;
            }
        }
        return arrayList.toArray(new AnnotationBinding[arrayList.size()]);
    }
}

