/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement {
    public Expression constantExpression;
    public BranchLabel targetLabel;
    public Expression[] constantExpressions;
    public BranchLabel[] targetLabels;
    public boolean isExpr = false;

    public CaseStatement(Expression expression, int n, int n2) {
        this.constantExpression = expression;
        this.sourceEnd = n;
        this.sourceStart = n2;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.constantExpressions != null && this.constantExpressions.length > 1) {
            for (Expression expression : this.constantExpressions) {
                this.analyseConstantExpression(blockScope, flowContext, flowInfo, expression);
            }
        } else if (this.constantExpression != null) {
            this.analyseConstantExpression(blockScope, flowContext, flowInfo, this.constantExpression);
        }
        return flowInfo;
    }

    private void analyseConstantExpression(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Expression expression) {
        if (expression.constant == Constant.NotAConstant && !expression.resolvedType.isEnum()) {
            blockScope.problemReporter().caseExpressionMustBeConstant(expression);
        }
        expression.analyseCode(blockScope, flowContext, flowInfo);
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        CaseStatement.printIndent(n, stringBuffer);
        if (this.constantExpression == null) {
            stringBuffer.append("default ");
            stringBuffer.append(this.isExpr ? "->" : ":");
        } else {
            stringBuffer.append("case ");
            if (this.constantExpressions != null && this.constantExpressions.length > 0) {
                int n2 = this.constantExpressions.length;
                for (int i = 0; i < n2; ++i) {
                    this.constantExpressions[i].printExpression(0, stringBuffer);
                    if (i >= n2 - 1) continue;
                    stringBuffer.append(',');
                }
            } else {
                this.constantExpression.printExpression(0, stringBuffer);
            }
            stringBuffer.append(this.isExpr ? " ->" : " :");
        }
        return stringBuffer;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (this.targetLabels != null) {
            int n2 = this.targetLabels.length;
            for (int i = 0; i < n2; ++i) {
                this.targetLabels[i].place();
            }
        } else {
            this.targetLabel.place();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public void resolve(BlockScope blockScope) {
    }

    @Override
    public Constant[] resolveCase(BlockScope blockScope, TypeBinding typeBinding, SwitchStatement switchStatement) {
        TypeBinding typeBinding2;
        blockScope.enclosingCase = this;
        if (this.constantExpression == null) {
            if (switchStatement.defaultCase != null) {
                blockScope.problemReporter().duplicateDefaultCase(this);
            }
            switchStatement.defaultCase = this;
            return Constant.NotAConstantList;
        }
        switchStatement.cases[switchStatement.caseCount++] = this;
        if (typeBinding != null && typeBinding.isEnum() && this.constantExpression instanceof SingleNameReference) {
            ((SingleNameReference)this.constantExpression).setActualReceiverType((ReferenceBinding)typeBinding);
        }
        if ((typeBinding2 = this.constantExpression.resolveType(blockScope)) == null || typeBinding == null) {
            return Constant.NotAConstantList;
        }
        if (this.constantExpressions != null && this.constantExpressions.length > 1) {
            ArrayList<Constant> arrayList = new ArrayList<Constant>();
            for (Expression expression : this.constantExpressions) {
                Constant constant;
                if (expression != this.constantExpression) {
                    if (typeBinding.isEnum() && expression instanceof SingleNameReference) {
                        ((SingleNameReference)expression).setActualReceiverType((ReferenceBinding)typeBinding);
                    }
                    expression.resolveType(blockScope);
                }
                if ((constant = this.resolveConstantExpression(blockScope, typeBinding2, typeBinding, switchStatement, expression)) == Constant.NotAConstant) continue;
                arrayList.add(constant);
            }
            if (arrayList.size() > 0) {
                return arrayList.toArray(new Constant[arrayList.size()]);
            }
        } else {
            return new Constant[]{this.resolveConstantExpression(blockScope, typeBinding2, typeBinding, switchStatement, this.constantExpression)};
        }
        return Constant.NotAConstantList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Constant resolveConstantExpression(BlockScope blockScope, TypeBinding typeBinding, TypeBinding typeBinding2, SwitchStatement switchStatement, Expression expression) {
        if (expression.isConstantValueOfTypeAssignableToType(typeBinding, typeBinding2) || typeBinding.isCompatibleWith(typeBinding2)) {
            if (!typeBinding.isEnum()) return expression.constant;
            if ((expression.bits & 0x1FE00000) >> 21 != 0) {
                blockScope.problemReporter().enumConstantsCannotBeSurroundedByParenthesis(expression);
            }
            if (expression instanceof NameReference && (expression.bits & 7) == 1) {
                NameReference nameReference = (NameReference)expression;
                FieldBinding fieldBinding = nameReference.fieldBinding();
                if ((fieldBinding.modifiers & 0x4000) == 0) {
                    blockScope.problemReporter().enumSwitchCannotTargetField(nameReference, fieldBinding);
                    return IntConstant.fromValue(fieldBinding.original().id + 1);
                } else {
                    if (!(nameReference instanceof QualifiedNameReference)) return IntConstant.fromValue(fieldBinding.original().id + 1);
                    blockScope.problemReporter().cannotUseQualifiedEnumConstantInCaseLabel(nameReference, fieldBinding);
                }
                return IntConstant.fromValue(fieldBinding.original().id + 1);
            }
        } else if (this.isBoxingCompatible(typeBinding, typeBinding2, expression, blockScope)) {
            return expression.constant;
        }
        blockScope.problemReporter().typeMismatchError(typeBinding, typeBinding2, this.constantExpression, (ASTNode)switchStatement.expression);
        return Constant.NotAConstant;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.constantExpressions != null && this.constantExpressions.length > 1) {
                for (Expression expression : this.constantExpressions) {
                    expression.traverse(aSTVisitor, blockScope);
                }
            } else if (this.constantExpression != null) {
                this.constantExpression.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

