/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBindingVisitor;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public abstract class FunctionalExpression
extends Expression {
    protected TypeBinding expectedType;
    public MethodBinding descriptor;
    public MethodBinding binding;
    protected MethodBinding actualMethodBinding;
    boolean ignoreFurtherInvestigation;
    protected ExpressionContext expressionContext = ExpressionContext.VANILLA_CONTEXT;
    public CompilationResult compilationResult;
    public BlockScope enclosingScope;
    public int bootstrapMethodNumber = -1;
    public boolean shouldCaptureInstance = false;
    protected static IErrorHandlingPolicy silentErrorHandlingPolicy = DefaultErrorHandlingPolicies.ignoreAllProblems();
    private boolean hasReportedSamProblem = false;
    public boolean hasDescripterProblem;
    public boolean isSerializable;
    public int ordinal;

    public FunctionalExpression(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public FunctionalExpression() {
    }

    @Override
    public boolean isBoxingCompatibleWith(TypeBinding typeBinding, Scope scope) {
        return false;
    }

    public void setCompilationResult(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public MethodBinding getMethodBinding() {
        return null;
    }

    @Override
    public void setExpectedType(TypeBinding typeBinding) {
        this.expectedType = typeBinding;
    }

    @Override
    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    public boolean isPolyExpression(MethodBinding methodBinding) {
        return true;
    }

    @Override
    public boolean isPolyExpression() {
        return true;
    }

    @Override
    public boolean isFunctionalType() {
        return true;
    }

    @Override
    public boolean isPertinentToApplicability(TypeBinding typeBinding, MethodBinding methodBinding) {
        if (typeBinding instanceof TypeVariableBinding) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBinding;
            if (methodBinding != null) {
                if (typeVariableBinding.declaringElement == methodBinding) {
                    return false;
                }
                if (methodBinding.isConstructor() && typeVariableBinding.declaringElement == methodBinding.declaringClass) {
                    return false;
                }
            } else if (typeVariableBinding.declaringElement instanceof MethodBinding) {
                return false;
            }
        }
        return true;
    }

    @Override
    public TypeBinding invocationTargetType() {
        if (this.expectedType == null) {
            return null;
        }
        MethodBinding methodBinding = this.expectedType.getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding != null && methodBinding.problemId() != 17) {
            if (methodBinding.isConstructor()) {
                return methodBinding.declaringClass;
            }
            return methodBinding.returnType;
        }
        return null;
    }

    @Override
    public TypeBinding expectedType() {
        return this.expectedType;
    }

    public boolean argumentsTypeElided() {
        return true;
    }

    public int recordFunctionalType(Scope scope) {
        while (scope != null) {
            switch (scope.kind) {
                case 2: {
                    ASTNode aSTNode;
                    ReferenceContext referenceContext = ((MethodScope)scope).referenceContext;
                    if (!(referenceContext instanceof LambdaExpression) || (aSTNode = (LambdaExpression)referenceContext) == ((LambdaExpression)aSTNode).original) break;
                    return 0;
                }
                case 4: {
                    ASTNode aSTNode = ((CompilationUnitScope)scope).referenceContext;
                    return aSTNode.record(this);
                }
            }
            scope = scope.parent;
        }
        return 0;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        return this.resolveType(blockScope, false);
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        MethodBinding methodBinding;
        this.constant = Constant.NotAConstant;
        this.enclosingScope = blockScope;
        MethodBinding methodBinding2 = methodBinding = this.expectedType == null ? null : this.expectedType.getSingleAbstractMethod(blockScope, this.argumentsTypeElided());
        if (methodBinding == null) {
            blockScope.problemReporter().targetTypeIsNotAFunctionalInterface(this);
            return null;
        }
        if (!methodBinding.isValidBinding() && methodBinding.problemId() != 25) {
            return this.reportSamProblem(blockScope, methodBinding);
        }
        this.descriptor = methodBinding;
        if (bl || this.kosherDescriptor(blockScope, methodBinding, true)) {
            Object object;
            if (this.expectedType instanceof IntersectionTypeBinding18) {
                object = ((IntersectionTypeBinding18)this.expectedType).intersectingTypes;
                int n = ((ReferenceBinding[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (object[i].findSuperTypeOriginatingFrom(37, false) == null) continue;
                    this.isSerializable = true;
                    break;
                }
            } else if (this.expectedType.findSuperTypeOriginatingFrom(37, false) != null) {
                this.isSerializable = true;
            }
            object = blockScope.environment();
            if (object.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                NullAnnotationMatching.checkForContradictions(methodBinding, this, blockScope);
            }
            this.resolvedType = this.expectedType;
            return this.resolvedType;
        }
        this.resolvedType = null;
        return null;
    }

    protected TypeBinding reportSamProblem(BlockScope blockScope, MethodBinding methodBinding) {
        if (this.hasReportedSamProblem) {
            return null;
        }
        switch (methodBinding.problemId()) {
            case 17: {
                blockScope.problemReporter().targetTypeIsNotAFunctionalInterface(this);
                this.hasReportedSamProblem = true;
                break;
            }
            case 18: {
                blockScope.problemReporter().illFormedParameterizationOfFunctionalInterface(this);
                this.hasReportedSamProblem = true;
            }
        }
        return null;
    }

    public boolean kosherDescriptor(Scope scope, MethodBinding methodBinding, boolean bl) {
        VisibilityInspector visibilityInspector = new VisibilityInspector(this, scope, bl);
        boolean bl2 = true;
        if (!visibilityInspector.visible(methodBinding.returnType)) {
            bl2 = false;
        }
        if (!visibilityInspector.visible(methodBinding.parameters)) {
            bl2 = false;
        }
        if (!visibilityInspector.visible(methodBinding.thrownExceptions)) {
            bl2 = false;
        }
        if (!visibilityInspector.visible(this.expectedType)) {
            bl2 = false;
        }
        this.hasDescripterProblem |= !bl2;
        return bl2;
    }

    public int nullStatus(FlowInfo flowInfo) {
        return 4;
    }

    public int diagnosticsSourceEnd() {
        return this.sourceEnd;
    }

    public MethodBinding[] getRequiredBridges() {
        ReferenceBinding referenceBinding = this.expectedType instanceof IntersectionTypeBinding18 ? (ReferenceBinding)((IntersectionTypeBinding18)this.expectedType).getSAMType(this.enclosingScope) : (ReferenceBinding)this.expectedType;
        class BridgeCollector {
            MethodBinding[] bridges;
            MethodBinding method;
            char[] selector;
            LookupEnvironment environment;
            Scope scope;

            BridgeCollector(ReferenceBinding referenceBinding, MethodBinding methodBinding) {
                this.method = methodBinding;
                this.selector = methodBinding.selector;
                this.environment = FunctionalExpression.this.enclosingScope.environment();
                this.scope = FunctionalExpression.this.enclosingScope;
                this.collectBridges(new ReferenceBinding[]{referenceBinding});
            }

            void collectBridges(ReferenceBinding[] referenceBindingArray) {
                int n = referenceBindingArray == null ? 0 : referenceBindingArray.length;
                for (int i = 0; i < n; ++i) {
                    int n2;
                    ReferenceBinding referenceBinding = referenceBindingArray[i];
                    if (referenceBinding == null) continue;
                    MethodBinding[] methodBindingArray = referenceBinding.getMethods(this.selector);
                    int n3 = n2 = methodBindingArray == null ? 0 : methodBindingArray.length;
                    for (int j = 0; j < n2; ++j) {
                        MethodBinding methodBinding = methodBindingArray[j];
                        if (methodBinding == null || this.method == methodBinding || methodBinding.isStatic() || methodBinding.redeclaresPublicObjectMethod(this.scope) || (methodBinding = MethodVerifier.computeSubstituteMethod(methodBinding, this.method, this.environment)) == null || !MethodVerifier.isSubstituteParameterSubsignature(this.method, methodBinding, this.environment) || !MethodVerifier.areReturnTypesCompatible(this.method, methodBinding, this.environment)) continue;
                        MethodBinding methodBinding2 = methodBinding.original();
                        MethodBinding methodBinding3 = this.method.original();
                        if (methodBinding3.areParameterErasuresEqual(methodBinding2) && !TypeBinding.notEquals(methodBinding3.returnType.erasure(), methodBinding2.returnType.erasure())) continue;
                        this.add(methodBinding2);
                    }
                    this.collectBridges(referenceBinding.superInterfaces());
                }
            }

            void add(MethodBinding methodBinding) {
                if (this.bridges == null) {
                    this.bridges = new MethodBinding[]{methodBinding};
                    return;
                }
                int n = this.bridges.length;
                for (int i = 0; i < n; ++i) {
                    if (!this.bridges[i].areParameterErasuresEqual(methodBinding) || !TypeBinding.equalsEquals(this.bridges[i].returnType.erasure(), methodBinding.returnType.erasure())) continue;
                    return;
                }
                this.bridges = new MethodBinding[n + 1];
                System.arraycopy(this.bridges, 0, this.bridges, 0, n);
                this.bridges[n] = methodBinding;
            }

            MethodBinding[] getBridges() {
                return this.bridges;
            }
        }
        return new BridgeCollector(referenceBinding, this.descriptor).getBridges();
    }

    boolean requiresBridges() {
        return this.getRequiredBridges() != null;
    }

    public void cleanUp() {
    }

    class VisibilityInspector
    extends TypeBindingVisitor {
        private Scope scope;
        private boolean shouldChatter;
        private boolean visible = true;
        private FunctionalExpression expression;

        public VisibilityInspector(FunctionalExpression functionalExpression2, Scope scope, boolean bl) {
            this.scope = scope;
            this.shouldChatter = bl;
            this.expression = functionalExpression2;
        }

        private void checkVisibility(ReferenceBinding referenceBinding) {
            if (!referenceBinding.canBeSeenBy(this.scope)) {
                this.visible = false;
                if (this.shouldChatter) {
                    this.scope.problemReporter().descriptorHasInvisibleType(this.expression, referenceBinding);
                }
            }
        }

        @Override
        public boolean visit(ReferenceBinding referenceBinding) {
            this.checkVisibility(referenceBinding);
            return true;
        }

        @Override
        public boolean visit(ParameterizedTypeBinding parameterizedTypeBinding) {
            this.checkVisibility(parameterizedTypeBinding);
            return true;
        }

        @Override
        public boolean visit(RawTypeBinding rawTypeBinding) {
            this.checkVisibility(rawTypeBinding);
            return true;
        }

        public boolean visible(TypeBinding typeBinding) {
            TypeBindingVisitor.visit((TypeBindingVisitor)this, typeBinding);
            return this.visible;
        }

        public boolean visible(TypeBinding[] typeBindingArray) {
            TypeBindingVisitor.visit((TypeBindingVisitor)this, typeBindingArray);
            return this.visible;
        }
    }
}

