/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CompactConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.SimpleSetOfCharArray;
import org.eclipse.jdt.internal.compiler.util.Util;

public class TypeDeclaration
extends Statement
implements ProblemSeverities,
ReferenceContext {
    public static final int CLASS_DECL = 1;
    public static final int INTERFACE_DECL = 2;
    public static final int ENUM_DECL = 3;
    public static final int ANNOTATION_TYPE_DECL = 4;
    public static final int RECORD_DECL = 5;
    public int modifiers = 0;
    public int modifiersSourceStart;
    public int functionalExpressionsCount = 0;
    public Annotation[] annotations;
    public char[] name;
    public TypeReference superclass;
    public TypeReference[] superInterfaces;
    public FieldDeclaration[] fields;
    public AbstractMethodDeclaration[] methods;
    public TypeDeclaration[] memberTypes;
    public SourceTypeBinding binding;
    public ClassScope scope;
    public MethodScope initializerScope;
    public MethodScope staticInitializerScope;
    public boolean ignoreFurtherInvestigation = false;
    public int maxFieldCount;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int restrictedIdentifierStart = -1;
    public int bodyStart;
    public int bodyEnd;
    public CompilationResult compilationResult;
    public MethodDeclaration[] missingAbstractMethods;
    public Javadoc javadoc;
    public QualifiedAllocationExpression allocation;
    public TypeDeclaration enclosingType;
    public FieldBinding enumValuesSyntheticfield;
    public int enumConstantsCounter;
    public TypeParameter[] typeParameters;
    public RecordComponent[] recordComponents;
    public int nRecordComponents;
    public static Set<String> disallowedComponentNames = new HashSet<String>(6);
    public TypeReference[] permittedTypes;

    public TypeDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    @Override
    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, categorizedProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortType(this.compilationResult, categorizedProblem);
    }

    public final void addClinit() {
        if (this.needClassInitMethod()) {
            AbstractMethodDeclaration[] abstractMethodDeclarationArray = this.methods;
            if (this.methods == null) {
                boolean bl = false;
                abstractMethodDeclarationArray = new AbstractMethodDeclaration[1];
            } else {
                int n = abstractMethodDeclarationArray.length;
                AbstractMethodDeclaration[] abstractMethodDeclarationArray2 = abstractMethodDeclarationArray;
                abstractMethodDeclarationArray = new AbstractMethodDeclaration[n + 1];
                System.arraycopy(abstractMethodDeclarationArray2, 0, abstractMethodDeclarationArray, 1, n);
            }
            Clinit clinit = new Clinit(this.compilationResult);
            abstractMethodDeclarationArray[0] = clinit;
            clinit.declarationSourceStart = clinit.sourceStart = this.sourceStart;
            clinit.declarationSourceEnd = clinit.sourceEnd = this.sourceEnd;
            clinit.bodyEnd = this.sourceEnd;
            this.methods = abstractMethodDeclarationArray;
        }
    }

    public MethodDeclaration addMissingAbstractMethodFor(MethodBinding methodBinding) {
        MethodDeclaration[] methodDeclarationArray;
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = typeBindingArray.length;
        MethodDeclaration methodDeclaration = new MethodDeclaration(this.compilationResult);
        methodDeclaration.selector = methodBinding.selector;
        methodDeclaration.sourceStart = this.sourceStart;
        methodDeclaration.sourceEnd = this.sourceEnd;
        methodDeclaration.modifiers = methodBinding.getAccessFlags() & 0xFFFFFBFF;
        if (n > 0) {
            methodDeclarationArray = "arg";
            methodDeclaration.arguments = new Argument[n];
            Argument[] argumentArray = methodDeclaration.arguments;
            int n2 = n;
            while (--n2 >= 0) {
                argumentArray[n2] = new Argument(((String)methodDeclarationArray + n2).toCharArray(), 0L, null, 0);
            }
        }
        if (this.missingAbstractMethods == null) {
            this.missingAbstractMethods = new MethodDeclaration[]{methodDeclaration};
        } else {
            methodDeclarationArray = new MethodDeclaration[this.missingAbstractMethods.length + 1];
            System.arraycopy(this.missingAbstractMethods, 0, methodDeclarationArray, 1, this.missingAbstractMethods.length);
            methodDeclarationArray[0] = methodDeclaration;
            this.missingAbstractMethods = methodDeclarationArray;
        }
        methodDeclaration.binding = new MethodBinding(methodDeclaration.modifiers | 0x1000, methodBinding.selector, methodBinding.returnType, n == 0 ? Binding.NO_PARAMETERS : typeBindingArray, methodBinding.thrownExceptions, this.binding);
        methodDeclaration.scope = new MethodScope(this.scope, methodDeclaration, true);
        methodDeclaration.bindArguments();
        return methodDeclaration;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        try {
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.binding;
                localTypeBinding.setConstantPoolName(blockScope.compilationUnitScope().computeConstantPoolName(localTypeBinding));
            }
            this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
        return flowInfo;
    }

    public void analyseCode(ClassScope classScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.updateMaxFieldCount();
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(ClassScope classScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.binding;
                localTypeBinding.setConstantPoolName(classScope.compilationUnitScope().computeConstantPoolName(localTypeBinding));
            }
            this.manageEnclosingInstanceAccessIfNecessary(classScope, flowInfo);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(CompilationUnitScope compilationUnitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public boolean checkConstructors(Parser parser) {
        boolean bl = false;
        if (this.methods != null) {
            int n = this.methods.length;
            while (--n >= 0) {
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[n];
                if (!abstractMethodDeclaration.isConstructor()) continue;
                if (!CharOperation.equals(abstractMethodDeclaration.selector, this.name)) {
                    ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)abstractMethodDeclaration;
                    if (constructorDeclaration.constructorCall != null && !constructorDeclaration.constructorCall.isImplicitSuper()) continue;
                    MethodDeclaration methodDeclaration = parser.convertToMethodDeclaration(constructorDeclaration, this.compilationResult);
                    this.methods[n] = methodDeclaration;
                    continue;
                }
                switch (TypeDeclaration.kind(this.modifiers)) {
                    case 2: {
                        parser.problemReporter().interfaceCannotHaveConstructors((ConstructorDeclaration)abstractMethodDeclaration);
                        break;
                    }
                    case 4: {
                        parser.problemReporter().annotationTypeDeclarationCannotHaveConstructor((ConstructorDeclaration)abstractMethodDeclaration);
                    }
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public ConstructorDeclaration createDefaultConstructorForRecord(boolean bl, boolean bl2) {
        AbstractMethodDeclaration[] abstractMethodDeclarationArray;
        int n;
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.compilationResult);
        constructorDeclaration.bits |= 0x600;
        constructorDeclaration.selector = this.name;
        constructorDeclaration.modifiers = this.modifiers & 7;
        constructorDeclaration.arguments = this.getArgumentsFromComponents(this.recordComponents);
        constructorDeclaration.sourceStart = constructorDeclaration.bodyStart = this.sourceStart;
        constructorDeclaration.declarationSourceStart = constructorDeclaration.bodyStart;
        constructorDeclaration.sourceEnd = constructorDeclaration.bodyEnd = this.sourceStart - 1;
        constructorDeclaration.declarationSourceEnd = constructorDeclaration.bodyEnd;
        if (bl) {
            constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
            constructorDeclaration.constructorCall.sourceStart = this.sourceStart;
            constructorDeclaration.constructorCall.sourceEnd = this.sourceEnd;
        }
        ArrayList<Assignment> arrayList = new ArrayList<Assignment>();
        int n2 = n = this.recordComponents != null ? this.recordComponents.length : 0;
        if (n > 0 && this.fields != null) {
            abstractMethodDeclarationArray = Arrays.stream(this.fields).filter(fieldDeclaration -> fieldDeclaration.isARecordComponent).map(fieldDeclaration -> new String(fieldDeclaration.name)).collect(Collectors.toList());
            for (int i = 0; i < n; ++i) {
                RecordComponent recordComponent = this.recordComponents[i];
                if (!abstractMethodDeclarationArray.contains(new String(recordComponent.name))) continue;
                FieldReference fieldReference = new FieldReference(recordComponent.name, 0L);
                fieldReference.receiver = ThisReference.implicitThis();
                arrayList.add(new Assignment(fieldReference, new SingleNameReference(recordComponent.name, 0L), 0));
            }
        }
        constructorDeclaration.statements = arrayList.toArray(new Statement[0]);
        if (bl2) {
            if (this.methods == null) {
                this.methods = new AbstractMethodDeclaration[]{constructorDeclaration};
            } else {
                abstractMethodDeclarationArray = new AbstractMethodDeclaration[this.methods.length + 1];
                System.arraycopy(this.methods, 0, abstractMethodDeclarationArray, 1, this.methods.length);
                abstractMethodDeclarationArray[0] = constructorDeclaration;
                this.methods = abstractMethodDeclarationArray;
            }
        }
        return constructorDeclaration;
    }

    private Argument[] getArgumentsFromComponents(RecordComponent[] recordComponentArray) {
        Argument[] argumentArray = recordComponentArray == null || recordComponentArray.length == 0 ? ASTNode.NO_ARGUMENTS : new Argument[recordComponentArray.length];
        int n = 0;
        for (RecordComponent recordComponent : recordComponentArray) {
            Argument argument = new Argument(recordComponent.name, (long)recordComponent.sourceStart << 32 | (long)recordComponent.sourceEnd, recordComponent.type, 0);
            argumentArray[n++] = argument;
        }
        return argumentArray;
    }

    public ConstructorDeclaration createDefaultConstructor(boolean bl, boolean bl2) {
        if (this.isRecord()) {
            return this.createDefaultConstructorForRecord(bl, bl2);
        }
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.compilationResult);
        constructorDeclaration.bits |= 0x80;
        constructorDeclaration.selector = this.name;
        constructorDeclaration.modifiers = this.modifiers & 7;
        constructorDeclaration.declarationSourceStart = constructorDeclaration.sourceStart = this.sourceStart;
        constructorDeclaration.sourceEnd = constructorDeclaration.bodyEnd = this.sourceEnd;
        constructorDeclaration.declarationSourceEnd = constructorDeclaration.bodyEnd;
        if (bl) {
            constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
            constructorDeclaration.constructorCall.sourceStart = this.sourceStart;
            constructorDeclaration.constructorCall.sourceEnd = this.sourceEnd;
        }
        if (bl2) {
            if (this.methods == null) {
                this.methods = new AbstractMethodDeclaration[]{constructorDeclaration};
            } else {
                AbstractMethodDeclaration[] abstractMethodDeclarationArray = new AbstractMethodDeclaration[this.methods.length + 1];
                System.arraycopy(this.methods, 0, abstractMethodDeclarationArray, 1, this.methods.length);
                abstractMethodDeclarationArray[0] = constructorDeclaration;
                this.methods = abstractMethodDeclarationArray;
            }
        }
        return constructorDeclaration;
    }

    public MethodBinding createDefaultConstructorWithBinding(MethodBinding methodBinding, boolean bl) {
        MethodBinding[] methodBindingArray;
        int n;
        Object[] objectArray;
        String string = "$anonymous";
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n2 = typeBindingArray.length;
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.compilationResult);
        constructorDeclaration.selector = new char[]{'x'};
        constructorDeclaration.sourceStart = this.sourceStart;
        constructorDeclaration.sourceEnd = this.sourceEnd;
        int n3 = this.modifiers & 7;
        if (methodBinding.isVarargs()) {
            n3 |= 0x80;
        }
        constructorDeclaration.modifiers = n3;
        constructorDeclaration.bits |= 0x80;
        if (n2 > 0) {
            constructorDeclaration.arguments = new Argument[n2];
            objectArray = constructorDeclaration.arguments;
            n = n2;
            while (--n >= 0) {
                objectArray[n] = new Argument((string + n).toCharArray(), 0L, null, 0);
            }
        }
        constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
        constructorDeclaration.constructorCall.sourceStart = this.sourceStart;
        constructorDeclaration.constructorCall.sourceEnd = this.sourceEnd;
        if (n2 > 0) {
            constructorDeclaration.constructorCall.arguments = new Expression[n2];
            objectArray = constructorDeclaration.constructorCall.arguments;
            n = n2;
            while (--n >= 0) {
                objectArray[n] = new SingleNameReference((string + n).toCharArray(), 0L);
            }
        }
        if (this.methods == null) {
            this.methods = new AbstractMethodDeclaration[]{constructorDeclaration};
        } else {
            objectArray = new AbstractMethodDeclaration[this.methods.length + 1];
            System.arraycopy(this.methods, 0, objectArray, 1, this.methods.length);
            objectArray[0] = constructorDeclaration;
            this.methods = objectArray;
        }
        objectArray = bl ? this.scope.environment().convertToRawTypes(methodBinding.thrownExceptions, true, true) : methodBinding.thrownExceptions;
        SourceTypeBinding sourceTypeBinding = this.binding;
        constructorDeclaration.binding = new MethodBinding(constructorDeclaration.modifiers, n2 == 0 ? Binding.NO_PARAMETERS : typeBindingArray, (ReferenceBinding[])objectArray, sourceTypeBinding);
        constructorDeclaration.binding.tagBits |= methodBinding.tagBits & 0x80L;
        constructorDeclaration.binding.modifiers |= 0x4000000;
        if (methodBinding.parameterNonNullness != null && n2 > 0) {
            int n4 = methodBinding.parameterNonNullness.length;
            constructorDeclaration.binding.parameterNonNullness = new Boolean[n4];
            System.arraycopy(methodBinding.parameterNonNullness, 0, constructorDeclaration.binding.parameterNonNullness, 0, n4);
        }
        constructorDeclaration.scope = new MethodScope(this.scope, constructorDeclaration, true);
        constructorDeclaration.bindArguments();
        constructorDeclaration.constructorCall.resolve(constructorDeclaration.scope);
        MethodBinding[] methodBindingArray2 = methodBindingArray = sourceTypeBinding.methods();
        int n5 = methodBindingArray.length;
        methodBindingArray = new MethodBinding[n5 + 1];
        System.arraycopy(methodBindingArray2, 0, methodBindingArray, 1, n5);
        methodBindingArray[0] = constructorDeclaration.binding;
        if (++n5 > 1) {
            ReferenceBinding.sortMethods(methodBindingArray, 0, n5);
        }
        sourceTypeBinding.setMethods(methodBindingArray);
        return constructorDeclaration.binding;
    }

    public FieldDeclaration declarationOf(FieldBinding fieldBinding) {
        if (fieldBinding != null && this.fields != null) {
            for (FieldDeclaration fieldDeclaration : this.fields) {
                if (fieldDeclaration.binding != fieldBinding) continue;
                return fieldDeclaration;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOf(MemberTypeBinding memberTypeBinding) {
        if (memberTypeBinding != null && this.memberTypes != null) {
            for (TypeDeclaration typeDeclaration : this.memberTypes) {
                if (!TypeBinding.equalsEquals(typeDeclaration.binding, memberTypeBinding)) continue;
                return typeDeclaration;
            }
        }
        return null;
    }

    public AbstractMethodDeclaration declarationOf(MethodBinding methodBinding) {
        if (methodBinding != null && this.methods != null) {
            for (AbstractMethodDeclaration abstractMethodDeclaration : this.methods) {
                if (abstractMethodDeclaration.binding != methodBinding) continue;
                return abstractMethodDeclaration;
            }
        }
        return null;
    }

    public RecordComponent declarationOf(RecordComponentBinding recordComponentBinding) {
        if (recordComponentBinding != null && this.recordComponents != null) {
            int n = this.fields.length;
            for (int i = 0; i < n; ++i) {
                RecordComponent recordComponent = this.recordComponents[i];
                if (recordComponent.binding != recordComponentBinding) continue;
                return recordComponent;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOfType(char[][] cArray) {
        int n = cArray.length;
        if (n < 1 || !CharOperation.equals(cArray[0], this.name)) {
            return null;
        }
        if (n == 1) {
            return this;
        }
        char[][] cArrayArray = new char[n - 1][];
        System.arraycopy(cArray, 1, cArrayArray, 0, n - 1);
        for (int i = 0; i < this.memberTypes.length; ++i) {
            TypeDeclaration typeDeclaration = this.memberTypes[i].declarationOfType(cArrayArray);
            if (typeDeclaration == null) continue;
            return typeDeclaration;
        }
        return null;
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        if (this.scope != null) {
            return this.scope.compilationUnitScope().referenceContext;
        }
        return null;
    }

    public ConstructorDeclaration getConstructor(Parser parser) {
        if (this.methods != null) {
            int n = this.methods.length;
            while (--n >= 0) {
                ConstructorDeclaration constructorDeclaration;
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[n];
                if (!abstractMethodDeclaration.isConstructor()) continue;
                if (!CharOperation.equals(abstractMethodDeclaration.selector, this.name)) {
                    constructorDeclaration = (ConstructorDeclaration)abstractMethodDeclaration;
                    if (constructorDeclaration.constructorCall != null && !constructorDeclaration.constructorCall.isImplicitSuper()) continue;
                    MethodDeclaration methodDeclaration = parser.convertToMethodDeclaration(constructorDeclaration, this.compilationResult);
                    this.methods[n] = methodDeclaration;
                    continue;
                }
                if (abstractMethodDeclaration instanceof CompactConstructorDeclaration) {
                    constructorDeclaration = (CompactConstructorDeclaration)abstractMethodDeclaration;
                    ((CompactConstructorDeclaration)constructorDeclaration).recordDeclaration = this;
                    if (((CompactConstructorDeclaration)constructorDeclaration).arguments == null) {
                        ((CompactConstructorDeclaration)constructorDeclaration).arguments = this.getArgumentsFromComponents(this.recordComponents);
                    }
                    return constructorDeclaration;
                }
                if (this.recordComponents != null || abstractMethodDeclaration.arguments != null) continue;
                return (ConstructorDeclaration)abstractMethodDeclaration;
            }
        }
        return null;
    }

    public void generateCode(ClassFile classFile) {
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        this.bits |= 0x2000;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
            return;
        }
        try {
            ClassFile classFile2 = ClassFile.getNewInstance(this.binding);
            classFile2.initialize(this.binding, classFile, false);
            if (this.binding.isMemberType()) {
                classFile2.recordInnerClasses(this.binding);
            } else if (this.binding.isLocalType()) {
                classFile.recordInnerClasses(this.binding);
                classFile2.recordInnerClasses(this.binding);
            }
            for (TypeVariableBinding object : this.binding.typeVariables()) {
                if ((object.tagBits & 0x800L) == 0L) continue;
                Util.recordNestedType(classFile2, object);
            }
            classFile2.addFieldInfos();
            if (this.memberTypes != null) {
                for (TypeDeclaration typeDeclaration : this.memberTypes) {
                    classFile2.recordInnerClasses(typeDeclaration.binding);
                    typeDeclaration.generateCode(this.scope, classFile2);
                }
            }
            classFile2.setForMethodInfos();
            if (this.methods != null) {
                int n = this.methods.length;
                for (int i = 0; i < n; ++i) {
                    this.methods[i].generateCode(this.scope, classFile2);
                }
            }
            classFile2.addSpecialMethods(this);
            if (this.ignoreFurtherInvestigation) {
                throw new AbortType(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            classFile2.addAttributes();
            this.scope.referenceCompilationUnit().compilationResult.record(this.binding.constantPoolName(), classFile2);
        }
        catch (AbortType abortType) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
        }
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        int n = codeStream.position;
        if (this.binding != null) {
            int n2;
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = ((NestedTypeBinding)this.binding).syntheticEnclosingInstances();
            int n3 = 0;
            int n4 = n2 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
            for (int i = 0; i < n2; ++i) {
                SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[i];
                syntheticArgumentBinding.resolvedPosition = ++n3;
                if (n3 <= 255) continue;
                blockScope.problemReporter().noMoreAvailableSpaceForArgument(syntheticArgumentBinding, blockScope.referenceType());
            }
        }
        this.generateCode(codeStream.classFile);
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        if (this.binding != null) {
            int n;
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = ((NestedTypeBinding)this.binding).syntheticEnclosingInstances();
            int n2 = 0;
            int n3 = n = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
            for (int i = 0; i < n; ++i) {
                SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[i];
                syntheticArgumentBinding.resolvedPosition = ++n2;
                if (n2 <= 255) continue;
                classScope.problemReporter().noMoreAvailableSpaceForArgument(syntheticArgumentBinding, classScope.referenceType());
            }
        }
        this.generateCode(classFile);
    }

    public void generateCode(CompilationUnitScope compilationUnitScope) {
        this.generateCode((ClassFile)null);
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    private void internalAnalyseCode(FlowContext flowContext, FlowInfo flowInfo) {
        int n;
        TypeConstants typeConstants22;
        this.checkYieldUsage();
        if (!this.binding.isUsed() && this.binding.isOrEnclosedByPrivateType() && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
            this.scope.problemReporter().unusedPrivateType(this);
        }
        if (this.typeParameters != null && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
            for (TypeConstants typeConstants22 : this.typeParameters) {
                if ((typeConstants22.binding.modifiers & 0x8000000) != 0) continue;
                this.scope.problemReporter().unusedTypeParameter((TypeParameter)typeConstants22);
            }
        }
        FlowContext flowContext2 = flowContext instanceof InitializationFlowContext ? null : flowContext;
        InitializationFlowContext initializationFlowContext = new InitializationFlowContext(flowContext2, this, flowInfo, flowContext, this.initializerScope);
        typeConstants22 = new InitializationFlowContext(null, this, flowInfo, flowContext, this.staticInitializerScope);
        FlowInfo flowInfo2 = flowInfo.unconditionalFieldLessCopy();
        FlowInfo flowInfo3 = flowInfo.unconditionalFieldLessCopy();
        if (this.fields != null) {
            for (FieldDeclaration object2 : this.fields) {
                if (object2.isStatic()) {
                    if ((flowInfo3.tagBits & 1) != 0) {
                        object2.bits &= Integer.MAX_VALUE;
                    }
                    ((InitializationFlowContext)typeConstants22).handledExceptions = Binding.ANY_EXCEPTION;
                    if ((flowInfo3 = object2.analyseCode(this.staticInitializerScope, (FlowContext)typeConstants22, flowInfo3)) != FlowInfo.DEAD_END) continue;
                    this.staticInitializerScope.problemReporter().initializerMustCompleteNormally(object2);
                    flowInfo3 = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    continue;
                }
                if ((flowInfo2.tagBits & 1) != 0) {
                    object2.bits &= Integer.MAX_VALUE;
                }
                initializationFlowContext.handledExceptions = Binding.ANY_EXCEPTION;
                if ((flowInfo2 = object2.analyseCode(this.initializerScope, (FlowContext)initializationFlowContext, flowInfo2)) != FlowInfo.DEAD_END) continue;
                this.initializerScope.problemReporter().initializerMustCompleteNormally(object2);
                flowInfo2 = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
            }
        }
        if (this.memberTypes != null) {
            n = this.memberTypes.length;
            for (int i = 0; i < n; ++i) {
                if (flowContext != null) {
                    this.memberTypes[i].analyseCode(this.scope, flowContext, ((FlowInfo)flowInfo2).copy().setReachMode(flowInfo.reachMode()));
                    continue;
                }
                this.memberTypes[i].analyseCode(this.scope);
            }
        }
        if (!(this.scope.compilerOptions().complianceLevel < 0x350000L || this.methods != null && this.methods[0].isClinit())) {
            Clinit clinit = new Clinit(this.compilationResult);
            clinit.declarationSourceStart = clinit.sourceStart = this.sourceStart;
            clinit.declarationSourceEnd = clinit.sourceEnd = this.sourceEnd;
            clinit.bodyEnd = this.sourceEnd;
            n = this.methods == null ? 0 : this.methods.length;
            AbstractMethodDeclaration[] abstractMethodDeclarationArray = new AbstractMethodDeclaration[n + 1];
            abstractMethodDeclarationArray[0] = clinit;
            if (this.methods != null) {
                System.arraycopy(this.methods, 0, abstractMethodDeclarationArray, 1, n);
            }
        }
        if (this.methods != null) {
            UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.unconditionalFieldLessCopy();
            FlowInfo flowInfo4 = ((FlowInfo)flowInfo2).unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(unconditionalFlowInfo);
            SimpleSetOfCharArray simpleSetOfCharArray = this.getJUnitMethodSourceValues();
            for (AbstractMethodDeclaration abstractMethodDeclaration : this.methods) {
                if (abstractMethodDeclaration.ignoreFurtherInvestigation) continue;
                if (abstractMethodDeclaration.isInitializationMethod()) {
                    if (abstractMethodDeclaration.isStatic()) {
                        ((Clinit)abstractMethodDeclaration).analyseCode(this.scope, (InitializationFlowContext)typeConstants22, flowInfo3.unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(unconditionalFlowInfo));
                        continue;
                    }
                    ((ConstructorDeclaration)abstractMethodDeclaration).analyseCode(this.scope, initializationFlowContext, flowInfo4.copy(), flowInfo.reachMode());
                    continue;
                }
                if (abstractMethodDeclaration.arguments == null && simpleSetOfCharArray.includes(abstractMethodDeclaration.selector) && abstractMethodDeclaration.binding != null) {
                    abstractMethodDeclaration.binding.modifiers |= 0x8000000;
                }
                ((MethodDeclaration)abstractMethodDeclaration).analyseCode(this.scope, flowContext2, flowInfo.copy());
            }
        }
        if (this.binding.isEnum() && !this.binding.isAnonymousType()) {
            this.enumValuesSyntheticfield = this.binding.addSyntheticFieldForEnumValues();
        }
    }

    private void checkYieldUsage() {
        long l2 = this.scope.compilerOptions().sourceLevel;
        if (l2 < 0x3A0000L || this.name == null || !"yield".equals(new String(this.name))) {
            return;
        }
        if (l2 >= 0x3A0000L) {
            this.scope.problemReporter().switchExpressionsYieldTypeDeclarationError(this);
        } else {
            this.scope.problemReporter().switchExpressionsYieldTypeDeclarationWarning(this);
        }
    }

    private SimpleSetOfCharArray getJUnitMethodSourceValues() {
        SimpleSetOfCharArray simpleSetOfCharArray = new SimpleSetOfCharArray();
        for (AbstractMethodDeclaration abstractMethodDeclaration : this.methods) {
            if (abstractMethodDeclaration.annotations == null) continue;
            for (Annotation annotation : abstractMethodDeclaration.annotations) {
                if (annotation.resolvedType == null || annotation.resolvedType.id != 93) continue;
                this.addJUnitMethodSourceValues(simpleSetOfCharArray, annotation, abstractMethodDeclaration.selector);
            }
        }
        return simpleSetOfCharArray;
    }

    private void addJUnitMethodSourceValues(SimpleSetOfCharArray simpleSetOfCharArray, Annotation annotation, char[] cArray) {
        for (MemberValuePair memberValuePair : annotation.memberValuePairs()) {
            if (!CharOperation.equals(memberValuePair.name, TypeConstants.VALUE)) continue;
            Expression expression = memberValuePair.value;
            if (expression instanceof ArrayInitializer) {
                ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                for (Expression expression2 : arrayInitializer.expressions) {
                    simpleSetOfCharArray.add(this.getValueAsChars(expression2));
                }
            } else {
                simpleSetOfCharArray.add(this.getValueAsChars(expression));
            }
            return;
        }
        simpleSetOfCharArray.add(cArray);
    }

    private char[] getValueAsChars(Expression expression) {
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).source;
        }
        if (expression.constant instanceof StringConstant) {
            return ((StringConstant)expression.constant).stringValue().toCharArray();
        }
        return CharOperation.NO_CHAR;
    }

    public static final int kind(int n) {
        switch (n & 0x1006200) {
            case 512: {
                return 2;
            }
            case 8704: {
                return 4;
            }
            case 16384: {
                return 3;
            }
            case 0x1000000: {
                return 5;
            }
        }
        return 1;
    }

    public boolean isRecord() {
        return (this.modifiers & 0x1000000) != 0;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)this.binding;
        MethodScope methodScope = blockScope.methodScope();
        if (!methodScope.isStatic && !methodScope.isConstructorCall) {
            nestedTypeBinding.addSyntheticArgumentAndField(nestedTypeBinding.enclosingType());
        }
        if (nestedTypeBinding.isAnonymousType()) {
            NestedTypeBinding nestedTypeBinding2;
            SyntheticArgumentBinding syntheticArgumentBinding;
            ReferenceBinding referenceBinding;
            ReferenceBinding referenceBinding2 = (ReferenceBinding)nestedTypeBinding.superclass.erasure();
            if (!(referenceBinding2.enclosingType() == null || referenceBinding2.isStatic() || referenceBinding2.isLocalType() && ((NestedTypeBinding)referenceBinding2).getSyntheticField(referenceBinding2.enclosingType(), true) == null && !referenceBinding2.isMemberType())) {
                nestedTypeBinding.addSyntheticArgument(referenceBinding2.enclosingType());
            }
            if (!methodScope.isStatic && methodScope.isConstructorCall && blockScope.compilerOptions().complianceLevel >= 0x310000L && (referenceBinding = nestedTypeBinding.enclosingType()).isNestedType() && (syntheticArgumentBinding = (nestedTypeBinding2 = (NestedTypeBinding)referenceBinding).getSyntheticArgument(nestedTypeBinding2.enclosingType(), true, false)) != null) {
                nestedTypeBinding.addSyntheticArgumentAndField(syntheticArgumentBinding);
            }
        }
    }

    public void manageEnclosingInstanceAccessIfNecessary(ClassScope classScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)this.binding;
            nestedTypeBinding.addSyntheticArgumentAndField(this.binding.enclosingType());
        }
    }

    public final boolean needClassInitMethod() {
        if ((this.bits & 1) != 0) {
            return true;
        }
        switch (TypeDeclaration.kind(this.modifiers)) {
            case 2: 
            case 4: {
                return this.fields != null;
            }
            case 3: {
                return true;
            }
        }
        if (this.fields != null) {
            int n = this.fields.length;
            while (--n >= 0) {
                FieldDeclaration fieldDeclaration = this.fields[n];
                if ((fieldDeclaration.modifiers & 8) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public void parseMethods(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        if (compilationUnitDeclaration.ignoreMethodBodies) {
            return;
        }
        if (this.memberTypes != null) {
            for (TypeDeclaration aSTNode : this.memberTypes) {
                aSTNode.parseMethods(parser, compilationUnitDeclaration);
                this.bits |= aSTNode.bits & 0x80000;
            }
        }
        if (this.methods != null) {
            for (AbstractMethodDeclaration abstractMethodDeclaration : this.methods) {
                abstractMethodDeclaration.parseStatements(parser, compilationUnitDeclaration);
                this.bits |= abstractMethodDeclaration.bits & 0x80000;
            }
        }
        if (this.fields != null) {
            for (FieldDeclaration fieldDeclaration : this.fields) {
                switch (fieldDeclaration.getKind()) {
                    case 2: {
                        ((Initializer)fieldDeclaration).parseStatements(parser, this, compilationUnitDeclaration);
                        this.bits |= fieldDeclaration.bits & 0x80000;
                    }
                }
            }
        }
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        if (this.javadoc != null) {
            this.javadoc.print(n, stringBuffer);
        }
        if ((this.bits & 0x200) == 0) {
            TypeDeclaration.printIndent(n, stringBuffer);
            this.printHeader(0, stringBuffer);
        }
        return this.printBody(n, stringBuffer);
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        int n2;
        stringBuffer.append(" {");
        if (this.memberTypes != null) {
            for (n2 = 0; n2 < this.memberTypes.length; ++n2) {
                if (this.memberTypes[n2] == null) continue;
                stringBuffer.append('\n');
                this.memberTypes[n2].print(n + 1, stringBuffer);
            }
        }
        if (this.fields != null) {
            for (n2 = 0; n2 < this.fields.length; ++n2) {
                if (this.fields[n2] == null) continue;
                stringBuffer.append('\n');
                this.fields[n2].print(n + 1, stringBuffer);
            }
        }
        if (this.methods != null) {
            for (n2 = 0; n2 < this.methods.length; ++n2) {
                if (this.methods[n2] == null) continue;
                stringBuffer.append('\n');
                this.methods[n2].print(n + 1, stringBuffer);
            }
        }
        stringBuffer.append('\n');
        return TypeDeclaration.printIndent(n, stringBuffer).append('}');
    }

    public StringBuffer printHeader(int n, StringBuffer stringBuffer) {
        int n2;
        TypeDeclaration.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            TypeDeclaration.printAnnotations(this.annotations, stringBuffer);
            stringBuffer.append(' ');
        }
        switch (TypeDeclaration.kind(this.modifiers)) {
            case 1: {
                stringBuffer.append("class ");
                break;
            }
            case 2: {
                stringBuffer.append("interface ");
                break;
            }
            case 3: {
                stringBuffer.append("enum ");
                break;
            }
            case 4: {
                stringBuffer.append("@interface ");
                break;
            }
            case 5: {
                stringBuffer.append("record ");
            }
        }
        stringBuffer.append(this.name);
        if (this.isRecord()) {
            stringBuffer.append('(');
            if (this.nRecordComponents > 0 && this.fields != null) {
                for (n2 = 0; n2 < this.nRecordComponents; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.fields[n2].type.getTypeName()[0]);
                    stringBuffer.append(' ');
                    stringBuffer.append(this.fields[n2].name);
                }
            }
            stringBuffer.append(')');
        }
        if (this.typeParameters != null) {
            stringBuffer.append("<");
            for (n2 = 0; n2 < this.typeParameters.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.typeParameters[n2].print(0, stringBuffer);
            }
            stringBuffer.append(">");
        }
        if (!this.isRecord() && this.superclass != null) {
            stringBuffer.append(" extends ");
            this.superclass.print(0, stringBuffer);
        }
        if (this.superInterfaces != null && this.superInterfaces.length > 0) {
            switch (TypeDeclaration.kind(this.modifiers)) {
                case 1: 
                case 3: 
                case 5: {
                    stringBuffer.append(" implements ");
                    break;
                }
                case 2: 
                case 4: {
                    stringBuffer.append(" extends ");
                }
            }
            for (n2 = 0; n2 < this.superInterfaces.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.superInterfaces[n2].print(0, stringBuffer);
            }
        }
        if (this.permittedTypes != null && this.permittedTypes.length > 0) {
            stringBuffer.append(" permits ");
            for (n2 = 0; n2 < this.permittedTypes.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.permittedTypes[n2].print(0, stringBuffer);
            }
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer);
    }

    public int record(FunctionalExpression functionalExpression) {
        return this.functionalExpressionsCount++;
    }

    /*
     * Unable to fully structure code
     */
    public void resolve() {
        var1_1 = this.binding;
        if (var1_1 == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        try {
            block64: {
                block61: {
                    block63: {
                        block62: {
                            if (CharOperation.equals(this.name, TypeConstants.VAR)) {
                                if (this.scope.compilerOptions().sourceLevel < 0x360000L) {
                                    this.scope.problemReporter().varIsReservedTypeNameInFuture(this);
                                } else {
                                    this.scope.problemReporter().varIsReservedTypeName(this);
                                }
                            }
                            this.scope.problemReporter().validateRestrictedKeywords(this.name, this);
                            var2_2 = var1_1.getAnnotationTagBits();
                            if ((var2_2 & 0x400000000000L) == 0L && (var1_1.modifiers & 0x100000) != 0 && this.scope.compilerOptions().sourceLevel >= 0x310000L) {
                                this.scope.problemReporter().missingDeprecatedAnnotationForType(this);
                            }
                            if ((var2_2 & 0x800000000000000L) != 0L && !this.binding.isFunctionalInterface(this.scope)) {
                                this.scope.problemReporter().notAFunctionalInterface(this);
                            }
                            if ((this.bits & 8) != 0) {
                                this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd);
                            }
                            v0 = var4_4 = this.scope.compilerOptions().getSeverity(0x20000008) != 256 && var1_1.isClass() != false && var1_1.isRecord() == false && var1_1.findSuperTypeOriginatingFrom(56, false) == null && var1_1.findSuperTypeOriginatingFrom(37, false) != null;
                            if (!var4_4) break block61;
                            var5_5 = this.scope.compilationUnitScope();
                            var6_7 = var1_1.getExactMethod(TypeConstants.WRITEREPLACE, Binding.NO_TYPES, (CompilationUnitScope)var5_5);
                            if (var6_7 == null || !var6_7.isValidBinding() || var6_7.returnType.id != 1) ** GOTO lbl-1000
                            var7_9 = var6_7.thrownExceptions;
                            if (var6_7.thrownExceptions.length != 1 || var7_9[0].id != 57) lbl-1000:
                            // 2 sources

                            {
                                v1 = true;
                            } else {
                                v1 = var4_4 = false;
                            }
                            if (!var4_4) break block61;
                            var8_11 = false;
                            var9_13 = 0;
                            var10_20 = this.scope.getType(TypeConstants.JAVA_IO_OBJECTOUTPUTSTREAM, 3);
                            if (!var10_20.isValidBinding()) break block62;
                            var6_7 = var1_1.getExactMethod(TypeConstants.WRITEOBJECT, new TypeBinding[]{var10_20}, (CompilationUnitScope)var5_5);
                            if (var6_7 == null || !var6_7.isValidBinding() || var6_7.modifiers != 2 || var6_7.returnType != TypeBinding.VOID) ** GOTO lbl-1000
                            var7_9 = var6_7.thrownExceptions;
                            if (var6_7.thrownExceptions.length == 1 && var7_9[0].id == 58) {
                                v2 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = var8_11 = false;
                            }
                        }
                        if (!(var10_20 = this.scope.getType(TypeConstants.JAVA_IO_OBJECTINPUTSTREAM, 3)).isValidBinding()) break block63;
                        var6_7 = var1_1.getExactMethod(TypeConstants.READOBJECT, new TypeBinding[]{var10_20}, (CompilationUnitScope)var5_5);
                        if (var6_7 == null || !var6_7.isValidBinding() || var6_7.modifiers != 2 || var6_7.returnType != TypeBinding.VOID) ** GOTO lbl-1000
                        var7_9 = var6_7.thrownExceptions;
                        if (var6_7.thrownExceptions.length == 1 && var7_9[0].id == 58) {
                            v3 = 1;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = 0;
                        }
                        var9_13 = v3;
                    }
                    v4 = var4_4 = var8_11 == false || var9_13 == 0;
                }
                if (var1_1.findSuperTypeOriginatingFrom(21, true) != null) {
                    var5_5 = var1_1;
                    do {
                        if (var5_5.isGenericType()) {
                            this.scope.problemReporter().genericTypeCannotExtendThrowable(this);
                            break;
                        }
                        if (var5_5.isStatic()) break;
                        if (!var5_5.isLocalType()) continue;
                        var6_7 = (NestedTypeBinding)var5_5.erasure();
                        if (var6_7.scope.methodScope().isStatic) break;
                    } while ((var5_5 = var5_5.enclosingType()) != null);
                }
                var5_6 = 0;
                var6_8 = -1;
                var7_10 = false;
                var8_12 = null;
                if (this.memberTypes != null) {
                    var10_21 = this.memberTypes.length;
                    for (var9_13 = 0; var9_13 < var10_21; ++var9_13) {
                        this.memberTypes[var9_13].resolve(this.scope);
                    }
                }
                if (this.recordComponents != null) {
                    var9_14 = this.recordComponents;
                    var10_22 = var9_14.length;
                    for (var11_28 = 0; var11_28 < var10_22; ++var11_28) {
                        var12_33 = var9_14[var11_28];
                        var12_33.resolve(this.initializerScope);
                    }
                }
                if (this.fields == null) break block64;
                var10_23 = this.fields.length;
                block14: for (var9_15 = 0; var9_15 < var10_23; ++var9_15) {
                    var11_29 = this.fields[var9_15];
                    switch (var11_29.getKind()) {
                        case 3: {
                            var7_10 = true;
                            if (!(var11_29.initialization instanceof QualifiedAllocationExpression)) {
                                if (var8_12 == null) {
                                    var8_12 = new FieldDeclaration[var10_23];
                                }
                                var8_12[var9_15] = var11_29;
                            }
                        }
                        case 1: {
                            var12_33 = var11_29.binding;
                            if (var12_33 == null) {
                                if (var11_29.initialization != null) {
                                    var11_29.initialization.resolve(var11_29.isStatic() != false ? this.staticInitializerScope : this.initializerScope);
                                }
                                this.ignoreFurtherInvestigation = true;
                                continue block14;
                            }
                            if (var4_4 && (var12_33.modifiers & 24) == 24 && CharOperation.equals(TypeConstants.SERIALVERSIONUID, var12_33.name) && TypeBinding.equalsEquals(TypeBinding.LONG, var12_33.type)) {
                                var4_4 = false;
                            }
                            ++var5_6;
                            var6_8 = var11_29.binding.id;
                            ** GOTO lbl107
                        }
                        case 2: {
                            ((Initializer)var11_29).lastVisibleFieldID = var6_8 + 1;
                        }
lbl107:
                        // 3 sources

                        default: {
                            var11_29.resolve(var11_29.isStatic() != false ? this.staticInitializerScope : this.initializerScope);
                        }
                    }
                }
            }
            if (this.maxFieldCount < var5_6) {
                this.maxFieldCount = var5_6;
            }
            if (var4_4) {
                var9_16 = this.scope.getType(TypeConstants.JAVAX_RMI_CORBA_STUB, 4);
                if (var9_16.isValidBinding()) {
                    for (var10_24 = this.binding.superclass; var10_24 != null; var10_24 = var10_24.superclass()) {
                        if (!TypeBinding.equalsEquals(var10_24, var9_16)) continue;
                        var4_4 = false;
                        break;
                    }
                }
                if (var4_4) {
                    this.scope.problemReporter().missingSerialVersion(this);
                }
            }
            switch (TypeDeclaration.kind(this.modifiers)) {
                case 4: {
                    if (this.superclass != null) {
                        this.scope.problemReporter().annotationTypeDeclarationCannotHaveSuperclass(this);
                    }
                    if (this.superInterfaces == null) break;
                    this.scope.problemReporter().annotationTypeDeclarationCannotHaveSuperinterfaces(this);
                    break;
                }
                case 3: {
                    if (!this.binding.isAbstract()) break;
                    if (!var7_10) {
                        for (AbstractMethodDeclaration var11_30 : this.methods) {
                            if (!var11_30.isAbstract() || var11_30.binding == null) continue;
                            this.scope.problemReporter().enumAbstractMethodMustBeImplemented(var11_30);
                        }
                    } else {
                        if (var8_12 == null) break;
                        for (AbstractMethodDeclaration var11_31 : this.methods) {
                            if (!var11_31.isAbstract() || var11_31.binding == null) continue;
                            var13_39 = var8_12.length;
                            for (var12_34 = 0; var12_34 < var13_39; ++var12_34) {
                                if (var8_12[var12_34] == null) continue;
                                this.scope.problemReporter().enumConstantMustImplementAbstractMethod(var11_31, var8_12[var12_34]);
                            }
                        }
                    }
                    break;
                }
            }
            var9_19 = this.missingAbstractMethods == null ? 0 : this.missingAbstractMethods.length;
            v5 = var10_27 = this.methods == null ? 0 : this.methods.length;
            if (var10_27 + var9_19 > 65535) {
                this.scope.problemReporter().tooManyMethods(this);
            }
            if (this.methods != null) {
                var12_35 = this.methods.length;
                for (var11_28 = 0; var11_28 < var12_35; ++var11_28) {
                    this.methods[var11_28].resolve(this.scope);
                }
            }
            if (this.javadoc != null) {
                if (this.scope != null && this.name != TypeConstants.PACKAGE_INFO_NAME) {
                    this.javadoc.resolve(this.scope);
                }
            } else if (!var1_1.isLocalType()) {
                var11_28 = var1_1.modifiers & 7;
                var12_36 = this.scope.problemReporter();
                var13_39 = var12_36.computeSeverity(-1610612250);
                if (var13_39 != 256) {
                    if (this.enclosingType != null) {
                        var11_28 = Util.computeOuterMostVisibility(this.enclosingType, var11_28);
                    }
                    var14_41 = this.binding.modifiers & -8 | var11_28;
                    var12_36.javadocMissing(this.sourceStart, this.sourceEnd, var13_39, var14_41);
                }
            }
            this.updateNestInfo();
            var11_32 = this.fields;
            if (var11_32 != null) {
                for (FieldDeclaration var15_42 : var11_32) {
                    var15_42.resolveJavadoc(this.initializerScope);
                }
            }
            if ((var12_38 = this.methods) != null) {
                for (AbstractMethodDeclaration var16_44 : var12_38) {
                    var16_44.resolveJavadoc();
                }
            }
        }
        catch (AbortType var2_3) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    @Override
    public void resolve(BlockScope blockScope) {
        if ((this.bits & 0x200) == 0) {
            TypeBinding typeBinding = blockScope.getType(this.name);
            if (typeBinding instanceof ReferenceBinding && typeBinding != this.binding && typeBinding.isValidBinding()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
                if (referenceBinding instanceof TypeVariableBinding) {
                    blockScope.problemReporter().typeHiding(this, (TypeVariableBinding)referenceBinding);
                    Scope scope = blockScope.parent;
                    while (scope != null) {
                        TypeBinding typeBinding2 = scope.getType(this.name);
                        if (typeBinding2 instanceof TypeVariableBinding && typeBinding2.isValidBinding()) {
                            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)referenceBinding;
                            Binding binding = typeVariableBinding.declaringElement;
                            if (binding instanceof ReferenceBinding && CharOperation.equals(((ReferenceBinding)binding).sourceName(), this.name)) {
                                blockScope.problemReporter().typeCollidesWithEnclosingType(this);
                                break;
                            }
                        } else {
                            if (typeBinding2 instanceof ReferenceBinding && typeBinding2.isValidBinding() && scope.isDefinedInType((ReferenceBinding)typeBinding2)) {
                                blockScope.problemReporter().typeCollidesWithEnclosingType(this);
                                break;
                            }
                            if (typeBinding2 == null) break;
                        }
                        scope = scope.parent;
                    }
                } else if (referenceBinding instanceof LocalTypeBinding && ((LocalTypeBinding)referenceBinding).scope.methodScope() == blockScope.methodScope()) {
                    blockScope.problemReporter().duplicateNestedType(this);
                } else if (referenceBinding instanceof LocalTypeBinding && blockScope.isLambdaSubscope() && blockScope.enclosingLambdaScope().enclosingMethodScope() == ((LocalTypeBinding)referenceBinding).scope.methodScope()) {
                    blockScope.problemReporter().duplicateNestedType(this);
                } else if (blockScope.isDefinedInType(referenceBinding)) {
                    blockScope.problemReporter().typeCollidesWithEnclosingType(this);
                } else if (blockScope.isDefinedInSameUnit(referenceBinding)) {
                    blockScope.problemReporter().typeHiding(this, referenceBinding);
                }
            }
            blockScope.addLocalType(this);
        }
        if (this.binding != null) {
            blockScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
            this.resolve();
            this.updateMaxFieldCount();
        }
    }

    public void resolve(ClassScope classScope) {
        if (this.binding != null && this.binding instanceof LocalTypeBinding) {
            classScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
        }
        this.resolve();
        this.updateMaxFieldCount();
    }

    public void resolve(CompilationUnitScope compilationUnitScope) {
        this.resolve();
        this.updateMaxFieldCount();
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int n) {
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        try {
            if (aSTVisitor.visit(this, compilationUnitScope)) {
                int n;
                int n2;
                if (this.javadoc != null) {
                    this.javadoc.traverse(aSTVisitor, this.scope);
                }
                if (this.annotations != null) {
                    n2 = this.annotations.length;
                    for (n = 0; n < n2; ++n) {
                        this.annotations[n].traverse(aSTVisitor, this.staticInitializerScope);
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n2 = this.superInterfaces.length;
                    for (n = 0; n < n2; ++n) {
                        this.superInterfaces[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.permittedTypes != null) {
                    n2 = this.permittedTypes.length;
                    for (n = 0; n < n2; ++n) {
                        this.permittedTypes[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.typeParameters != null) {
                    n2 = this.typeParameters.length;
                    for (n = 0; n < n2; ++n) {
                        this.typeParameters[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.recordComponents != null) {
                    n2 = this.recordComponents.length;
                    for (n = 0; n < n2; ++n) {
                        this.recordComponents[n].traverse(aSTVisitor, this.initializerScope);
                    }
                }
                if (this.memberTypes != null) {
                    n2 = this.memberTypes.length;
                    for (n = 0; n < n2; ++n) {
                        this.memberTypes[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.fields != null) {
                    for (FieldDeclaration fieldDeclaration : this.fields) {
                        if (fieldDeclaration.isStatic()) {
                            fieldDeclaration.traverse(aSTVisitor, this.staticInitializerScope);
                            continue;
                        }
                        fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                    }
                }
                if (this.methods != null) {
                    n2 = this.methods.length;
                    for (n = 0; n < n2; ++n) {
                        this.methods[n].traverse(aSTVisitor, this.scope);
                    }
                }
            }
            aSTVisitor.endVisit(this, compilationUnitScope);
        }
        catch (AbortType abortType) {
            // empty catch block
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        try {
            if (aSTVisitor.visit(this, blockScope)) {
                int n;
                int n2;
                if (this.javadoc != null) {
                    this.javadoc.traverse(aSTVisitor, this.scope);
                }
                if (this.annotations != null) {
                    n2 = this.annotations.length;
                    for (n = 0; n < n2; ++n) {
                        this.annotations[n].traverse(aSTVisitor, this.staticInitializerScope);
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n2 = this.superInterfaces.length;
                    for (n = 0; n < n2; ++n) {
                        this.superInterfaces[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.permittedTypes != null) {
                    n2 = this.permittedTypes.length;
                    for (n = 0; n < n2; ++n) {
                        this.permittedTypes[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.typeParameters != null) {
                    n2 = this.typeParameters.length;
                    for (n = 0; n < n2; ++n) {
                        this.typeParameters[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.recordComponents != null) {
                    n2 = this.recordComponents.length;
                    for (n = 0; n < n2; ++n) {
                        this.recordComponents[n].traverse(aSTVisitor, this.initializerScope);
                    }
                }
                if (this.memberTypes != null) {
                    n2 = this.memberTypes.length;
                    for (n = 0; n < n2; ++n) {
                        this.memberTypes[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.fields != null) {
                    for (FieldDeclaration fieldDeclaration : this.fields) {
                        if (fieldDeclaration.isStatic() && !fieldDeclaration.isFinal()) continue;
                        fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                    }
                }
                if (this.methods != null) {
                    n2 = this.methods.length;
                    for (n = 0; n < n2; ++n) {
                        this.methods[n].traverse(aSTVisitor, this.scope);
                    }
                }
            }
            aSTVisitor.endVisit(this, blockScope);
        }
        catch (AbortType abortType) {
            // empty catch block
        }
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        try {
            if (aSTVisitor.visit(this, classScope)) {
                int n;
                int n2;
                if (this.javadoc != null) {
                    this.javadoc.traverse(aSTVisitor, this.scope);
                }
                if (this.annotations != null) {
                    n2 = this.annotations.length;
                    for (n = 0; n < n2; ++n) {
                        this.annotations[n].traverse(aSTVisitor, this.staticInitializerScope);
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n2 = this.superInterfaces.length;
                    for (n = 0; n < n2; ++n) {
                        this.superInterfaces[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.permittedTypes != null) {
                    n2 = this.permittedTypes.length;
                    for (n = 0; n < n2; ++n) {
                        this.permittedTypes[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.typeParameters != null) {
                    n2 = this.typeParameters.length;
                    for (n = 0; n < n2; ++n) {
                        this.typeParameters[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.recordComponents != null) {
                    n2 = this.recordComponents.length;
                    for (n = 0; n < n2; ++n) {
                        this.recordComponents[n].traverse(aSTVisitor, this.initializerScope);
                    }
                }
                if (this.memberTypes != null) {
                    n2 = this.memberTypes.length;
                    for (n = 0; n < n2; ++n) {
                        this.memberTypes[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.fields != null) {
                    for (FieldDeclaration fieldDeclaration : this.fields) {
                        if (fieldDeclaration.isStatic()) {
                            fieldDeclaration.traverse(aSTVisitor, this.staticInitializerScope);
                            continue;
                        }
                        fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                    }
                }
                if (this.methods != null) {
                    n2 = this.methods.length;
                    for (n = 0; n < n2; ++n) {
                        this.methods[n].traverse(aSTVisitor, this.scope);
                    }
                }
            }
            aSTVisitor.endVisit(this, classScope);
        }
        catch (AbortType abortType) {
            // empty catch block
        }
    }

    void updateMaxFieldCount() {
        if (this.binding == null) {
            return;
        }
        TypeDeclaration typeDeclaration = this.scope.outerMostClassScope().referenceType();
        if (this.maxFieldCount > typeDeclaration.maxFieldCount) {
            typeDeclaration.maxFieldCount = this.maxFieldCount;
        } else {
            this.maxFieldCount = typeDeclaration.maxFieldCount;
        }
    }

    private SourceTypeBinding findNestHost() {
        ClassScope classScope = this.scope.enclosingTopMostClassScope();
        return classScope != null ? classScope.referenceContext.binding : null;
    }

    void updateNestInfo() {
        if (this.binding == null) {
            return;
        }
        SourceTypeBinding sourceTypeBinding = this.findNestHost();
        if (sourceTypeBinding != null && !this.binding.equals(sourceTypeBinding)) {
            this.binding.setNestHost(sourceTypeBinding);
            sourceTypeBinding.addNestMember(this.binding);
        }
    }

    public boolean isPackageInfo() {
        return CharOperation.equals(this.name, TypeConstants.PACKAGE_INFO_NAME);
    }

    public boolean isSecondary() {
        return (this.bits & 0x1000) != 0;
    }

    static {
        disallowedComponentNames.add("clone");
        disallowedComponentNames.add("finalize");
        disallowedComponentNames.add("getClass");
        disallowedComponentNames.add("hashCode");
        disallowedComponentNames.add("notify");
        disallowedComponentNames.add("notifyAll");
        disallowedComponentNames.add("toString");
        disallowedComponentNames.add("wait");
    }
}

