/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfoWithAnnotations;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;

class MethodInfoWithParameterAnnotations
extends MethodInfoWithAnnotations {
    private AnnotationInfo[][] parameterAnnotations;

    MethodInfoWithParameterAnnotations(MethodInfo methodInfo, AnnotationInfo[] annotationInfoArray, AnnotationInfo[][] annotationInfoArray2) {
        super(methodInfo, annotationInfoArray);
        this.parameterAnnotations = annotationInfoArray2;
    }

    @Override
    public IBinaryAnnotation[] getParameterAnnotations(int n, char[] cArray) {
        try {
            return this.parameterAnnotations == null ? null : this.parameterAnnotations[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            StringBuffer stringBuffer = new StringBuffer("Mismatching number of parameter annotations, ");
            stringBuffer.append(n);
            stringBuffer.append('>');
            stringBuffer.append(this.parameterAnnotations.length - 1);
            stringBuffer.append(" in ");
            stringBuffer.append(this.getSelector());
            char[] cArray2 = this.getGenericSignature();
            if (cArray2 != null) {
                stringBuffer.append(cArray2);
            } else {
                stringBuffer.append(this.getMethodDescriptor());
            }
            if (cArray != null) {
                stringBuffer.append(" in ").append(cArray);
            }
            throw new IllegalStateException(stringBuffer.toString(), arrayIndexOutOfBoundsException);
        }
    }

    @Override
    public int getAnnotatedParametersCount() {
        return this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
    }

    @Override
    protected void initialize() {
        int n;
        int n2 = n = this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
        for (int i = 0; i < n; ++i) {
            int n3;
            AnnotationInfo[] annotationInfoArray = this.parameterAnnotations[i];
            int n4 = n3 = annotationInfoArray == null ? 0 : annotationInfoArray.length;
            for (int j = 0; j < n3; ++j) {
                annotationInfoArray[j].initialize();
            }
        }
        super.initialize();
    }

    @Override
    protected void reset() {
        int n;
        int n2 = n = this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
        for (int i = 0; i < n; ++i) {
            int n3;
            AnnotationInfo[] annotationInfoArray = this.parameterAnnotations[i];
            int n4 = n3 = annotationInfoArray == null ? 0 : annotationInfoArray.length;
            for (int j = 0; j < n3; ++j) {
                annotationInfoArray[j].reset();
            }
        }
        super.reset();
    }
}

