/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import netrexx.lang.NoOtherwiseException;
import netrexx.lang.Rexx;
import netrexx.lang.RexxParse;
import org.netrexx.process.RxClassInfo;
import org.netrexx.process.RxClauseParser;
import org.netrexx.process.RxConvert;
import org.netrexx.process.RxProgram;
import org.netrexx.process.RxType;

public class RxField {
    private static final Rexx $01 = Rexx.toRexx("");
    private static final char[] $02 = new char[]{'\u0001', '\n', '\u0002', '\u0000', '\u0001', '\u0000'};
    private static final Rexx $03 = new Rexx('(');
    private static final Rexx $04 = new Rexx(')');
    private static final Rexx $05 = new Rexx('.');
    private static final Rexx $06 = Rexx.toRexx("static");
    private static final Rexx $07 = Rexx.toRexx("final");
    private static final Rexx $08 = Rexx.toRexx("abstract");
    private static final Rexx $09 = Rexx.toRexx("volatile");
    private static final Rexx $010 = Rexx.toRexx("transient");
    private static final Rexx $011 = Rexx.toRexx("native");
    private static final Rexx $012 = Rexx.toRexx("default");
    private static final String $0 = "RxField.nrx";
    public static final int VIS_UNKNOWN = 0;
    public static final int VIS_PUB = 1;
    public static final int VIS_INHER = 2;
    public static final int VIS_SHAR = 3;
    public static final int VIS_PRIV = 4;
    public static final int ATT_NONE = 0;
    public static final int ATT_STATIC = 1;
    public static final int ATT_FINAL = 2;
    public static final int ATT_ABSTRACT = 4;
    public static final int ATT_DEPRECATED = 8;
    public static final int ATT_SYNTHETIC = 16;
    public static final int ATT_VOLATILE = 32;
    public static final int ATT_TRANSIENT = 64;
    public static final int ATT_NATIVE = 128;
    public static final int ATT_PROTECT = 256;
    public static final int ATT_CONSTVALUE = 512;
    public static final int ATT_DEFAULT = 1024;
    public Rexx fieldname;
    public RxClassInfo fieldinfo;
    public RxProgram fieldprogram;
    public int fieldcount;
    public RxType fieldtype;
    public int fieldvisib;
    public int fieldatts;
    public boolean fieldambig = false;
    public RxClassInfo fieldhidden;
    public RxType[] fieldargtypes;
    public RxConvert[] fieldconvert;
    public Rexx fieldexcep = null;
    public boolean fieldref2 = false;
    public int fieldcost;
    public RxClauseParser fieldlocal;
    public int fieldid;
    public RxField fieldspecial;
    public Object fieldvalue;
    private boolean fieldmethod;
    private static final RxType voidtype = new RxType(null, Rexx.toRexx("void"), 0);
    private static final RxType[] emptytypes = new RxType[0];

    public RxField(RxProgram rxProgram, RxClassInfo rxClassInfo, Rexx rexx, RxType rxType, int n, int n2, RxType[] rxTypeArray) {
        this(rxProgram, rxClassInfo, rexx, rxType, n, n2, rxTypeArray, null);
    }

    public RxField(RxProgram rxProgram, RxClassInfo rxClassInfo, Rexx rexx, RxType rxType, int n, int n2, RxType[] rxTypeArray, Rexx rexx2) {
        this.fieldprogram = rxProgram;
        this.fieldinfo = rxClassInfo;
        this.fieldname = rexx;
        this.fieldtype = rxType;
        this.fieldvisib = n;
        this.fieldatts = n2;
        this.fieldargtypes = rxTypeArray;
        this.fieldexcep = rexx2;
        boolean bl = this.fieldmethod = rxTypeArray != null;
        if (this.fieldexcep != null && this.fieldexcep.OpEqS(null, $01)) {
            this.fieldexcep = null;
        }
    }

    public RxType[] excepTypes() {
        int n = 0;
        Rexx rexx = null;
        if (this.fieldexcep == null) {
            return emptytypes;
        }
        Rexx rexx2 = this.fieldexcep.changestr(new Rexx(','), new Rexx(' '));
        RxType[] rxTypeArray = new RxType[rexx2.words().toint()];
        int n2 = rxTypeArray.length;
        n = 0;
        while (n2 > 0) {
            Rexx[] rexxArray = new Rexx[2];
            RexxParse.parse(rexx2, $02, rexxArray);
            rexx = rexxArray[0];
            rexx2 = rexxArray[1];
            rxTypeArray[n] = new RxType(rexx, 0);
            --n2;
            ++n;
        }
        return rxTypeArray;
    }

    public boolean isMethod() {
        return this.fieldmethod;
    }

    public boolean isConstructor() {
        return this.fieldmethod & this.fieldname.OpEqS(null, Rexx.toRexx(this.fieldinfo.shortname));
    }

    public boolean isDefault() {
        return (this.fieldatts & 0x400) != 0;
    }

    public boolean isStatic() {
        return (this.fieldatts & 1) != 0;
    }

    public boolean isFinal() {
        return (this.fieldatts & 2) != 0;
    }

    public boolean isConstant() {
        return (this.fieldatts & 2) != 0 & (this.fieldatts & 1) != 0;
    }

    public boolean isKnownValue() {
        return (this.fieldatts & 2) != 0 & (this.fieldatts & 0x200) != 0;
    }

    public boolean isDeprecated() {
        return (this.fieldatts & 8) != 0;
    }

    public boolean isAbstract() {
        return (this.fieldatts & 4) != 0;
    }

    public boolean isSynthetic() {
        return (this.fieldatts & 0x10) != 0;
    }

    public boolean isProtected() {
        return (this.fieldatts & 0x100) != 0;
    }

    public boolean isNative() {
        return (this.fieldatts & 0x80) != 0;
    }

    public boolean isVolatile() {
        return (this.fieldatts & 0x20) != 0;
    }

    public boolean isTransient() {
        return (this.fieldatts & 0x40) != 0;
    }

    public String toString(RxProgram rxProgram) {
        Rexx rexx = null;
        if (this.fieldmethod) {
            rexx = rxProgram.toString(this.fieldargtypes);
            if (this.isConstructor()) {
                return Rexx.toString(this.fieldinfo.type.classname.OpCc(null, $03).OpCc(null, rexx).OpCc(null, $04));
            }
            return Rexx.toString(this.fieldinfo.type.classname.OpCc(null, $05).OpCc(null, this.fieldname).OpCc(null, $03).OpCc(null, rexx).OpCc(null, $04));
        }
        return Rexx.toString(this.fieldinfo.type.classname.OpCc(null, $05).OpCc(null, this.fieldname));
    }

    public String toConciseString(RxProgram rxProgram) {
        return this.toConciseString(rxProgram, false);
    }

    public String toConciseString(RxProgram rxProgram, boolean bl) {
        Rexx rexx = null;
        Rexx rexx2 = rxProgram.babel.typeConcise(this.fieldinfo.type);
        if (this.fieldmethod) {
            rexx = rxProgram.toConciseString(this.fieldargtypes);
            if (this.isConstructor()) {
                return Rexx.toString(rexx2.OpCc(null, $03).OpCc(null, rexx).OpCc(null, $04));
            }
            if (rexx.OpNotEqS(null, $01)) {
                rexx = $03.OpCc(null, rexx).OpCc(null, $04);
            }
            if (bl) {
                return Rexx.toString(this.fieldname.OpCc(null, rexx));
            }
            return Rexx.toString(rexx2.OpCc(null, $05).OpCc(null, this.fieldname).OpCc(null, rexx));
        }
        if (bl) {
            return Rexx.toString(this.fieldname);
        }
        return Rexx.toString(rexx2.OpCc(null, $05).OpCc(null, this.fieldname));
    }

    public String JVMsig() {
        RxType rxType = null;
        int n = 0;
        String string = null;
        boolean bl = this.isConstructor();
        String string2 = "";
        if (this.fieldmethod) {
            string2 = string2 + "(";
            if (bl && this.fieldinfo.isdependent) {
                rxType = this.fieldinfo.parentinfo.type;
                string2 = string2 + rxType.toJavaSig().replace('.', '/');
            }
            if (this.fieldargtypes != null) {
                int n2 = this.fieldargtypes.length;
                n = 0;
                while (n2 > 0) {
                    rxType = this.fieldargtypes[n];
                    string2 = string2 + rxType.toJavaSig().replace('.', '/');
                    --n2;
                    ++n;
                }
            }
            string2 = string2 + ")";
        }
        string = this.fieldtype.equals(voidtype) || bl ? "V" : this.fieldtype.toJavaSig().replace('.', '/');
        string2 = string2 + string;
        return string2;
    }

    public static Rexx visibilityToJava(int n) {
        Rexx rexx = null;
        if (n == 1) {
            rexx = Rexx.toRexx("public");
        } else if (n == 2) {
            rexx = Rexx.toRexx("protected");
        } else if (n == 3) {
            rexx = Rexx.toRexx("");
        } else if (n == 4) {
            rexx = Rexx.toRexx("private");
        } else {
            throw new NoOtherwiseException();
        }
        return rexx;
    }

    public static Rexx attributesToJava(int n) {
        Rexx rexx = Rexx.toRexx("");
        if ((n & 1) != 0) {
            rexx = rexx.OpCcblank(null, $06);
        }
        if ((n & 2) != 0) {
            rexx = rexx.OpCcblank(null, $07);
        }
        if ((n & 4) != 0) {
            rexx = rexx.OpCcblank(null, $08);
        }
        if ((n & 0x20) != 0) {
            rexx = rexx.OpCcblank(null, $09);
        }
        if ((n & 0x40) != 0) {
            rexx = rexx.OpCcblank(null, $010);
        }
        if ((n & 0x80) != 0) {
            rexx = rexx.OpCcblank(null, $011);
        }
        if ((n & 0x100) != 0) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("synchronized"));
        }
        if ((n & 0x400) != 0) {
            rexx = rexx.OpCcblank(null, $012);
        }
        return rexx.space();
    }
}

