/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import org.netrexx.process.RxBabel;
import org.netrexx.process.RxQuit;
import org.netrexx.process.RxSource;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxTranslator;

public class RxFileReader
implements RxSource {
    private static final Rexx $01 = new Rexx('.');
    private static final Rexx $02 = Rexx.toRexx("# Reading");
    private static final Rexx $03 = Rexx.toRexx("...");
    private static final Rexx $04 = Rexx.toRexx("# Read");
    private static final String $0 = "RxFileReader.nrx";
    private static final int bitesize = 250;
    private static final Rexx filesep = new Rexx(System.getProperty("file.separator"));
    private Rexx infile;
    private Rexx infilepath;
    private File infileob;
    private String inmemob = null;
    private BufferedReader inhandle;
    private boolean inopen = false;
    private boolean inread = false;
    private Object[] inline;
    private int inspace = 0;
    private int sourcelines = 0;
    private RxTranslator rxt;

    public RxFileReader(RxTranslator rxTranslator) {
        this.rxt = rxTranslator;
    }

    public void openfile(Rexx rexx, String string) {
        this.inmemob = string;
        this.infile = rexx;
        this.infilepath = null;
    }

    public void openfile(Rexx rexx) {
        block18: {
            String[] stringArray;
            int n;
            int n2;
            block17: {
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                RxBabel rxBabel = null;
                Rexx rexx2 = null;
                n2 = 0;
                if (rexx.right(new Rexx(5)).OpEq(null, Rexx.toRexx(".java"))) {
                    throw new RxQuit(this.rxt, (RxToken)null, "cannot.translate.java", rexx);
                }
                if (rexx.right(new Rexx(6)).OpEq(null, Rexx.toRexx(".class"))) {
                    throw new RxQuit(this.rxt, (RxToken)null, "cannot.translate.class", rexx);
                }
                this.infileob = new File(Rexx.toString(rexx));
                if (!this.infileob.exists() | this.infileob.isDirectory()) {
                    n3 = rexx.lastpos(new Rexx('.')).toint();
                    if (n3 == 0 | n3 < (n4 = rexx.lastpos(filesep).toint())) {
                        n = this.rxt.babels.length;
                        n5 = 0;
                        while (n > 0) {
                            rxBabel = this.rxt.babels[n5];
                            rexx2 = $01.OpCc(null, rxBabel.getExtension());
                            if (rexx.right(rexx2.length()).OpNotEqS(null, rexx2)) {
                                this.infileob = new File(Rexx.toString(rexx.OpCc(null, rexx2)));
                                if (this.infileob.exists() && !this.infileob.isDirectory()) break block17;
                            }
                            --n;
                            ++n5;
                        }
                        if (this.rxt.babels.length == 1) {
                            rexx = rexx.OpCc(null, rexx2);
                        }
                    }
                    throw new RxQuit(this.rxt, (RxToken)null, "file.not.found", rexx);
                }
            }
            if (!this.infileob.canRead()) {
                throw new RxQuit(this.rxt, (RxToken)null, "file.may.not.be.read", rexx);
            }
            this.infile = Rexx.toRexx(this.infileob.getName());
            String string = this.infileob.getParent();
            if (string == null) {
                string = ".";
            }
            if ((stringArray = new File(string).list()) != null) {
                n = stringArray.length;
                n2 = 0;
                while (n > 0) {
                    if (!Rexx.toRexx(stringArray[n2]).OpEqS(null, this.infile)) {
                        --n;
                        ++n2;
                        continue;
                    }
                    break block18;
                }
                n = stringArray.length;
                n2 = 0;
                while (n > 0) {
                    if (new Rexx(stringArray[n2]).OpEq(null, this.infile)) {
                        this.infile = Rexx.toRexx(stringArray[n2]);
                        break;
                    }
                    --n;
                    ++n2;
                }
            }
        }
        Rexx rexx3 = Rexx.toRexx(this.infileob.getAbsolutePath());
        this.infilepath = rexx3.left(new Rexx(rexx3.length().toint() - this.infile.length().toint()));
        if (this.infilepath.length().toint() == 0) {
            this.infilepath = null;
        }
    }

    @Override
    public String getShortName() {
        Rexx rexx = null;
        int n = this.infile.lastpos(filesep).toint();
        rexx = n > 0 ? this.infile.substr(new Rexx(n + 1)) : this.infile;
        int n2 = rexx.lastpos(new Rexx('.')).toint();
        if (n2 < 2) {
            n2 = rexx.length().toint() + 1;
        }
        return rexx.left(new Rexx(n2 - 1)).toString();
    }

    @Override
    public String getName() {
        return this.infile.toString();
    }

    @Override
    public String getPath() {
        return Rexx.toString(this.infilepath);
    }

    @Override
    public int getLineCount() {
        return this.sourcelines;
    }

    public void recover() {
        this.inline = null;
    }

    @Override
    public void close() {
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# closeinput");
        }
        if (this.inhandle != null) {
            try {
                this.inhandle.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.inhandle = null;
            }
        }
        this.inline = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] getLine(int n) {
        FileInputStream fileInputStream = null;
        IOException iOException = null;
        String string = null;
        char[] cArray = null;
        int n2 = 0;
        Object[] objectArray = null;
        if (n < 1) {
            return null;
        }
        if (!this.inopen) {
            this.inopen = true;
            if (this.inmemob != null) {
                this.inhandle = new BufferedReader(new StringReader(this.inmemob));
            } else {
                try {
                    fileInputStream = new FileInputStream(this.infileob);
                    this.inhandle = !this.rxt.superflag.utf8 ? new BufferedReader(new InputStreamReader(fileInputStream)) : new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF8"));
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    throw new RxQuit(this.rxt, null, "error.opening.file", this.infile, Rexx.toRexx(iOException.getMessage()));
                }
            }
            if (this.rxt.superflag.diag) {
                RexxIO.Say($02.OpCcblank(null, this.infile).OpCc(null, $03));
            }
            this.inline = new Object[250];
            this.inspace = 250;
        }
        if (n > this.sourcelines) {
            if (this.inread) {
                return null;
            }
            if (n > this.sourcelines + 1) {
                return null;
            }
            try {
                string = this.inhandle.readLine();
            }
            catch (IOException iOException3) {
                iOException = iOException3;
                throw new RxQuit(this.rxt, null, "error.reading.file", this.infile, Rexx.toRexx(iOException.getMessage()));
            }
            if (string == null) {
                cArray = null;
            } else {
                cArray = string.toCharArray();
                n2 = cArray.length - 1;
                if (n2 >= 0 && cArray[n2] == '\u001a') {
                    cArray = n2 == 0 ? (char[])null : string.substring(0, n2).toCharArray();
                }
            }
            if (cArray == null) {
                try {
                    this.inhandle.close();
                }
                catch (IOException iOException4) {}
                finally {
                    this.inhandle = null;
                    this.inread = true;
                    if (this.rxt.superflag.diag) {
                        RexxIO.Say($04.OpCcblank(null, this.infile).OpCc(null, $01));
                    }
                    return null;
                }
            }
            if (this.inspace == 0) {
                objectArray = new Object[this.inline.length + 250];
                this.inspace = 250;
                System.arraycopy(this.inline, 0, objectArray, 0, this.inline.length);
                this.inline = objectArray;
            }
            ++this.sourcelines;
            this.inline[this.sourcelines - 1] = cArray;
            --this.inspace;
        }
        return (char[])this.inline[n - 1];
    }
}

