/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import netrexx.lang.NoOtherwiseException;
import netrexx.lang.Rexx;

public class RxType {
    private static final Rexx $01 = new Rexx('.');
    private static final Rexx $02 = new Rexx('[');
    private static final Rexx $03 = new Rexx(']');
    private static final Rexx $04 = new Rexx('L');
    private static final Rexx $05 = new Rexx(';');
    private static final Rexx $06 = new Rexx(',');
    private static final String $0 = "RxType.nrx";
    static final Rexx OBJECT_CLASS = Rexx.toRexx("java.lang.Object");
    static final Rexx CLASS_CLASS = Rexx.toRexx("java.lang.Class");
    static final Rexx THROWABLE_CLASS = Rexx.toRexx("java.lang.Throwable");
    static final Rexx STRING_CLASS = Rexx.toRexx("java.lang.String");
    static final Rexx CHARSEQUENCE_CLASS = Rexx.toRexx("java.lang.CharSequence");
    static final Rexx STRINGARRAY_CLASS = Rexx.toRexx("java.lang.String[]");
    static final Rexx ENUM_CLASS = Rexx.toRexx("java.util.Enumeration");
    static final Rexx VECTOR_CLASS = Rexx.toRexx("java.util.Vector");
    static final Rexx MAP_CLASS = Rexx.toRexx("java.util.Map");
    static final Rexx BOOL_CLASS = Rexx.toRexx("boolean");
    static final Rexx CHAR_CLASS = Rexx.toRexx("char");
    static final Rexx BYTE_CLASS = Rexx.toRexx("byte");
    static final Rexx SHORT_CLASS = Rexx.toRexx("short");
    static final Rexx INT_CLASS = Rexx.toRexx("int");
    static final Rexx LONG_CLASS = Rexx.toRexx("long");
    static final Rexx FLOAT_CLASS = Rexx.toRexx("float");
    static final Rexx DOUBLE_CLASS = Rexx.toRexx("double");
    static final Rexx CHARARRAY_CLASS = Rexx.toRexx("char[]");
    static final Rexx NULL_CLASS = Rexx.toRexx("null");
    static final Rexx VOID_CLASS = Rexx.toRexx("void");
    static final RxType OBJECT_TYPE = new RxType(OBJECT_CLASS, 0);
    static final RxType CLASS_TYPE = new RxType(CLASS_CLASS, 0);
    static final RxType THROWABLE_TYPE = new RxType(THROWABLE_CLASS, 0);
    static final RxType CHARSEQUENCE_TYPE = new RxType(CHARSEQUENCE_CLASS, 0);
    static final RxType STRING_TYPE = new RxType(STRING_CLASS, 0);
    static final RxType STRINGARRAY_TYPE = new RxType(STRING_CLASS, 1);
    static final RxType ENUM_TYPE = new RxType(ENUM_CLASS, 0);
    static final RxType VECTOR_TYPE = new RxType(VECTOR_CLASS, 0);
    static final RxType MAP_TYPE = new RxType(MAP_CLASS, 0);
    static final RxType BOOL_TYPE = new RxType(BOOL_CLASS, 0);
    static final RxType CHAR_TYPE = new RxType(CHAR_CLASS, 0);
    static final RxType BYTE_TYPE = new RxType(BYTE_CLASS, 0);
    static final RxType SHORT_TYPE = new RxType(SHORT_CLASS, 0);
    static final RxType INT_TYPE = new RxType(INT_CLASS, 0);
    static final RxType LONG_TYPE = new RxType(LONG_CLASS, 0);
    static final RxType FLOAT_TYPE = new RxType(FLOAT_CLASS, 0);
    static final RxType DOUBLE_TYPE = new RxType(DOUBLE_CLASS, 0);
    static final RxType CHARARRAY_TYPE = new RxType(CHAR_CLASS, 1);
    static final RxType NULL_TYPE = new RxType(NULL_CLASS, 0);
    static final RxType VOID_TYPE = new RxType(VOID_CLASS, 0);
    static final RxType[] EMPTY_TYPES = new RxType[0];
    static final Rexx PRIMITIVES = Rexx.toRexx("int long short char byte float double boolean");
    static final Rexx PRIMITIVE_SIGS = Rexx.toRexx("I J S C B F D Z");
    static final Rexx BOOLEAN_LITS = Rexx.toRexx("0 1 '0' '1' \"0\" \"1\"");
    static final Rexx REXX_CLASS = Rexx.toRexx("netrexx.lang.Rexx");
    static final Rexx REXXSET_CLASS = Rexx.toRexx("netrexx.lang.RexxSet");
    static final Rexx REXXPARSE_CLASS = Rexx.toRexx("netrexx.lang.RexxParse");
    static final Rexx REXXTRACE_CLASS = Rexx.toRexx("netrexx.lang.RexxTrace");
    static final Rexx REXXUTIL_CLASS = Rexx.toRexx("netrexx.lang.RexxUtil");
    static final Rexx REXXNOOTHER_CLASS = Rexx.toRexx("netrexx.lang.NoOtherwiseException");
    static final Rexx REXXIO_CLASS = Rexx.toRexx("netrexx.lang.RexxIO");
    static final Rexx REXXADDRESS_CLASS = Rexx.toRexx("netrexx.lang.RexxAddress");
    static final RxType REXX_TYPE = new RxType(REXX_CLASS, 0);
    static final RxType REXXSET_TYPE = new RxType(REXXSET_CLASS, 0);
    static final RxType REXXPARSE_TYPE = new RxType(REXXPARSE_CLASS, 0);
    static final RxType REXXTRACE_TYPE = new RxType(REXXTRACE_CLASS, 0);
    static final RxType REXXUTIL_TYPE = new RxType(REXXUTIL_CLASS, 0);
    static final RxType REXXNOOTHER_TYPE = new RxType(REXXNOOTHER_CLASS, 0);
    static final RxType REXXIO_TYPE = new RxType(REXXIO_CLASS, 0);
    public Rexx classname;
    public int dimension = 0;
    private Rexx packagename;
    private Rexx classfilename;
    private Class ourclass;
    private boolean primitive;
    private boolean hadprimitive;

    public RxType(Rexx rexx, int n) {
        this.dimension = n;
        this.split(rexx);
    }

    public RxType(Rexx rexx, Rexx rexx2, int n) {
        this.packagename = rexx;
        this.classfilename = rexx2.changestr(new Rexx('.'), new Rexx('$'));
        this.dimension = n;
        this.classname = rexx == null ? rexx2 : rexx.OpCc(null, $01).OpCc(null, rexx2);
    }

    private void split(Rexx rexx) {
        int n = rexx.lastpos(new Rexx('.')).toint();
        if (n == 0) {
            this.classfilename = rexx;
            this.packagename = null;
            this.classname = rexx.changestr(new Rexx('$'), new Rexx('.'));
        } else {
            this.classfilename = rexx.substr(new Rexx(n + 1));
            this.packagename = rexx.left(new Rexx(n - 1));
            this.classname = this.packagename.OpCc(null, $01).OpCc(null, this.classfilename.changestr(new Rexx('$'), new Rexx('.')));
        }
    }

    public boolean equals(Object object) {
        RxType rxType = (RxType)object;
        if (this.dimension != rxType.dimension) {
            return false;
        }
        return this.classname.OpEqS(null, rxType.classname);
    }

    public boolean isarray() {
        return this.dimension > 0;
    }

    public boolean isPrimitive() {
        if (!this.hadprimitive) {
            if (this.dimension == 0) {
                this.primitive = this.isBasePrimitive();
            }
            this.hadprimitive = true;
        }
        return this.primitive;
    }

    public boolean isBasePrimitive() {
        if (this.packagename != null) {
            return false;
        }
        if (this.classname.length().toint() > 7) {
            return false;
        }
        return PRIMITIVES.wordpos(this.classname, new Rexx(1)).toint() > 0;
    }

    public boolean isNull() {
        if (this.classname.length().toint() != 4) {
            return false;
        }
        if (this.dimension > 0) {
            return false;
        }
        return this.classname.OpEqS(null, NULL_CLASS);
    }

    public RxType basetype() {
        return this.basetype(0);
    }

    public RxType basetype(int n) {
        return new RxType(this.packagename, this.classfilename.changestr(new Rexx('$'), new Rexx('.')), n);
    }

    public Rexx toJava() {
        if (this.dimension == 0) {
            return this.classname;
        }
        return this.classname.OpCc(null, $02).OpCc(null, Rexx.toRexx("][").copies(new Rexx(this.dimension - 1))).OpCc(null, $03);
    }

    public Class getClassObject() {
        return this.getClassObject(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class getClassObject(ClassLoader classLoader) {
        String string = null;
        if (this.ourclass != null) return this.ourclass;
        if (this.isPrimitive()) {
            if (this.classname.OpEqS(null, Rexx.toRexx("int"))) {
                this.ourclass = Integer.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("byte"))) {
                this.ourclass = Byte.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("short"))) {
                this.ourclass = Short.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("long"))) {
                this.ourclass = Long.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("char"))) {
                this.ourclass = Character.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("float"))) {
                this.ourclass = Float.TYPE;
                return this.ourclass;
            } else if (this.classname.OpEqS(null, Rexx.toRexx("double"))) {
                this.ourclass = Double.TYPE;
                return this.ourclass;
            } else {
                if (!this.classname.OpEqS(null, Rexx.toRexx("boolean"))) throw new NoOtherwiseException();
                this.ourclass = Boolean.TYPE;
            }
            return this.ourclass;
        }
        try {
            string = this.dimension == 0 ? (this.packagename == null ? Rexx.toString(this.classfilename) : Rexx.toString(this.packagename.OpCc(null, $01).OpCc(null, this.classfilename))) : this.toJavaSig();
            this.ourclass = classLoader == null ? Class.forName(string) : Class.forName(string, true, classLoader);
            return this.ourclass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.ourclass = null;
        }
        return this.ourclass;
    }

    public Rexx toSig() {
        if (this.dimension == 0) {
            return this.classname;
        }
        return this.classname.OpCc(null, $02).OpCc(null, new Rexx(',').copies(new Rexx(this.dimension - 1))).OpCc(null, $03);
    }

    public String toJavaSig() {
        int n = 0;
        Rexx rexx = null;
        n = this.packagename != null || this.classname.length().toint() > 7 ? 0 : PRIMITIVES.wordpos(this.classname, new Rexx(1)).toint();
        rexx = n == 0 ? (this.packagename == null ? $04.OpCc(null, this.classfilename).OpCc(null, $05) : $04.OpCc(null, this.packagename).OpCc(null, $01).OpCc(null, this.classfilename).OpCc(null, $05)) : PRIMITIVE_SIGS.word(new Rexx(n));
        if (this.dimension > 0) {
            return Rexx.toString(new Rexx('[').copies(new Rexx(this.dimension)).OpCc(null, rexx));
        }
        return Rexx.toString(rexx);
    }

    public String toString() {
        return this.toSig().toString();
    }

    public static Rexx toJavaString(RxType[] rxTypeArray) {
        int n = 0;
        Rexx rexx = Rexx.toRexx("");
        if (rxTypeArray != null) {
            int n2 = rxTypeArray.length;
            n = 0;
            while (n2 > 0) {
                if (n > 0) {
                    rexx = rexx.OpCc(null, $06);
                }
                rexx = rexx.OpCc(null, rxTypeArray[n].toJava());
                --n2;
                ++n;
            }
        }
        return rexx;
    }

    public Rexx getPackageName() {
        return this.packagename;
    }

    public Rexx getClassName() {
        return this.classfilename.changestr(new Rexx('$'), new Rexx('.'));
    }

    public Rexx getClassFileName() {
        return this.classfilename;
    }
}

