/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jline.builtins.NfaMatcher;
import org.jline.reader.Candidate;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class Completers {

    public static class RegexCompleter
    implements org.jline.reader.Completer {
        private final NfaMatcher<String> matcher;
        private final Function<String, org.jline.reader.Completer> completers;
        private final ThreadLocal<LineReader> reader = new ThreadLocal();

        public RegexCompleter(String syntax, Function<String, org.jline.reader.Completer> completers) {
            this.matcher = new NfaMatcher<String>(syntax, this::doMatch);
            this.completers = completers;
        }

        @Override
        public synchronized void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            List<String> words = line.words().subList(0, line.wordIndex());
            this.reader.set(reader);
            Set<String> next = this.matcher.matchPartial(words);
            for (String n : next) {
                this.completers.apply(n).complete(reader, new ArgumentLine(line.word(), line.wordCursor()), candidates);
            }
            this.reader.set(null);
        }

        private boolean doMatch(String arg, String name) {
            ArrayList<Candidate> candidates = new ArrayList<Candidate>();
            LineReader r = this.reader.get();
            boolean caseInsensitive = r != null && r.isSet(LineReader.Option.CASE_INSENSITIVE);
            this.completers.apply(name).complete(r, new ArgumentLine(arg, arg.length()), candidates);
            return candidates.stream().anyMatch(c -> caseInsensitive ? c.value().equalsIgnoreCase(arg) : c.value().equals(arg));
        }

        public static class ArgumentLine
        implements ParsedLine {
            private final String word;
            private final int cursor;

            public ArgumentLine(String word, int cursor) {
                this.word = word;
                this.cursor = cursor;
            }

            @Override
            public String word() {
                return this.word;
            }

            @Override
            public int wordCursor() {
                return this.cursor;
            }

            @Override
            public int wordIndex() {
                return 0;
            }

            @Override
            public List<String> words() {
                return Collections.singletonList(this.word);
            }

            @Override
            public String line() {
                return this.word;
            }

            @Override
            public int cursor() {
                return this.cursor;
            }
        }
    }

    public static class TreeCompleter
    implements org.jline.reader.Completer {
        final Map<String, org.jline.reader.Completer> completers = new HashMap<String, org.jline.reader.Completer>();
        final RegexCompleter completer;

        public TreeCompleter(Node ... nodes) {
            this(Arrays.asList(nodes));
        }

        public TreeCompleter(List<Node> nodes) {
            StringBuilder sb = new StringBuilder();
            this.addRoots(sb, nodes);
            this.completer = new RegexCompleter(sb.toString(), this.completers::get);
        }

        public static Node node(Object ... objs) {
            org.jline.reader.Completer comp = null;
            ArrayList<Candidate> cands = new ArrayList<Candidate>();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Object obj : objs) {
                if (obj instanceof String) {
                    cands.add(new Candidate((String)obj));
                    continue;
                }
                if (obj instanceof Candidate) {
                    cands.add((Candidate)obj);
                    continue;
                }
                if (obj instanceof Node) {
                    nodes.add((Node)obj);
                    continue;
                }
                if (obj instanceof org.jline.reader.Completer) {
                    comp = (org.jline.reader.Completer)obj;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if (comp != null) {
                if (!cands.isEmpty()) {
                    throw new IllegalArgumentException();
                }
                return new Node(comp, nodes);
            }
            if (!cands.isEmpty()) {
                return new Node((r, l, c) -> c.addAll(cands), nodes);
            }
            throw new IllegalArgumentException();
        }

        void addRoots(StringBuilder sb, List<Node> nodes) {
            if (!nodes.isEmpty()) {
                sb.append(" ( ");
                boolean first = true;
                for (Node n : nodes) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(" | ");
                    }
                    String name = "c" + this.completers.size();
                    this.completers.put(name, n.completer);
                    sb.append(name);
                    this.addRoots(sb, n.nodes);
                }
                sb.append(" ) ");
            }
        }

        @Override
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            this.completer.complete(reader, line, candidates);
        }

        public static class Node {
            final org.jline.reader.Completer completer;
            final List<Node> nodes;

            public Node(org.jline.reader.Completer completer, List<Node> nodes) {
                this.completer = completer;
                this.nodes = nodes;
            }
        }
    }

    public static class FileNameCompleter
    implements org.jline.reader.Completer {
        @Override
        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            Path current;
            String curBuf;
            String sep;
            assert (commandLine != null);
            assert (candidates != null);
            String buffer = commandLine.word().substring(0, commandLine.wordCursor());
            int lastSep = buffer.lastIndexOf(sep = this.getSeparator());
            if (lastSep >= 0) {
                curBuf = buffer.substring(0, lastSep + 1);
                current = curBuf.startsWith("~") ? (curBuf.startsWith("~" + sep) ? this.getUserHome().resolve(curBuf.substring(2)) : this.getUserHome().getParent().resolve(curBuf.substring(1))) : this.getUserDir().resolve(curBuf);
            } else {
                curBuf = "";
                current = this.getUserDir();
            }
            try (DirectoryStream<Path> directory = Files.newDirectoryStream(current, this::accept);){
                directory.forEach(p -> {
                    String value = curBuf + p.getFileName().toString();
                    if (Files.isDirectory(p, new LinkOption[0])) {
                        candidates.add(new Candidate(value + (reader.isSet(LineReader.Option.AUTO_PARAM_SLASH) ? sep : ""), this.getDisplay(reader.getTerminal(), (Path)p), null, null, reader.isSet(LineReader.Option.AUTO_REMOVE_SLASH) ? sep : null, null, false));
                    } else {
                        candidates.add(new Candidate(value, this.getDisplay(reader.getTerminal(), (Path)p), null, null, null, null, true));
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected boolean accept(Path path) {
            try {
                return !Files.isHidden(path);
            }
            catch (IOException e) {
                return false;
            }
        }

        protected Path getUserDir() {
            return Paths.get(System.getProperty("user.dir"), new String[0]);
        }

        protected Path getUserHome() {
            return Paths.get(System.getProperty("user.home"), new String[0]);
        }

        protected String getSeparator() {
            return this.getUserDir().getFileSystem().getSeparator();
        }

        protected String getDisplay(Terminal terminal, Path p) {
            String name = p.getFileName().toString();
            if (Files.isDirectory(p, new LinkOption[0])) {
                AttributedStringBuilder sb = new AttributedStringBuilder();
                sb.styled(AttributedStyle.BOLD.foreground(1), (CharSequence)name);
                sb.append("/");
                name = sb.toAnsi(terminal);
            } else if (Files.isSymbolicLink(p)) {
                AttributedStringBuilder sb = new AttributedStringBuilder();
                sb.styled(AttributedStyle.BOLD.foreground(1), (CharSequence)name);
                sb.append("@");
                name = sb.toAnsi(terminal);
            }
            return name;
        }
    }

    public static class FilesCompleter
    extends FileNameCompleter {
        private final Supplier<Path> currentDir;
        private final boolean forceSlash;

        public FilesCompleter(File currentDir) {
            this(currentDir.toPath(), false);
        }

        public FilesCompleter(File currentDir, boolean forceSlash) {
            this(currentDir.toPath(), forceSlash);
        }

        public FilesCompleter(Path currentDir) {
            this(currentDir, false);
        }

        public FilesCompleter(Path currentDir, boolean forceSlash) {
            this.currentDir = () -> currentDir;
            this.forceSlash = forceSlash;
        }

        public FilesCompleter(Supplier<Path> currentDir) {
            this(currentDir, false);
        }

        public FilesCompleter(Supplier<Path> currentDir, boolean forceSlash) {
            this.currentDir = currentDir;
            this.forceSlash = forceSlash;
        }

        @Override
        protected Path getUserDir() {
            return this.currentDir.get();
        }

        @Override
        protected String getSeparator() {
            return this.forceSlash ? "/" : this.getUserDir().getFileSystem().getSeparator();
        }
    }

    public static class DirectoriesCompleter
    extends FileNameCompleter {
        private final Supplier<Path> currentDir;
        private final boolean forceSlash;

        public DirectoriesCompleter(File currentDir) {
            this(currentDir.toPath(), false);
        }

        public DirectoriesCompleter(File currentDir, boolean forceSlash) {
            this(currentDir.toPath(), forceSlash);
        }

        public DirectoriesCompleter(Path currentDir) {
            this(currentDir, false);
        }

        public DirectoriesCompleter(Path currentDir, boolean forceSlash) {
            this.currentDir = () -> currentDir;
            this.forceSlash = forceSlash;
        }

        public DirectoriesCompleter(Supplier<Path> currentDir) {
            this(currentDir, false);
        }

        public DirectoriesCompleter(Supplier<Path> currentDir, boolean forceSlash) {
            this.currentDir = currentDir;
            this.forceSlash = forceSlash;
        }

        @Override
        protected Path getUserDir() {
            return this.currentDir.get();
        }

        @Override
        protected String getSeparator() {
            return this.forceSlash ? "/" : this.getUserDir().getFileSystem().getSeparator();
        }

        @Override
        protected boolean accept(Path path) {
            return Files.isDirectory(path, new LinkOption[0]) && super.accept(path);
        }
    }

    public static class Completer
    implements org.jline.reader.Completer {
        private final CompletionEnvironment environment;

        public Completer(CompletionEnvironment environment) {
            this.environment = environment;
        }

        @Override
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            if (line.wordIndex() == 0) {
                this.completeCommand(candidates);
            } else {
                this.tryCompleteArguments(reader, line, candidates);
            }
        }

        protected void tryCompleteArguments(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            List<CompletionData> cmd;
            String command = line.words().get(0);
            String resolved = this.environment.resolveCommand(command);
            Map<String, List<CompletionData>> comp = this.environment.getCompletions();
            if (comp != null && (cmd = comp.get(resolved)) != null) {
                this.completeCommandArguments(reader, line, candidates, cmd);
            }
        }

        protected void completeCommandArguments(LineReader reader, ParsedLine line, List<Candidate> candidates, List<CompletionData> completions) {
            for (CompletionData completion : completions) {
                Object res;
                boolean isOption = line.word().startsWith("-");
                String prevOption = line.wordIndex() >= 2 && line.words().get(line.wordIndex() - 1).startsWith("-") ? line.words().get(line.wordIndex() - 1) : null;
                String key = UUID.randomUUID().toString();
                boolean conditionValue = true;
                if (completion.condition != null) {
                    res = Boolean.FALSE;
                    try {
                        res = this.environment.evaluate(reader, line, completion.condition);
                    }
                    catch (Throwable t) {
                        t.getCause();
                    }
                    conditionValue = this.isTrue(res);
                }
                if (conditionValue && isOption && completion.options != null) {
                    for (String opt : completion.options) {
                        candidates.add(new Candidate(opt, opt, "options", completion.description, null, key, true));
                    }
                    continue;
                }
                if (!isOption && prevOption != null && completion.argument != null && completion.options != null && completion.options.contains(prevOption)) {
                    res = null;
                    try {
                        res = this.environment.evaluate(reader, line, completion.argument);
                    }
                    catch (Throwable opt) {
                        // empty catch block
                    }
                    if (res instanceof Candidate) {
                        candidates.add((Candidate)res);
                        continue;
                    }
                    if (res instanceof String) {
                        candidates.add(new Candidate((String)res, (String)res, null, null, null, null, true));
                        continue;
                    }
                    if (res instanceof Collection) {
                        for (Object s : (Collection)res) {
                            if (s instanceof Candidate) {
                                candidates.add((Candidate)s);
                                continue;
                            }
                            if (!(s instanceof String)) continue;
                            candidates.add(new Candidate((String)s, (String)s, null, null, null, null, true));
                        }
                        continue;
                    }
                    if (res == null || !res.getClass().isArray()) continue;
                    int l = Array.getLength(res);
                    for (int i = 0; i < l; ++i) {
                        Object s = Array.get(res, i);
                        if (s instanceof Candidate) {
                            candidates.add((Candidate)s);
                            continue;
                        }
                        if (!(s instanceof String)) continue;
                        candidates.add(new Candidate((String)s, (String)s, null, null, null, null, true));
                    }
                    continue;
                }
                if (isOption || completion.argument == null) continue;
                res = null;
                try {
                    res = this.environment.evaluate(reader, line, completion.argument);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (res instanceof Candidate) {
                    candidates.add((Candidate)res);
                    continue;
                }
                if (res instanceof String) {
                    candidates.add(new Candidate((String)res, (String)res, null, completion.description, null, null, true));
                    continue;
                }
                if (!(res instanceof Collection)) continue;
                for (Object s : (Collection)res) {
                    if (s instanceof Candidate) {
                        candidates.add((Candidate)s);
                        continue;
                    }
                    if (!(s instanceof String)) continue;
                    candidates.add(new Candidate((String)s, (String)s, null, completion.description, null, null, true));
                }
            }
        }

        protected void completeCommand(List<Candidate> candidates) {
            Set<String> commands = this.environment.getCommands();
            for (String command : commands) {
                List<CompletionData> completions;
                String name = this.environment.commandName(command);
                boolean resolved = command.equals(this.environment.resolveCommand(name));
                if (name.startsWith("_")) continue;
                String desc = null;
                Map<String, List<CompletionData>> comp = this.environment.getCompletions();
                if (comp != null && (completions = comp.get(command)) != null) {
                    for (CompletionData completion : completions) {
                        if (completion.description == null || completion.options != null || completion.argument != null || completion.condition != null) continue;
                        desc = completion.description;
                    }
                }
                String key = UUID.randomUUID().toString();
                if (desc != null) {
                    candidates.add(new Candidate(command, command, null, desc, null, key, true));
                    if (!resolved) continue;
                    candidates.add(new Candidate(name, name, null, desc, null, key, true));
                    continue;
                }
                candidates.add(new Candidate(command, command, null, null, null, key, true));
                if (!resolved) continue;
                candidates.add(new Candidate(name, name, null, null, null, key, true));
            }
        }

        private boolean isTrue(Object result) {
            if (result == null) {
                return false;
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof Number && 0 == ((Number)result).intValue()) {
                return false;
            }
            return !"".equals(result) && !"0".equals(result);
        }
    }

    public static class CompletionData {
        public final List<String> options;
        public final String description;
        public final String argument;
        public final String condition;

        public CompletionData(List<String> options, String description, String argument, String condition) {
            this.options = options;
            this.description = description;
            this.argument = argument;
            this.condition = condition;
        }
    }

    public static interface CompletionEnvironment {
        public Map<String, List<CompletionData>> getCompletions();

        public Set<String> getCommands();

        public String resolveCommand(String var1);

        public String commandName(String var1);

        public Object evaluate(LineReader var1, ParsedLine var2, String var3) throws Exception;
    }
}

