/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.charts.skin;

import eu.hansolo.enzo.charts.SimplePieChart;
import eu.hansolo.enzo.common.Util;
import eu.hansolo.enzo.fonts.Fonts;
import java.util.Locale;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class SimplePieChartSkin
extends SkinBase<SimplePieChart>
implements Skin<SimplePieChart> {
    private static final double PREFERRED_WIDTH = 200.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private Pane pane;
    private Canvas dataCanvas;
    private GraphicsContext dataCtx;
    private Region info;
    private Text sum;
    private Text title;
    private double angleStep;
    private double interactiveAngle;

    public SimplePieChartSkin(SimplePieChart chart) {
        super((Control)chart);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((SimplePieChart)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((SimplePieChart)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((SimplePieChart)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((SimplePieChart)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((SimplePieChart)this.getSkinnable()).getPrefWidth() > 0.0 && ((SimplePieChart)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((SimplePieChart)this.getSkinnable()).setPrefSize(((SimplePieChart)this.getSkinnable()).getPrefWidth(), ((SimplePieChart)this.getSkinnable()).getPrefHeight());
            } else {
                ((SimplePieChart)this.getSkinnable()).setPrefSize(200.0, 200.0);
            }
        }
        if (Double.compare(((SimplePieChart)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((SimplePieChart)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((SimplePieChart)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((SimplePieChart)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((SimplePieChart)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((SimplePieChart)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        Fonts.robotoLight(12.0);
        this.dataCanvas = new Canvas(200.0, 200.0);
        this.dataCtx = this.dataCanvas.getGraphicsContext2D();
        this.info = new Region();
        this.info.getStyleClass().setAll((Object[])new String[]{"info"});
        this.sum = new Text(String.format(Locale.US, "%." + ((SimplePieChart)this.getSkinnable()).getDecimals() + "f", ((SimplePieChart)this.getSkinnable()).getSum()));
        this.sum.setMouseTransparent(true);
        this.sum.setTextOrigin(VPos.CENTER);
        this.sum.getStyleClass().setAll((Object[])new String[]{"info-text"});
        this.title = new Text(((SimplePieChart)this.getSkinnable()).getTitle());
        this.title.setTextOrigin(VPos.CENTER);
        this.title.getStyleClass().setAll((Object[])new String[]{"title"});
        this.pane = new Pane();
        this.pane.getStyleClass().setAll((Object[])new String[]{"simple-pie-chart"});
        this.pane.getChildren().setAll((Object[])new Node[]{this.dataCanvas, this.info, this.sum, this.title});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((SimplePieChart)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimplePieChart)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimplePieChart)this.getSkinnable()).sumProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimplePieChart)this.getSkinnable()).titleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimplePieChart)this.getSkinnable()).infoColorProperty().addListener(observable -> this.handleControlPropertyChanged("INFO_COLOR"));
        ((SimplePieChart)this.getSkinnable()).sectionTextVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimplePieChart)this.getSkinnable()).infoTextColorProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimplePieChart)this.getSkinnable()).titleTextColorProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimplePieChart)this.getSkinnable()).sectionTextColorProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimplePieChart)this.getSkinnable()).getData().addListener(change -> this.handleControlPropertyChanged("RESIZE"));
        this.dataCanvas.setOnMouseDragged(mouseEvent -> this.touchRotate(mouseEvent.getSceneX() - ((SimplePieChart)this.getSkinnable()).getLayoutX(), mouseEvent.getSceneY() - ((SimplePieChart)this.getSkinnable()).getLayoutY()));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("INFO_COLOR".equals(PROPERTY)) {
            this.info.setStyle("-info-color: " + Util.colorToCss((Color)((SimplePieChart)this.getSkinnable()).getInfoColor()));
        }
    }

    private void touchRotate(double X, double Y) {
        double theta = this.getTheta(X, Y);
        this.interactiveAngle = (theta + 90.0) % 360.0;
        this.dataCanvas.setRotate(this.interactiveAngle);
    }

    private double getTheta(double x, double y) {
        double nx;
        double deltaY = y - this.size * 0.5;
        double deltaX = x - this.size * 0.5;
        double radius = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        double ny = deltaY / radius;
        double theta = Math.atan2(ny, nx = deltaX / radius);
        return Double.compare(theta, 0.0) >= 0 ? Math.toDegrees(theta) : Math.toDegrees(theta) + 360.0;
    }

    private final void drawData() {
        this.dataCtx.clearRect(0.0, 0.0, this.size, this.size);
        int NO_OF_DATA_POINTS = ((SimplePieChart)this.getSkinnable()).getData().size();
        double DATA_POINT_OFFSET = this.size * 0.015;
        double DATA_POINT_SIZE = this.size - this.size * 0.03;
        double startAngle = -((SimplePieChart)this.getSkinnable()).getStartAngle();
        this.angleStep = 360.0 / ((SimplePieChart)this.getSkinnable()).getSum();
        this.dataCtx.setFont(Font.font((String)"Open Sans", (FontWeight)FontWeight.NORMAL, (double)(0.06 * this.size)));
        this.dataCtx.setTextAlign(TextAlignment.CENTER);
        this.dataCtx.setTextBaseline(VPos.CENTER);
        for (int i = 0; i < NO_OF_DATA_POINTS; ++i) {
            PieChart.Data DATA_POINT = (PieChart.Data)((SimplePieChart)this.getSkinnable()).getData().get(i);
            double ANGLE_EXTEND = -DATA_POINT.getPieValue() * this.angleStep;
            this.dataCtx.save();
            switch (i) {
                case 0: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill0());
                    break;
                }
                case 1: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill1());
                    break;
                }
                case 2: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill2());
                    break;
                }
                case 3: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill3());
                    break;
                }
                case 4: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill4());
                    break;
                }
                case 5: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill5());
                    break;
                }
                case 6: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill6());
                    break;
                }
                case 7: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill7());
                    break;
                }
                case 8: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill8());
                    break;
                }
                case 9: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill9());
                    break;
                }
                case 10: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill10());
                    break;
                }
                case 11: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill11());
                    break;
                }
                case 12: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill12());
                    break;
                }
                case 13: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill13());
                    break;
                }
                case 14: {
                    this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionFill14());
                }
            }
            this.dataCtx.fillArc(DATA_POINT_OFFSET, DATA_POINT_OFFSET, DATA_POINT_SIZE, DATA_POINT_SIZE, startAngle, ANGLE_EXTEND, ArcType.ROUND);
            if (((SimplePieChart)this.getSkinnable()).isSectionTextVisible()) {
                double percentage = DATA_POINT.getPieValue() / ((SimplePieChart)this.getSkinnable()).getSum() * 100.0;
                this.dataCtx.setFill(((SimplePieChart)this.getSkinnable()).getSectionTextColor());
                this.dataCtx.save();
                this.dataCtx.translate(this.size * 0.5, this.size * 0.5);
                this.dataCtx.rotate(-startAngle - ANGLE_EXTEND * 0.5);
                Point2D textPoint = new Point2D(this.size * 0.35, 0.0);
                switch (((SimplePieChart)this.getSkinnable()).getDataFormat()) {
                    case TEXT: {
                        this.dataCtx.fillText(DATA_POINT.getName(), textPoint.getX(), textPoint.getY());
                        break;
                    }
                    case VALUE: {
                        this.dataCtx.fillText(String.format(Locale.US, "%." + ((SimplePieChart)this.getSkinnable()).getDecimals() + "f", DATA_POINT.getPieValue()), textPoint.getX(), textPoint.getY());
                        break;
                    }
                    case PERCENTAGE: {
                        this.dataCtx.fillText(String.format(Locale.US, "%." + ((SimplePieChart)this.getSkinnable()).getDecimals() + "f", percentage) + "%", textPoint.getX(), textPoint.getY());
                        break;
                    }
                    case TEXT_AND_PERCENTAGE: {
                        this.dataCtx.fillText(DATA_POINT.getName() + "\n" + String.format(Locale.US, "%." + ((SimplePieChart)this.getSkinnable()).getDecimals() + "f", percentage) + "%", textPoint.getX(), textPoint.getY());
                        break;
                    }
                    default: {
                        this.dataCtx.fillText(DATA_POINT.getName() + "\n" + String.format(Locale.US, "%." + ((SimplePieChart)this.getSkinnable()).getDecimals() + "f", DATA_POINT.getPieValue()), textPoint.getX(), textPoint.getY());
                    }
                }
                this.dataCtx.restore();
            }
            this.dataCtx.restore();
            startAngle += ANGLE_EXTEND;
        }
        this.dataCtx.setStroke((Paint)Color.WHITE);
        this.dataCtx.setLineWidth(5.0);
        this.dataCtx.strokeArc(DATA_POINT_OFFSET, DATA_POINT_OFFSET, DATA_POINT_SIZE, DATA_POINT_SIZE, 0.0, 360.0, ArcType.OPEN);
    }

    private void resizeText() {
        double decrement;
        this.sum.setFont(Fonts.robotoBold(0.145 * this.size));
        if (this.sum.getLayoutBounds().getWidth() > 0.38 * this.size) {
            decrement = 0.0;
            while (this.sum.getLayoutBounds().getWidth() > 0.38 * this.size && this.sum.getFont().getSize() > 0.0) {
                this.sum.setFont(Fonts.robotoBold(this.size * (0.15 - decrement)));
                decrement += 0.01;
            }
        }
        this.sum.setTranslateX((this.size - this.sum.getLayoutBounds().getWidth()) * 0.5);
        this.sum.setTranslateY(this.size * (this.title.getText().isEmpty() ? 0.5 : 0.48));
        this.title.setFont(Fonts.robotoBold(0.045 * this.size));
        if (this.title.getLayoutBounds().getWidth() > 0.38 * this.size) {
            decrement = 0.0;
            while (this.title.getLayoutBounds().getWidth() > 0.38 * this.size && this.title.getFont().getSize() > 0.0) {
                this.title.setFont(Fonts.robotoBold(this.size * (0.05 - decrement)));
                decrement += 0.01;
            }
        }
        this.title.setTranslateX((this.size - this.title.getLayoutBounds().getWidth()) * 0.5);
        this.title.setTranslateY(this.size * 0.5 + this.sum.getFont().getSize() * 0.7);
    }

    private void resize() {
        double d = this.size = ((SimplePieChart)this.getSkinnable()).getWidth() < ((SimplePieChart)this.getSkinnable()).getHeight() ? ((SimplePieChart)this.getSkinnable()).getWidth() : ((SimplePieChart)this.getSkinnable()).getHeight();
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.dataCanvas.setWidth(this.size);
            this.dataCanvas.setHeight(this.size);
            this.drawData();
            this.dataCanvas.setCache(true);
            this.dataCanvas.setCacheHint(CacheHint.QUALITY);
            this.info.setPrefSize(this.size * 0.45, this.size * 0.45);
            this.info.relocate((this.size - this.info.getPrefWidth()) * 0.5, (this.size - this.info.getPrefHeight()) * 0.5);
            this.sum.setText(String.format(Locale.US, "%." + ((SimplePieChart)this.getSkinnable()).getDecimals() + "f", ((SimplePieChart)this.getSkinnable()).getSum()));
            this.title.setText(((SimplePieChart)this.getSkinnable()).getTitle());
            this.resizeText();
        }
    }
}

