/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.clock.skin;

import eu.hansolo.enzo.clock.Clock;
import eu.hansolo.enzo.fonts.Fonts;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class ClockSkin
extends SkinBase<Clock>
implements Skin<Clock> {
    private static final int SHORT_INTERVAL = 20;
    private static final int LONG_INTERVAL = 1000;
    private static final double PREFERRED_WIDTH = 200.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private Pane pane;
    private String nightDayStyleClass = ((Clock)this.getSkinnable()).isNightMode() ? "night-mode" : "day-mode";
    private Region background;
    private Canvas logoLayer;
    private GraphicsContext ctx;
    private Region minutePointer;
    private Region minutePointerFlour;
    private Region hourPointer;
    private Region hourPointerFlour;
    private Region secondPointer;
    private Region centerKnob;
    private Region foreground;
    private double size;
    private double hourPointerWidthFactor = 0.04;
    private double hourPointerHeightFactor = 0.55;
    private double minutePointerWidthFactor = 0.04;
    private double minutePointerHeightFactor = 0.4;
    private double secondPointerWidthFactor = 0.075;
    private double secondPointerHeightFactor = 0.46;
    private double majorTickWidthFactor = 0.04;
    private double majorTickHeightFactor = 0.12;
    private double minorTickWidthFactor = 0.01;
    private double minorTickHeightFactor = 0.05;
    private double majorTickOffset = 0.018;
    private double minorTickOffset = 0.05;
    private Rotate hourRotate;
    private Rotate minuteRotate;
    private Rotate secondRotate;
    private List<Region> ticks;
    private List<Text> tickLabels;
    private Group tickMarkGroup;
    private Group tickLabelGroup;
    private Group pointerGroup;
    private Group secondPointerGroup;
    private Font tickLabelFont = Fonts.bebasNeue(12.0);
    private DoubleProperty currentMinuteAngle;
    private DoubleProperty minuteAngle = new SimpleDoubleProperty(0.0);
    private Timeline timeline;

    public ClockSkin(Clock CONTROL) {
        super((Control)CONTROL);
        this.currentMinuteAngle = new SimpleDoubleProperty(0.0);
        this.minuteRotate = new Rotate();
        this.hourRotate = new Rotate();
        this.secondRotate = new Rotate();
        this.ticks = new ArrayList<Region>(60);
        this.tickLabels = new ArrayList<Text>(12);
        this.timeline = new Timeline();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((Clock)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Clock)this.getSkinnable()).getPrefWidth() > 0.0 && ((Clock)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Clock)this.getSkinnable()).setPrefSize(((Clock)this.getSkinnable()).getPrefWidth(), ((Clock)this.getSkinnable()).getPrefHeight());
            } else {
                ((Clock)this.getSkinnable()).setPrefSize(200.0, 200.0);
            }
        }
        if (Double.compare(((Clock)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Clock)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Clock)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Clock)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        String minorTickStyleClass;
        String majorTickStyleClass;
        this.pane = new Pane();
        this.background = new Region();
        if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
            this.background.getStyleClass().setAll((Object[])new String[]{"background-ios6"});
        } else if (Clock.Design.DB == ((Clock)this.getSkinnable()).getDesign()) {
            this.background.getStyleClass().setAll((Object[])new String[]{"background-db"});
        } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
            this.background.getStyleClass().setAll((Object[])new String[]{"background-braun"});
        } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
            this.background.getStyleClass().setAll((Object[])new String[]{"background-bosch"});
        }
        this.logoLayer = new Canvas(200.0, 200.0);
        this.ctx = this.logoLayer.getGraphicsContext2D();
        if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
            majorTickStyleClass = "major-tick-ios6";
            minorTickStyleClass = "minor-tick-ios6";
        } else if (Clock.Design.DB == ((Clock)this.getSkinnable()).getDesign()) {
            majorTickStyleClass = "major-tick-db";
            minorTickStyleClass = "minor-tick-db";
        } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
            majorTickStyleClass = "major-tick-bosch";
            minorTickStyleClass = "minor-tick-bosch";
        } else {
            majorTickStyleClass = "major-tick-braun";
            minorTickStyleClass = "minor-tick-braun";
        }
        int tickLabelCounter = 1;
        for (double angle = 0.0; angle < 360.0; angle += 6.0) {
            Region tick = new Region();
            if (angle % 30.0 == 0.0) {
                tick.getStyleClass().setAll((Object[])new String[]{majorTickStyleClass});
                Text tickLabel = new Text(Integer.toString(tickLabelCounter));
                tickLabel.getStyleClass().setAll((Object[])new String[]{"tick-label-braun"});
                this.tickLabels.add(tickLabel);
                ++tickLabelCounter;
            } else {
                tick.getStyleClass().setAll((Object[])new String[]{minorTickStyleClass});
            }
            this.ticks.add(tick);
        }
        DropShadow dropShadow = new DropShadow();
        dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
        dropShadow.setRadius(1.5);
        dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        dropShadow.setOffsetY(1.0);
        this.tickMarkGroup = new Group();
        this.tickMarkGroup.setEffect((Effect)dropShadow);
        this.tickMarkGroup.getChildren().setAll(this.ticks);
        this.tickLabelGroup = new Group();
        this.tickLabelGroup.setEffect((Effect)dropShadow);
        this.tickLabelGroup.getChildren().setAll(this.tickLabels);
        this.tickLabelGroup.setOpacity(Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign() ? 1.0 : 0.0);
        this.minutePointer = new Region();
        if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
            this.minutePointer.getStyleClass().setAll((Object[])new String[]{"hour-pointer-ios6"});
        } else if (Clock.Design.DB == ((Clock)this.getSkinnable()).getDesign()) {
            this.minutePointer.getStyleClass().setAll((Object[])new String[]{"hour-pointer-db"});
        } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
            this.minutePointer.getStyleClass().setAll((Object[])new String[]{"hour-pointer-braun"});
        } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
            this.minutePointer.getStyleClass().setAll((Object[])new String[]{"hour-pointer-bosch"});
        }
        this.minutePointer.getTransforms().setAll((Object[])new Transform[]{this.minuteRotate});
        this.minutePointerFlour = new Region();
        this.minutePointerFlour.getStyleClass().setAll((Object[])new String[]{"hour-pointer-braun-flour"});
        if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
            this.minutePointerFlour.setOpacity(1.0);
        } else {
            this.minutePointerFlour.setOpacity(0.0);
        }
        this.minutePointerFlour.getTransforms().setAll((Object[])new Transform[]{this.minuteRotate});
        this.hourPointer = new Region();
        if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
            this.hourPointer.getStyleClass().setAll((Object[])new String[]{"minute-pointer-ios6"});
        } else if (Clock.Design.DB == ((Clock)this.getSkinnable()).getDesign()) {
            this.hourPointer.getStyleClass().setAll((Object[])new String[]{"minute-pointer-db"});
        } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
            this.hourPointer.getStyleClass().setAll((Object[])new String[]{"minute-pointer-braun"});
        } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
            this.hourPointer.getStyleClass().setAll((Object[])new String[]{"minute-pointer-bosch"});
        }
        this.hourPointer.getTransforms().setAll((Object[])new Transform[]{this.hourRotate});
        this.hourPointerFlour = new Region();
        this.hourPointerFlour.getStyleClass().setAll((Object[])new String[]{"minute-pointer-braun-flour"});
        if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
            this.hourPointerFlour.setOpacity(1.0);
        } else {
            this.hourPointerFlour.setOpacity(0.0);
        }
        this.hourPointerFlour.getTransforms().setAll((Object[])new Transform[]{this.hourRotate});
        DropShadow pointerShadow = new DropShadow();
        pointerShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.45));
        pointerShadow.setRadius(12.0);
        pointerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        pointerShadow.setOffsetY(6.0);
        this.pointerGroup = new Group();
        this.pointerGroup.setEffect((Effect)pointerShadow);
        this.pointerGroup.getChildren().setAll((Object[])new Node[]{this.hourPointerFlour, this.hourPointer, this.minutePointerFlour, this.minutePointer});
        this.secondPointer = new Region();
        this.secondPointer.setOpacity(1.0);
        if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
            this.secondPointer.getStyleClass().setAll((Object[])new String[]{"second-pointer-ios6"});
        } else if (Clock.Design.DB == ((Clock)this.getSkinnable()).getDesign()) {
            this.secondPointer.getStyleClass().setAll((Object[])new String[]{"second-pointer-db"});
        } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
            this.secondPointer.getStyleClass().setAll((Object[])new String[]{"second-pointer-braun"});
        } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
            this.secondPointer.setOpacity(0.0);
        }
        this.secondPointer.getTransforms().setAll((Object[])new Transform[]{this.secondRotate});
        InnerShadow secondPointerInnerShadow = new InnerShadow();
        secondPointerInnerShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.3));
        secondPointerInnerShadow.setRadius(1.0);
        secondPointerInnerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        secondPointerInnerShadow.setOffsetY(-1.0);
        InnerShadow secondPointerInnerHighlight = new InnerShadow();
        secondPointerInnerHighlight.setColor(Color.rgb((int)255, (int)255, (int)255, (double)0.3));
        secondPointerInnerHighlight.setRadius(1.0);
        secondPointerInnerHighlight.setBlurType(BlurType.TWO_PASS_BOX);
        secondPointerInnerHighlight.setOffsetY(1.0);
        secondPointerInnerHighlight.setInput((Effect)secondPointerInnerShadow);
        DropShadow secondPointerShadow = new DropShadow();
        secondPointerShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.45));
        secondPointerShadow.setRadius(12.0);
        secondPointerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        secondPointerShadow.setOffsetY(6.0);
        secondPointerShadow.setInput((Effect)secondPointerInnerHighlight);
        this.secondPointerGroup = new Group();
        this.secondPointerGroup.setEffect((Effect)secondPointerShadow);
        this.secondPointerGroup.getChildren().setAll((Object[])new Node[]{this.secondPointer});
        this.secondPointerGroup.setOpacity(((Clock)this.getSkinnable()).isSecondPointerVisible() ? 1.0 : 0.0);
        this.centerKnob = new Region();
        if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
            this.centerKnob.getStyleClass().setAll((Object[])new String[]{"center-knob-ios6"});
        } else if (Clock.Design.DB == ((Clock)this.getSkinnable()).getDesign()) {
            this.centerKnob.getStyleClass().setAll((Object[])new String[]{"center-knob-db"});
        } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
            this.centerKnob.getStyleClass().setAll((Object[])new String[]{"center-knob-braun"});
        } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
            this.centerKnob.getStyleClass().setAll((Object[])new String[]{"center-knob-bosch"});
        }
        this.foreground = new Region();
        if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
            this.foreground.getStyleClass().setAll((Object[])new String[]{"foreground-ios6"});
        } else if (Clock.Design.DB == ((Clock)this.getSkinnable()).getDesign()) {
            this.foreground.getStyleClass().setAll((Object[])new String[]{"foreground-db"});
        } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
            this.foreground.getStyleClass().setAll((Object[])new String[]{"foreground-braun"});
        } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
            this.foreground.getStyleClass().setAll((Object[])new String[]{"foreground-bosch"});
        }
        this.foreground.setOpacity(((Clock)this.getSkinnable()).isHighlightVisible() ? 1.0 : 0.0);
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.logoLayer, this.tickMarkGroup, this.tickLabelGroup, this.pointerGroup, this.secondPointerGroup, this.centerKnob, this.foreground});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.updateDesign();
    }

    private void registerListeners() {
        this.minuteRotate.angleProperty().bind((ObservableValue)this.currentMinuteAngle);
        this.minuteAngle.addListener(observable -> this.moveMinutePointer(this.minuteAngle.get()));
        ((Clock)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Clock)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Clock)this.getSkinnable()).secondPointerVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("SECOND_POINTER_VISIBLE"));
        ((Clock)this.getSkinnable()).nightModeProperty().addListener(observable -> this.handleControlPropertyChanged("DESIGN"));
        ((Clock)this.getSkinnable()).designProperty().addListener(observable -> this.handleControlPropertyChanged("DESIGN"));
        ((Clock)this.getSkinnable()).highlightVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("DESIGN"));
        ((Clock)this.getSkinnable()).timeProperty().addListener(observable -> this.handleControlPropertyChanged("TIME"));
        ((Clock)this.getSkinnable()).runningProperty().addListener(observable -> this.handleControlPropertyChanged("RUNNING"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("DESIGN".equals(PROPERTY)) {
            this.updateDesign();
        } else if ("SECOND_POINTER_VISIBLE".equals(PROPERTY)) {
            this.secondPointerGroup.setOpacity(((Clock)this.getSkinnable()).isSecondPointerVisible() ? 1.0 : 0.0);
        } else if ("TIME".equals(PROPERTY)) {
            this.updateTime();
        }
    }

    private void updateTime() {
        LocalTime TIME = ((Clock)this.getSkinnable()).getTime();
        if (((Clock)this.getSkinnable()).isDiscreteSecond()) {
            this.secondRotate.setAngle((double)(TIME.getSecond() * 6));
        } else {
            this.secondRotate.setAngle((double)(TIME.getSecond() * 6) + (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 0.006);
        }
        this.minuteAngle.set((double)(TIME.getMinute() * 6));
        this.hourRotate.setAngle(0.5 * (double)(60 * TIME.getHour() + TIME.getMinute()));
        if (((Clock)this.getSkinnable()).isAutoNightMode()) {
            this.checkForNight(TIME);
        }
    }

    private void checkForNight(LocalTime TIME) {
        int hour = TIME.getHour();
        int minute = TIME.getMinute();
        if (0 <= hour && minute >= 0 && hour <= 5 && minute <= 59 || 17 <= hour && minute <= 59 && hour <= 23 && minute <= 59) {
            ((Clock)this.getSkinnable()).setNightMode(true);
        } else {
            ((Clock)this.getSkinnable()).setNightMode(false);
        }
    }

    private void moveMinutePointer(double ANGLE) {
        KeyValue kv = new KeyValue((WritableValue)this.currentMinuteAngle, (Object)ANGLE, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
        if ((int)this.currentMinuteAngle.get() == 354 && ANGLE == 0.0) {
            kv = new KeyValue((WritableValue)this.currentMinuteAngle, (Object)360, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
        } else if ((int)this.currentMinuteAngle.get() == 0 && ANGLE == 354.0) {
            kv = new KeyValue((WritableValue)this.currentMinuteAngle, (Object)-6, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
        }
        KeyFrame kf = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{kv});
        this.timeline = new Timeline();
        this.timeline.getKeyFrames().add((Object)kf);
        this.timeline.setOnFinished(event -> {
            if ((int)this.currentMinuteAngle.get() == 360) {
                this.currentMinuteAngle.set(0.0);
            } else if ((int)this.currentMinuteAngle.get() == -6) {
                this.currentMinuteAngle.set(354.0);
            }
        });
        this.timeline.play();
    }

    private void drawLogoLayer() {
        this.ctx.clearRect(0.0, 0.0, this.size, this.size);
        if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
            this.ctx.setFill((Paint)(((Clock)this.getSkinnable()).isNightMode() ? Color.rgb((int)240, (int)240, (int)240) : Color.rgb((int)10, (int)10, (int)10)));
            this.ctx.fillRect(this.size * 0.5 - 1.0, this.size * 0.18, 2.0, this.size * 0.27);
            this.ctx.fillRect(this.size * 0.5 - 1.0, this.size * 0.55, 2.0, this.size * 0.27);
            this.ctx.fillRect(this.size * 0.18, this.size * 0.5 - 1.0, this.size * 0.27, 2.0);
            this.ctx.fillRect(this.size * 0.55, this.size * 0.5 - 1.0, this.size * 0.27, 2.0);
        }
        if (((Clock)this.getSkinnable()).getText().isEmpty()) {
            return;
        }
        this.ctx.setFill((Paint)(((Clock)this.getSkinnable()).isNightMode() ? Color.WHITE : Color.BLACK));
        this.ctx.setFont(Fonts.robotoMedium(this.size * 0.05));
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.fillText(((Clock)this.getSkinnable()).getText(), this.size * 0.5, this.size * 0.675, this.size * 0.8);
    }

    private void updateDesign() {
        boolean wasRunning = ((Clock)this.getSkinnable()).isRunning();
        if (wasRunning) {
            ((Clock)this.getSkinnable()).setRunning(false);
        }
        String string = this.nightDayStyleClass = ((Clock)this.getSkinnable()).isNightMode() ? "night-mode" : "day-mode";
        if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
            this.background.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "background-ios6"});
            int index = 0;
            for (double angle = 0.0; angle < 360.0; angle += 6.0) {
                Region tick = this.ticks.get(index);
                if (angle % 30.0 == 0.0) {
                    tick.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "major-tick-ios6"});
                } else {
                    tick.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "minor-tick-ios6"});
                }
                this.ticks.add(tick);
                ++index;
            }
            this.minutePointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "hour-pointer-ios6"});
            this.hourPointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "minute-pointer-ios6"});
            this.secondPointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "second-pointer-ios6"});
            this.centerKnob.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "center-knob-ios6"});
            this.foreground.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "foreground-ios6"});
        } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
            this.nightDayStyleClass = ((Clock)this.getSkinnable()).isNightMode() ? "night-mode-braun" : "day-mode-braun";
            this.background.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "background-braun"});
            int index = 0;
            for (double angle = 0.0; angle < 360.0; angle += 6.0) {
                if (angle % 30.0 == 0.0) {
                    this.ticks.get(index).getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "major-tick-braun"});
                } else {
                    this.ticks.get(index).getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "minor-tick-braun"});
                }
                ++index;
            }
            for (index = 0; index < 12; ++index) {
                this.tickLabels.get(index).getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "tick-label-braun"});
            }
            this.minutePointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "hour-pointer-braun"});
            this.hourPointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "minute-pointer-braun"});
            this.secondPointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "second-pointer-braun"});
            this.centerKnob.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "center-knob-braun"});
            this.foreground.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "foreground-braun"});
        } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
            this.nightDayStyleClass = ((Clock)this.getSkinnable()).isNightMode() ? "night-mode-bosch" : "day-mode-bosch";
            this.background.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "background-bosch"});
            int index = 0;
            for (double angle = 0.0; angle < 360.0; angle += 6.0) {
                Region tick = this.ticks.get(index);
                if (angle % 30.0 == 0.0) {
                    tick.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "major-tick-bosch"});
                } else {
                    tick.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "minor-tick-bosch"});
                }
                this.ticks.add(tick);
                ++index;
            }
            this.minutePointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "hour-pointer-bosch"});
            this.hourPointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "minute-pointer-bosch"});
            this.secondPointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "second-pointer-bosch"});
            this.centerKnob.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "center-knob-bosch"});
            this.foreground.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "foreground-bosch"});
        } else {
            this.background.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "background-db"});
            int index = 0;
            for (double angle = 0.0; angle < 360.0; angle += 6.0) {
                Region tick = this.ticks.get(index);
                if (angle % 30.0 == 0.0) {
                    tick.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "major-tick-db"});
                } else {
                    tick.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "minor-tick-db"});
                }
                this.ticks.add(tick);
                ++index;
            }
            this.minutePointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "hour-pointer-db"});
            this.hourPointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "minute-pointer-db"});
            this.secondPointer.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "second-pointer-db"});
            this.centerKnob.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "center-knob-db"});
            this.foreground.getStyleClass().setAll((Object[])new String[]{this.nightDayStyleClass, "foreground-db"});
        }
        this.tickLabelGroup.setOpacity(Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign() ? 1.0 : 0.0);
        this.foreground.setOpacity(((Clock)this.getSkinnable()).isHighlightVisible() ? 1.0 : 0.0);
        this.resize();
        if (wasRunning) {
            ((Clock)this.getSkinnable()).setRunning(true);
        }
    }

    private void resize() {
        this.size = ((Clock)this.getSkinnable()).getWidth() < ((Clock)this.getSkinnable()).getHeight() ? ((Clock)this.getSkinnable()).getWidth() : ((Clock)this.getSkinnable()).getHeight();
        this.logoLayer.setWidth(this.size);
        this.logoLayer.setHeight(this.size);
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.background.setPrefSize(this.size, this.size);
            if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
                this.hourPointerWidthFactor = 0.04;
                this.hourPointerHeightFactor = 0.55;
                this.minutePointerWidthFactor = 0.04;
                this.minutePointerHeightFactor = 0.4;
                this.secondPointerWidthFactor = 0.075;
                this.secondPointerHeightFactor = 0.46;
                this.majorTickWidthFactor = 0.04;
                this.majorTickHeightFactor = 0.12;
                this.minorTickWidthFactor = 0.01;
                this.minorTickHeightFactor = 0.05;
                this.majorTickOffset = 0.018;
                this.minorTickOffset = 0.05;
                this.minuteRotate.setPivotX(this.size * 0.5 * this.hourPointerWidthFactor);
                this.minuteRotate.setPivotY(this.size * 0.76 * this.hourPointerHeightFactor);
                this.hourRotate.setPivotX(this.size * 0.5 * this.minutePointerWidthFactor);
                this.hourRotate.setPivotY(this.size * 0.66 * this.minutePointerHeightFactor);
                this.secondRotate.setPivotX(this.size * 0.5 * this.secondPointerWidthFactor);
                this.secondRotate.setPivotY(this.size * 0.7341040462 * this.secondPointerHeightFactor);
            } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
                this.hourPointerWidthFactor = 0.105;
                this.hourPointerHeightFactor = 0.485;
                this.minutePointerWidthFactor = 0.105;
                this.minutePointerHeightFactor = 0.4;
                this.secondPointerWidthFactor = 0.09;
                this.secondPointerHeightFactor = 0.53;
                this.majorTickWidthFactor = 0.015;
                this.majorTickHeightFactor = 0.045;
                this.minorTickWidthFactor = 0.0075;
                this.minorTickHeightFactor = 0.0225;
                this.majorTickOffset = 0.012;
                this.minorTickOffset = 0.02;
                this.minuteRotate.setPivotX(this.size * 0.5 * this.hourPointerWidthFactor);
                this.minuteRotate.setPivotY(this.size * 0.895 * this.hourPointerHeightFactor);
                this.hourRotate.setPivotX(this.size * 0.5 * this.minutePointerWidthFactor);
                this.hourRotate.setPivotY(this.size * 0.87 * this.minutePointerHeightFactor);
                this.secondRotate.setPivotX(this.size * 0.5 * this.secondPointerWidthFactor);
                this.secondRotate.setPivotY(this.size * 0.8125 * this.secondPointerHeightFactor);
            } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
                this.hourPointerWidthFactor = 0.04;
                this.hourPointerHeightFactor = 0.54;
                this.minutePointerWidthFactor = 0.04;
                this.minutePointerHeightFactor = 0.38;
                this.secondPointerWidthFactor = 0.09;
                this.secondPointerHeightFactor = 0.53;
                this.majorTickWidthFactor = 0.02;
                this.majorTickHeightFactor = 0.145;
                this.minorTickWidthFactor = 0.006;
                this.minorTickHeightFactor = 0.07;
                this.majorTickOffset = 0.005;
                this.minorTickOffset = 0.04;
                this.minuteRotate.setPivotX(this.size * 0.5 * this.hourPointerWidthFactor);
                this.minuteRotate.setPivotY(this.size * 0.8240740741 * this.hourPointerHeightFactor);
                this.hourRotate.setPivotX(this.size * 0.5 * this.minutePointerWidthFactor);
                this.hourRotate.setPivotY(this.size * 0.75 * this.minutePointerHeightFactor);
                this.secondRotate.setPivotX(this.size * 0.5 * this.secondPointerWidthFactor);
                this.secondRotate.setPivotY(this.size * 0.8125 * this.secondPointerHeightFactor);
            } else {
                this.hourPointerWidthFactor = 0.04;
                this.hourPointerHeightFactor = 0.47;
                this.minutePointerWidthFactor = 0.055;
                this.minutePointerHeightFactor = 0.33;
                this.secondPointerWidthFactor = 0.1;
                this.secondPointerHeightFactor = 0.455;
                this.majorTickWidthFactor = 0.04;
                this.majorTickHeightFactor = 0.12;
                this.minorTickWidthFactor = 0.025;
                this.minorTickHeightFactor = 0.04;
                this.majorTickOffset = 0.018;
                this.minorTickOffset = 0.06;
                this.minuteRotate.setPivotX(this.size * 0.5 * this.hourPointerWidthFactor);
                this.minuteRotate.setPivotY(this.size * this.hourPointerHeightFactor);
                this.hourRotate.setPivotX(this.size * 0.5 * this.minutePointerWidthFactor);
                this.hourRotate.setPivotY(this.size * this.minutePointerHeightFactor);
                this.secondRotate.setPivotX(this.size * 0.5 * this.secondPointerWidthFactor);
                this.secondRotate.setPivotY(this.size * this.secondPointerHeightFactor);
            }
            this.drawLogoLayer();
            double radius = 0.4;
            int index = 0;
            for (double angle = 0.0; angle < 360.0; angle += 6.0) {
                double sinValue = Math.sin(Math.toRadians(angle));
                double cosValue = Math.cos(Math.toRadians(angle));
                Region tick = this.ticks.get(index);
                if (angle % 30.0 == 0.0) {
                    tick.setPrefWidth(this.size * this.majorTickWidthFactor);
                    tick.setPrefHeight(this.size * this.majorTickHeightFactor);
                    tick.relocate(this.size * 0.5 + (this.size * (radius + this.majorTickOffset) * sinValue - this.size * this.majorTickWidthFactor * 0.5), this.size * 0.5 + (this.size * (radius + this.majorTickOffset) * cosValue - this.size * this.majorTickHeightFactor * 0.5));
                } else {
                    tick.setPrefWidth(this.size * this.minorTickWidthFactor);
                    tick.setPrefHeight(this.size * this.minorTickHeightFactor);
                    tick.relocate(this.size * 0.5 + (this.size * (radius + this.minorTickOffset) * sinValue - this.size * this.minorTickWidthFactor * 0.5), this.size * 0.5 + (this.size * (radius + this.minorTickOffset) * cosValue - this.size * this.minorTickHeightFactor * 0.5));
                }
                tick.setRotate(-angle);
                ++index;
            }
            if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
                int tickLabelCounter = 0;
                this.tickLabelFont = Font.font((String)"Bebas Neue", (FontWeight)FontWeight.THIN, (FontPosture)FontPosture.REGULAR, (double)(0.09 * this.size));
                for (double angle = 0.0; angle < 360.0; angle += 30.0) {
                    double x = 0.34 * this.size * Math.sin(Math.toRadians(150.0 - angle));
                    double y = 0.34 * this.size * Math.cos(Math.toRadians(150.0 - angle));
                    this.tickLabels.get(tickLabelCounter).setFont(this.tickLabelFont);
                    this.tickLabels.get(tickLabelCounter).setX(this.size * 0.5 + x - this.tickLabels.get(tickLabelCounter).getLayoutBounds().getWidth() * 0.5);
                    this.tickLabels.get(tickLabelCounter).setY(this.size * 0.5 + y);
                    this.tickLabels.get(tickLabelCounter).setTextOrigin(VPos.CENTER);
                    this.tickLabels.get(tickLabelCounter).setTextAlignment(TextAlignment.CENTER);
                    ++tickLabelCounter;
                }
            }
            this.minutePointer.setPrefSize(this.size * this.hourPointerWidthFactor, this.size * this.hourPointerHeightFactor);
            if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
                this.minutePointer.relocate(this.size * 0.5 - this.minutePointer.getPrefWidth() * 0.5, this.size * 0.5 - this.minutePointer.getPrefHeight() + this.minutePointer.getPrefHeight() * 0.24);
            } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
                this.minutePointer.relocate(this.size * 0.5 - this.minutePointer.getPrefWidth() * 0.5, this.size * 0.5 - this.minutePointer.getPrefHeight() + this.minutePointer.getPrefHeight() * 0.108);
                this.minutePointerFlour.setPrefSize(this.size * this.hourPointerWidthFactor, this.size * this.hourPointerHeightFactor);
                this.minutePointerFlour.relocate(this.size * 0.5 - this.minutePointer.getPrefWidth() * 0.5, this.size * 0.5 - this.minutePointer.getPrefHeight() + this.minutePointer.getPrefHeight() * 0.108);
            } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
                this.minutePointer.relocate(this.size * 0.5 - this.minutePointer.getPrefWidth() * 0.5, this.size * 0.5 - this.minutePointer.getPrefHeight() + this.minutePointer.getPrefHeight() * 0.1759259259);
            } else {
                this.minutePointer.relocate(this.size * 0.5 - this.minutePointer.getPrefWidth() * 0.5, this.size * 0.5 - this.minutePointer.getPrefHeight());
            }
            this.hourPointer.setPrefSize(this.size * this.minutePointerWidthFactor, this.size * this.minutePointerHeightFactor);
            if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
                this.hourPointer.relocate(this.size * 0.5 - this.hourPointer.getPrefWidth() * 0.5, this.size * 0.5 - this.hourPointer.getPrefHeight() + this.hourPointer.getPrefHeight() * 0.34);
            } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
                this.hourPointer.relocate(this.size * 0.5 - this.hourPointer.getPrefWidth() * 0.5, this.size * 0.5 - this.hourPointer.getPrefHeight() + this.hourPointer.getPrefHeight() * 0.128);
                this.hourPointerFlour.setPrefSize(this.size * this.minutePointerWidthFactor, this.size * this.minutePointerHeightFactor);
                this.hourPointerFlour.relocate(this.size * 0.5 - this.hourPointer.getPrefWidth() * 0.5, this.size * 0.5 - this.hourPointer.getPrefHeight() + this.hourPointer.getPrefHeight() * 0.128);
            } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
                this.hourPointer.relocate(this.size * 0.5 - this.hourPointer.getPrefWidth() * 0.5, this.size * 0.5 - this.hourPointer.getPrefHeight() + this.hourPointer.getPrefHeight() * 0.25);
            } else {
                this.hourPointer.relocate(this.size * 0.5 - this.hourPointer.getPrefWidth() * 0.5, this.size * 0.5 - this.hourPointer.getPrefHeight());
            }
            this.secondPointer.setPrefSize(this.size * this.secondPointerWidthFactor, this.size * this.secondPointerHeightFactor);
            if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
                this.secondPointer.relocate(this.size * 0.5 - this.secondPointer.getPrefWidth() * 0.5, this.size * 0.5 - this.secondPointer.getPrefHeight() + this.secondPointer.getPrefHeight() * 0.2658959538);
            } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
                this.secondPointer.relocate(this.size * 0.5 - this.secondPointer.getPrefWidth() * 0.5, this.size * 0.5 - this.secondPointer.getPrefHeight() + this.secondPointer.getPrefHeight() * 0.189);
            } else {
                this.secondPointer.relocate(this.size * 0.5 - this.secondPointer.getPrefWidth() * 0.5, this.size * 0.5 - this.secondPointer.getPrefHeight());
            }
            if (Clock.Design.IOS6 == ((Clock)this.getSkinnable()).getDesign()) {
                this.centerKnob.setPrefSize(this.size * 0.015, this.size * 0.015);
            } else if (Clock.Design.BRAUN == ((Clock)this.getSkinnable()).getDesign()) {
                this.centerKnob.setPrefSize(this.size * 0.085, this.size * 0.085);
            } else if (Clock.Design.BOSCH == ((Clock)this.getSkinnable()).getDesign()) {
                this.centerKnob.setPrefSize(this.size * 0.035, this.size * 0.035);
            } else {
                this.centerKnob.setPrefSize(this.size * 0.1, this.size * 0.1);
            }
            this.centerKnob.relocate(this.size * 0.5 - this.centerKnob.getPrefWidth() * 0.5, this.size * 0.5 - this.centerKnob.getPrefHeight() * 0.5);
            this.foreground.setPrefSize(this.size * 0.955, this.size * 0.495);
            this.foreground.relocate(this.size * 0.5 - this.foreground.getPrefWidth() * 0.5, this.size * 0.01);
        }
    }
}

