/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.common;

import eu.hansolo.enzo.common.SymbolType;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;

public class Symbol
extends Region {
    public static final boolean RESIZEABLE = true;
    public static final boolean NOT_RESIZEABLE = false;
    public static final boolean SELECTABLE = true;
    public static final boolean NOT_SELECTABLE = false;
    private static final double PREFERRED_WIDTH = 28.0;
    private static final double PREFERRED_HEIGHT = 28.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private final double DEFAULT_SIZE;
    private static final PseudoClass NOT_AVAILABLE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"not-available");
    private static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    private BooleanProperty notAvailable;
    private BooleanProperty selected;
    private boolean isSelectable;
    private ObjectProperty<SymbolType> symbolType;
    private ObjectProperty<Color> color;
    private double size;
    private boolean resizeable;
    private Region symbolRegion;
    private Pane pane;
    private Tooltip tooltip;
    private String tooltipText;

    public Symbol(SymbolType SYMBOL_TYPE, double SIZE, Color COLOR, boolean RESIZEABLE) {
        this(SYMBOL_TYPE, SIZE, COLOR, RESIZEABLE, false);
    }

    public Symbol(SymbolType SYMBOL_TYPE, double SIZE, Color COLOR, boolean RESIZEABLE, String TOOLTIP_TEXT) {
        this(SYMBOL_TYPE, SIZE, COLOR, RESIZEABLE, false, TOOLTIP_TEXT);
    }

    public Symbol(SymbolType SYMBOL_TYPE, double SIZE, Color COLOR, boolean RESIZEABLE, boolean SELECTABLE) {
        this(SYMBOL_TYPE, SIZE, COLOR, RESIZEABLE, SELECTABLE, "");
    }

    public Symbol(SymbolType SYMBOL_TYPE, double SIZE, Color COLOR, boolean RESIZEABLE, boolean SELECTABLE, String TOOLTIP_TEXT) {
        this.symbolType = new SimpleObjectProperty((Object)this, "symbolType", (Object)(null == SYMBOL_TYPE ? SymbolType.NONE : SYMBOL_TYPE));
        this.color = new SimpleObjectProperty((Object)this, "color", (Object)(null == COLOR ? Color.BLACK : COLOR));
        this.size = SIZE;
        this.DEFAULT_SIZE = SIZE;
        this.resizeable = RESIZEABLE;
        this.isSelectable = SELECTABLE;
        this.tooltipText = TOOLTIP_TEXT;
        this.getStylesheets().add((Object)Symbol.class.getResource("symbols.css").toExternalForm());
        this.getStyleClass().setAll((Object[])new String[]{"symbol"});
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(28.0, 28.0);
            }
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(5.0, 5.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.symbolRegion = new Region();
        this.symbolRegion.setId(((SymbolType)((Object)this.symbolType.get())).STYLE_CLASS);
        this.pane = new Pane();
        this.pane.getStyleClass().add((Object)"symbol");
        this.pane.setStyle("-symbol-color: " + this.getColor().toString().replace("0x", "#") + ";");
        this.pane.getChildren().addAll((Object[])new Node[]{this.symbolRegion});
        this.getChildren().add((Object)this.pane);
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.symbolType.addListener(o -> Platform.runLater(() -> {
            this.symbolRegion.setId(this.getSymbolType().STYLE_CLASS);
            this.resize();
        }));
        this.color.addListener(o -> this.symbolRegion.setStyle("-symbol-color: " + this.getColor().toString().replace("0x", "#") + ";"));
        this.sceneProperty().addListener(o -> {
            if (null != this.getScene()) {
                this.tooltip = new Tooltip(this.tooltipText);
                Tooltip.install((Node)this, (Tooltip)this.tooltip);
            }
        });
    }

    public final SymbolType getSymbolType() {
        return (SymbolType)((Object)this.symbolType.get());
    }

    public final void setSymbolType(SymbolType SYMBOL_TYPE) {
        this.symbolType.set((Object)SYMBOL_TYPE);
    }

    public final ObjectProperty<SymbolType> symbolTypeProperty() {
        return this.symbolType;
    }

    public final Color getColor() {
        return (Color)this.color.get();
    }

    public final void setColor(Color COLOR) {
        this.color.set((Object)COLOR);
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public final boolean isNotAvailable() {
        return null == this.notAvailable ? false : this.notAvailable.get();
    }

    public final void setNotAvailable(boolean SELECTED) {
        this.notAvailableProperty().set(SELECTED);
    }

    public final BooleanProperty notAvailableProperty() {
        if (null == this.notAvailable) {
            this.notAvailable = new BooleanPropertyBase(false){

                protected void invalidated() {
                    Symbol.this.symbolRegion.pseudoClassStateChanged(NOT_AVAILABLE_PSEUDO_CLASS, this.get());
                }

                public void set(boolean NOT_AVAILABLE) {
                    super.set(NOT_AVAILABLE);
                }

                public Object getBean() {
                    return Symbol.this;
                }

                public String getName() {
                    return "notAvailable";
                }
            };
        }
        return this.notAvailable;
    }

    public final boolean isSelected() {
        return null == this.selected ? false : this.selected.get();
    }

    public final void setSelected(boolean SELECTED) {
        this.selectedProperty().set(SELECTED);
    }

    public final BooleanProperty selectedProperty() {
        if (null == this.selected) {
            this.selected = new BooleanPropertyBase(false){

                protected void invalidated() {
                    if (Symbol.this.isSelectable) {
                        Symbol.this.symbolRegion.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.get());
                    }
                }

                public void set(boolean SELECTED) {
                    if (Symbol.this.isSelectable) {
                        super.set(SELECTED);
                    }
                }

                public Object getBean() {
                    return Symbol.this;
                }

                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    public final Tooltip getTooltip() {
        return this.tooltip;
    }

    public final void setTooltip(Tooltip TOOLTIP) {
        if (Platform.isFxApplicationThread()) {
            this.tooltip = TOOLTIP;
            Tooltip.install((Node)this, (Tooltip)this.tooltip);
        }
    }

    public final void setTooltipText(String TOOLTIP_TEXT) {
        this.tooltip.setText(TOOLTIP_TEXT);
    }

    public void resize() {
        double height;
        double width = this.getWidth();
        double d = this.size = width < (height = this.getHeight()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(width, height);
            if (this.resizeable) {
                this.pane.relocate((this.getWidth() - width) * 0.5, (this.getHeight() - height) * 0.5);
                this.symbolRegion.setPrefSize(this.size * this.getSymbolType().WIDTH_FACTOR, this.size * this.getSymbolType().HEIGHT_FACTOR);
                this.symbolRegion.relocate((width - this.symbolRegion.getPrefWidth()) * 0.5, (height - this.symbolRegion.getPrefHeight()) * 0.5);
            } else {
                this.pane.relocate((this.getWidth() - width) * 0.5, (this.getHeight() - height) * 0.5);
                this.symbolRegion.setMinSize(this.DEFAULT_SIZE * this.getSymbolType().WIDTH_FACTOR, this.DEFAULT_SIZE * this.getSymbolType().HEIGHT_FACTOR);
                this.symbolRegion.setPrefSize(this.DEFAULT_SIZE * this.getSymbolType().WIDTH_FACTOR, this.DEFAULT_SIZE * this.getSymbolType().HEIGHT_FACTOR);
                this.symbolRegion.setMaxSize(this.DEFAULT_SIZE * this.getSymbolType().WIDTH_FACTOR, this.DEFAULT_SIZE * this.getSymbolType().HEIGHT_FACTOR);
                this.symbolRegion.relocate((width - this.symbolRegion.getPrefWidth()) * 0.5, (height - this.symbolRegion.getPrefHeight()) * 0.5);
            }
        }
    }
}

