/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.experimental.led;

import eu.hansolo.enzo.experimental.led.LedOne;
import java.time.LocalTime;
import java.util.Random;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Demo
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private LocalTime start;
    private LocalTime stop;

    public void init() {
    }

    public void start(Stage stage) {
        GridPane pane = new GridPane();
        for (int y = 0; y < 20; ++y) {
            for (int x = 0; x < 20; ++x) {
                Pane p = new Pane();
                p.setPrefSize(16.0, 16.0);
                p.getChildren().add((Object)new LedOne(16.0, Color.rgb((int)RND.nextInt(255), (int)RND.nextInt(255), (int)RND.nextInt(255)), false, 500000000L, true));
                pane.add((Node)p, x, y);
            }
        }
        pane.sceneProperty().addListener(observable -> {
            this.start = LocalTime.now();
        });
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("Led demo");
        stage.setScene(scene);
        stage.show();
        this.stop = LocalTime.now();
        System.out.println("CSS Led: ");
        System.out.println("Start: " + this.start);
        System.out.println("Stop : " + this.stop);
        Demo.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
        System.out.println((double)((this.stop.toNanoOfDay() - this.start.toNanoOfDay()) / (long)noOfNodes) / 1000000.0 + " [ms/node]");
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Demo.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Demo.calcNoOfNodes(n);
            }
        }
    }
}

