/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.experimental.led;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;

public class Led
extends Region {
    private static final double PREFERRED_SIZE = 16.0;
    private static final double MINIMUM_SIZE = 8.0;
    private static final double MAXIMUM_SIZE = 1024.0;
    public static final Color DEFAULT_LED_COLOR = Color.RED;
    private Paint _ledColor;
    private ObjectProperty<Paint> ledColor;
    private BooleanProperty on;
    private boolean _blinking;
    private BooleanProperty blinking;
    private boolean _frameVisible;
    private BooleanProperty frameVisible;
    private boolean toggle;
    private long lastTimerCall;
    private long _interval;
    private LongProperty interval;
    private AnimationTimer timer;
    private Canvas canvas;
    private GraphicsContext ctx;

    public Led() {
        this(Color.RED, true, 500000000L, false);
    }

    public Led(Color LED_COLOR, boolean FRAME_VISIBLE, long INTERVAL, boolean BLINKING) {
        this.getStylesheets().add((Object)Led.class.getResource("led.css").toExternalForm());
        this.getStyleClass().add((Object)"led");
        this._ledColor = LED_COLOR;
        this._frameVisible = FRAME_VISIBLE;
        this._interval = INTERVAL;
        this._blinking = BLINKING;
        this.toggle = false;
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > Led.this.lastTimerCall + Led.this.getInterval()) {
                    Led.this.toggle = Led.this.toggle ^ true;
                    Led.this.setOn(Led.this.toggle);
                    Led.this.lastTimerCall = NOW;
                }
            }
        };
        this.init();
        this.initGraphics();
        this.registerListeners();
        if (this._blinking) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    private void init() {
        if (Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0 || Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0) {
            this.setPrefSize(16.0, 16.0);
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(8.0, 8.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.canvas = new Canvas();
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().add((Object)this.canvas);
    }

    private void registerListeners() {
        this.widthProperty().addListener(observable -> this.draw());
        this.heightProperty().addListener(observable -> this.draw());
        this.frameVisibleProperty().addListener(observable -> this.draw());
        this.onProperty().addListener(observable -> this.draw());
        this.ledColorProperty().addListener(observable -> this.draw());
    }

    public final boolean isOn() {
        return null == this.on ? false : this.on.get();
    }

    public final void setOn(boolean GLOWING) {
        this.onProperty().set(GLOWING);
    }

    public final BooleanProperty onProperty() {
        if (null == this.on) {
            this.on = new SimpleBooleanProperty((Object)this, "on", false);
        }
        return this.on;
    }

    public final boolean isBlinking() {
        return null == this.blinking ? this._blinking : this.blinking.get();
    }

    public final void setBlinking(boolean BLINKING) {
        if (null == this.blinking) {
            this._blinking = BLINKING;
        } else {
            this.blinking.set(BLINKING);
        }
        if (BLINKING) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    public final BooleanProperty blinkingProperty() {
        if (null == this.blinking) {
            this.blinking = new SimpleBooleanProperty((Object)this, "blinking", this._blinking);
        }
        return this.blinking;
    }

    public final long getInterval() {
        return null == this.interval ? this._interval : this.interval.get();
    }

    public final void setInterval(long INTERVAL) {
        if (null == this.interval) {
            this._interval = Led.clamp(50000000L, 5000000000L, INTERVAL);
        } else {
            this.interval.set(Led.clamp(50000000L, 5000000000L, INTERVAL));
        }
    }

    public final LongProperty intervalProperty() {
        if (null == this.interval) {
            this.interval = new SimpleLongProperty((Object)this, "interval", this._interval);
        }
        return this.interval;
    }

    public final boolean isFrameVisible() {
        return null == this.frameVisible ? this._frameVisible : this.frameVisible.get();
    }

    public final void setFrameVisible(boolean FRAME_VISIBLE) {
        if (null == this.frameVisible) {
            this._frameVisible = FRAME_VISIBLE;
        } else {
            this.frameVisible.set(FRAME_VISIBLE);
        }
    }

    public final BooleanProperty frameVisibleProperty() {
        if (null == this.frameVisible) {
            this.frameVisible = new SimpleBooleanProperty((Object)this, "frameVisible", this._frameVisible);
        }
        return this.frameVisible;
    }

    public final Paint getLedColor() {
        return null == this.ledColor ? this._ledColor : (Paint)this.ledColor.get();
    }

    public final void setLedColor(Paint LED_COLOR) {
        this.ledColorProperty().set((Object)LED_COLOR);
    }

    public final ObjectProperty<Paint> ledColorProperty() {
        if (null == this.ledColor) {
            this.ledColor = new StyleableObjectProperty<Paint>(this._ledColor){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.LED_COLOR;
                }

                public Object getBean() {
                    return Led.this;
                }

                public String getName() {
                    return "ledColor";
                }
            };
        }
        return this.ledColor;
    }

    public static long clamp(long MIN, long MAX, long VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private void draw() {
        double size = this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight();
        this.canvas.setWidth(size);
        this.canvas.setHeight(size);
        this.ctx.clearRect(0.0, 0.0, size, size);
        if (this.isFrameVisible()) {
            LinearGradient frame = new LinearGradient(0.14 * size, 0.14 * size, 0.84 * size, 0.84 * size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.15, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.64)), new Stop(0.85, Color.rgb((int)200, (int)200, (int)200, (double)0.41)), new Stop(1.0, Color.rgb((int)200, (int)200, (int)200, (double)0.35))});
            this.ctx.setFill((Paint)frame);
            this.ctx.fillOval(0.0, 0.0, size, size);
        }
        InnerShadow innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * size, 0.0, 0.0, 0.0);
        if (this.isOn()) {
            this.ctx.save();
            LinearGradient on = new LinearGradient(0.25 * size, 0.25 * size, 0.74 * size, 0.74 * size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.77, 1.0)), new Stop(0.49, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, (Color)this.ledColor.get())});
            innerShadow.setInput((Effect)new DropShadow(BlurType.TWO_PASS_BOX, (Color)this.ledColor.get(), 0.36 * size, 0.0, 0.0, 0.0));
            this.ctx.setEffect((Effect)innerShadow);
            this.ctx.setFill((Paint)on);
            this.ctx.fillOval(0.14 * size, 0.14 * size, 0.72 * size, 0.72 * size);
            this.ctx.restore();
        } else {
            this.ctx.save();
            LinearGradient off = new LinearGradient(0.25 * size, 0.25 * size, 0.74 * size, 0.74 * size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.2, 1.0)), new Stop(0.49, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.13, 1.0)), new Stop(1.0, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.2, 1.0))});
            this.ctx.setEffect((Effect)innerShadow);
            this.ctx.setFill((Paint)off);
            this.ctx.fillOval(0.14 * size, 0.14 * size, 0.72 * size, 0.72 * size);
            this.ctx.restore();
        }
        RadialGradient highlight = new RadialGradient(0.0, 0.0, 0.3 * size, 0.3 * size, 0.29 * size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.TRANSPARENT)});
        this.ctx.setFill((Paint)highlight);
        this.ctx.fillOval(0.21 * size, 0.21 * size, 0.58 * size, 0.58 * size);
    }

    private static class StyleableProperties {
        private static final CssMetaData<Led, Paint> LED_COLOR = new CssMetaData<Led, Paint>("-led-color", StyleConverter.getPaintConverter(), (Paint)DEFAULT_LED_COLOR){

            public boolean isSettable(Led led) {
                return null == led.ledColor || !led.ledColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Led led) {
                return (StyleableProperty)led.ledColorProperty();
            }

            public Color getInitialValue(Led led) {
                return (Color)led.getLedColor();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, LED_COLOR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

