/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.experimental.tbutton.skin;

import eu.hansolo.enzo.common.Util;
import eu.hansolo.enzo.experimental.tbutton.TButton;
import java.io.InputStream;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class TButtonSkin
extends SkinBase<TButton>
implements Skin<TButton> {
    private static final double MINIMUM_SIZE = 25.0;
    private static final double MAXIMUM_SIZE = 1024.0;
    private static final double PREFERRED_SIZE = 144.0;
    private double size;
    private double width;
    private double height;
    private EventHandler<InputEvent> inputHandler;
    private Pane pane = new Pane();
    private Region frame;
    private Region off;
    private InnerShadow offInnerShadow;
    private InnerShadow offInnerShadow1;
    private DropShadow offDropShadow;
    private Region ledOff;
    private InnerShadow ledOffInnerShadow;
    private InnerShadow ledOffInnerShadow1;
    private Region on;
    private InnerShadow onInnerShadow;
    private InnerShadow onInnerShadow1;
    private DropShadow onDropShadow;
    private Region ledOn;
    private InnerShadow ledOnInnerShadow;
    private InnerShadow ledOnInnerShadow1;
    private DropShadow ledOnGlow;
    private Text text;
    private Font font;
    private InnerShadow textInnerShadow;
    private InnerShadow textInnerShadow1;

    public TButtonSkin(TButton CONTROL) {
        super((Control)CONTROL);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((TButton)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((TButton)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((TButton)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((TButton)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((TButton)this.getSkinnable()).getPrefWidth() > 0.0 && ((TButton)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((TButton)this.getSkinnable()).setPrefSize(((TButton)this.getSkinnable()).getPrefWidth(), ((TButton)this.getSkinnable()).getPrefHeight());
            } else {
                ((TButton)this.getSkinnable()).setPrefSize(144.0, 144.0);
            }
        }
        if (Double.compare(((TButton)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((TButton)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((TButton)this.getSkinnable()).setMinSize(25.0, 25.0);
        }
        if (Double.compare(((TButton)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((TButton)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((TButton)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
        this.inputHandler = new EventHandler<InputEvent>(){

            public void handle(InputEvent EVENT) {
                EventType TYPE = EVENT.getEventType();
                Object SRC = EVENT.getSource();
                if (MouseEvent.MOUSE_PRESSED == TYPE) {
                    if (SRC.equals(TButtonSkin.this.on)) {
                        ((TButton)TButtonSkin.this.getSkinnable()).setSelected(false);
                    } else if (SRC.equals(TButtonSkin.this.off)) {
                        ((TButton)TButtonSkin.this.getSkinnable()).setSelected(true);
                    }
                    EVENT.consume();
                }
            }
        };
    }

    private void initGraphics() {
        this.frame = new Region();
        this.frame.getStyleClass().setAll((Object[])new String[]{"frame"});
        this.off = new Region();
        this.off.getStyleClass().setAll((Object[])new String[]{"off"});
        this.offInnerShadow = new InnerShadow();
        this.offInnerShadow.setOffsetX(0.0);
        this.offInnerShadow.setOffsetY(-5.0);
        this.offInnerShadow.setRadius(2.0);
        this.offInnerShadow.setColor(Color.web((String)"0x00000080"));
        this.offInnerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.offInnerShadow1 = new InnerShadow();
        this.offInnerShadow1.setOffsetX(0.0);
        this.offInnerShadow1.setOffsetY(0.0);
        this.offInnerShadow1.setRadius(3.0);
        this.offInnerShadow1.setColor(Color.web((String)"0x0000004d"));
        this.offInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.offInnerShadow1.setInput((Effect)this.offInnerShadow);
        this.offDropShadow = new DropShadow();
        this.offDropShadow.setOffsetX(0.0);
        this.offDropShadow.setOffsetY(10.0);
        this.offDropShadow.setRadius(10.0);
        this.offDropShadow.setColor(Color.web((String)"0x000000bf"));
        this.offDropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.offDropShadow.setInput((Effect)this.offInnerShadow1);
        this.off.setEffect((Effect)this.offDropShadow);
        this.off.setVisible(!((TButton)this.getSkinnable()).isSelected());
        this.ledOff = new Region();
        this.ledOff.getStyleClass().setAll((Object[])new String[]{"off-led"});
        this.ledOff.setMouseTransparent(true);
        this.ledOff.setVisible(!((TButton)this.getSkinnable()).isSelected());
        this.ledOffInnerShadow = new InnerShadow();
        this.ledOffInnerShadow.setOffsetX(0.0);
        this.ledOffInnerShadow.setOffsetY(2.0);
        this.ledOffInnerShadow.setRadius(1.0);
        this.ledOffInnerShadow.setColor(Color.web((String)"0x0000004d"));
        this.ledOffInnerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.ledOffInnerShadow1 = new InnerShadow();
        this.ledOffInnerShadow1.setOffsetX(0.0);
        this.ledOffInnerShadow1.setOffsetY(-2.0);
        this.ledOffInnerShadow1.setRadius(1.0);
        this.ledOffInnerShadow1.setColor(Color.web((String)"0xffffffa6"));
        this.ledOffInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.ledOffInnerShadow1.setInput((Effect)this.ledOffInnerShadow);
        this.ledOff.setEffect((Effect)this.ledOffInnerShadow1);
        this.on = new Region();
        this.on.getStyleClass().setAll((Object[])new String[]{"on"});
        this.onInnerShadow = new InnerShadow();
        this.onInnerShadow.setOffsetX(0.0);
        this.onInnerShadow.setOffsetY(-2.0);
        this.onInnerShadow.setRadius(2.0);
        this.onInnerShadow.setColor(Color.web((String)"0x00000080"));
        this.onInnerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.onInnerShadow1 = new InnerShadow();
        this.onInnerShadow1.setOffsetX(0.0);
        this.onInnerShadow1.setOffsetY(5.0);
        this.onInnerShadow1.setRadius(2.0);
        this.onInnerShadow1.setColor(Color.web((String)"0x90909080"));
        this.onInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.onInnerShadow1.setInput((Effect)this.onInnerShadow);
        this.onDropShadow = new DropShadow();
        this.onDropShadow.setOffsetX(0.0);
        this.onDropShadow.setOffsetY(1.0);
        this.onDropShadow.setRadius(1.0);
        this.onDropShadow.setColor(Color.web((String)"0x000000bf"));
        this.onDropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.onDropShadow.setInput((Effect)this.onInnerShadow1);
        this.on.setEffect((Effect)this.onDropShadow);
        this.on.setVisible(((TButton)this.getSkinnable()).isSelected());
        this.ledOn = new Region();
        this.ledOn.getStyleClass().setAll((Object[])new String[]{"on-led"});
        this.ledOn.setMouseTransparent(true);
        this.ledOn.setVisible(((TButton)this.getSkinnable()).isSelected());
        this.ledOnInnerShadow = new InnerShadow();
        this.ledOnInnerShadow.setOffsetX(1.4142135623730951);
        this.ledOnInnerShadow.setOffsetY(1.414213562373095);
        this.ledOnInnerShadow.setRadius(1.0);
        this.ledOnInnerShadow.setColor(((TButton)this.getSkinnable()).getLedColor().darker().darker().darker());
        this.ledOnInnerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.ledOnInnerShadow1 = new InnerShadow();
        this.ledOnInnerShadow1.setOffsetX(-2.457456132866976);
        this.ledOnInnerShadow1.setOffsetY(-1.7207293090531375);
        this.ledOnInnerShadow1.setRadius(2.0);
        this.ledOnInnerShadow1.setColor(((TButton)this.getSkinnable()).getLedColor().darker());
        this.ledOnInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.ledOnInnerShadow1.setInput((Effect)this.ledOnInnerShadow);
        this.ledOnGlow = new DropShadow();
        this.ledOnGlow.setOffsetX(0.0);
        this.ledOnGlow.setOffsetY(0.0);
        this.ledOnGlow.setRadius(9.0);
        this.ledOnGlow.setColor(((TButton)this.getSkinnable()).getLedColor());
        this.ledOnGlow.setBlurType(BlurType.TWO_PASS_BOX);
        this.ledOnGlow.setInput((Effect)this.ledOnInnerShadow1);
        this.ledOn.setEffect((Effect)this.ledOnGlow);
        Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/eu/hansolo/enzo/fonts/opensans-semibold.ttf"), (double)28.0);
        this.font = Font.font((String)"Open Sans", (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)28.0);
        this.text = new Text(((TButton)this.getSkinnable()).getText());
        this.text.setFont(this.font);
        this.text.setTextOrigin(VPos.TOP);
        this.text.getStyleClass().add((Object)"text");
        this.text.setMouseTransparent(true);
        this.textInnerShadow = new InnerShadow();
        this.textInnerShadow.setOffsetX(0.0);
        this.textInnerShadow.setOffsetY(-1.0);
        this.textInnerShadow.setRadius(1.0);
        this.textInnerShadow.setColor(Color.web((String)"0x90909080"));
        this.textInnerShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.textInnerShadow1 = new InnerShadow();
        this.textInnerShadow1.setOffsetX(0.0);
        this.textInnerShadow1.setOffsetY(1.0);
        this.textInnerShadow1.setRadius(1.0);
        this.textInnerShadow1.setColor(Color.web((String)"0x00000080"));
        this.textInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.textInnerShadow1.setInput((Effect)this.textInnerShadow);
        this.text.setEffect((Effect)this.textInnerShadow1);
        this.pane.getChildren().setAll((Object[])new Node[]{this.frame, this.off, this.ledOff, this.on, this.ledOn, this.text});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
    }

    private void registerListeners() {
        ((TButton)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((TButton)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((TButton)this.getSkinnable()).selectedProperty().addListener(observable -> this.handleControlPropertyChanged("SELECTED"));
        ((TButton)this.getSkinnable()).textProperty().addListener(observable -> this.handleControlPropertyChanged("TEXT"));
        ((TButton)this.getSkinnable()).ledColorProperty().addListener(observable -> this.handleControlPropertyChanged("LED_COLOR"));
        this.on.setOnMousePressed(this.inputHandler);
        this.on.setOnTouchPressed(this.inputHandler);
        this.off.setOnMousePressed(this.inputHandler);
        this.off.setOnTouchPressed(this.inputHandler);
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("SELECTED".equals(PROPERTY)) {
            ((TButton)this.getSkinnable()).fireSelectEvent(((TButton)this.getSkinnable()).isSelected() ? new TButton.SelectEvent(this.getSkinnable(), (EventTarget)this.getSkinnable(), TButton.SelectEvent.SELECT) : new TButton.SelectEvent(this.getSkinnable(), (EventTarget)this.getSkinnable(), TButton.SelectEvent.DESELECT));
            this.on.setVisible(((TButton)this.getSkinnable()).isSelected());
            this.ledOn.setVisible(((TButton)this.getSkinnable()).isSelected());
            this.off.setVisible(!((TButton)this.getSkinnable()).isSelected());
            this.ledOff.setVisible(!((TButton)this.getSkinnable()).isSelected());
            this.text.setTranslateY(((TButton)this.getSkinnable()).isSelected() ? (this.height - this.text.getLayoutBounds().getHeight()) * 0.49 + 0.020833333333333332 * this.height : (this.height - this.text.getLayoutBounds().getHeight()) * 0.49);
        } else if ("TEXT".equals(PROPERTY)) {
            this.text.setText(((TButton)this.getSkinnable()).getText());
        } else if ("LED_COLOR".equals(PROPERTY)) {
            ((TButton)this.getSkinnable()).setStyle("-led-color: " + Util.colorToCss(((TButton)this.getSkinnable()).getLedColor()) + ";");
            this.ledOnGlow.setColor(((TButton)this.getSkinnable()).getLedColor());
            this.ledOnInnerShadow.setColor(((TButton)this.getSkinnable()).getLedColor().darker().darker().darker());
            this.ledOnInnerShadow1.setColor(((TButton)this.getSkinnable()).getLedColor().darker());
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinWidth(Math.max(25.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMinHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinHeight(Math.max(25.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxWidth(Math.min(1024.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxHeight(Math.min(1024.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefHeight = 144.0;
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - TOP_INSET - BOTTOM_INSET);
        }
        return super.computePrefWidth(prefHeight, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefWidth = 144.0;
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - LEFT_INSET - RIGHT_INSET);
        }
        return super.computePrefHeight(prefWidth, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    private void resize() {
        this.width = this.size = ((TButton)this.getSkinnable()).getWidth() < ((TButton)this.getSkinnable()).getHeight() ? ((TButton)this.getSkinnable()).getWidth() : ((TButton)this.getSkinnable()).getHeight();
        this.height = this.size;
        if (this.width > 0.0 && this.height > 0.0) {
            this.frame.setPrefSize(this.width, this.height);
            this.off.setPrefSize(0.7916666666666666 * this.width, 0.7916666666666666 * this.height);
            this.off.setTranslateX(0.10416666666666667 * this.width);
            this.off.setTranslateY(0.10416666666666667 * this.height);
            this.offInnerShadow.setOffsetY(-0.034722222222222224 * this.size);
            this.offInnerShadow.setRadius(0.013888888888888888 * this.size);
            this.offInnerShadow1.setRadius(0.020833333333333332 * this.size);
            this.offDropShadow.setOffsetY(0.06944444444444445 * this.size);
            this.offDropShadow.setRadius(0.06944444444444445 * this.size);
            this.ledOff.setPrefSize(0.08333333333333333 * this.width, 0.08333333333333333 * this.height);
            this.ledOff.setTranslateX(0.4583333333333333 * this.width);
            this.ledOff.setTranslateY(0.7291666666666666 * this.height);
            this.ledOffInnerShadow.setRadius(0.006944444444444444 * this.size);
            this.ledOffInnerShadow1.setRadius(0.006944444444444444 * this.size);
            this.on.setPrefSize(0.7916666666666666 * this.width, 0.7916666666666666 * this.height);
            this.on.setTranslateX(0.10416666666666667 * this.width);
            this.on.setTranslateY(0.10416666666666667 * this.height);
            this.onInnerShadow.setOffsetY(-0.013888888888888888 * this.size);
            this.onInnerShadow.setRadius(0.013888888888888888 * this.size);
            this.onInnerShadow1.setOffsetY(0.027777777777777776 * this.size);
            this.onInnerShadow1.setRadius(0.013888888888888888 * this.size);
            this.onDropShadow.setRadius(0.006944444444444444 * this.size);
            this.ledOn.setPrefSize(0.08333333333333333 * this.width, 0.08333333333333333 * this.height);
            this.ledOn.setTranslateX(0.4583333333333333 * this.width);
            this.ledOn.setTranslateY(0.75 * this.height);
            this.ledOnInnerShadow.setRadius(0.006944444444444444 * this.size);
            this.ledOnInnerShadow1.setRadius(0.013888888888888888 * this.size);
            this.ledOnGlow.setRadius(0.0625 * this.size);
            this.font = Font.font((String)"Open Sans", (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)(0.19444444444444445 * this.size));
            this.text.setFont(this.font);
            if (this.text.getLayoutBounds().getWidth() > 0.78 * this.width) {
                this.text.setText("...");
            }
            this.text.setTranslateX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
            this.text.setTranslateY((this.height - this.text.getLayoutBounds().getHeight()) * 0.49);
            this.textInnerShadow.setOffsetY(-0.006944444444444444 * this.size);
            this.textInnerShadow.setRadius(0.006944444444444444 * this.size);
            this.textInnerShadow1.setOffsetY(0.006944444444444444 * this.size);
            this.textInnerShadow1.setRadius(0.006944444444444444 * this.size);
        }
    }
}

