/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.gauge.skin.LinearSkin;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class Linear
extends Control {
    private static final PseudoClass HORIZONTAL_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"horizontal");
    private static final PseudoClass LED_ON_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"led-on");
    private static final long LED_BLINK_INTERVAL = 500000000L;
    private DoubleProperty value;
    private DoubleProperty minValue;
    private double exactMinValue;
    private DoubleProperty maxValue;
    private double exactMaxValue;
    private DoubleProperty threshold;
    private IntegerProperty decimals;
    private StringProperty title;
    private StringProperty unit;
    private BooleanProperty animated;
    private double animationDuration;
    private BooleanProperty autoScale;
    private ObjectProperty<Color> barColor;
    private BooleanProperty ledOn;
    private BooleanProperty blinking;
    private ObjectProperty<Color> ledColor;
    private ObjectProperty<NumberFormat> numberFormat;
    private DoubleProperty majorTickSpace;
    private DoubleProperty minorTickSpace;
    private ObjectProperty<Orientation> orientation;
    private ObjectProperty<Paint> tickMarkFill;
    private ObjectProperty<Paint> tickLabelFill;
    private long lastTimerCall;
    private AnimationTimer timer;

    public Linear() {
        this.getStyleClass().add((Object)"linear");
        this.minValue = new DoublePropertyBase(0.0){

            public void set(double MIN_VALUE) {
                super.set(Linear.this.clamp(-1.7976931348623157E308, Linear.this.getMaxValue(), MIN_VALUE));
                Linear.this.setThreshold(Linear.this.clamp(Linear.this.getMinValue(), Linear.this.getMaxValue(), Linear.this.getThreshold()));
            }

            public Object getBean() {
                return Linear.this;
            }

            public String getName() {
                return "minValue";
            }
        };
        this.maxValue = new DoublePropertyBase(100.0){

            public void set(double MAX_VALUE) {
                super.set(Linear.this.clamp(Linear.this.getMinValue(), Double.MAX_VALUE, MAX_VALUE));
                Linear.this.setThreshold(Linear.this.clamp(Linear.this.getMinValue(), Linear.this.getMaxValue(), Linear.this.getThreshold()));
            }

            public Object getBean() {
                return Linear.this;
            }

            public String getName() {
                return "maxValue";
            }
        };
        this.value = new DoublePropertyBase(this.minValue.get()){

            public void set(double VALUE) {
                super.set(Linear.this.clamp(Linear.this.getMinValue(), Linear.this.getMaxValue(), VALUE));
            }

            public Object getBean() {
                return Linear.this;
            }

            public String getName() {
                return "value";
            }
        };
        this.threshold = new DoublePropertyBase(50.0){

            public void set(double THRESHOLD) {
                super.set(Linear.this.clamp(Linear.this.getMinValue(), Linear.this.getMaxValue(), THRESHOLD));
            }

            public Object getBean() {
                return Linear.this;
            }

            public String getName() {
                return "threshold";
            }
        };
        this.lastTimerCall = System.nanoTime();
        this.animationDuration = 800.0;
        this.timer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > Linear.this.lastTimerCall + 500000000L) {
                    Linear.this.setLedOn(!Linear.this.isLedOn());
                    Linear.this.lastTimerCall = NOW;
                }
            }
        };
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        this.value.set(VALUE);
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final double getMinValue() {
        return this.minValue.get();
    }

    public final void setMinValue(double MIN_VALUE) {
        this.minValue.set(MIN_VALUE);
    }

    public final DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public final double getMaxValue() {
        return this.maxValue.get();
    }

    public final void setMaxValue(double MAX_VALUE) {
        this.maxValue.set(MAX_VALUE);
    }

    public final DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public final double getThreshold() {
        return this.threshold.get();
    }

    public final void setThreshold(double THRESHOLD) {
        this.threshold.set(THRESHOLD);
    }

    public final DoubleProperty thresholdProperty() {
        return this.threshold;
    }

    public final int getDecimals() {
        return null == this.decimals ? 1 : this.decimals.get();
    }

    public final void setDecimals(int DECIMALS) {
        this.decimalsProperty().set(this.clamp(0, 3, DECIMALS));
    }

    public final IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new SimpleIntegerProperty((Object)this, "decimals", 1);
        }
        return this.decimals;
    }

    public final String getTitle() {
        return null == this.title ? "" : (String)this.title.get();
    }

    public final void setTitle(String TITLE) {
        this.titleProperty().set((Object)TITLE);
    }

    public final StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new SimpleStringProperty((Object)this, "title", "");
        }
        return this.title;
    }

    public final String getUnit() {
        return null == this.unit ? "" : (String)this.unit.get();
    }

    public final void setUnit(String UNIT) {
        this.unitProperty().set((Object)UNIT);
    }

    public final StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new SimpleStringProperty((Object)this, "unit", "");
        }
        return this.unit;
    }

    public final boolean isAnimated() {
        return null == this.animated ? true : this.animated.get();
    }

    public final void setAnimated(boolean ANIMATED) {
        this.animatedProperty().set(ANIMATED);
    }

    public final BooleanProperty animatedProperty() {
        if (null == this.animated) {
            this.animated = new SimpleBooleanProperty((Object)this, "animated", true);
        }
        return this.animated;
    }

    public final double getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(double ANIMATION_DURATION) {
        this.animationDuration = this.clamp(20.0, 5000.0, ANIMATION_DURATION);
    }

    public final boolean isAutoScale() {
        return null == this.autoScale ? false : this.autoScale.get();
    }

    public final void setAutoScale(boolean AUTO_SCALE) {
        this.autoScaleProperty().set(AUTO_SCALE);
    }

    public final BooleanProperty autoScaleProperty() {
        if (null == this.autoScale) {
            this.autoScale = new BooleanPropertyBase(false){

                public void set(boolean AUTO_SCALE) {
                    if (this.get()) {
                        Linear.this.exactMinValue = Linear.this.getMinValue();
                        Linear.this.exactMaxValue = Linear.this.getMaxValue();
                    } else {
                        Linear.this.setMinValue(Linear.this.exactMinValue);
                        Linear.this.setMaxValue(Linear.this.exactMaxValue);
                    }
                    super.set(AUTO_SCALE);
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "autoScale";
                }
            };
        }
        return this.autoScale;
    }

    public final Color getBarColor() {
        return null == this.barColor ? Color.RED : (Color)this.barColor.get();
    }

    public final void setBarColor(Color BAR_COLOR) {
        this.barColorProperty().set((Object)BAR_COLOR);
    }

    public final ObjectProperty<Color> barColorProperty() {
        if (null == this.barColor) {
            this.barColor = new SimpleObjectProperty((Object)this, "barColor", (Object)Color.RED);
        }
        return this.barColor;
    }

    public final boolean isLedOn() {
        return null == this.ledOn ? false : this.ledOn.get();
    }

    public final void setLedOn(boolean LED_ON) {
        this.ledOnProperty().set(LED_ON);
    }

    public final BooleanProperty ledOnProperty() {
        if (null == this.ledOn) {
            this.ledOn = new BooleanPropertyBase(false){

                protected void invalidated() {
                    Linear.this.pseudoClassStateChanged(LED_ON_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "on";
                }
            };
        }
        return this.ledOn;
    }

    public final boolean isBlinking() {
        return null == this.blinking ? false : this.blinking.get();
    }

    public final void setBlinking(boolean BLINKING) {
        this.blinkingProperty().set(BLINKING);
    }

    public final BooleanProperty blinkingProperty() {
        if (null == this.blinking) {
            this.blinking = new BooleanPropertyBase(){

                public void set(boolean BLINKING) {
                    super.set(BLINKING);
                    if (BLINKING) {
                        Linear.this.timer.start();
                    } else {
                        Linear.this.timer.stop();
                        Linear.this.setLedOn(false);
                    }
                }

                public Object getBean() {
                    return Linear.this;
                }

                public String getName() {
                    return "blinking";
                }
            };
        }
        return this.blinking;
    }

    public final Color getLedColor() {
        return null == this.ledColor ? Color.RED : (Color)this.ledColor.get();
    }

    public final void setLedColor(Color LED_COLOR) {
        this.ledColorProperty().set((Object)LED_COLOR);
    }

    public final ObjectProperty<Color> ledColorProperty() {
        if (null == this.ledColor) {
            this.ledColor = new SimpleObjectProperty((Object)this, "ledColor", (Object)Color.RED);
        }
        return this.ledColor;
    }

    public final NumberFormat getNumberFormat() {
        return null == this.numberFormat ? NumberFormat.STANDARD : (NumberFormat)((Object)this.numberFormat.get());
    }

    public final void setNumberFormat(NumberFormat NUMBER_FORMAT) {
        this.numberFormatProperty().set((Object)NUMBER_FORMAT);
    }

    public final ObjectProperty<NumberFormat> numberFormatProperty() {
        if (null == this.numberFormat) {
            this.numberFormat = new SimpleObjectProperty((Object)this, "numberFormat", (Object)NumberFormat.STANDARD);
        }
        return this.numberFormat;
    }

    public final double getMajorTickSpace() {
        return null == this.majorTickSpace ? 10.0 : this.majorTickSpace.get();
    }

    public final void setMajorTickSpace(double MAJOR_TICK_SPACE) {
        this.majorTickSpaceProperty().set(MAJOR_TICK_SPACE);
    }

    public final DoubleProperty majorTickSpaceProperty() {
        if (null == this.majorTickSpace) {
            this.majorTickSpace = new SimpleDoubleProperty((Object)this, "majorTickSpace", 10.0);
        }
        return this.majorTickSpace;
    }

    public final double getMinorTickSpace() {
        return null == this.minorTickSpace ? 1.0 : this.minorTickSpace.get();
    }

    public final void setMinorTickSpace(double MINOR_TICK_SPACE) {
        this.minorTickSpaceProperty().set(MINOR_TICK_SPACE);
    }

    public final DoubleProperty minorTickSpaceProperty() {
        if (null == this.minorTickSpace) {
            this.minorTickSpace = new SimpleDoubleProperty((Object)this, "minorTickSpace", 1.0);
        }
        return this.minorTickSpace;
    }

    public final Orientation getOrientation() {
        return null == this.orientation ? Orientation.VERTICAL : (Orientation)this.orientation.get();
    }

    public final void setOrientation(Orientation ORIENTATION) {
        this.orientationProperty().set((Object)ORIENTATION);
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (null == this.orientation) {
            this.orientation = new ObjectPropertyBase<Orientation>(Orientation.VERTICAL){

                public void invalidated() {
                    Linear.this.pseudoClassStateChanged(HORIZONTAL_PSEUDO_CLASS, Orientation.HORIZONTAL == this.get());
                }

                public Object getBean() {
                    return Linear.this;
                }

                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    public int clamp(int MIN_VALUE, int MAX_VALUE, int VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    public Duration clamp(Duration MIN_VALUE, Duration MAX_VALUE, Duration VALUE) {
        if (VALUE.lessThan(MIN_VALUE)) {
            return MIN_VALUE;
        }
        if (VALUE.greaterThan(MAX_VALUE)) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    public final Paint getTickMarkFill() {
        return null == this.tickMarkFill ? Color.WHITE : (Paint)this.tickMarkFill.get();
    }

    public final void setTickMarkFill(Paint value) {
        this.tickMarkFillProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> tickMarkFillProperty() {
        if (null == this.tickMarkFill) {
            this.tickMarkFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TICK_MARK_FILL;
                }

                public Object getBean() {
                    return Linear.this;
                }

                public String getName() {
                    return "tickMarkFill";
                }
            };
        }
        return this.tickMarkFill;
    }

    public final Paint getTickLabelFill() {
        return null == this.tickLabelFill ? Color.WHITE : (Paint)this.tickLabelFill.get();
    }

    public final void setTickLabelFill(Paint value) {
        this.tickLabelFillProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> tickLabelFillProperty() {
        if (null == this.tickLabelFill) {
            this.tickLabelFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TICK_LABEL_FILL;
                }

                public Object getBean() {
                    return Linear.this;
                }

                public String getName() {
                    return "tickLabelFill";
                }
            };
        }
        return this.tickLabelFill;
    }

    protected Skin createDefaultSkin() {
        return new LinearSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("linear.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Linear.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<Linear, Paint> TICK_MARK_FILL = new CssMetaData<Linear, Paint>("-tick-mark-fill", StyleConverter.getPaintConverter(), (Paint)Color.BLACK){

            public boolean isSettable(Linear gauge) {
                return null == gauge.tickMarkFill || !gauge.tickMarkFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Linear gauge) {
                return (StyleableProperty)gauge.tickMarkFillProperty();
            }
        };
        private static final CssMetaData<Linear, Paint> TICK_LABEL_FILL = new CssMetaData<Linear, Paint>("-tick-label-fill", StyleConverter.getPaintConverter(), (Paint)Color.BLACK){

            public boolean isSettable(Linear gauge) {
                return null == gauge.tickLabelFill || !gauge.tickLabelFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Linear gauge) {
                return (StyleableProperty)gauge.tickLabelFillProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, TICK_MARK_FILL, TICK_LABEL_FILL);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum NumberFormat {
        AUTO("0"),
        STANDARD("0"),
        FRACTIONAL("0.0#"),
        SCIENTIFIC("0.##E0"),
        PERCENTAGE("##0.0%");

        private final DecimalFormat DF;

        private NumberFormat(String FORMAT_STRING) {
            Locale.setDefault(new Locale("en", "US"));
            this.DF = new DecimalFormat(FORMAT_STRING);
        }

        public String format(Number NUMBER) {
            return this.DF.format(NUMBER);
        }
    }
}

