/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.led;

import eu.hansolo.enzo.led.skin.LedSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class Led
extends Control {
    public static final String STYLE_CLASS_RED = "led-red";
    public static final String STYLE_CLASS_GREEN = "led-green";
    public static final String STYLE_CLASS_BLUE = "led-blue";
    public static final String STYLE_CLASS_YELLOW = "led-yellow";
    public static final String STYLE_CLASS_ORANGE = "led-orange";
    public static final String STYLE_CLASS_CYAN = "led-cyan";
    public static final String STYLE_CLASS_MAGENTA = "led-magenta";
    public static final String STYLE_CLASS_PURPLE = "led-purple";
    public static final String STYLE_CLASS_GRAY = "led-gray";
    public static final LedType DEFAULT_LED_TYPE = LedType.ROUND;
    public static final Color DEFAULT_LED_COLOR = Color.RED;
    private static final PseudoClass ON_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"on");
    private BooleanProperty on;
    private ObjectProperty<Paint> ledColor;
    private ObjectProperty<LedType> ledType;
    private boolean _blinking = false;
    private BooleanProperty blinking;
    private boolean _frameVisible = true;
    private BooleanProperty frameVisible;
    private int _interval = 500;
    private IntegerProperty interval;
    private volatile ScheduledFuture<?> periodicBlinkTask;
    private static ScheduledExecutorService periodicBlinkExecutorService;

    public Led() {
        this.getStyleClass().add((Object)"led");
    }

    public final boolean isOn() {
        return null == this.on ? false : this.on.get();
    }

    public final void setOn(boolean ON) {
        this.onProperty().set(ON);
    }

    public final BooleanProperty onProperty() {
        if (null == this.on) {
            this.on = new BooleanPropertyBase(false){

                protected void invalidated() {
                    Led.this.pseudoClassStateChanged(ON_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "on";
                }
            };
        }
        return this.on;
    }

    public final boolean isBlinking() {
        return null == this.blinking ? this._blinking : this.blinking.get();
    }

    public final void setBlinking(boolean BLINKING) {
        if (null == this.blinking) {
            this._blinking = BLINKING;
        } else {
            this.blinking.set(BLINKING);
        }
        if (BLINKING) {
            this.scheduleBlinkTask();
        } else {
            this.stopTask(this.periodicBlinkTask);
            this.setOn(false);
        }
    }

    public final BooleanProperty blinkingProperty() {
        if (null == this.blinking) {
            this.blinking = new SimpleBooleanProperty((Object)this, "blinking", this._blinking);
        }
        return this.blinking;
    }

    public final int getInterval() {
        return null == this.interval ? this._interval : this.interval.get();
    }

    public final void setInterval(int INTERVAL) {
        if (null == this.interval) {
            this._interval = Led.clamp(50, 5000, INTERVAL);
        } else {
            this.interval.set(Led.clamp(50, 5000, INTERVAL));
        }
    }

    public final ReadOnlyIntegerProperty intervalProperty() {
        if (null == this.interval) {
            this.interval = new SimpleIntegerProperty((Object)this, "interval", this._interval);
        }
        return this.interval;
    }

    public final boolean isFrameVisible() {
        return null == this.frameVisible ? this._frameVisible : this.frameVisible.get();
    }

    public final void setFrameVisible(boolean FRAME_VISIBLE) {
        if (null == this.frameVisible) {
            this._frameVisible = FRAME_VISIBLE;
        } else {
            this.frameVisible.set(FRAME_VISIBLE);
        }
    }

    public final BooleanProperty frameVisibleProperty() {
        if (null == this.frameVisible) {
            this.frameVisible = new SimpleBooleanProperty((Object)this, "frameVisible", this._frameVisible);
        }
        return this.frameVisible;
    }

    public final Paint getLedColor() {
        return null == this.ledColor ? DEFAULT_LED_COLOR : (Paint)this.ledColor.get();
    }

    public final void setLedColor(Paint value) {
        this.ledColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> ledColorProperty() {
        if (null == this.ledColor) {
            this.ledColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_LED_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.LED_COLOR;
                }

                public Object getBean() {
                    return Led.this;
                }

                public String getName() {
                    return "ledColor";
                }
            };
        }
        return this.ledColor;
    }

    public final LedType getLedType() {
        return null == this.ledType ? DEFAULT_LED_TYPE : (LedType)((Object)this.ledType.get());
    }

    public final void setLedType(LedType TYPE) {
        this.ledTypeProperty().set((Object)TYPE);
    }

    public final ObjectProperty<LedType> ledTypeProperty() {
        if (null == this.ledType) {
            this.ledType = new StyleableObjectProperty<LedType>(DEFAULT_LED_TYPE){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.LED_TYPE;
                }

                public Object getBean() {
                    return Led.this;
                }

                public String getName() {
                    return "ledType";
                }
            };
        }
        return this.ledType;
    }

    public static int clamp(int MIN, int MAX, int VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    private static synchronized void enableBlinkExecutorService() {
        if (null == periodicBlinkExecutorService) {
            periodicBlinkExecutorService = new ScheduledThreadPoolExecutor(1, Led.getThreadFactory("BlinkLCD", false));
        }
    }

    private synchronized void scheduleBlinkTask() {
        Led.enableBlinkExecutorService();
        this.stopTask(this.periodicBlinkTask);
        this.periodicBlinkTask = periodicBlinkExecutorService.scheduleAtFixedRate(() -> Platform.runLater(() -> this.setOn(!this.isOn())), 0L, this.getInterval(), TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory getThreadFactory(String THREAD_NAME, boolean IS_DAEMON) {
        return runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(IS_DAEMON);
            return thread;
        };
    }

    private void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    protected Skin createDefaultSkin() {
        return new LedSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("led.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Led.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<Led, Paint> LED_COLOR = new CssMetaData<Led, Paint>("-led-color", StyleConverter.getPaintConverter(), (Paint)DEFAULT_LED_COLOR){

            public boolean isSettable(Led led) {
                return null == led.ledColor || !led.ledColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Led led) {
                return (StyleableProperty)led.ledColorProperty();
            }

            public Color getInitialValue(Led led) {
                return (Color)led.getLedColor();
            }
        };
        private static final CssMetaData<Led, LedType> LED_TYPE = new CssMetaData<Led, LedType>("-led-type", StyleConverter.getEnumConverter(LedType.class)){

            public boolean isSettable(Led led) {
                return null == led.ledType || !led.ledType.isBound();
            }

            public StyleableProperty<LedType> getStyleableProperty(Led led) {
                return (StyleableProperty)led.ledTypeProperty();
            }

            public LedType getInitialValue(Led led) {
                return led.getLedType();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, LED_COLOR, LED_TYPE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum LedType {
        ROUND,
        SQUARE,
        VERTICAL,
        HORIZONTAL;

    }
}

